#pragma once

#include "stdafx.h"
#include "hct_msg_def.h"
#include "hostappemu_sn.h"

struct ECA_APPEMU_MGH
{
public:
	ECA_APPEMU_MGH();
	
	UINT32 flags;
  UINT16 phy_tx_level;
  UINT16 gain_value;
  UINT16 mac_cfp_bytes;
  BOOL bToneMask;
  UINT8 ToneMask[12];
	UINT8 modulation;

  UINT16 serial_number[8];
  UINT16 sSerial[ECA_APPEMU_SERIAL_LEN_WORDS];

  ECF_TIME_t time_of_day;
  ECF_TIME_t task_start;
  ECF_TIME_t last_task;
  ECF_TIME_t RPY_task_start;
  ECF_TIME_t exit_start;
  ECA_APPEMU_STEP_t curr_step;
  UINT16 NextDWLen;

  UINT16 PPDU_LengthTesting_Offset;
  UINT16 PPDU_LengthTesting_Offset_Save;
  UINT16 PPDU_LengthTesting_Index;

  ConnHandle_t connHandle;
  UINT16 MAC_TX_priority;

  ECA_APPEMU_STATS_s stats;

  UINT16 SNA[3];
  UINT16 EUI[3];

  UINT8 destSap;
  UINT8 srcSap;
  UINT8 LLC_DeviceIdentifier[16];
  UINT16 Destination_Address;
  UINT16 Base_Address;

  UINT16 save_Serial_Number_Len;
  UINT8 save_Serial_Number[HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Serial_Number];
  UINT8 save_EUI[HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_EUI];
  UINT8 save_Device_Mode;
  int save_HostPort;
  int save_DiagPort;

  UINT8 save_IPv4_SourceAddress[HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_SIZE_SourceAddress];
  UINT8 save_IPv4_Netmask[HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_SIZE_NetMask];
  UINT8 save_IPv4_Gateway[HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_SIZE_Gateway];

  UINT16 G3_Address_Type;
  UINT16 G3_Long_Address[4];
  UINT16 G3_Pan_ID;
  UINT16 G3_Short_Address;
	UINT16 G3_MAC_Segment_Length;

  UINT8 tx_nsdu_handle;
  UINT8 rx_nsdu_handle;
  UINT16 Network_Address;
  UINT16 LBA_Address;
  UINT8 discover_time;
};