#include "G3Network.h"
#include "ipv6mainheader.h"
#include "highresolutiontimer.h"
#include "hostappemu.h"
#include "hct_msg_def.h"
#include "hct_msg_if_def.h"
#include "hostappemu_sn.h"
#include "eca_appemu_mgh.h"
#include "hostappemu_data.h"
#include <fstream>
#include <iomanip>
#include <direct.h>

using namespace std;

extern ECA_APPEMU_MGH ECA_AppEmu_mgh;
extern BOOL skipEmeterMessages;
extern BOOL g3DataOnlyTesting;
extern UINT32 emeterMessageDelay;
extern UINT32 emeterBlackList[];
extern UINT16 emeterBlackListCount;
extern bool emeterSyncServiceNodes;
extern int eMeterSecurity;
extern UINT32 firmwareVersion;
extern int microIP;
extern UINT32 emeterMessageTimeout;

void ECA_AppEmu_BuildPayload(HCT_MSG_BUFFER_t *msg, UINT16 len, UINT16 *ppkthdr, UINT16 hdrlen);
void ECA_AppEMU_DETACH(UINT16 *extendedAddress);


G3_Network * G3_Network::m_first = NULL;
G3_Network * G3_Network::m_last = NULL;
HANDLE G3_Network::m_GlobalMutex = CreateMutex(NULL, FALSE, _T("Global G3 Network Mutext"));
HANDLE G3_Network::m_GlobalLogMutex = CreateMutex(NULL, FALSE, _T("Global G3 Log Mutext"));

HANDLE G3_Network::m_AbortEvent = CreateEvent(NULL, TRUE, FALSE, _T("Global G3 Abort Event"));

int G3_Network::m_SyncCount = 0;

int G3_Network::m_QuitFlag = 0;
int G3_Network::m_Count = 0;
//G3_Network * G3_Network::m_MessageToG3NetworkArray[0xFF] = {0};
IPv6Address G3_Network::m_LocalIpAddress;
//int G3_Network::m_PPDULengths[] = {21, 28, 30, 62, 141, 300};
const int G3_Network::m_PPDULengths[] = {21, 28, 30, 62, 141, 300, 0, 1000, 0};//xraf

int createDirectory = _mkdir("C:\\G3_Logs");

LONGLONG  HighResolutionTimer::m_Frequency = 0; 

extern int eMeterRetryCount;

G3_Network::G3_Network(void)
{
}

G3_Network::~G3_Network(void)
{
}

G3_Network::G3_Network(UINT8 * pna1, UINT8 * pna2, UINT8 * pea, UINT8 ci, BOOL connect)
{
  memcpy(&m_IPv6Address[0], pna1, 8);
	memcpy(&m_IPv6Address[8], pna2, 8);
	memcpy(m_ExtendedAddress, pea, sizeof(m_ExtendedAddress));
  //
  // the ip address is in network order and should be reversed.
  //
  m_NetworkShortAddress[0] = m_IPv6Address[15];
  m_NetworkShortAddress[1] = m_IPv6Address[14];
  
	m_CapabilityInfo = ci;
	m_Connected = connect;

	m_AttachCount = 0;
	m_DetachCount = 0;
  m_MessagesSent = 0;
  m_MessagesReceived = 0;

	m_MessageEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
  m_ServiceNodeSyncEvent = CreateEvent(NULL, FALSE, FALSE, NULL);

	for (int index=0; index < MAX_MESSAGE_POINTERS; index++)
	{
		m_MessagePointer[index] = NULL;
	}
	m_next = NULL;

	if (m_first == NULL)
	{
		m_first = this;
		m_last = this;
	}
	else
	{
		m_last->m_next = this;
		m_last = this;
	}

	Init();
}

void G3_Network::Init()
{
	m_SystemTimeRetries = 0;
	m_SystemTimeRoundTripTime = 0;

	m_EnergyReadRetries = 0;
	m_EnergyReadRoundTripTime = 0;

	m_AccumulatedReadRetries[0] = 0;
	m_AccumulatedReadRetries[1] = 0;
	m_AccumulatedReadRoundTripTime[0] = 0;
	m_AccumulatedReadRoundTripTime[1] = 0;

	m_PPDURetries[0] = 0;
	m_PPDURetries[1] = 0;
	m_PPDURetries[2] = 0;
	m_PPDURetries[3] = 0;
	m_PPDURetries[4] = 0;
	m_PPDURetries[5] = 0;
	m_PPDURetries[6] = 0;

	m_PPDURoundTripTime[0] = 0;
	m_PPDURoundTripTime[1] = 0;
	m_PPDURoundTripTime[2] = 0;
	m_PPDURoundTripTime[3] = 0;
	m_PPDURoundTripTime[4] = 0;
	m_PPDURoundTripTime[5] = 0;
	m_PPDURoundTripTime[6] = 0;

	m_AttachCount++;

	m_State = 0;

	for(int index=0; index < MAX_MESSAGE_POINTERS; index++)
	{
		if (m_MessagePointer[index] != NULL)
		{
			LocalFree(m_MessagePointer[index]);
			m_MessagePointer[index] = NULL;
		}
	}
	m_CurrentMessageIndex = 0;
	m_NextMessageIndex = 0;

	m_Count++;
	m_PayloadId = m_Count * 1000;

  //
  // If on black list send no data.. check the black list array..
  //
  bool blackListed = false;
  for (int index = 0; index < emeterBlackListCount; index++)
  {
    //
    // works because emeterBlackList is little endian..
    //
    if (memcmp(&emeterBlackList[index], &m_NetworkShortAddress, 2) == 0)
    {
      blackListed = true;
      break;
    }
  }
  //
  // If not black listed then create the worker thread to send data..
  //
  if (blackListed == false)
  {
  	m_ProcessThread = CreateThread(NULL, 0, G3NetworkProcess, this, 0, & m_ThreadId);
  }
}
void G3_Network::Abort()
{
	//
	// Kill things in a loop;
	//
	m_QuitFlag = 1;
	//
	// Signal things waiting on the mutex
	//
	SetEvent(m_AbortEvent);
}
void G3_Network::SendNodeMessage(UINT16 payloadType, UINT16 payloadLength)
{
	IPv6MainHeader ipWrapper;
	int messageLength = HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_SIZE;
	int payloadOffset = HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_SIZE;

	if (microIP == 0)
	{
		ipWrapper.SetPayloadLength(payloadLength);
		ipWrapper.SetSourceAddress((UINT8*)m_LocalIpAddress.m_IpAddress);
		ipWrapper.SetDestinationAddress(m_IPv6Address);
		messageLength += IPv6MainHeader::IP6vHeaderSize + payloadLength;
		payloadOffset += IPv6MainHeader::IP6vHeaderSize;
	}
	else
	{
		messageLength = 2 + 2 + 2+ 2 + 2 + payloadLength;
		payloadOffset += 2+2+2+2;
	}

	m_PayloadId++;

	/* allocate the DW_MSG packet */

	UINT8 * pup_msg = (UINT8 *) LocalAlloc(LPTR, messageLength);

	if (pup_msg == NULL)
	{
		ECA_OutOfMemory();
	}
	else
	{
		UINT8 * payload = & pup_msg[payloadOffset];

		UINT16 flags = ECA_AppEmu_mgh.tx_nsdu_handle++;
		flags |= HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_FLAGS_DISCOVERY_ROUTE_ENABLED;
		if (eMeterSecurity == 1)
		{
		  flags |= HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_FLAGS_SEC_ENABLED;
		}

		*(UINT16 *) &pup_msg[HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_OFFSET_NSDU_Handle_Flags] = flags;
	
		if (microIP == 0)
		{
			ipWrapper.Encode(pup_msg, HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_SIZE);
		}
		else
		{
			*(UINT16 *) &pup_msg[2] = 1; // port = 0
			*(UINT16 *) &pup_msg[4] = 2; // port = 0
			*(UINT16 *) &pup_msg[6] = 0; // address type = short address
			pup_msg[8] = m_IPv6Address[14]; // destination short address..
			pup_msg[9] = m_IPv6Address[15]; // destination short address..
		}
		/* build packet */
		ECA_AppEmu_BuildPayload((HCT_MSG_BUFFER_t *)payload, payloadLength, NULL, 0);
		//
		// Send packet type and id and extended address
		//
		*(UINT16 *) &payload[0] = payloadType;
		*(UINT32 *) &payload[2] = m_PayloadId;
		memcpy(&payload[6], m_ExtendedAddress, sizeof(m_ExtendedAddress));
		//
		// save the message id to confirm later
		//
		m_CurrentPayloadId = m_PayloadId;

		/* send packet */

		ECA_AppEmu_mgh.stats.send_pkt[ECA_APPEMU_STEP_SystemTimeRead]++;
		ECA_AppEmu_mgh.flags |= ECA_APPEMU_FLAGS_DATA_SEND;

    HostAppEMU_DbgPrint(TRUE, HostAppEMU_DBG_LEVEL_ERROR, TEXT("%S: Concentrator sent SN msg - Short Address: %X - Type:%d  Id:%d\n......Attach: %d  Detach: %d  Sent Msg: %d  Received Msg: %d\n"), 
        __FUNCTION__, NetworkShortAddress(), payloadType, m_PayloadId, m_AttachCount, m_DetachCount, m_MessagesSent, m_MessagesReceived );

    m_Timer.Reset();
		HostAppEMU_SendSyncMsgToPLC(HCT_MSG_TYPE_DATA_TRANSFER, (UINT8 *) pup_msg, messageLength, (ECA_AppEmu_mgh.flags & ECA_APPEMU_FLAGS_USE_RPY) ? TRUE : FALSE);
	}
}

UINT32 G3_Network::GetPayloadId(UINT8 * message)
{
	UINT32 payloadId = 0;
	if (microIP == 0)
	{
		//
		// Get the ip header and skip the status info (in bytes)
		//
		IPv6MainHeader ipWrapper(&message[HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_SIZE]);
		//
		// get a pointer to the message..
		//
		UINT8 * payload = ipWrapper.GetData(&message[2]);
		
		UINT16 payloadType = *((UINT16 *) &payload[0]);
		payloadId   = *((UINT32 *) &payload[2]);
	}
	else
	{
		//
		// PLC data always sends address type 2 = IPv6 address
		//
		UINT8 * payload = &message[2+2+2+2+2+16];
		payloadId = *((UINT32 *) &payload[0]);
	}
	return payloadId;
}
int G3_Network::DoTest(UINT16 testId, UINT16 msgLength, UINT32 & intervalTimer, UINT32 & retries)
{
	HANDLE handleArray[] = { m_MessageEvent, m_AbortEvent};
	int state = 0;
	
	while (state == 0)
	{
		SendNodeMessage(testId, msgLength);
		m_MessagesSent++;
		{
Ugly:
			DWORD status = WaitForMultipleObjects(2, handleArray, FALSE, emeterMessageTimeout * 1000);
			if (status == 0)
			{
				m_MessagesReceived++;
				//
				// Received Message...
				//
				UINT8 * newMessage = m_MessagePointer[m_CurrentMessageIndex];
				UINT8 count = 0;
				while(newMessage == NULL)
				{
					if (m_CurrentMessageIndex > MAX_MESSAGE_POINTERS)
					{
						m_CurrentMessageIndex = 0;
					}
					newMessage = m_MessagePointer[m_CurrentMessageIndex];
					
					count++;
					if (count >= MAX_MESSAGE_POINTERS)
					{
						HostAppEMU_DbgPrint(TRUE, HostAppEMU_DBG_LEVEL_ERROR, TEXT("%S: New message not found.\n"), __FUNCTION__);
						break;
					}
				}

				if (newMessage != NULL)
				{
					UINT32 payloadId = GetPayloadId(newMessage);

					LocalFree(m_MessagePointer[m_CurrentMessageIndex]);

					m_MessagePointer[m_CurrentMessageIndex++] = NULL;
					if (m_CurrentMessageIndex > MAX_MESSAGE_POINTERS)
					{
						m_CurrentMessageIndex = 0;
					}

					if (payloadId == m_CurrentPayloadId)
					{
						//
						// Done go to the next test..
						//
						intervalTimer = m_Timer.IntervalInMicroSeconds();
						HostAppEMU_DbgPrint(TRUE, HostAppEMU_DBG_LEVEL_ERROR, TEXT("%S: Received sn message id: %d\n"), __FUNCTION__, payloadId);

						break;
					}
					else
					{		
						printf("payload id not found: payload Id: %x - looking for: %x\n", payloadId, m_CurrentPayloadId);
						goto Ugly;
					}
				}
			}
			else if (status == 1)
			{
				//
				// Abort event - exit..
				//
				state = 2; //quit
				HostAppEMU_DbgPrint(TRUE, HostAppEMU_DBG_LEVEL_ERROR, TEXT("%S: Received abort signal\n"), __FUNCTION__);
			}
			else
			{
				//
				// Time out.. try again..
				//
				retries++;
				if (retries >= (UINT16)eMeterRetryCount)
				{
					state = 1; // quit...
				}
			}
		}
	}

	return state;
}
void G3_Network::SetSyncEvents()
{
	G3_Network* next = m_first;
	while (next != NULL)
	{
		G3_Network * temp = next->m_next;
    //
    // don't set your own event..
    //
    if (temp != this)
    {
      SetEvent(temp->m_ServiceNodeSyncEvent);
    }
		next = temp;
	}
}
DWORD WINAPI G3_Network::G3NetworkProcess(LPVOID lpParam)
{
	G3_Network * serviceNode = (G3_Network *) lpParam;
  ResetEvent(serviceNode->m_ServiceNodeSyncEvent);

start:
	serviceNode->m_SystemTimeRetries = 0;
	serviceNode->m_SystemTimeRoundTripTime = 0;

	serviceNode->m_EnergyReadRetries = 0;
	serviceNode->m_EnergyReadRoundTripTime = 0;

	serviceNode->m_AccumulatedReadRetries[0] = 0;
	serviceNode->m_AccumulatedReadRetries[1] = 0;
	serviceNode->m_AccumulatedReadRoundTripTime[0] = 0;
	serviceNode->m_AccumulatedReadRoundTripTime[1] = 0;

	serviceNode->m_PPDURetries[0] = 0;
	serviceNode->m_PPDURetries[1] = 0;
	serviceNode->m_PPDURetries[2] = 0;
	serviceNode->m_PPDURetries[3] = 0;
	serviceNode->m_PPDURetries[4] = 0;
	serviceNode->m_PPDURetries[5] = 0;
	serviceNode->m_PPDURetries[6] = 0;

	serviceNode->m_PPDURoundTripTime[0] = 0;
	serviceNode->m_PPDURoundTripTime[1] = 0;
	serviceNode->m_PPDURoundTripTime[2] = 0;
	serviceNode->m_PPDURoundTripTime[3] = 0;
	serviceNode->m_PPDURoundTripTime[4] = 0;
	serviceNode->m_PPDURoundTripTime[5] = 0;
	serviceNode->m_PPDURoundTripTime[6] = 0;

  serviceNode->m_State = 0;

	int state = 0; 
	HANDLE handleArray[] = { serviceNode->m_MessageEvent, serviceNode->m_AbortEvent};

  if (skipEmeterMessages == TRUE)
  {
    state = 2; // skip messages and disconnect
  }
  else
  {
    if (emeterSyncServiceNodes == true)
    {
      m_SyncCount++;
      int count = GetNumberOfNetworks();
      if (m_SyncCount >= count)
      {
        m_SyncCount = 0;
        serviceNode->SetSyncEvents();
      }
      else
      {
        DWORD waitStatus = WaitForSingleObject(serviceNode->m_ServiceNodeSyncEvent, 10000);
        if (WAIT_OBJECT_0 != waitStatus)
        {
          //
          // If anyone times out release everyone..
          //
          serviceNode->SetSyncEvents();
          m_SyncCount = 0;
        }
      }
    }
    else
    {
	    srand((unsigned)GetTickCount());
	    int number = rand() % 1000;
	    int sleepTimeMS = 1000 + number;
	    _sleep(sleepTimeMS); // pause before starting test.
    }
  }
	//
	// system time test
	//
	if (state != 2)
	{
		state = serviceNode->DoTest(G3_Network::SystemReadMsg, 24, serviceNode->m_SystemTimeRoundTripTime, serviceNode->m_SystemTimeRetries);
    _sleep(emeterMessageDelay);
	}	
	//
	// Energy Register Test
	//
	if (state != 2)
	{
		state = serviceNode->DoTest(G3_Network::EngeryRegisterReadMsg, 24, serviceNode->m_EnergyReadRoundTripTime, serviceNode->m_EnergyReadRetries);
    _sleep(emeterMessageDelay);
	}
	//
	// Accumulated Information Test - Test 1
	//
	if (state != 2)
	{
		state = serviceNode->DoTest(G3_Network::AccumulatedInfomationMsg1, 75, serviceNode->m_AccumulatedReadRoundTripTime[0], serviceNode->m_AccumulatedReadRetries[0]);
    _sleep(emeterMessageDelay);
	}
	//
	// Accumulated Information Test - Test 2
	//
	if (state != 2)
	{
		state = serviceNode->DoTest(G3_Network::AccumulatedInfomationMsg2, 16, serviceNode->m_AccumulatedReadRoundTripTime[1], serviceNode->m_AccumulatedReadRetries[1]);
    _sleep(emeterMessageDelay);
	}
	//
	// PPDU Length testing..
	//
	int index = 0;
	while (serviceNode->m_QuitFlag == 0 && state != 2 && m_PPDULengths[index] > 0)
	{
		state = serviceNode->DoTest(G3_Network::PPDUTestMsg+index, m_PPDULengths[index], serviceNode->m_PPDURoundTripTime[index], serviceNode->m_PPDURetries[index]);
		index++;
    _sleep(emeterMessageDelay);
	}
  //
  // 
  //
  if (skipEmeterMessages == false)
  {
	  SYSTEMTIME	 systemTime;
	  GetLocalTime(&systemTime);
	  DWORD status = WaitForSingleObject(m_GlobalLogMutex, -1);
	  //
	  // Write state and log values..
	  //

	  ofstream logFile("c:\\G3_Logs\\G3_Log.csv", ios::app | ios::out);
	  logFile << setfill('0');
	  logFile << systemTime.wYear << "-" << setw(2) << systemTime.wMonth << "-" << setw(2) << systemTime.wDay << " "
		  << ", " << setw(2) << systemTime.wHour << ":" << setw(2) << systemTime.wMinute << ":" << setw(2) << systemTime.wSecond << "." << setw(3) << systemTime.wMilliseconds
		  << setbase(16)
		  << ", " << setw(2) << (int)serviceNode->m_ExtendedAddress[0] << ":" << setw(2) << (int)serviceNode->m_ExtendedAddress[1] << ":"
		  << setw(2) << (int)serviceNode->m_ExtendedAddress[2] << ":" << setw(2) << (int)serviceNode->m_ExtendedAddress[3] << ":"
		  << setw(2) << (int)serviceNode->m_ExtendedAddress[4] << ":" << setw(2) << (int)serviceNode->m_ExtendedAddress[5] << ":"
		  << setw(2) << (int)serviceNode->m_ExtendedAddress[6] << ":" << setw(2) << (int)serviceNode->m_ExtendedAddress[7]
		  << setbase(10)
		  << ", " << state << ", " << serviceNode->m_AttachCount << ", " << serviceNode->m_DetachCount 
		  << ", " << serviceNode->m_SystemTimeRetries << ", " << serviceNode->m_SystemTimeRoundTripTime
		  << ", " << serviceNode->m_EnergyReadRetries << ", " << serviceNode->m_EnergyReadRoundTripTime
		  << ", " << serviceNode->m_AccumulatedReadRetries[0] << ", " << serviceNode->m_AccumulatedReadRoundTripTime[0]
		  << ", " << serviceNode->m_AccumulatedReadRetries[1] << ", " << serviceNode->m_AccumulatedReadRoundTripTime[1]
		  << ", " << serviceNode->m_PPDURetries[0] << ", " << serviceNode->m_PPDURoundTripTime[0]
		  << ", " << serviceNode->m_PPDURetries[1] << ", " << serviceNode->m_PPDURoundTripTime[1]
		  << ", " << serviceNode->m_PPDURetries[2] << ", " << serviceNode->m_PPDURoundTripTime[2]
		  << ", " << serviceNode->m_PPDURetries[3] << ", " << serviceNode->m_PPDURoundTripTime[3]
		  << ", " << serviceNode->m_PPDURetries[4] << ", " << serviceNode->m_PPDURoundTripTime[4]
		  << ", " << serviceNode->m_PPDURetries[5] << ", " << serviceNode->m_PPDURoundTripTime[5]
		  << ", " << serviceNode->m_PPDURetries[6] << ", " << serviceNode->m_PPDURoundTripTime[6]
		  << endl;

	  logFile.close();

    ofstream shortLogFile("C:\\G3_Logs\\G3_Summary.csv", ios::trunc | ios::out);
    G3_Network * g3Network = m_first;
    while (g3Network != NULL)
    {
      g3Network->WriteShortLog(shortLogFile, systemTime);
      g3Network = g3Network->m_next;
    }
    shortLogFile.close();

	  ReleaseMutex(m_GlobalLogMutex);
	  //
	  // Free any memory in circular buf
	  //
	  status = WaitForSingleObject(m_GlobalMutex, -1);

	  for (int index = 0; index < MAX_MESSAGE_POINTERS; index++)
	  {
		  if (serviceNode->m_MessagePointer[index] != NULL)
		  {
			  LocalFree(serviceNode->m_MessagePointer[index]);
			  serviceNode->m_MessagePointer[index] = NULL;
		  }
	  }
    serviceNode->m_CurrentMessageIndex = 0;
	  serviceNode->m_NextMessageIndex = 0;

	  ReleaseMutex(m_GlobalMutex);
  }
  //
  // state == 2 if aborting..
  //
  if (g3DataOnlyTesting && state != 2)
  {
    goto start;
  }
  else
  {
    DetachNetwork(serviceNode);
  }
  return (DWORD)state;
}

void G3_Network::WriteShortLog( ofstream & logFile, SYSTEMTIME & systemTime)
{
  logFile << systemTime.wYear << "-" << setw(2) << systemTime.wMonth << "-" << setw(2) << systemTime.wDay << " "
	  << ", " << setw(2) << systemTime.wHour << ":" << setw(2) << systemTime.wMinute << ":" << setw(2) << systemTime.wSecond << "." << setw(3) << systemTime.wMilliseconds
	  << setbase(16)
	  << ", " << setw(2) << (int)m_ExtendedAddress[0] << ":" << setw(2) << (int)m_ExtendedAddress[1] << ":"
	  << setw(2) << (int)m_ExtendedAddress[2] << ":" << setw(2) << (int)m_ExtendedAddress[3] << ":"
	  << setw(2) << (int)m_ExtendedAddress[4] << ":" << setw(2) << (int)m_ExtendedAddress[5] << ":"
	  << setw(2) << (int)m_ExtendedAddress[6] << ":" << setw(2) << (int)m_ExtendedAddress[7]
	  << setbase(10)
	  << ", " << m_AttachCount << ", " << m_DetachCount 
    << ", " << m_MessagesSent << ", " << m_MessagesReceived << ", " 
    << m_MessagesSent - m_MessagesReceived << endl;
}

G3_Network * G3_Network::Add(UINT8 * pna1, UINT8 * pna2, UINT8 * pea, UINT8 ci, BOOL connect)
{
  G3_Network * network = NULL;

	HANDLE handleArray[] = { m_GlobalMutex, m_AbortEvent};
	DWORD status = WaitForMultipleObjects(2, handleArray, FALSE, 1000);
	if (status == 0)
	{
		//
		//swap bytes
		//
		UINT8 temp1[8];
		UINT8 temp2[8];

		for(int index=0; index < 8; index+=2)
		{
			temp1[index] = pna1[index+1];
			temp1[index+1] = pna1[index];

			temp2[index] = pna2[index+1];
			temp2[index+1] = pna2[index];
		}

		network = FindMacAddress(pea);
		if (network == NULL)
		{
			network = new G3_Network(temp1, temp2, pea, ci, connect);
		}
		else
		{
			network->Init();
			network->DestinationIpAddress(temp1, temp2);
			network->m_Connected = TRUE;
		}
		ReleaseMutex(m_GlobalMutex);
	}
  return network;
}

void G3_Network::DestinationIpAddress(UINT8 * pna1, UINT8 *pna2)
{
  memcpy(&m_IPv6Address[0], pna1, 8);
	memcpy(&m_IPv6Address[8], pna2, 8);

  m_NetworkShortAddress[0] = m_IPv6Address[15];
  m_NetworkShortAddress[1] = m_IPv6Address[14];
}

void G3_Network::Delete(void)
{
	HANDLE handleArray[] = { m_GlobalMutex, m_AbortEvent};
	DWORD status = WaitForMultipleObjects(2, handleArray, FALSE, 1000);
	if (status == 0)
	{
		G3_Network* next = m_first;
		while (next != NULL)
		{
			G3_Network * temp = next->m_next;
			delete next;
			next = temp;
		}
		ReleaseMutex(m_GlobalMutex);
	}
}
UINT16 G3_Network::NetworkShortAddress()
{
  union
  {
    UINT8 temp8[2];
    UINT16 temp16;
  }shortAddress;

  shortAddress.temp8[0] = m_NetworkShortAddress[0];
  shortAddress.temp8[1] = m_NetworkShortAddress[1];

  return shortAddress.temp16;
}

UINT32 G3_Network::GetNumberOfNetworks()
{
  UINT32 count = 0;
	HANDLE handleArray[] = { m_GlobalMutex, m_AbortEvent};
	DWORD status = WaitForMultipleObjects(2, handleArray, FALSE, 1000);
	
  G3_Network * next = NULL;
	if (status == 0)
	{
		next = m_first;
		while (next != NULL)
		{
      count++;
			next = next->m_next;
		}
		ReleaseMutex(m_GlobalMutex);
	}
	return count;
}

G3_Network * G3_Network::GetNetwork(UINT32 index)
{
  G3_Network * next = NULL;
  UINT32 networkCount = GetNumberOfNetworks();
  if (networkCount != 0)
  {
    UINT32 boundedIndex = index % networkCount;

    UINT32 count = 0;
	  HANDLE handleArray[] = { m_GlobalMutex, m_AbortEvent};
	  DWORD status = WaitForMultipleObjects(2, handleArray, FALSE, 1000);
  	
	  if (status == 0)
	  {
		  next = m_first;
		  while (next != NULL)
		  {
        //
        // If this is the one we want return it..
        //
        if (count == boundedIndex)
        {
          break;
        }
        count++;
			  next = next->m_next;
		  }
		  ReleaseMutex(m_GlobalMutex);
	  }
  }
	return next;
}

G3_Network * G3_Network::FindIPAddress(UINT8 * pea)
{
	HANDLE handleArray[] = { m_GlobalMutex, m_AbortEvent};
	DWORD status = WaitForMultipleObjects(2, handleArray, FALSE, 1000);
	G3_Network * next = NULL;
	if (status == 0)
	{
		next = m_first;
		while (next != NULL)
		{
			if (memcmp(pea, next->m_IPv6Address, 16) == 0)
			{
				break;
			}
			next = next->m_next;
		}
		ReleaseMutex(m_GlobalMutex);
	}
	return next;
}


G3_Network * G3_Network::FindMacAddress(UINT8 * macAddress)
{
	HANDLE handleArray[] = { m_GlobalMutex, m_AbortEvent};
	DWORD status = WaitForMultipleObjects(2, handleArray, FALSE, 1000);
	G3_Network * next = NULL;
	if (status == 0)
	{
		next = m_first;
		while (next != NULL)
		{
			if (memcmp(macAddress, next->m_ExtendedAddress, 8) == 0)
			{
				break;
			}
			next = next->m_next;
		}
		ReleaseMutex(m_GlobalMutex);
	}
	return next;
}

G3_Network * G3_Network::FindMacAddress(UINT8 * macAddress, UINT8 * pMessage)
{
	HANDLE handleArray[] = { m_GlobalMutex, m_AbortEvent};
	DWORD status = WaitForMultipleObjects(2, handleArray, FALSE, 1000);

	G3_Network * pNetwork = NULL;

	if (status == 0)
	{
		pNetwork = FindMacAddress(macAddress);
		if (pNetwork != NULL)
		{
			if (pNetwork->m_MessagePointer[pNetwork->m_NextMessageIndex] == NULL)
			{
				pNetwork->m_MessagePointer[pNetwork->m_NextMessageIndex++] = pMessage;
				if (pNetwork->m_NextMessageIndex > MAX_MESSAGE_POINTERS)
				{
					pNetwork->m_NextMessageIndex = 0;
				}
				//
				// signal thread that a new message has arrived
				//
				SetEvent(pNetwork->m_MessageEvent);
			}
			else
			{
				//xraf add ip address..
				HostAppEMU_DbgPrint(TRUE, HostAppEMU_DBG_LEVEL_ERROR, TEXT("%S: Message pointer not null..\n"), __FUNCTION__);
				pNetwork = NULL;
			}
		}
		ReleaseMutex(m_GlobalMutex);
	}
	return pNetwork;
}
/*
G3_Network * G3_Network::FindIPAddress(UINT8 * ipAddress, UINT8 * pMessage)
{
	HANDLE handleArray[] = { m_GlobalMutex, m_AbortEvent};
	DWORD status = WaitForMultipleObjects(2, handleArray, FALSE, 1000);

	G3_Network * pNetwork = NULL;

	if (status == 0)
	{
		pNetwork = FindIPAddress(ipAddress);
		if (pNetwork != NULL)
		{
			if (pNetwork->m_MessagePointer == NULL)
			{
				pNetwork->m_MessagePointer = pMessage;
			}
			else
			{
				//xraf add ip address..
				HostAppEMU_DbgPrint(TRUE, HostAppEMU_DBG_LEVEL_ERROR, TEXT("%S: Message pointer not null..\n"), __FUNCTION__);
				pNetwork = NULL;
			}
		}
		ReleaseMutex(m_GlobalMutex);
	}
	return pNetwork;
}
*/
void G3_Network::DetachNetwork(G3_Network * network)
{
	HANDLE handleArray[] = { m_GlobalMutex, m_AbortEvent};
	int state = 0;
		
	DWORD status = WaitForMultipleObjects(2, handleArray, FALSE, 1000);
	if (status == 0)
	{
		network->m_DetachCount++;
		network->m_Connected = false;
		UINT16 extendedAddress[4];
		memcpy(extendedAddress, network->m_ExtendedAddress, 8);

		ReleaseMutex(m_GlobalMutex);

		ECA_AppEMU_DETACH(extendedAddress);
	}

}
