#pragma once

#include "stdafx.h"
#include "ipv6mainheader.h"
#include "highresolutiontimer.h"
#include <iostream>
#include <fstream>
#include <iomanip>
#include <direct.h>

class G3_Network
{
private:
	UINT8 m_IPv6Address[16];
	UINT8 m_ExtendedAddress[8];
	UINT8 m_CapabilityInfo;

	static G3_Network * m_first;
	static G3_Network * m_last;
	static HANDLE m_GlobalMutex;
	static HANDLE m_GlobalLogMutex;

  HANDLE m_ServiceNodeSyncEvent;
  static int m_SyncCount;

	static HANDLE m_AbortEvent;
	static int m_QuitFlag;
	static int m_Count;
	static const int m_PPDULengths[];// = {21, 28, 30, 62, 141, 300, 0};

	G3_Network * m_next;

	BOOL m_Connected;

	UINT32 m_SystemTimeRetries;
	UINT32 m_SystemTimeRoundTripTime;

	UINT32 m_EnergyReadRetries;
	UINT32 m_EnergyReadRoundTripTime;

	UINT32 m_AccumulatedReadRetries[2];
	UINT32 m_AccumulatedReadRoundTripTime[2];

	UINT32 m_PPDURetries[7];
	UINT32 m_PPDURoundTripTime[7];

	UINT32 m_State;
	HANDLE m_ProcessThread;
	HANDLE m_MessageEvent;
	DWORD  m_ThreadId;
  UINT8 m_NetworkShortAddress[2];
	//
	// this number is big enough it should probably never wrap..
	//
	static const UINT8 MAX_MESSAGE_POINTERS = 50;
	UINT8 * m_MessagePointer[MAX_MESSAGE_POINTERS];
	UINT8 m_CurrentMessageIndex;
	UINT8 m_NextMessageIndex;

	HighResolutionTimer m_Timer;
	int m_PayloadId;
	UINT32  m_CurrentPayloadId;

	G3_Network(UINT8 * pna1, UINT8 * pna2, UINT8 * pea, UINT8 ci, BOOL connect);

	static DWORD WINAPI G3NetworkProcess(LPVOID lpParam);
	
	UINT32 GetPayloadId(UINT8 * message);
	int DoTest(UINT16 testid, UINT16 msgLength, UINT32 & intervalTimer, UINT32 & retries);
	void SendNodeMessage(UINT16 payloadType, UINT16 payloadLength);
	void DestinationIpAddress(UINT8 * temp1, UINT8 *temp2);
	void Init();
  void WriteShortLog(std::ofstream & logfile, SYSTEMTIME & systemTime);
  void SetSyncEvents();

public:
	G3_Network();
	virtual ~ G3_Network();

  UINT16 m_AttachCount;
	UINT16 m_DetachCount;
  UINT32 m_MessagesSent;
  UINT32 m_MessagesReceived;

  UINT16 NetworkShortAddress();

	static IPv6Address m_LocalIpAddress;

	static const UINT16 SystemReadMsg = 1;
	static const UINT16 EngeryRegisterReadMsg = 2;
	static const UINT16 AccumulatedInfomationMsg1 = 3;
	static const UINT16 AccumulatedInfomationMsg2 = 4;
	static const UINT16 PPDUTestMsg = 5;

  static UINT32 GetNumberOfNetworks();
  static G3_Network * GetNetwork(UINT32 index);

	static G3_Network * Add(UINT8 * pna1, UINT8 * pna2, UINT8 * pea, UINT8 ci, BOOL connect);
	static void Delete(void);
  static G3_Network * FindMacAddress(UINT8 * macAddress);
	static G3_Network * FindMacAddress(UINT8 * macAddress, UINT8 * pMessage );
	static G3_Network * FindIPAddress(UINT8 * pea);
	static void DetachNetwork(G3_Network * network);

	static void Abort();
};
