#pragma once

class HighResolutionTimer  
{
public:
  HighResolutionTimer()
  {
    if (m_Frequency == 0)      // frequency value not yet set
    {
      LARGE_INTEGER  frequency;

      QueryPerformanceFrequency(&frequency);
      m_Frequency = frequency.QuadPart;
    }
    QueryPerformanceCounter(&m_Counter);
  }

	~HighResolutionTimer(void){};

	void Reset()
	{
    QueryPerformanceCounter(&m_Counter);
	}

	int IntervalInMilliSeconds(bool reset=false)
  {
    LARGE_INTEGER now;
    QueryPerformanceCounter(&now);
    int duration = (int)(((now.QuadPart - m_Counter.QuadPart)*1000)/m_Frequency);

		if (reset == true)
		{
			m_Counter = now;
		}
		return duration;
  }

	int IntervalInMicroSeconds(bool reset=false)
  {
    LARGE_INTEGER    now;
    QueryPerformanceCounter(&now);
    int duration = (int)(((now.QuadPart - m_Counter.QuadPart)*1000000)/m_Frequency);
		
		if (reset == true)
		{
			m_Counter = now;
		}
		return duration;
  }

private:
  LARGE_INTEGER  m_Counter;

private:
  static LONGLONG  m_Frequency; 

private:
  HighResolutionTimer(const HighResolutionTimer&);
  HighResolutionTimer& operator=(const HighResolutionTimer&);
};

