#include "IPv6MainHeader.h"
#include <intrin.h>


IPv6Address::IPv6Address()
{
	memset(m_IpAddress, 0, sizeof(m_IpAddress));
}

IPv6Address::IPv6Address(UINT16 panId, UINT16 shortAddress)
{
	m_IpAddress[0] = 0x80FE;
	m_IpAddress[1] = 0x0000;
	m_IpAddress[2] = 0x0000;
	m_IpAddress[3] = 0x0000;

	m_IpAddress[4] = _rotr16(panId,8);
	m_IpAddress[5] = 0xFF00;
	m_IpAddress[6] = 0x00FE;
	m_IpAddress[7] = _rotr16(shortAddress,8);
}

WCHAR * IPv6Address::GetIPv6Address()
{
	WCHAR * address = new WCHAR[64];
	wsprintf(address, _T("%04X:%04X:%04X:%04X:%04X:%04X:%04X:%04X:"), 
		m_IpAddress[0],m_IpAddress[1],m_IpAddress[2],m_IpAddress[3],m_IpAddress[4],m_IpAddress[5],m_IpAddress[6],m_IpAddress[7]);

	return address;
}
IPv6MainHeader::IPv6MainHeader(void)
{
	m_Header = 0x0060;  // 0x60 00 0000 since this will be saved in little endian formatn
	m_PayloadLength = 0;
	m_NextHeader = 17;  // the next header is udp
	m_HopLimit = 0;
	m_UDP_SrcPort = 0;
	m_UDP_DestPort = 0;
	m_UDP_CRC = 0;
	m_UDP_PayloadLen = 0;
}
IPv6MainHeader::IPv6MainHeader(UINT8 * buffer)
{
	int offset = 0;
	Decode(buffer, offset);
}

IPv6MainHeader::IPv6MainHeader(UINT16 panId, UINT16 networkAddress):m_SourceAddress(panId, networkAddress)
{
	m_Header = 0x0060;  // 0x60 00 0000 since this will be saved in little endian formatn
	m_PayloadLength = 0;
	m_NextHeader = 17; // next header is udp
	m_HopLimit = 0;

	m_UDP_SrcPort = 0;
	m_UDP_DestPort = 0;
	m_UDP_CRC = 0;
	m_UDP_PayloadLen = 0;
}

IPv6MainHeader::~IPv6MainHeader(void)
{
}
UINT8  IPv6MainHeader::GetVersion()
{
	UINT32 temp = m_Header & 0x0F;
	UINT8 result = temp;
	return result;
}
UINT8  IPv6MainHeader::GetTrafficClass()
{
	UINT32 temp = m_Header & 0x0FF0;
	UINT8 result = temp >> 4;
	return result;
}
UINT32 IPv6MainHeader::GetFlowLabel()
{
	UINT32 temp = m_Header & 0x0FFFFF000;
	UINT32 result = temp >> 12;
	return result;
}
UINT16 IPv6MainHeader::GetPayloadLength()
{
	return m_PayloadLength;
}
UINT8  IPv6MainHeader::GetNextHeader()
{
	return m_NextHeader;
}
UINT8  IPv6MainHeader::GetHopLimit()
{
	return m_HopLimit;
}
UINT8 * IPv6MainHeader::GetSourceAddress()
{
	return (UINT8 *)m_SourceAddress.m_IpAddress;
}
UINT8 * IPv6MainHeader::GetDestinationAddress()
{
	return (UINT8 *)m_DestinationAddress.m_IpAddress;
}
UINT8 * IPv6MainHeader::GetData(UINT8 * buffer)
{
	return & buffer[IP6vHeaderSize];
}

UINT8  * IPv6MainHeader::GetData(UINT8 * buffer, int offset)
{
	return & buffer[offset];
}

void IPv6MainHeader::SwapAddresses(void)
{
	UINT8 temp[16];
	memcpy(temp, m_SourceAddress.m_IpAddress, sizeof(temp));
	memcpy(m_SourceAddress.m_IpAddress, m_DestinationAddress.m_IpAddress, sizeof(m_SourceAddress.m_IpAddress));
	memcpy(m_DestinationAddress.m_IpAddress, temp, sizeof(m_DestinationAddress.m_IpAddress));
}
void IPv6MainHeader::SetVersion(UINT8 value)
{
	UINT32 temp = value & 0x0000000F;
	m_Header = (m_Header & 0xFFFFFFF0) | temp;
}
void IPv6MainHeader::SetTrafficClass(UINT8 value)
{
	UINT32 temp = value & 0x000000FF;
	m_Header = (m_Header & 0xFFFFF00F) | (temp << 4);
}

void IPv6MainHeader::SetFlowLabel(UINT32 value)
{
	UINT32 temp = value & 0x000FFFFF;
	m_Header = (m_Header & 0x00000FFF) | (temp << 12);
}
void IPv6MainHeader::SetPayloadLength(UINT16 value)
{
	m_PayloadLength = value;
	m_UDP_PayloadLen = value+8;
}
void IPv6MainHeader::SetNextHeader(UINT8 value)
{
	m_NextHeader = value;
}
void IPv6MainHeader::SetHopLimit(UINT8 value )
{
	m_HopLimit = value;
}
void IPv6MainHeader::SetSourceAddress(UINT8 *value)
{
	memcpy(m_SourceAddress.m_IpAddress, value, sizeof(m_SourceAddress.m_IpAddress));
}
void IPv6MainHeader::SetDestinationAddress(UINT8 *value)
{
	memcpy(m_DestinationAddress.m_IpAddress, value, sizeof(m_DestinationAddress.m_IpAddress));
}

int IPv6MainHeader::Encode(UINT8 * buffer, int offset)
{
	int saveOffset = offset;
	memcpy(&buffer[offset], &m_Header, sizeof (m_Header));
	offset += sizeof(m_Header);

	UINT16 temp = _rotr16(m_PayloadLength, 8);
	memcpy(&buffer[offset], & temp, sizeof(m_PayloadLength));

	offset += sizeof(m_PayloadLength);

	buffer[offset] = m_NextHeader;
	offset += sizeof(m_NextHeader);
	buffer[offset] = m_HopLimit;
	offset += sizeof(m_HopLimit);

	memcpy(&buffer[offset], m_SourceAddress.m_IpAddress, sizeof(m_SourceAddress.m_IpAddress));
	offset += sizeof(m_SourceAddress.m_IpAddress);
	memcpy(&buffer[offset], m_DestinationAddress.m_IpAddress, sizeof(m_DestinationAddress.m_IpAddress));
	offset += sizeof(m_DestinationAddress.m_IpAddress);

	memcpy(&buffer[offset], &m_UDP_SrcPort, sizeof(m_UDP_SrcPort));
	offset += sizeof(m_UDP_SrcPort);

	memcpy(&buffer[offset], &m_UDP_DestPort, sizeof(m_UDP_DestPort));
	offset += sizeof(m_UDP_DestPort);

	memcpy(&buffer[offset], &m_UDP_PayloadLen, sizeof(m_UDP_PayloadLen));
	offset += sizeof(m_UDP_PayloadLen);

	memcpy(&buffer[offset], &m_UDP_CRC, sizeof(m_UDP_CRC));
	offset += sizeof(m_UDP_CRC);

	return offset;
}
int IPv6MainHeader::Decode(UINT8 * buffer, int offset)
{
	memcpy(&m_Header, &buffer[offset], sizeof (m_Header));
	offset += sizeof(m_Header);

	UINT16 temp;
	
	memcpy(&temp, &buffer[offset], sizeof(m_PayloadLength));
	m_PayloadLength = _rotr16(temp, 8);
	offset += sizeof(m_PayloadLength);

	m_NextHeader = buffer[offset];
	offset += sizeof(m_NextHeader);

	m_HopLimit = buffer[offset];
	offset += sizeof(m_HopLimit);

	memcpy(m_SourceAddress.m_IpAddress, &buffer[offset], sizeof(m_SourceAddress.m_IpAddress));
	offset += sizeof(m_SourceAddress.m_IpAddress);
	
	memcpy(m_DestinationAddress.m_IpAddress, &buffer[offset], sizeof(m_DestinationAddress.m_IpAddress));
	offset += sizeof(m_SourceAddress.m_IpAddress);
	
	memcpy(&m_UDP_SrcPort, &buffer[offset], sizeof(m_UDP_SrcPort));
	offset += sizeof(m_UDP_SrcPort);

	memcpy(&m_UDP_DestPort, &buffer[offset], sizeof(m_UDP_DestPort));
	offset += sizeof(m_UDP_DestPort);

	memcpy(&m_UDP_PayloadLen, &buffer[offset], sizeof(m_UDP_PayloadLen));
	offset += sizeof(m_UDP_PayloadLen);

	memcpy(&m_UDP_CRC, &buffer[offset], sizeof(m_UDP_CRC));
	offset += sizeof(m_UDP_CRC);

	return offset;
}

