#pragma once
#include "stdafx.h"

struct IPv6Address
{
	UINT16 m_IpAddress[8];

	IPv6Address();
	IPv6Address(UINT16 panId, UINT16 networkAddress);

	WCHAR * GetIPv6Address();
};

class IPv6MainHeader
{
	UINT32 m_Header;
	UINT16 m_PayloadLength;
	UINT8 m_NextHeader;
	UINT8 m_HopLimit;

public:
	IPv6Address m_SourceAddress;
	IPv6Address m_DestinationAddress;

private:
	UINT16 m_UDP_SrcPort;
	UINT16 m_UDP_DestPort;
	UINT16 m_UDP_PayloadLen;
	UINT16 m_UDP_CRC;

public:
	IPv6MainHeader(void);
	IPv6MainHeader(UINT16 panId, UINT16 networkAddress);
	IPv6MainHeader(UINT8 * buffer);

	virtual ~IPv6MainHeader(void);

	static const int IP6vHeaderSize = 48;
  /*	sizeof(m_Header)
		+ sizeof(m_PayloadLength)
		+ sizeof(m_NextHeader)
		+ sizeof(m_HopLimit)
		+ sizeof(m_SourceAddress)
		+ sizeof(m_DestinationAddress);
		*/
	UINT8  GetVersion();
	UINT8  GetTrafficClass();
	UINT32 GetFlowLabel();
	UINT16 GetPayloadLength();
	UINT8  GetNextHeader();
	UINT8  GetHopLimit();
	UINT8  * GetSourceAddress();
	UINT8  * GetDestinationAddress();
	UINT8  * GetData(UINT8 * buffer);
	UINT8  * GetData(UINT8 * buffer, int offset);

	void SwapAddresses(void);

	void SetVersion(UINT8 value);
	void SetTrafficClass(UINT8 value);
	void SetFlowLabel(UINT32 value);
	void SetPayloadLength(UINT16 value);
	void SetNextHeader(UINT8 value);
	void SetHopLimit(UINT8 value );
	void SetSourceAddress(UINT8 value[]);
	void SetDestinationAddress(UINT8 value[]);
	//int  SetData(UINT8 * buffer);
	//int  SetData(UINT8 * buffer, int offset);

	int Encode(UINT8 * buffer, int offest);
	int Decode(UINT8 * buffer, int offest);
};
