#pragma once

#include "eca_appemu_mgh.h"
#include "hostappemu.h"
#include "IPv6MainHeader.h"

class TunTap
{
public:
	TunTap(char * tunTapDriverName, UINT32 tunTapIPv4Address, UINT32 mode);
	virtual ~TunTap(void);

	WCHAR * GetDeviceGUID() { return m_DeviceGuid; }
	WCHAR * GetHumanName()  { return m_HumanName; }

	DWORD Status() { return m_Status; }
	WCHAR * LastError();
	//
	// Write data to Tun Tap driver
	//
	void WriteToTunTap(HCT_MSG_BUFFER_t *pmsg, UINT16 msg_len, BOOL bRPY);
	void EchoPingRequest(HCT_MSG_BUFFER_t * pmsg, UINT16 msg_len, BOOL bRPY);
	UINT16 CheckSum(unsigned char * data, int length);

private:
	static const UINT16 IPv4Message = 0x20;
	static const UINT16 IPv6Message = 0x21;

	UINT32 m_Mode;

	UINT32 m_TunTapIPv4Address;
	HANDLE m_TunTapWriteEvent; 
	HANDLE m_DeviceHandle;
	HANDLE m_WriteHandle;
	char m_TunTapDriverName[256];
	int m_MsgLength;

	WCHAR m_DeviceGuid[512];
	WCHAR m_HumanName[128];

	DWORD m_Status;
	int m_PayloadId;

	HANDLE m_TunTapListener_Thread;
	DWORD m_TunTapListener_ThreadID;
	static DWORD WINAPI TunTapListener(LPVOID lpParam);


	void FindDeviceGuid(HKEY hKey, WCHAR * startingKey);
	void FindHumanName(WCHAR * guild);
	
	void SendNodeMessage(UINT16 payloadType, UINT8 * data, UINT16 payloadLength, IPv6Address destination, IPv6Address source);
	void SendNodeMessage(UINT16 payloadType, UINT8 * data, UINT16 payloadLength, UINT16 shortAddress);

	unsigned int TAP_CONTROL_CODE(unsigned int request, unsigned int method);
};
