/******************************************************************************
* FILE PURPOSE: Embedded Component Framework module.
*******************************************************************************
*
* FILE NAME: ec_task.h
*
* DESCRIPTION:
*       Embedded Component task header file.
*
* HISTORY:
* 07/07/2009  stephen smith   initial revision
*
* Copyright (c) 2009 Texas Instruments Inc.  All rights reserved.
******************************************************************************/
#ifndef __EC_TASK_H__
#define __EC_TASK_H__

//#include <prime_mac_app.h>
#include <mac.h>
#include "ecf.h"

#define EC_TASK_TIMER       (ECF_TASK_TYPE_OTHER_START + 0)

typedef enum
{
  EC_TASK_MSG_ID_SendDataPkt,
  EC_TASK_MSG_ID_RecvDataPkt
} EC_TASK_MSG_ID_t;

typedef struct
{
  EC_TASK_MSG_ID_t msg_id;
  void *pdata;
} EC_TASK_MSG_s;

#define EC_TASK_FLAGS_TEST_CONNECTION_ARQ     (1 << 0)
#define EC_TASK_FLAGS_TEST_CONNECTION_AES     (1 << 1)
typedef struct
{
  ECF_MGH_s *pECF_mgh;
  UINT16 flags;     // EC_TASK_FLAGS_xxx
  MAC_CM_ConnHandle_t hmacTestConnection;

  UINT32 malloc_err;
} EC_TASK_MGH_s;

/* global API */
void EC_Task_Init(MP_SPOOL_HND_s *pmp_pool_hnd_tx, MP_SPOOL_HND_s *pmp_pool_hnd_rx);
void EC_Task_PostDataPkt(SBD_s *pbd);
void EC_Task_timer(void);
void EC_Task_thread(void);
UINT32 EC_OpenTestConnection(void);
UINT32 EC_CloseTestConnection(void);

#endif // #ifndef __EC_TASK_H__
