/******************************************************************************
* FILE PURPOSE: HCT Message module defines.
*******************************************************************************
*
* FILE NAME: hct.h
*
* DESCRIPTION:
*       HCT (Host Controller) Message defines.
*
* HISTORY:
* 03/25/2007  stephen smith ported from WiMAX.
* 06/01/2009  stephen smith converted to Prime project
*
* Copyright (c) 2007-2009 Texas Instruments Inc.  All rights reserved.
******************************************************************************/
#ifndef __HCT_MSG_DEF_H__
#define __HCT_MSG_DEF_H__

#if defined(_M_IX86)    // Visual Studio 2005 (Windows)
typedef signed int          SINT16;     // Signed 16-bit integer (15-bit magnitude)
#elif defined(__TI_COMPILER_VERSION__)  // TI Code Composer Studio
#include <typedefs.h>
#endif

#if !defined(__TI_COMPILER_VERSION__)  // TI Code Composer Studio
// structs byte packed
#pragma pack(1)
#endif // #if !defined(__TI_COMPILER_VERSION__)  // TI Code Composer Studio

#define HCT_MSG_OFFSET_MSG_TYPE_TAG         0
#define HCT_MSG_OFFSET_MSG_LENGTH           2
#define HCT_MSG_SIZE_MSG_TYPE_TAG           2 // (sizeof(UINT16) * CHAR_BIT) // CHAR_BIT, see limits.h
#define HCT_MSG_SIZE_MSG_LENGTH             2 // (sizeof(UINT16) * CHAR_BIT) // CHAR_BIT, see limits.h
#define HCT_MSG_HDR_SIZE                    4 // (sizeof(UINT32) * CHAR_BIT) // CHAR_BIT, see limits.h

/* message header tag definitions */
#define HCT_MSG_TYPE_MASK                   0x00ff
#define HCT_MSG_SEQ_MASK                    0x0f00
#define HCT_MSG_TAG_MASK                    0xf000
#define HCT_MSG_TAG_RESV_MASK               0x3000
#define HCT_MSG_TAG_ORG_MASK                0x8000
#define HCT_MSG_TAG_RPY_MASK                0x4000
#define HCT_MSG_TAG_ORG_MAC                 0x0000  // originated from the MAC (device)
#define HCT_MSG_TAG_ORG_HOST                0x8000  // originated from the Host (pc)
#define HCT_MSG_TAG_MSG_RPY_ACK             0x4000
#define HCT_MSG_TAG_MSG_RPY_NO_ACK          0x0000

#define HCT_MSG_TYPE_GET(pmsghdr)           (( *(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_TYPE_TAG >> 1)) & HCT_MSG_TYPE_MASK))
#define HCT_MSG_TAG_GET(pmsghdr)            (( *(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_TYPE_TAG >> 1)) & HCT_MSG_TAG_MASK))
#define HCT_MSG_ORG_GET(pmsghdr)            (( *(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_TYPE_TAG >> 1)) & HCT_MSG_TAG_ORG_MASK))
#define HCT_MSG_RPY_GET(pmsghdr)            (( *(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_TYPE_TAG >> 1)) & HCT_MSG_TAG_RPY_MASK))
#define HCT_MSG_SEQ_GET(pmsghdr)            (( *(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_TYPE_TAG >> 1)) & HCT_MSG_SEQ_MASK) >> 8)
#define HCT_MSG_LEN_GET(pmsghdr)            (( *(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_LENGTH >> 1)) ))
#define HCT_MSG_TYPE_SET(pmsghdr, v)        (( *(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_TYPE_TAG >> 1)) ) =  ( ((v) & HCT_MSG_TYPE_MASK) | (*(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_TYPE_TAG >> 1)) & HCT_MSG_TAG_MASK )) )
#define HCT_MSG_TAG_SET(pmsghdr, v)         (( *(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_TYPE_TAG >> 1)) ) =  ( ((v) & HCT_MSG_TAG_MASK)  | (*(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_TYPE_TAG >> 1)) & HCT_MSG_TYPE_MASK)) )
#define HCT_MSG_ORG_SET(pmsghdr, v)         (( *(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_TYPE_TAG >> 1)) ) =  ( ((v) & HCT_MSG_TAG_ORG_MASK)   | (*(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_TYPE_TAG >> 1)) & ~HCT_MSG_TAG_ORG_MASK)) )
#define HCT_MSG_RPY_SET(pmsghdr, v)         (( *(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_TYPE_TAG >> 1)) ) =  ( ((v) & HCT_MSG_TAG_RPY_MASK)   | (*(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_TYPE_TAG >> 1)) & ~HCT_MSG_TAG_RPY_MASK)) )
#define HCT_MSG_SEQ_SET(pmsghdr, v)         (( *(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_TYPE_TAG >> 1)) ) = ( (((v) << 8) & HCT_MSG_SEQ_MASK) | (*(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_TYPE_TAG >> 1)) & ~HCT_MSG_SEQ_MASK    )) )
#define HCT_MSG_LEN_SET(pmsghdr, v)         (( *(((UINT16 *) pmsghdr) + (HCT_MSG_OFFSET_MSG_LENGTH >> 1)) ) = (v) )

typedef UINT16 HCT_MSG_HEADER_t, *PHCT_MSG_HEADER_t;
typedef UINT16 HCT_MSG_BUFFER_t, *PHCT_MSG_BUFFER_t;

/* HCT_MSG_EXT_HEADER */
typedef struct
{
  UINT16 Header_CRC16;
  UINT16 Payload_CRC16;
} HCT_MSG_EXT_HEADER_s;

#define HCT_MSG_EXT_HDR_OFFSET_HEADER_CRC16                 0
#define HCT_MSG_EXT_HDR_OFFSET_PAYLOAD_CRC16                2
#define HCT_MSG_EXT_HDR_SIZE_HEADER_CRC16                   2
#define HCT_MSG_EXT_HDR_SIZE_PAYLOAD_CRC16                  2
#define HCT_MSG_EXT_HDR_SIZE                                4

#define HCT_MSG_HDR_CRC_GET(pmsghdr)        (( *(((UINT16 *) pmsghdr) + HCT_MSG_HDR_SIZE + (HCT_MSG_EXT_HDR_OFFSET_HEADER_CRC16 >> 1)) ))
#define HCT_MSG_PLD_CRC_GET(pmsghdr)        (( *(((UINT16 *) pmsghdr) + HCT_MSG_HDR_SIZE + (HCT_MSG_EXT_HDR_OFFSET_PAYLOAD_CRC16 >> 1)) ))
#define HCT_MSG_HDR_CRC_SET(pmsghdr, v)     (( *(((UINT16 *) pmsghdr) + HCT_MSG_HDR_SIZE + (HCT_MSG_EXT_HDR_OFFSET_HEADER_CRC16 >> 1)) ) = (v) )
#define HCT_MSG_PLD_CRC_SET(pmsghdr, v)     (( *(((UINT16 *) pmsghdr) + HCT_MSG_HDR_SIZE + (HCT_MSG_EXT_HDR_OFFSET_PAYLOAD_CRC16 >> 1)) ) = (v) )

/* a standard reply message with only a status field */
typedef struct
{
  UINT16 status;
} HCT_MSG_RPY_STD_STATUS_s;

#define HCT_MSG_RPY_STD_STATUS_OFFSET_status                0
#define HCT_MSG_RPY_STD_STATUS_SIZE_status                  2
#define HCT_MSG_RPY_STD_STATUS_SIZE                         2

#if !defined(__TI_COMPILER_VERSION__)  // TI Code Composer Studio
// return to default packing
#pragma pack()
#endif // #if !defined(__TI_COMPILER_VERSION__)  // TI Code Composer Studio

#endif // #ifndef __HCT_MSG_DEF_H__
