/******************************************************************************
* FILE PURPOSE: HCT interface module.
*******************************************************************************
*
* FILE NAME: hct_msg_if_def.h
*
* DESCRIPTION:
*       HCT interface module public header file.
*
* HISTORY:
* 12/01/2009  stephen smith   initial revision.
*
* Copyright (c) 2009-2010 Texas Instruments Inc.  All rights reserved.
******************************************************************************/
#ifndef __HCT_MSG_IF_DEF_H__
#define __HCT_MSG_IF_DEF_H__

#if defined(_M_IX86)    // Visual Studio 2005 (Windows)
typedef signed int          SINT16;     // Signed 16-bit integer (15-bit magnitude)
#elif defined(__TI_COMPILER_VERSION__)  // TI Code Composer Studio
#include <typedefs.h>
#endif

#if defined(PRIME_IEC432)
 #if !defined(PRIME)
  #define HCT_MSG_IF_PLATFORM_DEFINES_ERROR
 #elif defined(PRIME_IP) || defined(G3)
  #define HCT_MSG_IF_PLATFORM_DEFINES_ERROR
 #endif
#elif defined(PRIME_IP)
 #if !defined(PRIME)
  #define HCT_MSG_IF_PLATFORM_DEFINES_ERROR
 #elif defined(PRIME_IEC432) || defined(G3)
  #define HCT_MSG_IF_PLATFORM_DEFINES_ERROR
 #endif
#elif defined(G3)
 #if defined(PRIME) || defined(PRIME_IEC432) || defined(PRIME_IP)
  #define HCT_MSG_IF_PLATFORM_DEFINES_ERROR
 #endif
#endif
#if defined(HCT_MSG_IF_PLATFORM_DEFINES_ERROR)
 #error Platform Defines Error!  Only PRIME_IEC432 or PRIME_IP or G3 may be defined!
#endif

#if !defined(__TI_COMPILER_VERSION__)  // TI Code Composer Studio
// structs byte packed
#pragma pack(1)
#endif // #if !defined(__TI_COMPILER_VERSION__)  // TI Code Composer Studio

/* version of the message interface specification */
#define HCT_MSG_MSG_IF_VERSION                              0x00080000

/* Status definitions */
#define HCT_MSG_STATUS_GENERAL_ERROR_CODE_GROUP             0x0000
#define HCT_MSG_STATUS_PHY_ERROR_CODE_GROUP                 0x1000
#define HCT_MSG_STATUS_MAC_ERROR_CODE_GROUP                 0x2000
#define HCT_MSG_STATUS_CL_ERROR_CODE_GROUP                  0x3000
#define HCT_MSG_STATUS_ECA_ERROR_CODE_GROUP                 0x4000
#define HCT_MSG_STATUS_ADP_ERROR_CODE_GROUP                 0x5000

#define HCT_MSG_STATUS_OK                                   0x00
#define HCT_MSG_STATUS_SUCCESS                              HCT_MSG_STATUS_OK
#define HCT_MSG_STATUS_INVALID_PARAMETER                    0x02
#define HCT_MSG_STATUS_FEATURE_UNSUPPORTED                  0x03
#define HCT_MSG_STATUS_PAYLOAD_CRC_ERROR                    0x04
#define HCT_MSG_STATUS_NO_EEPROM                            0x05
#define HCT_MSG_STATUS_HEADER_CRC_ERROR                     0x06
#define HCT_MSG_STATUS_INVALID_HANDLE                       0x07
#define HCT_MSG_STATUS_INVALID_FORMAT                       0x08
#define HCT_MSG_STATUS_RPY_BLOCKED                          0x09
#define HCT_MSG_STATUS_RPY_NOT_BLOCKED                      0x0a
#define HCT_MSG_STATUS_INVALID_MESSAGE_LENGTH               0x0b
#define HCT_MSG_STATUS_ERR_NO_HANDLER                       0xf3
#define HCT_MSG_STATUS_PENDING                              0xfc
#define HCT_MSG_STATUS_ERR_TIMEOUT                          0xfd
#define HCT_MSG_STATUS_ERR_NO_MEMORY                        0xfe
#define HCT_MSG_STATUS_GENERAL_FAILURE                      0xff

/* message types */
#define HCT_MSG_TYPE_DATA_TRANSFER                          0x0000
#define HCT_MSG_TYPE_GET_SYSTEM_INFO                        0x0001
#define HCT_MSG_TYPE_GET_PHY_PIB                            0x0002
#define HCT_MSG_TYPE_GET_MAC_PIB                            0x0003
#define HCT_MSG_TYPE_SET_INFO                               0x0004
#define HCT_MSG_TYPE_SHUT_DOWN                              0x0005
#define HCT_MSG_TYPE_SETUP_ALARM                            0x0006
#define HCT_MSG_TYPE_ALARM                                  0x0007
#define HCT_MSG_TYPE_NETWORK_REGISTER                       0x0008
#define HCT_MSG_TYPE_NETWORK_START                          0x0008
#define HCT_MSG_TYPE_NETWORK_UNREGISTER                     0x0009
#define HCT_MSG_TYPE_CONNECT                                0x000a
#define HCT_MSG_TYPE_DISCONNECT                             0x000b
#define HCT_MSG_TYPE_LOAD_SYSTEM_CONFIG                     0x000c
#define HCT_MSG_TYPE_SET_MAC_PIB                            0x000d
#define HCT_MSG_TYPE_CLEAR_PHY_PIB                          0x000e
#define HCT_MSG_TYPE_CLEAR_MAC_PIB                          0x000f
#define HCT_MSG_TYPE_CL_ESTABLISH                           0x0010
#define HCT_MSG_TYPE_ATTACH                                 0x0010
#define HCT_MSG_TYPE_CL_RELEASE                             0x0011
#define HCT_MSG_TYPE_DETACH                                 0x0011
#define HCT_MSG_TYPE_DISCOVER                               0x0012
#define HCT_MSG_TYPE_FIRMWARE_UPGRADE						0x0013
#define HCT_MSG_TYPE_FIRMWARE_FLASH							0x0094
#define HCT_MGG_TYPE_FIRMWARE_READ_BLOB						0x0096
#define HCT_MGG_TYPE_FIRMWARE_WRITE_BLOB					0x0097
#define HCT_MSG_TYPE_INVALID_MSG                            0x00ff

/* connection types */
#define HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_AR                0x0001
#define HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_UNICAST           0x0002
#define HCT_MSG_CONNECT_CONN_TYPE_CL_IEC432                 0x0003
#define HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_MULTICAST         0x0004
#define HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_BROADCAST         0x0005
#define HCT_MSG_CONNECT_CONN_TYPE_MAC                       0x00fd
#define HCT_MSG_CONNECT_CONN_TYPE_NONE                      0x00ff

/* HCT_MSG_TYPE_DATA_TRANSFER */

#define HCT_MSG_DATA_TRANSFER_MODE_OFFSET                   0
#define HCT_MSG_DATA_TRANSFER_MODE_SIZE                     2
#define HCT_MSG_DATA_TRANSFER_MODE_REQUEST                  0x01
#define HCT_MSG_DATA_TRANSFER_MODE_CONFIRM                  0x02
#define HCT_MSG_DATA_TRANSFER_MODE_INDICATION               0x03
#define HCT_MSG_DATA_TRANSFER_MODE_REPLY_REQUEST            0x04
#define HCT_MSG_DATA_TRANSFER_MODE_REPLY_CONFIRM            0x05
#define HCT_MSG_DATA_TRANSFER_MODE_REPLY_INDICATION         0x06
#define HCT_MSG_DATA_TRANSFER_MODE_UPDATE_REPLY_REQUEST     0x07
#define HCT_MSG_DATA_TRANSFER_MODE_UPDATE_REPLY_CONFIRM     0x08
#define HCT_MSG_DATA_TRANSFER_MODE_UPDATE_REPLY_INDICATION  0x09

// DATA_TRANSFER.Request: (message from host to PLC)
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_DST_LSAP_MASK     0x00ff
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_SRC_LSAP_MASK     0xff00
typedef struct
{
  UINT16 Mode;    // HCT_MSG_DATA_TRANSFER_MODE_xxx
  UINT16 Dst_LSAP_Src_LSAP;
  UINT16 Dest_Addr;
  UINT16 reserved[2];
// UINT8 Data;
} HCT_MSG_REQ_DATA_TRANSFER_REQUEST_s;

#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_OFFSET_Mode               0
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_OFFSET_Dst_LSAP_Src_LSAP  2
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_OFFSET_Dest_Addr          4
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_OFFSET_reserved           6
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_OFFSET_Data               10
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_SIZE_Mode                 2
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_SIZE_Dst_LSAP_Src_LSAP    2
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_SIZE_Dest_Addr            2
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_SIZE_reserved             4
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_SIZE                      10

#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_OFFSET_Dst_LSAP           2
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_OFFSET_Src_LSAP           3
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_SIZE_Dst_LSAP             1
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_SIZE_Src_LSAP             1

// DATA_TRANSFER.Confirm: (message from PLC to host)
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_DST_LSAP_MASK     0x00ff
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_SRC_LSAP_MASK     0xff00
typedef struct
{
  UINT16 Mode;    // HCT_MSG_DATA_TRANSFER_MODE_xxx
  UINT16 Dst_LSAP_Src_LSAP;
  UINT16 Dest_Addr;
  UINT16 reserved[2];
  UINT16 Status;
} HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_s;

#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_OFFSET_Mode               0
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_OFFSET_Dst_LSAP_Src_LSAP  2
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_OFFSET_Dest_Addr          4
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_OFFSET_reserved           6
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_OFFSET_Status             10
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_SIZE_Mode                 2
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_SIZE_Dst_LSAP_Src_LSAP    2
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_SIZE_Dest_Addr            2
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_SIZE_reserved             4
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_SIZE_Status               2
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_SIZE                      12

#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_OFFSET_Dst_LSAP           2
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_OFFSET_Src_LSAP           3
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_SIZE_Dst_LSAP             1
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_SIZE_Src_LSAP             1

#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_OFFSET_Dst_LSAP           2
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_OFFSET_Src_LSAP           3
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_SIZE_Dst_LSAP             1
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_SIZE_Src_LSAP             1

// DATA_TRANSFER.Indication: (message from PLC to host)
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_DST_LSAP_MASK     0x00ff
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_SRC_LSAP_MASK     0xff00
typedef struct
{
  UINT16 Mode;    // HCT_MSG_DATA_TRANSFER_MODE_xxx
  UINT16 Dst_LSAP_Src_LSAP;
  UINT16 Dest_Addr;
  UINT16 reserved_1[2];
  UINT16 Src_Addr;
  UINT16 reserved_2[2];
// UINT8 Data;
} HCT_MSG_REQ_DATA_TRANSFER_INDICATION_s;

#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_OFFSET_Mode                0
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_OFFSET_Dst_LSAP_Src_LSAP   2
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_OFFSET_Dest_Addr           4
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_OFFSET_reserved_1          6
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_OFFSET_Src_Addr            10
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_OFFSET_reserved_2          12
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_OFFSET_Data                16
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_SIZE_Mode                  2
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_SIZE_Dst_LSAP_Src_LSAP     2
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_SIZE_Dest_Addr             2
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_SIZE_reserved_1            4
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_SIZE_Src_Addr              2
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_SIZE_reserved_2            4
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_SIZE                       16

#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_OFFSET_Dst_LSAP            2
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_OFFSET_Src_LSAP            3
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_SIZE_Dst_LSAP              1
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_SIZE_Src_LSAP              1

#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_OFFSET_Dst_LSAP            2
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_OFFSET_Src_LSAP            3
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_SIZE_Dst_LSAP              1
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_SIZE_Src_LSAP              1

// DATA_TRANSFER_Reply.Request: (message from host to PLC)
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_DST_LSAP_MASK     0x00ff
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_SRC_LSAP_MASK     0xff00
typedef struct
{
  UINT16 Mode;    // HCT_MSG_DATA_TRANSFER_MODE_xxx
  UINT16 Dst_LSAP_Src_LSAP;
  UINT16 Dst_MAC_Addr;
  UINT16 reserved[2];
  UINT16 Length_Allowed;
} HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_s;

#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_OFFSET_Mode                 0
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_OFFSET_Dst_LSAP_Src_LSAP    2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_OFFSET_Dest_Addr            4
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_OFFSET_reserved             6
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_OFFSET_Length_Allowed       10
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_SIZE_Mode                   2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_SIZE_Dst_LSAP_Src_LSAP      2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_SIZE_Dest_Addr              2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_SIZE_reserved               4
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_SIZE_Length_Allowed         2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_SIZE                        12

#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_OFFSET_Dst_LSAP             2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_OFFSET_Src_LSAP             3
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_SIZE_Dst_LSAP               1
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_REQUEST_SIZE_Src_LSAP               1

// DATA_TRANSFER_Reply.Confirm: (message from PLC to host)
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_DST_LSAP_MASK     0x00ff
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_SRC_LSAP_MASK     0xff00
typedef struct
{
  UINT16 Mode;    // HCT_MSG_DATA_TRANSFER_MODE_xxx
  UINT16 Dst_LSAP_Src_LSAP;
  UINT16 Dest_Addr;
  UINT16 reserved_1[2];
  UINT16 Src_Addr;
  UINT16 reserved_2[2];
} HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_s;

#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_OFFSET_Mode                 0
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_OFFSET_Dst_LSAP_Src_LSAP    2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_OFFSET_Dest_Addr            4
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_OFFSET_reserved_1           6
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_OFFSET_Src_Addr             10
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_OFFSET_reserved_2           12
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_SIZE_Mode                   2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_SIZE_Dst_LSAP_Src_LSAP      2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_SIZE_Dest_Addr              2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_SIZE_reserved_1             4
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_SIZE_Src_Addr               2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_SIZE_reserved_2             4
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_SIZE                        16

#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_OFFSET_Dst_LSAP             2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_OFFSET_Src_LSAP             3
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_SIZE_Dst_LSAP               1
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_CONFIRM_SIZE_Src_LSAP               1

// DATA_TRANSFER_Reply.Indication: (message from PLC to host)
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_DST_LSAP_MASK     0x00ff
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_SRC_LSAP_MASK     0xff00
typedef struct
{
  UINT16 Mode;    // HCT_MSG_DATA_TRANSFER_MODE_xxx
  UINT16 Dst_LSAP_Src_LSAP;
  UINT16 Src_Addr;
  UINT16 reserved[2];
} HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_s;

#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_OFFSET_Mode                 0
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_OFFSET_Dst_LSAP_Src_LSAP    2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_OFFSET_Src_Addr             4
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_OFFSET_reserved             6
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_SIZE_Mode                   2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_SIZE_Dst_LSAP_Src_LSAP      2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_SIZE_Src_Addr               2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_SIZE_reserved               4
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_SIZE                        10

#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_OFFSET_Dst_LSAP             2
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_OFFSET_Src_LSAP             3
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_SIZE_Dst_LSAP               1
#define HCT_MSG_REQ_DATA_TRANSFER_REPLY_INDICATION_SIZE_Src_LSAP               1

// DATA_TRANSFER_Update_Reply.Request: (message from host to PLC)
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_REQUEST_DST_LSAP_MASK     0x00ff
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_REQUEST_SRC_LSAP_MASK     0xff00
typedef struct
{
  UINT16 Mode;    // HCT_MSG_DATA_TRANSFER_MODE_xxx
  UINT16 Src_LSAP_Pad;
} HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_REQUEST_s;

#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_REQUEST_OFFSET_Mode                 0
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_REQUEST_OFFSET_Src_LSAP_Pad         2
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_REQUEST_SIZE_Mode                   2
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_REQUEST_SIZE_Src_LSAP_Pad           2
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_REQUEST_SIZE                        4

#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_REQUEST_OFFSET_Src_LSAP             2
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_REQUEST_OFFSET_Pad                  3
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_REQUEST_SIZE_Src_LSAP               1
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_REQUEST_SIZE_Pad                    1

// DATA_TRANSFER_Update_Reply.Confirm: (message from PLC to host)
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_CONFIRM_DST_LSAP_MASK     0x00ff
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_CONFIRM_SRC_LSAP_MASK     0xff00
typedef struct
{
  UINT16 Mode;    // HCT_MSG_DATA_TRANSFER_MODE_xxx
  UINT16 Src_LSAP_Pad;
} HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_CONFIRM_s;

#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_CONFIRM_OFFSET_Mode                 0
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_CONFIRM_OFFSET_Src_LSAP_Pad         2
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_CONFIRM_SIZE_Mode                   2
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_CONFIRM_SIZE_Src_LSAP_Pad           2
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_CONFIRM_SIZE                        4

#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_CONFIRM_OFFSET_Src_LSAP             2
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_CONFIRM_OFFSET_Pad                  3
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_CONFIRM_SIZE_Src_LSAP               1
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_CONFIRM_SIZE_Pad                    1

// DATA_TRANSFER_Update_Reply.Indication: (message from PLC to host)
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_DST_LSAP_MASK     0x00ff
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_SRC_LSAP_MASK     0xff00
typedef struct
{
  UINT16 Mode;    // HCT_MSG_DATA_TRANSFER_MODE_xxx
  UINT16 Dst_LSAP_Src_LSAP;
  UINT16 Dest_Addr;
  UINT16 reserved_1[2];
  UINT16 Src_Addr;
  UINT16 reserved_2[2];
  UINT16 Length_Allowed;
} HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_s;

#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_OFFSET_Mode                 0
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_OFFSET_Dst_LSAP_Src_LSAP    2
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_OFFSET_Dest_Addr            4
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_OFFSET_reserved_1           6
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_OFFSET_Src_Addr             10
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_OFFSET_reserved_2           12
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_OFFSET_Length_Allowed       16
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_SIZE_Mode                   2
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_SIZE_Dst_LSAP_Src_LSAP      2
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_SIZE_Dest_Addr              2
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_SIZE_reserved_1             4
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_SIZE_Src_Addr               2
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_SIZE_reserved_2             4
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_SIZE_Length_Allowed         2
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_SIZE                        18

#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_OFFSET_Dst_LSAP             2
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_OFFSET_Src_LSAP             3
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_SIZE_Dst_LSAP               1
#define HCT_MSG_REQ_DATA_TRANSFER_UPDATE_REPLY_INDICATION_SIZE_Src_LSAP               1

// DATA_TRANSFER.Request: (message from host to PLC)
typedef struct
{
  UINT16 NSDU_Handle_Flags;
// UINT8 L_SDU_Data;
} HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_s;

#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_OFFSET_NSDU_Handle_Flags   0
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_OFFSET_Data                2
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_SIZE_NSDU_Handle_Flags     2
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_SIZE                       2

#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_NSDU_HANDLE_MASK           0x00ff
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_FLAGS_MASK                 0xff00
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_FLAGS_DISCOVERY_ROUTE      (1 << 8)
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_FLAGS_SEC                  (1 << 9)
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_FLAGS_QOS                  (1 << 10)

#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_FLAGS_DISCOVERY_ROUTE_DISABLED   0
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_FLAGS_DISCOVERY_ROUTE_ENABLED    HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_FLAGS_DISCOVERY_ROUTE
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_FLAGS_SEC_DISABLED               0
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_FLAGS_SEC_ENABLED                HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_FLAGS_SEC
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_FLAGS_QOS_PRIORITY_STD           0
#define HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_FLAGS_QOS_PRIORITY_HIGH          HCT_MSG_REQ_DATA_TRANSFER_REQUEST_G3_FLAGS_QOS

// DATA_TRANSFER.Confirm: (message from PLC to host)
typedef struct
{
  UINT16 NSDU_Handle_Resv;
  UINT16 Status;
} HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_G3_s;

#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_G3_OFFSET_NSDU_Handle_Resv    0
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_G3_OFFSET_Status              2
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_G3_SIZE_NSDU_Handle_Resv      2
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_G3_SIZE_Status                2
#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_G3_SIZE                       4

#define HCT_MSG_REQ_DATA_TRANSFER_CONFIRM_G3_NSDU_Handle_MASK           0x00ff


// DATA_TRANSFER.Indication: (message from PLC to host)
typedef struct
{
  UINT16 LinkQualityIndicator_Flags;
// UINT8 Data;
} HCT_MSG_REQ_DATA_TRANSFER_INDICATION_G3_s;

#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_G3_OFFSET_LinkQualityIndicator_Flags   0
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_G3_OFFSET_LinkQualityIndicator         0
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_G3_OFFSET_Flags                        1
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_G3_OFFSET_Data                         2
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_G3_SIZE_LinkQualityIndicator_Flags     2
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_G3_SIZE_LinkQualityIndicator           1
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_G3_SIZE_Flags                          1
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_G3_SIZE                                2

#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_G3_LinkQualityIndicator_MASK           0x00ff
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_G3_FLAGS_MASK                          0xff00
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_G3_FLAGS_SEC                           (1 << 8)

#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_G3_FLAGS_SEC_DISABLED                  0
#define HCT_MSG_REQ_DATA_TRANSFER_INDICATION_G3_FLAGS_SEC_ENABLED                   HCT_MSG_REQ_DATA_TRANSFER_INDICATION_G3_FLAGS_SEC

// HCT_MSG_CONNECT_CONN_TYPE_MAC
typedef struct
{
  UINT16 Conn_Handle;
// UINT16 data;
} HCT_MSG_REQ_DATA_TRANSFER_MAC_s;

#define HCT_MSG_REQ_DATA_TRANSFER_MAC_OFFSET_Conn_Handle    0
#define HCT_MSG_REQ_DATA_TRANSFER_MAC_OFFSET_Data           2
#define HCT_MSG_REQ_DATA_TRANSFER_MAC_SIZE_Conn_Handle      2
#define HCT_MSG_REQ_DATA_TRANSFER_MAC_SIZE                  2

typedef struct
{
  UINT16 Status;
} HCT_MSG_RPY_DATA_TRANSFER_s;

#define HCT_MSG_RPY_DATA_TRANSFER_OFFSET_Status         0
#define HCT_MSG_RPY_DATA_TRANSFER_SIZE_Status           2
#define HCT_MSG_RPY_DATA_TRANSFER_SIZE                  2

/* HCT_MSG_TYPE_GET_SYSTEM_INFO */
#define HCT_MSG_GET_SYSTEM_INFO_FLAGS_ROBO                          0x0100

#define HCT_MSG_GET_SYSTEM_INFO_DEVICE_TYPE_MASK                    0x00ff
#define HCT_MSG_GET_SYSTEM_INFO_DEVICE_MODE_MASK                    0x7f00
#define HCT_MSG_GET_SYSTEM_INFO_DEVICE_TYPE_IEC432                  0x0001
#define HCT_MSG_GET_SYSTEM_INFO_DEVICE_TYPE_IP                      0x0002
#define HCT_MSG_GET_SYSTEM_INFO_DEVICE_TYPE_G3                      0x0003
#define HCT_MSG_GET_SYSTEM_INFO_DEVICE_MODE_NORMAL                  0x0000
#define HCT_MSG_GET_SYSTEM_INFO_DEVICE_MODE_APPEMU_MAC              0x0100
#define HCT_MSG_GET_SYSTEM_INFO_DEVICE_MODE_APPEMU_IEC432_LLC       0x0200
#define HCT_MSG_GET_SYSTEM_INFO_DEVICE_MODE_POINT_TO_POINT          0x0300
#define HCT_MSG_GET_SYSTEM_INFO_DEVICE_MODE_MAC                     0x0400
#define HCT_MSG_GET_SYSTEM_INFO_DEVICE_MODE_PHY                     0x0500
#define HCT_MSG_GET_SYSTEM_INFO_DEVICE_MODE_SNIFFER                 0x0600
#define HCT_MSG_GET_SYSTEM_INFO_DEVICE_MODE_mIP			                0x0800

#define HCT_MSG_GET_SYSTEM_INFO_PORT_DESIGNATION_TYPE_SCI_A         0
#define HCT_MSG_GET_SYSTEM_INFO_PORT_DESIGNATION_TYPE_SCI_B         1

#define HCT_MSG_GET_SYSTEM_INFO_PORT_DESIGNATION_DATA_PORT_MASK     0x0003
#define HCT_MSG_GET_SYSTEM_INFO_PORT_DESIGNATION_DIAG_PORT_MASK     0x000c
#define HCT_MSG_GET_SYSTEM_INFO_PORT_DESIGNATION_GET_DATA_PORT(Port) \
      (((Port) & HCT_MSG_GET_SYSTEM_INFO_PORT_DESIGNATION_DATA_PORT_MASK) >> 0)
#define HCT_MSG_GET_SYSTEM_INFO_PORT_DESIGNATION_GET_DIAG_PORT(Port) \
      (((Port) & HCT_MSG_GET_SYSTEM_INFO_PORT_DESIGNATION_DIAG_PORT_MASK) >> 2)
#define HCT_MSG_GET_SYSTEM_INFO_PORT_DESIGNATION_SET_DATA_PORT(Port) \
      (((Port << 0) & HCT_MSG_GET_SYSTEM_INFO_PORT_DESIGNATION_DATA_PORT_MASK))
#define HCT_MSG_GET_SYSTEM_INFO_PORT_DESIGNATION_SET_DIAG_PORT(Port) \
      (((Port << 2) & HCT_MSG_GET_SYSTEM_INFO_PORT_DESIGNATION_DIAG_PORT_MASK))

#define HCT_MSG_GET_SYSTEM_INFO_FLAGS_MASK                      0xfc00
#define HCT_MSG_GET_SYSTEM_INFO_PHY_MODE_MASK                   0x0300
#define HCT_MSG_GET_SYSTEM_INFO_PHY_PRIME                       0x0000
#define HCT_MSG_GET_SYSTEM_INFO_PHY_ROBO                        0x0100
#define HCT_MSG_GET_SYSTEM_INFO_FLAGS_AUTO_MODE                 0x2000
#define HCT_MSG_GET_SYSTEM_INFO_FLAGS_IP_FLAG                   0x4000
#define HCT_MSG_GET_SYSTEM_INFO_FLAGS_USE_RPY                   0x8000

#define HCT_MSG_GET_SYSTEM_INFO_MAC_FLAGS_MASK                  0xff00
#define HCT_MSG_GET_SYSTEM_INFO_MAC_DFLT_SECURITY_PROFILE_MASK  0x00ff

#define HCT_MSG_GET_SYSTEM_INFO_MAC_FLAGS_DFLT_ARQ              (1 << 0)
#define HCT_MSG_GET_SYSTEM_INFO_MAC_FLAGS_DFLT_PAC              (1 << 1)
#define HCT_MSG_GET_SYSTEM_INFO_MAC_FLAGS_PAN_COORD             (1 << 2)

#define HCT_MSG_REQ_GET_SYSTEM_INFO_SIZE                        0

#define HCT_MSG_GET_SYSTEM_INFO_PLATFORM_PRIME                  0x0001
#define HCT_MSG_GET_SYSTEM_INFO_PLATFORM_G3                     0x0002
#define HCT_MSG_GET_SYSTEM_INFO_PLATFORM_FLEX                   0x0003

typedef struct
{
  UINT32 Firmware_Version;    // A 32-bit value representing the firmware version, in the format of MAJOR.MINOR.REVISION.BUILD.
  UINT16 Serial_Number_Len;
  UINT16 Serial_Number[16];
  UINT16 Device_Mode_Type;    // The device mode and type.
  UINT16 Hardware_Revision;   // The hardware revision.
  UINT16 EUI[3];
  UINT16 Flags;

  UINT16 MAC_RX_Max_Hold_Ppdu;
  UINT16 MAC_Max_Conn;
  UINT16 MAC_Max_Queue_Len_Per_Conn;
  UINT16 MAC_Flags_Dflt_Security_Profile;

#if defined(PRIME_IEC432)
  UINT16 LLC_Src_LSAP;
  UINT16 LLC_Dflt_Dest_MAC_Addr[3];
#endif // #if defined(PRIME_IEC432)
#if defined(PRIME_IP)
  union
  {
    struct
    {
      UINT32 CL_IPV4_Source_Address;
      UINT32 CL_IPV4_Netmask;
      UINT32 CL_IPV4_Gateway;
      UINT16 CL_ControlPort;
    } ipv4_s;
    struct
    {
      UINT16 CL_IPV6_Address_Prefix[4];
      UINT16 CL_IPV6_Source_Address[4];
      UINT16 CL_ControlPort;
    } ipv6_s;
  } cl_ip_addr_u;
#endif // #if defined(PRIME_IP)
#if defined(G3)
  UINT16 G3_Address_Type;
  UINT16 G3_Long_Address[4];
  UINT16 G3_PAN_ID;
  UINT16 G3_Short_Address;
#endif // #if defined(G3)

} HCT_MSG_RPY_GET_SYSTEM_INFO_s;

#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Firmware_Version                 4
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Serial_Number_Len                2
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Serial_Number                    16
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Device_Mode_Type                 2
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Hardware_Revision                2
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_EUI                              6
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Flags                            2
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_RX_Max_Hold_Ppdu             2

#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Max_Conn                     2
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Max_Queue_Len_Per_Conn       2

#if defined(PRIME)
//#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Field_1                      HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Max_Conn
//#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Field_2                      HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Max_Queue_Len_Per_Conn
#elif defined(G3)
//#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Field_1                      0
//#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Field_2                      0
#else
//#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Field_1                      0
//#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Field_2                      0
#endif

#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Flags_Dflt_Security_Profile  2
//#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Flags_Dflt_Security_Level    2
//#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Key_ID_Key_Index                 2

//#if defined(PRIME)
//#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Flags_Security_Field_1       HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Flags_Dflt_Security_Profile
//#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Security_Field_2                 0
//#elif defined(G3)
//#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Flags_Security_Field_1       HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Flags_Dflt_Security_Level
//#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Security_Field_2                 HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Key_ID_Key_Index
//#else
//#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Flags_Security_Field_1       0
//#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Security_Field_2                 0
//#endif

#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IPV6_Address_Prefix           8
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IPV4_Source_Address           4
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IPV6_Source_Address           8
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IPV4_Netmask                  4
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IPV4_Gateway                  4
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IP_ControlPort                2

#if 0
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_1_IPv6             HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IPV6_Address_Prefix
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_2_IPv6             HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IPV6_Source_Address
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_3_IPv6             0
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_4_IPv6             0
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_5_IPv6             0
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_1_IPv4             0
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_2_IPv4             HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IPV4_Source_Address
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_3_IPv4             HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IPV4_Netmask
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_4_IPv4             HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IPV4_Gateway
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_5_IPv4             HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_ControlPort
#endif

#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_LLC_Src_LSAP                     2
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_LLC_Dflt_Dest_LSAP               2
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_LLC_Dflt_Dest_Addr               2

#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_G3_Address_Type                  2
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_G3_Long_Address                  8
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_G3_PAN_ID                        2
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_G3_Short_Address                 2
#define HCT_MAG_RPT_GET_SYSTEM_INFO_SIZE_G3_MAC_Segment_Length						2
#if 0
#if defined(PRIME_IP)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_1                  HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_1_IPv6
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_2                  HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_2_IPv6
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_3                  HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_3_IPv4
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_4                  HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_4_IPv4
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_5                  HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_5_IPv4
#elif defined(PRIME_IEC432)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_1                  0
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_2                  HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_LLC_Src_LSAP
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_3                  HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_LLC_Dflt_Dest_LSAP
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_4                  HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_LLC_Dflt_Dest_Addr
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_5                  0
#elif defined(G3)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_1                  HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_G3_Address_Type
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_2                  HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_G3_Long_Address
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_3                  HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_G3_PAN_ID
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_4                  HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_G3_Short_Address
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_5                  0
#else
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_1                  0
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_2                  0
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_3                  0
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_4                  0
#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_5                  0
#endif
#endif

#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Firmware_Version               0
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Serial_Number_Len              4
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Serial_Number                  6
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Device_Mode_Type               22
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Hardware_Revision              24
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_EUI                            26
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Flags                          32
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_RX_Max_Hold_Ppdu           34
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Max_Conn                   36
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Max_Queue_Len_Per_Conn     38
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Flags_Dflt_Security_Profile  40

#if 0
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Field_1                    (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_RX_Max_Hold_Ppdu + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_RX_Max_Hold_Ppdu)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Field_2                    (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Field_1 + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Field_1)

#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Max_Conn                   HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Field_1
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Max_Queue_Len_Per_Conn     HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Field_2


#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Flags_Security_Field_1     (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Field_2 + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Field_2)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Security_Field_2               (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Flags_Security_Field_1 + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Flags_Security_Field_1)

#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Flags_Dflt_Security_Profile  HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Flags_Security_Field_1

#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Flags_Dflt_Security_Level    HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Flags_Security_Field_1
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Key_ID_Key_Index                 HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Security_Field_2
#endif

//#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_1                  (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Security_Field_2 + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Security_Field_2)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_1                  (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_MAC_Flags_Dflt_Security_Profile + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_MAC_Flags_Dflt_Security_Profile)
/*
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_2                  (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_1 + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_1)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_3                  (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_2 + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_2)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_4                  (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_3 + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_3)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_5                  (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_4 + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_Address_Field_4)
*/
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV6_Address_Prefix           HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_1
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV6_Source_Address           (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV6_Address_Prefix + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IPV6_Address_Prefix)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV6_ControlPort              (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV6_Source_Address + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IPV6_Source_Address)

#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV4_Source_Address           HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_1
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV4_Netmask                  (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV4_Source_Address + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IPV4_Source_Address)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV4_Gateway                  (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV4_Netmask + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IPV4_Netmask)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV4_ControlPort              (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV4_Gateway + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IPV4_Gateway)

/*
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_1_IPv6             HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_1
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_2_IPv6             HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_2
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_3_IPv6             HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_3
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_4_IPv6             HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_4
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_5_IPv6             HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_5
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_1_IPv4             HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_1
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_2_IPv4             HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_2
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_3_IPv4             HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_3
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_4_IPv4             HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_4
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_5_IPv4             HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_5
*/

#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_LLC_Src_LSAP                     HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_1
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_LLC_Dflt_Dest_LSAP               (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_LLC_Src_LSAP + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_LLC_Src_LSAP)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_LLC_Dflt_Dest_Addr               (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_LLC_Dflt_Dest_LSAP + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_LLC_Dflt_Dest_LSAP)

#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_Address_Type                  HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Address_Field_1
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_Long_Address                  (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_Address_Type  + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_G3_Address_Type)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_PAN_ID                        (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_Long_Address  + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_G3_Long_Address)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_Short_Address                 (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_PAN_ID        + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_G3_PAN_ID)
#define HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_MAC_Segment_Length            (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_Short_Address + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_G3_Short_Address)

#define HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE                                    (HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV6_ControlPort + HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_CL_IP_ControlPort)

/* HCT_MSG_TYPE_GET_PHY_PIB */
#if 0
typedef struct
{
//  UINT16 Attr_ID;
} HCT_MSG_REQ_GET_PHY_PIB_s;
#endif

#define HCT_MSG_REQ_GET_PHY_PIB_OFFSET_Attr_ID              0
#define HCT_MSG_REQ_GET_PHY_PIB_SIZE_Attr_ID                2
#define HCT_MSG_REQ_GET_PHY_PIB_SIZE                        0

typedef struct
{
  UINT16 Status;
//  UINT16 Attr_ID;
//  UINT16 Attr_Type;
//  var Attr_Value;
} HCT_MSG_RPY_GET_PHY_PIB_s;

#define HCT_MSG_RPY_GET_PHY_PIB_OFFSET_Status               0
#define HCT_MSG_RPY_GET_PHY_PIB_OFFSET_Attr_ID              2
#define HCT_MSG_RPY_GET_PHY_PIB_SIZE_Status                 2
#define HCT_MSG_RPY_GET_PHY_PIB_SIZE                        2

/* HCT_MSG_TYPE_GET_MAC_PIB */
#if 0
typedef struct
{
//  UINT16 Attr_ID;
} HCT_MSG_REQ_GET_MAC_PIB_s;
#endif

#define HCT_MSG_REQ_GET_MAC_PIB_OFFSET_Attr_ID              0
#define HCT_MSG_REQ_GET_MAC_PIB_SIZE                        0

typedef struct
{
  UINT16 Status;
//  UINT16 Attr_ID;
//  UINT16 Attr_Type;
//  var Attr_Value;
} HCT_MSG_RPY_GET_MAC_PIB_s;

#define HCT_MSG_RPY_GET_MAC_PIB_OFFSET_Status               0
#define HCT_MSG_RPY_GET_MAC_PIB_OFFSET_Attr_ID              2
#define HCT_MSG_RPY_GET_MAC_PIB_OFFSET_Length               4
#define HCT_MSG_RPY_GET_MAC_PIB_OFFSET_Value                6
#define HCT_MSG_RPY_GET_MAC_PIB_SIZE_Status                 2
#define HCT_MSG_RPY_GET_MAC_PIB_SIZE                        2

/* HCT_MSG_TYPE_SET_INFO */
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS             0x0000
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_RX_PARAMS             0x0001
#define HCT_MSG_REQ_SET_INFO_TYPE_G3_PHY_TX_PARAMS          0x0002
#define HCT_MSG_REQ_SET_INFO_TYPE_G3_PHY_RX_PARAMS          0x0003

typedef struct
{
  UINT16 INFO_Type;
  UINT16 INFO_Length;
//  UINT16 INFO_Value[var];
} HCT_MSG_REQ_SET_INFO_s;

#define HCT_MSG_REQ_SET_INFO_OFFSET_INFO_Type               0
#define HCT_MSG_REQ_SET_INFO_OFFSET_INFO_Length             2
#define HCT_MSG_REQ_SET_INFO_OFFSET_INFO_Value              4
#define HCT_MSG_REQ_SET_INFO_SIZE_INFO_Type                 2
#define HCT_MSG_REQ_SET_INFO_SIZE_INFO_Length               2
#define HCT_MSG_REQ_SET_INFO_SIZE                           4

/* HCT_MSG_SET_INFO_TYPE_TX_PHY_PARAMS */
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_FLAG_FEC    (1 << 8)
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_FLAG_ROBO   (1 << 9)
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_FLAG_PRM    (1 << 10)

#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_MODULATION_DBPSK            0x0001
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_MODULATION_DQPSK            0x0002
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_MODULATION_D8PSK            0x0003
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_MODULATION_D8PSK_1_4_REP    0x0004
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_MODULATION_D8PSK_1_8_REP    0x0005

typedef struct
{
  UINT16 Flags;
  UINT16 Modulation;
  UINT16 Level;
} HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_s;

#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_OFFSET_Flags        0
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_OFFSET_Modulation   2
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_OFFSET_Level        4
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_SIZE_Flags          2
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_SIZE_Modulation     2
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_SIZE_Level          2
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_SIZE                6

/* HCT_MSG_SET_INFO_TYPE_RX_PHY_PARAMS */
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_RX_PARAMS_FLAG_AGC    (1 << 8)
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_RX_PARAMS_FLAG_ROBO   (1 << 9)

typedef struct
{
  UINT16 Flags;
  UINT16 Gain_Value;
} HCT_MSG_REQ_SET_INFO_TYPE_PHY_RX_PARAMS_s;

#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_RX_PARAMS_OFFSET_Flags        0
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_RX_PARAMS_OFFSET_Gain_Value   2
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_RX_PARAMS_SIZE_Flags          2
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_RX_PARAMS_SIZE_Gain_Value     2
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_RX_PARAMS_SIZE                4

/* HCT_MSG_SET_INFO_TYPE_G3_TX_PHY_PARAMS */
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_G3_MODULATION_ROBO    0x0000
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_G3_MODULATION_BPSK    0x0001
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_G3_MODULATION_QPSK    0x0002
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_G3_MODULATION_8PSK    0x0004
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_G3_LEVEL_MIN          0
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_TX_PARAMS_G3_LEVEL_MAX          32
typedef struct
{
  UINT16 Modulation;
  UINT16 Level;
  UINT16 Tonemask[6];
} HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_TX_PARAMS_s;

#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_TX_PARAMS_OFFSET_Modulation  0
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_TX_PARAMS_OFFSET_Level       2
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_TX_PARAMS_OFFSET_Tonemask    4
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_TX_PARAMS_SIZE_Modulation    2
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_TX_PARAMS_SIZE_Level         2
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_TX_PARAMS_SIZE_Tonemask      12
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_TX_PARAMS_SIZE               16

/* HCT_MSG_SET_INFO_TYPE_G3_RX_PHY_PARAMS */
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_RX_PARAMS_FLAG_AGC    (1 << 8)
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_RX_PARAMS_FLAG_ROBO   (1 << 9)
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_RX_PARAMS_FLAG_BLI    (1 << 10)

typedef struct
{
  UINT16 Flags;
  UINT16 Gain_Value;
  UINT16 Tonemask[6];
} HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_RX_PARAMS_s;

#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_RX_PARAMS_OFFSET_Flags        0
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_RX_PARAMS_OFFSET_Gain_Value   2
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_RX_PARAMS_OFFSET_Tonemask     4
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_RX_PARAMS_SIZE_Flags          2
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_RX_PARAMS_SIZE_Gain_Value     2
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_RX_PARAMS_SIZE_Tonemask       12
#define HCT_MSG_REQ_SET_INFO_TYPE_PHY_G3_RX_PARAMS_SIZE                16

typedef struct
{
  UINT16 Status;
} HCT_MSG_RPY_SET_INFO_s;

#define HCT_MSG_RPY_SET_INFO_OFFSET_Status                  0
#define HCT_MSG_RPY_SET_INFO_SIZE_Status                    2
#define HCT_MSG_RPY_SET_INFO_SIZE                           2

/* HCT_MSG_TYPE_SHUT_DOWN */
#define HCT_MSG_REQ_SHUT_DOWN_RESET_TYPE_SOFT_RESET         0x0000
#define HCT_MSG_REQ_SHUT_DOWN_RESET_TYPE_HARD_RESET         0x0001
#define HCT_MSG_REQ_SHUT_DOWN_RESET_TYPE_SOFT_SHUTDOWN      0x0002
#define HCT_MSG_REQ_SHUT_DOWN_RESET_TYPE_HARD_SHUTDOWN      0x0003

typedef struct
{
  UINT16 Reset_Type;
} HCT_MSG_REQ_SHUT_DOWN_s;

#define HCT_MSG_REQ_SHUT_DOWN_OFFSET_Reset_Type             0
#define HCT_MSG_REQ_SHUT_DOWN_SIZE_Reset_Type               2
#define HCT_MSG_REQ_SHUT_DOWN_SIZE                          2

typedef struct
{
  UINT16 Status;
} HCT_MSG_RPY_SHUT_DOWN_s;

#define HCT_MSG_RPY_SHUT_DOWN_OFFSET_Status                 0
#define HCT_MSG_RPY_SHUT_DOWN_SIZE_Status                   2
#define HCT_MSG_RPY_SHUT_DOWN_SIZE                          2

/* HCT_MSG_TYPE_SETUP_ALARM */
#define HCT_MSG_ALARM_TYPE_NETWORK_DEREGISTERED             0x0001
#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST                  0x0002
#define HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATION            0x0003
#define HCT_MSG_ALARM_TYPE_NETWORK_REGISTRATION_STARTED     0x0004
#define HCT_MSG_ALARM_TYPE_NETWORK_REGISTRATION_COMPLETE    0x0005
#define HCT_MSG_ALARM_TYPE_CONNECT_COMPLETE                 0x0006
#define HCT_MSG_ALARM_TYPE_G3_NETWORK_STATUS_INDICATION     0x0007
#define HCT_MSG_ALARM_TYPE_PHY_RX_PPDU_CRC_FAIL             0x0040
#define HCT_MSG_ALARM_TYPE_PHY_RX_HDR_SYNTAX_ERR            0x0041
#define HCT_MSG_ALARM_TYPE_MAC_PROMOTED_SWITCH_NODE         0x0080
#define HCT_MSG_ALARM_TYPE_MAC_DEMOTED_SERVICE_NODE         0x0081
#define HCT_MSG_ALARM_TYPE_CL                               0x00c0
#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR                    0x00ff

typedef struct
{
  UINT16 Alarm_Type;
  UINT16 Alarm_Length;
//  UINT16 Alarm_Data;
} HCT_MSG_REQ_SETUP_ALARM_s;

#define HCT_MSG_REQ_SETUP_ALARM_OFFSET_Alarm_Type           0
#define HCT_MSG_REQ_SETUP_ALARM_OFFSET_Alarm_Length         2
#define HCT_MSG_REQ_SETUP_ALARM_OFFSET_Alarm_Data           4
#define HCT_MSG_REQ_SETUP_ALARM_SIZE_Alarm_Type             2
#define HCT_MSG_REQ_SETUP_ALARM_SIZE_Alarm_Length           2
#define HCT_MSG_REQ_SETUP_ALARM_SIZE                        4

// HCT_MSG_ALARM_TYPE_NETWORK_DEREGISTERED
// HCT_MSG_ALARM_TYPE_CONNECT_REQUEST
// HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATION
// HCT_MSG_ALARM_TYPE_NETWORK_REGISTRATION_COMPLETE
// HCT_MSG_ALARM_TYPE_G3_NETWORK_STATUS_INDICATION
// HCT_MSG_ALARM_TYPE_CONNECT_COMPLETE
// HCT_MSG_ALARM_TYPE_PHY_RX_PPDU_CRC_FAIL
// HCT_MSG_ALARM_TYPE_PHY_RX_HDR_SYNTAX_ERR
// HCT_MSG_ALARM_TYPE_MAC_PROMOTED_SWITCH_NODE
// HCT_MSG_ALARM_TYPE_MAC_DEMOTED_SERVICE_NODE
// HCT_MSG_ALARM_TYPE_CL
// HCT_MSG_ALARM_TYPE_GENERAL_ERROR

#define HCT_MSG_ALARM_DEFAULT_FLAG_CLEAR                    (1 << 0)
#if 0
typedef struct
{
  UINT8 Flags;
} HCT_MSG_REQ_SETUP_ALARM_DEFAULT_s;
#endif

#define HCT_MSG_REQ_SETUP_ALARM_DEFAULT_OFFSET_Flags        0
#define HCT_MSG_REQ_SETUP_ALARM_DEFAULT_SIZE_Flags          1
#define HCT_MSG_REQ_SETUP_ALARM_DEFAULT_SIZE                1

typedef struct
{
  UINT16 Status;
} HCT_MSG_RPY_SETUP_ALARM_s;

#define HCT_MSG_RPY_SETUP_ALARM_OFFSET_Status               0
#define HCT_MSG_RPY_SETUP_ALARM_SIZE_Status                 2
#define HCT_MSG_RPY_SETUP_ALARM_SIZE                        2

/* HCT_MSG_TYPE_ALARM */
typedef struct
{
  UINT16 Alarm_Type;
  UINT16 Alarm_Length;
//  UINT16 Alarm_Data;
} HCT_MSG_ALARM_s;

#define HCT_MSG_ALARM_OFFSET_Alarm_Type                     0
#define HCT_MSG_ALARM_OFFSET_Alarm_Length                   2
#define HCT_MSG_ALARM_OFFSET_Alarm_Data                     4
#define HCT_MSG_ALARM_SIZE_Alarm_Type                       2
#define HCT_MSG_ALARM_SIZE_Alarm_Length                     2
#define HCT_MSG_ALARM_SIZE                                  4

// HCT_MSG_ALARM_TYPE_NETWORK_DEREGISTERED
typedef struct
{
  UINT16 reason;
} HCT_MSG_ALARM_TYPE_NETWORK_DEREGISTERED_s;

#define HCT_MSG_ALARM_TYPE_NETWORK_DEREGISTERED_OFFSET_reason        0
#define HCT_MSG_ALARM_TYPE_NETWORK_DEREGISTERED_SIZE_reason          2
#define HCT_MSG_ALARM_TYPE_NETWORK_DEREGISTERED_SIZE                 2

// HCT_MSG_ALARM_TYPE_CONNECT_REQUEST
typedef struct
{
  UINT16 Conn_Type;
  UINT16 Conn_Handle;
  UINT16 Connection_Data_Length;
//  UINT16 Connection_Data;
} HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_s;

#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_OFFSET_Conn_Type                 0
#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_OFFSET_Conn_Handle               2
#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_OFFSET_Connection_Data_Length    4
#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_OFFSET_Connection_Data           6
#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_SIZE_Conn_Type                   2
#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_SIZE_Conn_Handle                 2
#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_SIZE_Connection_Data_Length      2
#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_SIZE                             6

// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_AR
// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_UNICAST
// HCT_MSG_CONNECT_CONN_TYPE_CL_IEC432
// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_MULTICAST
// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_BROADCAST

// HCT_MSG_CONNECT_CONN_TYPE_MAC
typedef struct
{
  UINT16 Flags_ConnType;
  UINT16 CfBytes;
  UINT16 Dest_Addr[3];
//  UINT16 Additional_Data;
} HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_CONN_TYPE_MAC_s;

#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_CONN_TYPE_MAC_OFFSET_Flags_ConnType      0
#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_CONN_TYPE_MAC_OFFSET_CfBytes             2
#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_CONN_TYPE_MAC_OFFSET_Dest_Addr           4
#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_CONN_TYPE_MAC_OFFSET_Additional_Data     10
#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_CONN_TYPE_MAC_SIZE_Flags_ConnType        2
#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_CONN_TYPE_MAC_SIZE_CfBytes               2
#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_CONN_TYPE_MAC_SIZE_Dest_Addr             6
#define HCT_MSG_ALARM_TYPE_CONNECT_REQUEST_CONN_TYPE_MAC_SIZE                       10

// HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATION
typedef struct
{
  UINT16 Conn_Type;
  UINT16 Conn_Handle;
  UINT16 Disconnect_Data_Length;
//  UINT16 Disconnect_Data;
} HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATE_s;

#define HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATE_OFFSET_Conn_Type                 0
#define HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATE_OFFSET_Conn_Handle               2
#define HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATE_OFFSET_Disconnect_Data_Length    4
#define HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATE_OFFSET_Disconnect_Data           6
#define HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATE_SIZE_Conn_Type                   2
#define HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATE_SIZE_Conn_Handle                 2
#define HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATE_SIZE_Disconnect_Data_Length      2
#define HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATE_SIZE                             6

// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_AR
typedef struct
{
  UINT32 IPv4_Addr;
} HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATION_CONN_TYPE_CL_IPV4_AR_s;

#define HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATION_CONN_TYPE_CL_IPV4_AR_OFFSET_IPv4_Addr  0
#define HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATION_CONN_TYPE_CL_IPV4_AR_SIZE_IPv4_Addr    2
#define HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATION_CONN_TYPE_CL_IPV4_AR_SIZE              2

// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_UNICAST
// HCT_MSG_CONNECT_CONN_TYPE_CL_IEC432
// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_MULTICAST
// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_BROADCAST

// HCT_MSG_CONNECT_CONN_TYPE_MAC
typedef struct
{
  UINT16 reason;
} HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATION_CONN_TYPE_MAC_s;

#define HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATION_CONN_TYPE_MAC_OFFSET_reason      0
#define HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATION_CONN_TYPE_MAC_SIZE_reason        2
#define HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATION_CONN_TYPE_MAC_SIZE               2

// HCT_MSG_ALARM_TYPE_NETWORK_REGISTRATION_COMPLETE
#define HCT_MSG_ALARM_TYPE_NETWORK_REGISTRATION_COMPLETE_SIZE   0

// HCT_MSG_ALARM_TYPE_CONNECT_COMPLETE
#define HCT_MSG_ALARM_TYPE_CONNECT_COMPLETE_SIZE            0

// HCT_MSG_ALARM_TYPE_G3_NETWORK_STATUS_INDICATION
typedef struct
{
  UINT16 Status;
//  UINT16 Additional_Info[]
} HCT_MSG_ALARM_TYPE_G3_NETWORK_STATUS_INDICATION_s;

#define HCT_MSG_ALARM_TYPE_G3_NETWORK_STATUS_INDICATION_OFFSET_Status             0
#define HCT_MSG_ALARM_TYPE_G3_NETWORK_STATUS_INDICATION_OFFSET_Additional_Info    2
#define HCT_MSG_ALARM_TYPE_G3_NETWORK_STATUS_INDICATION_SIZE_Status               2
#define HCT_MSG_ALARM_TYPE_G3_NETWORK_STATUS_INDICATION_SIZE                      2

// HCT_MSG_ALARM_TYPE_PHY_RX_PPDU_CRC_FAIL
#define HCT_MSG_ALARM_TYPE_PHY_RX_PPDU_CRC_FAIL_SIZE        0

// HCT_MSG_ALARM_TYPE_PHY_RX_HDR_SYNTAX_ERR
#define HCT_MSG_ALARM_TYPE_PHY_RX_HDR_SYNTAX_ERR_SIZE       0

// HCT_MSG_ALARM_TYPE_MAC_PROMOTED_SWITCH_NODE
#define HCT_MSG_ALARM_TYPE_MAC_PROMOTED_SWITCH_NODE_SIZE    0

// HCT_MSG_ALARM_TYPE_MAC_DEMOTED_SERVICE_NODE
#define HCT_MSG_ALARM_TYPE_MAC_PROMOTED_SWITCH_NODE_SIZE    0

// HCT_MSG_ALARM_TYPE_CL
#define HCT_MSG_ALARM_TYPE_CL_SEND_PACKET_ERROR             (0x0001)
#define HCT_MSG_ALARM_TYPE_CL_RECV_PACKET_ERROR             (0x0002)
typedef struct
{
  UINT16 Alarm;
//  UINT16 Alarm_Data;
} HCT_MSG_ALARM_TYPE_CL_s;

#define HCT_MSG_ALARM_TYPE_CL_OFFSET_Alarm                  0
#define HCT_MSG_ALARM_TYPE_CL_OFFSET_Alarm_Data             2
#define HCT_MSG_ALARM_TYPE_CL_SIZE_Alarm                    2
#define HCT_MSG_ALARM_TYPE_CL_SIZE                          2

/* HCT_MSG_ALARM_TYPE_CL_SEND_PACKET_ERROR */
typedef struct
{
  UINT16 Error;
} HCT_MSG_ALARM_TYPE_CL_SEND_PACKET_ERROR_s;

#define HCT_MSG_ALARM_TYPE_CL_SEND_PACKET_ERROR_OFFSET_Error  0
#define HCT_MSG_ALARM_TYPE_CL_SEND_PACKET_ERROR_SIZE_Error    2
#define HCT_MSG_ALARM_TYPE_CL_SEND_PACKET_ERROR_SIZE          2

/* HCT_MSG_ALARM_TYPE_CL_RECV_PACKET_ERROR */
typedef struct
{
  UINT16 Error;
} HCT_MSG_ALARM_TYPE_CL_RECV_PACKET_ERROR_s;

#define HCT_MSG_ALARM_TYPE_CL_RECV_PACKET_ERROR_OFFSET_Error  0
#define HCT_MSG_ALARM_TYPE_CL_RECV_PACKET_ERROR_SIZE_Error    2
#define HCT_MSG_ALARM_TYPE_CL_RECV_PACKET_ERROR_SIZE          2

// HCT_MSG_ALARM_TYPE_GENERAL_ERROR
#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_PORT_DISCARDED         (0x0001)
#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_OUT_OF_MEMORY          (0x0002)
#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_MESSAGE_DISCARDED      (0x0004)

typedef struct
{
  UINT16 Error;
//  UINT16 Error_Data;
} HCT_MSG_ALARM_TYPE_GENERAL_ERROR_s;

#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_OFFSET_Error       0
#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_OFFSET_Error_Data  2
#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_SIZE_Error         2
#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_SIZE               2

/* HCT_MSG_ALARM_TYPE_GENERAL_ERROR_PORT_DISCARDED */
typedef struct
{
  UINT16 Octets_Discarded;
} HCT_MSG_ALARM_TYPE_GENERAL_ERROR_PORT_DISCARDED_s;

#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_PORT_DISCARDED_OFFSET_Octets_Discarded   0
#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_PORT_DISCARDED_SIZE_Octets_Discarded     2
#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_PORT_DISCARDED_SIZE                      2

/* HCT_MSG_ALARM_TYPE_GENERAL_ERROR_OUT_OF_MEMORY */
#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_OUT_OF_MEMORY_SIZE       0

/* HCT_MSG_ALARM_TYPE_GENERAL_ERROR_MESSAGE_DISCARDED */
typedef struct
{
  UINT16 Msg_Type_Tag;
  UINT16 Msg_Len;
} HCT_MSG_ALARM_TYPE_GENERAL_ERROR_MESSAGE_DISCARDED_s;

#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_MESSAGE_DISCARDED_OFFSET_Msg_Type_Tag    0
#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_MESSAGE_DISCARDED_OFFSET_Msg_Len         2
#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_MESSAGE_DISCARDED_SIZE_Msg_Type_Tag      2
#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_MESSAGE_DISCARDED_SIZE_Msg_Len           2
#define HCT_MSG_ALARM_TYPE_GENERAL_ERROR_MESSAGE_DISCARDED_SIZE                   4

typedef struct
{
  UINT16 Alarm_Type;
  UINT16 Data_Length;
//  UINT16 Data;
} HCT_MSG_RPY_ALARM_s;

#define HCT_MSG_RPY_ALARM_OFFSET_Alarm_Type                 0
#define HCT_MSG_RPY_ALARM_OFFSET_Data_Length                2
#define HCT_MSG_RPY_ALARM_OFFSET_Data                       4
#define HCT_MSG_RPY_ALARM_SIZE_Alarm_Type                   2
#define HCT_MSG_RPY_ALARM_SIZE_Data_Length                  2
#define HCT_MSG_RPY_ALARM_SIZE                              4

// HCT_MSG_ALARM_TYPE_NETWORK_DEREGISTERED
#define HCT_MSG_RPY_ALARM_TYPE_NETWORK_DEREGISTERED_SIZE    0

// HCT_MSG_ALARM_TYPE_CONNECT_REQUEST
#define HCT_MSG_RPY_ALARM_TYPE_CONNECT_REQUEST_FLAG_ACCEPT    (0x0100)

typedef struct
{
  UINT16 Flags;
  UINT16 Conn_Type;
  UINT16 Conn_Handle;
  UINT16 Connection_Data_Length;
//  UINT16 Connection_Data;
} HCT_MSG_RPY_ALARM_TYPE_CONNECT_REQUEST_s;

#define HCT_MSG_RPY_ALARM_TYPE_CONNECT_REQUEST_OFFSET_Flags                   0
#define HCT_MSG_RPY_ALARM_TYPE_CONNECT_REQUEST_OFFSET_Conn_Type               2
#define HCT_MSG_RPY_ALARM_TYPE_CONNECT_REQUEST_OFFSET_Conn_Handle             4
#define HCT_MSG_RPY_ALARM_TYPE_CONNECT_REQUEST_OFFSET_Connection_Data_Length  6
#define HCT_MSG_RPY_ALARM_TYPE_CONNECT_REQUEST_OFFSET_Connection_Data         8
#define HCT_MSG_RPY_ALARM_TYPE_CONNECT_REQUEST_SIZE_Flags                     2
#define HCT_MSG_RPY_ALARM_TYPE_CONNECT_REQUEST_SIZE_Conn_Type                 2
#define HCT_MSG_RPY_ALARM_TYPE_CONNECT_REQUEST_SIZE_Conn_Handle               2
#define HCT_MSG_RPY_ALARM_TYPE_CONNECT_REQUEST_SIZE_Connection_Data_Length    2
#define HCT_MSG_RPY_ALARM_TYPE_CONNECT_REQUEST_SIZE                           8

// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_AR
// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_UNICAST
// HCT_MSG_CONNECT_CONN_TYPE_CL_IEC432
// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_MULTICAST
// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_BROADCAST

// HCT_MSG_CONNECT_CONN_TYPE_MAC
#define HCT_MSG_RPY_ALARM_TYPE_CONNECT_REQUEST_CONN_TYPE_MAC_SIZE             0

// HCT_MSG_ALARM_TYPE_DISCONNECT_INDICATION
typedef struct
{
  UINT16 Conn_Type;
  UINT16 Conn_Handle;
  UINT16 Disconnect_Data_Length;
//  UINT16 Disconnect_Data;
} HCT_MSG_RPY_ALARM_TYPE_DISCONNECT_INDICATE_s;

#define HCT_MSG_RPY_ALARM_TYPE_DISCONNECT_INDICATE_OFFSET_Conn_Type               0
#define HCT_MSG_RPY_ALARM_TYPE_DISCONNECT_INDICATE_OFFSET_Conn_Handle             2
#define HCT_MSG_RPY_ALARM_TYPE_DISCONNECT_INDICATE_OFFSET_Disconnect_Data_Length  4
#define HCT_MSG_RPY_ALARM_TYPE_DISCONNECT_INDICATE_OFFSET_Disconnect_Data         6
#define HCT_MSG_RPY_ALARM_TYPE_DISCONNECT_INDICATE_SIZE_Conn_Type                 2
#define HCT_MSG_RPY_ALARM_TYPE_DISCONNECT_INDICATE_SIZE_Conn_Handle               2
#define HCT_MSG_RPY_ALARM_TYPE_DISCONNECT_INDICATE_SIZE_Disconnect_Data_Length    2
#define HCT_MSG_RPY_ALARM_TYPE_DISCONNECT_INDICATE_SIZE                           6

// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_AR
// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_UNICAST
// HCT_MSG_CONNECT_CONN_TYPE_CL_IEC432
// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_MULTICAST
// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_BROADCAST

// HCT_MSG_CONNECT_CONN_TYPE_MAC
#define HCT_MSG_RPY_ALARM_TYPE_DISCONNECT_INDICATE_CONN_TYPE_MAC_SIZE             0

// HCT_MSG_ALARM_TYPE_NETWORK_REGISTRATION_COMPLETE
#define HCT_MSG_RPY_ALARM_TYPE_NETWORK_REGISTRATION_COMPLETE_SIZE   0

// HCT_MSG_ALARM_TYPE_CONNECT_COMPLETE
#define HCT_MSG_RPY_ALARM_TYPE_CONNECT_COMPLETE_SIZE        0

// HCT_MSG_SETUP_ALARM_TYPE_PHY_RX_PPDU_CRC_FAIL
// HCT_MSG_SETUP_ALARM_TYPE_PHY_RX_HDR_SYNTAX_ERR
// HCT_MSG_SETUP_ALARM_TYPE_MAC_PROMOTED_SWITCH_NODE
// HCT_MSG_SETUP_ALARM_TYPE_MAC_DEMOTED_SERVICE_NODE
// HCT_MSG_SETUP_ALARM_TYPE_CL

/* HCT_MSG_TYPE_NETWORK_REGISTER */
#define HCT_MSG_NETWORK_REGISTRATION_TYPE_AUTO              0x0000
#define HCT_MSG_NETWORK_REGISTRATION_TYPE_SNA               0x0001
#define HCT_MSG_NETWORK_REGISTRATION_TYPE_EUI48             0x0002

typedef struct
{
  UINT16 Registration_Type;
  UINT16 Registration_Data_Length;
//  UINT16 Registration_Data;
} HCT_MSG_REQ_NETWORK_REGISTER_s;

#define HCT_MSG_REQ_NETWORK_REGISTER_OFFSET_Registration_Type           0
#define HCT_MSG_REQ_NETWORK_REGISTER_OFFSET_Registration_Data_Length    2
#define HCT_MSG_REQ_NETWORK_REGISTER_OFFSET_Registration_Data           4
#define HCT_MSG_REQ_NETWORK_REGISTER_SIZE_Registration_Type             2
#define HCT_MSG_REQ_NETWORK_REGISTER_SIZE_Registration_Data_Length      2
#define HCT_MSG_REQ_NETWORK_REGISTER_SIZE                               4

#define HCT_MSG_REQ_NETWORK_REGISTER_TYPE_AUTO_Registration_Data_Length 0
#define HCT_MSG_REQ_NETWORK_REGISTER_TYPE_SNA_Registration_Data_Length  6
#define HCT_MSG_REQ_NETWORK_REGISTER_TYPE_EUI_Registration_Data_Length  6

typedef struct
{
  UINT16 Status;
  UINT16 SNA[3];
  UINT16 EUI48[3];
} HCT_MSG_RPY_NETWORK_REGISTER_s;

#define HCT_MSG_RPY_NETWORK_REGISTER_OFFSET_STATUS          0
#define HCT_MSG_RPY_NETWORK_REGISTER_OFFSET_SNA             2
#define HCT_MSG_RPY_NETWORK_REGISTER_OFFSET_EUI48           8
#define HCT_MSG_RPY_NETWORK_REGISTER_SIZE_STATUS            2
#define HCT_MSG_RPY_NETWORK_REGISTER_SIZE_SNA               6
#define HCT_MSG_RPY_NETWORK_REGISTER_SIZE_EUI48             6
#define HCT_MSG_RPY_NETWORK_REGISTER_SIZE                   14

/* HCT_MSG_TYPE_NETWORK_START */
typedef struct
{
  UINT16 Pan_ID;
} HCT_MSG_REQ_NETWORK_START_G3_s;

#define HCT_MSG_REQ_NETWORK_START_G3_OFFSET_Pan_ID          0
#define HCT_MSG_REQ_NETWORK_START_G3_SIZE_Pan_ID            2
#define HCT_MSG_REQ_NETWORK_START_G3_SIZE                   2

typedef struct
{
  UINT16 Status;
} HCT_MSG_RPY_NETWORK_START_G3_s;

#define HCT_MSG_RPY_NETWORK_START_G3_OFFSET_STATUS          0
#define HCT_MSG_RPY_NETWORK_START_G3_SIZE_STATUS            2
#define HCT_MSG_RPY_NETWORK_START_G3_SIZE                   2

/* HCT_MSG_TYPE_NETWORK_UNREGISTER */
#define HCT_MSG_REQ_NETWORK_UNREGISTER_SIZE                 0

typedef struct
{
  UINT16 Status;
} HCT_MSG_RPY_NETWORK_UNREGISTER_s;

#define HCT_MSG_RPY_NETWORK_UNREGISTER_OFFSET_STATUS        0
#define HCT_MSG_RPY_NETWORK_UNREGISTER_SIZE_STATUS          2
#define HCT_MSG_RPY_NETWORK_UNREGISTER_SIZE                 2

/* HCT_MSG_TYPE_CONNECT */
typedef struct
{
  UINT16 Conn_Type;
  UINT16 Connection_Data_Length;
//  UINT16 Connection_Data;
} HCT_MSG_REQ_CONNECT_s;

#define HCT_MSG_REQ_CONNECT_OFFSET_Conn_Type                0
#define HCT_MSG_REQ_CONNECT_OFFSET_Connection_Data_Length   2
#define HCT_MSG_REQ_CONNECT_OFFSET_Connection_Data          4
#define HCT_MSG_REQ_CONNECT_SIZE_Conn_Type                  2
#define HCT_MSG_REQ_CONNECT_SIZE_Connection_Data_Length     2
#define HCT_MSG_REQ_CONNECT_SIZE                            4

// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_AR
// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_UNICAST

// HCT_MSG_CONNECT_CONN_TYPE_CL_IEC432
typedef struct
{
  UINT16 Serial_Number[8];
} HCT_MSG_REQ_CONNECT_CONN_TYPE_CL_IEC432_s;

#define HCT_MSG_REQ_CONNECT_CONN_TYPE_CL_IEC432_OFFSET_Serial_Number    0
#define HCT_MSG_REQ_CONNECT_CONN_TYPE_CL_IEC432_SIZE_Serial_Number      16
#define HCT_MSG_REQ_CONNECT_CONN_TYPE_CL_IEC432_SIZE                    16

// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_MULTICAST
// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_BROADCAST

// HCT_MSG_CONNECT_CONN_TYPE_MAC
#define HCT_MSG_REQ_CONNECT_CONN_TYPE_MAC_FLAG_ARQ          (1 << 8)
#define HCT_MSG_REQ_CONNECT_CONN_TYPE_MAC_FLAG_PAC          (1 << 9)
#define HCT_MSG_REQ_CONNECT_CONN_TYPE_MAC_FLAGS_MASK        (0xff00)
#define HCT_MSG_REQ_CONNECT_CONN_TYPE_MAC_CONN_TYPE_MASK    (0x00ff)

typedef struct
{
  UINT16 Flags_ConnType;
  UINT16 CfBytes;
  UINT16 Dest_Addr[3];
//  UINT16 Additional_Data;
} HCT_MSG_REQ_CONNECT_CONN_TYPE_MAC_s;

#define HCT_MSG_REQ_CONNECT_CONN_TYPE_MAC_OFFSET_Flags_ConnType         0
#define HCT_MSG_REQ_CONNECT_CONN_TYPE_MAC_OFFSET_CfBytes                2
#define HCT_MSG_REQ_CONNECT_CONN_TYPE_MAC_OFFSET_Dest_Addr              4
#define HCT_MSG_REQ_CONNECT_CONN_TYPE_MAC_OFFSET_Additional_Data        10
#define HCT_MSG_REQ_CONNECT_CONN_TYPE_MAC_SIZE_Flags_ConnType           2
#define HCT_MSG_REQ_CONNECT_CONN_TYPE_MAC_SIZE_CfBytes                  2
#define HCT_MSG_REQ_CONNECT_CONN_TYPE_MAC_SIZE_Dest_Addr                6
#define HCT_MSG_REQ_CONNECT_CONN_TYPE_MAC_SIZE                          10

#define HCT_MSG_CONN_HANDLE_INVALID                         ((UINT16) -1)
typedef struct
{
  UINT16 Status;
  UINT16 Conn_Type;
  UINT16 Conn_Handle;
  UINT16 Conn_Data_Length;
//  UINT16 Conn_Data;
} HCT_MSG_RPY_CONNECT_s;

#define HCT_MSG_RPY_CONNECT_OFFSET_Status                   0
#define HCT_MSG_RPY_CONNECT_OFFSET_Conn_Type                2
#define HCT_MSG_RPY_CONNECT_OFFSET_Conn_Handle              4
#define HCT_MSG_RPY_CONNECT_OFFSET_Conn_Data_Length         6
#define HCT_MSG_RPY_CONNECT_OFFSET_Conn_Data                8
#define HCT_MSG_RPY_CONNECT_SIZE_Status                     2
#define HCT_MSG_RPY_CONNECT_SIZE_Conn_Type                  2
#define HCT_MSG_RPY_CONNECT_SIZE_Conn_Handle                2
#define HCT_MSG_RPY_CONNECT_SIZE_Conn_Data_Length           2
#define HCT_MSG_RPY_CONNECT_SIZE                            8

// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_AR
typedef struct
{
  UINT32 IPv4_Addr;
} HCT_MSG_RPY_CONNECT_CONN_TYPE_CL_IPV4_AR_s;

#define HCT_MSG_RPY_CONNECT_CONN_TYPE_CL_IPV4_AR_OFFSET_IPv4_Addr   0
#define HCT_MSG_RPY_CONNECT_CONN_TYPE_CL_IPV4_AR_SIZE_IPv4_Addr     4
#define HCT_MSG_RPY_CONNECT_CONN_TYPE_CL_IPV4_AR_SIZE               4

// HCT_MSG_CONNECT_CONN_TYPE_CL_IEC432
typedef struct
{
  UINT16 Dest_Addr;
  UINT16 Base_Addr;
} HCT_MSG_RPY_CONNECT_CONN_TYPE_CL_IEC432_s;

#define HCT_MSG_RPY_CONNECT_CONN_TYPE_CL_IEC432_OFFSET_Dest_Addr    0
#define HCT_MSG_RPY_CONNECT_CONN_TYPE_CL_IEC432_OFFSET_Base_Addr    2
#define HCT_MSG_RPY_CONNECT_CONN_TYPE_CL_IEC432_SIZE_Dest_Addr      2
#define HCT_MSG_RPY_CONNECT_CONN_TYPE_CL_IEC432_SIZE_Base_Addr      2
#define HCT_MSG_RPY_CONNECT_CONN_TYPE_CL_IEC432_SIZE                4

// HCT_MSG_CONNECT_CONN_TYPE_MAC
typedef struct
{
  UINT16 Node_Addr[3];
//  UINT16 Negotiation_Data;
} HCT_MSG_RPY_CONNECT_CONN_TYPE_MAC_s;

#define HCT_MSG_RPY_CONNECT_CONN_TYPE_MAC_OFFSET_Node_Addr          0
#define HCT_MSG_RPY_CONNECT_CONN_TYPE_MAC_OFFSET_Negotiation_Data   6
#define HCT_MSG_RPY_CONNECT_CONN_TYPE_MAC_SIZE_Node_Addr            6
#define HCT_MSG_RPY_CONNECT_CONN_TYPE_MAC_SIZE                      6

/* HCT_MSG_TYPE_DISCONNECT */
typedef struct
{
  UINT16 Conn_Type;
  UINT16 Conn_Handle;
  UINT16 Disconnect_Data_Length;
//  UINT16 Disconnection_Data;
} HCT_MSG_REQ_DISCONNECT_s;

#define HCT_MSG_REQ_DISCONNECT_OFFSET_Conn_Type                   0
#define HCT_MSG_REQ_DISCONNECT_OFFSET_Conn_Handle                 2
#define HCT_MSG_REQ_DISCONNECT_OFFSET_Disconnection_Data_Length   4
#define HCT_MSG_REQ_DISCONNECT_OFFSET_Disconnection_Data          6
#define HCT_MSG_REQ_DISCONNECT_SIZE_Conn_Type                     2
#define HCT_MSG_REQ_DISCONNECT_SIZE_Conn_handle                   2
#define HCT_MSG_REQ_DISCONNECT_SIZE_Disconnection_Data_Length     2
#define HCT_MSG_REQ_DISCONNECT_SIZE                               6

// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_AR
typedef struct
{
  UINT16 Conn_Handle;
} HCT_MSG_REQ_DISCONNECT_CONN_TYPE_CL_IPV4_AR_s;

#define HCT_MSG_REQ_DISCONNECT_CONN_TYPE_CL_IPV4_AR_OFFSET_Conn_Handle    0
#define HCT_MSG_REQ_DISCONNECT_CONN_TYPE_CL_IPV4_AR_SIZE_Conn_Handle      2
#define HCT_MSG_REQ_DISCONNECT_CONN_TYPE_CL_IPV4_AR_SIZE                  2

// HCT_MSG_CONNECT_CONN_TYPE_MAC
typedef struct
{
  UINT16 Conn_Handle;
} HCT_MSG_REQ_DISCONNECT_CONN_TYPE_MAC_s;

#define HCT_MSG_REQ_DISCONNECT_CONN_TYPE_MAC_OFFSET_Conn_Handle    0
#define HCT_MSG_REQ_DISCONNECT_CONN_TYPE_MAC_SIZE_Conn_Handle      2
#define HCT_MSG_REQ_DISCONNECT_CONN_TYPE_MAC_SIZE                  2

typedef struct
{
  UINT16 Status;
  UINT16 Conn_Type;
  UINT16 Conn_Handle;
  UINT16 Disconnect_Data_Length;
//  UINT16 Disconnect_Data;
} HCT_MSG_RPY_DISCONNECT_s;

#define HCT_MSG_RPY_DISCONNECT_OFFSET_Status                   0
#define HCT_MSG_RPY_DISCONNECT_OFFSET_Conn_Type                2
#define HCT_MSG_RPY_DISCONNECT_OFFSET_Conn_Handle              4
#define HCT_MSG_RPY_DISCONNECT_OFFSET_Disconnect_Data_Length   6
#define HCT_MSG_RPY_DISCONNECT_OFFSET_Disconnect_Data          8
#define HCT_MSG_RPY_DISCONNECT_SIZE_Status                     2
#define HCT_MSG_RPY_DISCONNECT_SIZE_Conn_Type                  2
#define HCT_MSG_RPY_DISCONNECT_SIZE_Conn_Handle                2
#define HCT_MSG_RPY_DISCONNECT_SIZE_Disconnect_Data_Length     2
#define HCT_MSG_RPY_DISCONNECT_SIZE                            8

// HCT_MSG_CONNECT_CONN_TYPE_CL_IPV4_AR
typedef struct
{
  UINT32 IPv4_Addr;
} HCT_MSG_RPY_DISCONNECT_CONN_TYPE_CL_IPV4_AR_s;

#define HCT_MSG_RPY_DISCONNECT_CONN_TYPE_CL_IPV4_AR_OFFSET_IPv4_Addr  0
#define HCT_MSG_RPY_DISCONNECT_CONN_TYPE_CL_IPV4_AR_SIZE_IPv4_Addr    4
#define HCT_MSG_RPY_DISCONNECT_CONN_TYPE_CL_IPV4_AR_SIZE              4

/* HCT_MSG_TYPE_LOAD_SYSTEM_CONFIG */
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION      0x0001
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_SYSTEM_CONFIG         0x0003
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PHY_CONFIG            0x0004
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG            0x0005
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG          0x0006
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_LLC_CONFIG            0x0007
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_G3_CONFIG             0x0008

typedef struct
{
  UINT16 Config_Type;
  UINT16 Config_Length;
//  UINT16 Config_Data;
} HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_s;

#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_OFFSET_Config_Type       0
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_OFFSET_Config_Length     2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_OFFSET_Config_Data       4
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_SIZE_Config_Type         2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_SIZE_Config_Length       2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_SIZE                     4

// HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION
#if 0
typedef struct
{
  UINT8 Ports;
} HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_s;
#endif

#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_OFFSET_Ports         0
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_SIZE_Ports           1
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_SIZE                 1

#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_TYPE_SCI_A           0
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_TYPE_SCI_B           1

#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_DATA_PORT_MASK       0x03
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_DIAG_PORT_MASK       0x0c
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_GET_DATA_PORT(Port) \
      (((Port) & HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_DATA_PORT_MASK) >> 0)
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_GET_DIAG_PORT(Port) \
      (((Port) & HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_DIAG_PORT_MASK) >> 2)
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_SET_DATA_PORT(Port) \
      (((Port << 0) & HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_DATA_PORT_MASK))
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_SET_DIAG_PORT(Port) \
      (((Port << 2) & HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PORT_DESIGNATION_DIAG_PORT_MASK))

/* HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_SYSTEM_CONFIG */
#define HCT_MSG_LOAD_SYSTEM_CONFIG_DEVICE_MODE_NORMAL                  0
#define HCT_MSG_LOAD_SYSTEM_CONFIG_DEVICE_MODE_APPEMU_MAC              1
#define HCT_MSG_LOAD_SYSTEM_CONFIG_DEVICE_MODE_APPEMU_IEC432_LLC       2
#define HCT_MSG_LOAD_SYSTEM_CONFIG_DEVICE_MODE_POINT_TO_POINT          3
#define HCT_MSG_LOAD_SYSTEM_CONFIG_DEVICE_MODE_MAC                     4
#define HCT_MSG_LOAD_SYSTEM_CONFIG_DEVICE_MODE_PHY                     5
#define HCT_MSG_LOAD_SYSTEM_CONFIG_DEVICE_MODE_SNIFFER                 6
#define HCT_MSG_LOAD_SYSTEM_CONFIG_DEVICE_MODE_mIP                     8

#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_SYSTEM_CONFIG_DeviceMode_Flags_DeviceMode_MASK  0x00ff
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_SYSTEM_CONFIG_DeviceMode_Flags_AUTO_MODE        0x2000
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_SYSTEM_CONFIG_DeviceMode_Flags_USE_RPY          0x8000

typedef struct
{
  UINT16 SerialNumberLen;
  UINT16 SerialNumber[8];
  UINT16 EUI[3];
  UINT16 DeviceMode_Flags;
} HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_SYSTEM_CONFIG_s;

#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_SYSTEM_CONFIG_OFFSET_SerialNumberLen  0
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_SYSTEM_CONFIG_OFFSET_SerialNumber     2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_SYSTEM_CONFIG_OFFSET_EUI              18
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_SYSTEM_CONFIG_OFFSET_DeviceMode_Flags 24
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_SYSTEM_CONFIG_SIZE_SerialNumberLen    2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_SYSTEM_CONFIG_SIZE_SerialNumber       16
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_SYSTEM_CONFIG_SIZE_EUI                6
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_SYSTEM_CONFIG_SIZE_DeviceMode_Flags   2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_SYSTEM_CONFIG_SIZE                    26

/* HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PHY_CONFIG */
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PHY_CONFIG_FLAG_ROBO      (1 << 0)

typedef struct
{
  UINT16 flags;
} HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PHY_CONFIG_s;

#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PHY_CONFIG_OFFSET_flags   0
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PHY_CONFIG_SIZE_flags     2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_PHY_CONFIG_SIZE           2

/* HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG */
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG_MAC_FLAGS_MASK                   (0xff00)
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG_MAC_DFLT_SECURITY_PROFILE_MASK   (0x00ff)

#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG_MAC_FLAGS_DFLT_ARQ               (1 << 8)
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG_MAC_FLAGS_DFLT_PAC               (1 << 9)
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG_MAC_FLAGS_PAN_COORD              (1 << 10)

typedef struct
{
  UINT16 MAC_RX_Max_Hold_Ppdu;
  UINT16 MAC_Max_Conn;
  UINT16 MAC_Max_Queue_Len_Per_Conn;
  UINT16 MAC_Flags_Dflt_Security_Profile;
} HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG_s;

#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG_OFFSET_MAC_RX_Max_Hold_Ppdu              0
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG_OFFSET_MAC_Max_Conn                      2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG_OFFSET_MAC_Max_Queue_Len_Per_Conn        4
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG_OFFSET_MAC_Flags_Dflt_Security_Profile   6
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG_SIZE_MAC_RX_Max_Hold_Ppdu                2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG_SIZE_MAC_Max_Conn                        2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG_SIZE_MAC_Max_Queue_Len_Per_Conn          2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG_SIZE_MAC_Flags_Dflt_Security_Profile     2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_MAC_CONFIG_SIZE                                     8

/* HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG */

#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_FLAGS_IP_FLAG            (1 << 0)
typedef struct
{
  UINT16 Flags;
  UINT16 SourceAddrPrefix[4];
  UINT16 SourceAddress[4];
  UINT16 NetMask[2];
  UINT16 Gateway[2];
  UINT16 ControlPort;
} HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_s;

#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_OFFSET_Flags             0
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_OFFSET_SourceAddrPrefix  2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_OFFSET_SourceAddress     10
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_OFFSET_NetMask           18
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_OFFSET_Gateway           22
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_OFFSET_ControlPort       26
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_SIZE_Flags               2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_SIZE_SourceAddrPrefix    8
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_SIZE_SourceAddress       8
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_SIZE_NetMask             4
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_SIZE_Gateway             4
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_SIZE_ControlPort         2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_SIZE                     28

/* HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_LLC_CONFIG */
typedef struct
{
  UINT16 LLC_Src_LSAP;
  UINT16 LLC_Dflt_Dest_LSAP;
  UINT16 LLC_Dflt_Dest_Addr;
} HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_LLC_CONFIG_s;

#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_LLC_CONFIG_OFFSET_LLC_Src_LSAP              0
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_LLC_CONFIG_OFFSET_LLC_Dflt_Dest_LSAP        2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_LLC_CONFIG_OFFSET_LLC_Dflt_Dest_Addr        4
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_LLC_CONFIG_SIZE_LLC_Src_LSAP                2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_LLC_CONFIG_SIZE_LLC_Dflt_Dest_LSAP          2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_LLC_CONFIG_SIZE_LLC_Dflt_Dest_Addr          2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_LLC_CONFIG_SIZE                             6

/* HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_G3_CONFIG */
typedef struct
{
  UINT16 G3_Address_Type;
  UINT16 G3_Long_Address[4];
  UINT16 G3_Pan_ID;
  UINT16 G3_Short_Address;
	UINT16 G3_MAC_Segment_Length;
} HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_G3_CONFIG_s;

#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_G3_CONFIG_OFFSET_G3_Address_Type         0
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_G3_CONFIG_OFFSET_G3_Long_Address         2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_G3_CONFIG_OFFSET_G3_Pan_ID              10
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_G3_CONFIG_OFFSET_G3_Short_Address       12
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_G3_CONFIG_OFFSET_G3_MAC_Segment_Length  14
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_G3_CONFIG_SIZE_G3_Address_Type           2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_G3_CONFIG_SIZE_G3_Long_Address           8
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_G3_CONFIG_SIZE_G3_Pan_ID                 2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_G3_CONFIG_SIZE_G3_Short_Address          2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_G3_CONFIG_SIZE_G3_MAC_Segment_Length     2
#define HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_G3_CONFIG_SIZE                          16

typedef struct
{
  UINT16 Status;
} HCT_MSG_RPY_LOAD_SYSTEM_CONFIG_s;

#define HCT_MSG_RPY_LOAD_SYSTEM_CONFIG_OFFSET_Status        0
#define HCT_MSG_RPY_LOAD_SYSTEM_CONFIG_SIZE_Status          2
#define HCT_MSG_RPY_LOAD_SYSTEM_CONFIG_SIZE                 2

/* HCT_MSG_TYPE_SET_MAC_PIB */
typedef struct
{
  UINT16 Attribute_ID;
  UINT16 Attribute_Length;
//  UINT16 Attribute_Data;
} HCT_MSG_REQ_SET_MAC_PIB_s;

#define HCT_MSG_REQ_SET_MAC_PIB_OFFSET_Attribute_ID         0
#define HCT_MSG_REQ_SET_MAC_PIB_OFFSET_Attribute_Length     2
#define HCT_MSG_REQ_SET_MAC_PIB_OFFSET_Attribute_Data       4
#define HCT_MSG_REQ_SET_MAC_PIB_SIZE_Attribute_ID           2
#define HCT_MSG_REQ_SET_MAC_PIB_SIZE_Attribute_Length       2
#define HCT_MSG_REQ_SET_MAC_PIB_SIZE                        4

typedef struct
{
  UINT16 Status;
} HCT_MSG_RPY_SET_MAC_PIB_s;

#define HCT_MSG_RPY_SET_MAC_PIB_OFFSET_Status               0
#define HCT_MSG_RPY_SET_MAC_PIB_SIZE_Status                 2
#define HCT_MSG_RPY_SET_MAC_PIB_SIZE                        2

/* HCT_MSG_TYPE_CLEAR_PHY_PIB */
#if 0
typedef struct
{
//  UINT16 Attribute_ID;
} HCT_MSG_REQ_CLEAR_PHY_PIB_s;
#endif

#define HCT_MSG_REQ_CLEAR_PHY_PIB_OFFSET_Attribute_ID       0
#define HCT_MSG_REQ_CLEAR_PHY_PIB_SIZE_Attribute_ID         2
#define HCT_MSG_REQ_CLEAR_PHY_PIB_SIZE                      0

typedef struct
{
  UINT16 Status;
} HCT_MSG_RPY_CLEAR_PHY_PIB_s;

#define HCT_MSG_RPY_CLEAR_PHY_PIB_OFFSET_Status             0
#define HCT_MSG_RPY_CLEAR_PHY_PIB_SIZE_Status               2
#define HCT_MSG_RPY_CLEAR_PHY_PIB_SIZE                      2

/* HCT_MSG_TYPE_CLEAR_MAC_PIB */
#if 0
typedef struct
{
//  UINT16 Attribute_ID;
} HCT_MSG_REQ_CLEAR_MAC_PIB_s;
#endif

#define HCT_MSG_REQ_CLEAR_MAC_PIB_OFFSET_Attribute_ID       0
#define HCT_MSG_REQ_CLEAR_MAC_PIB_SIZE_Attribute_ID         2
#define HCT_MSG_REQ_CLEAR_MAC_PIB_SIZE                      0

typedef struct
{
  UINT16 Status;
} HCT_MSG_RPY_CLEAR_MAC_PIB_s;

#define HCT_MSG_RPY_CLEAR_MAC_PIB_OFFSET_Status             0
#define HCT_MSG_RPY_CLEAR_MAC_PIB_SIZE_Status               2
#define HCT_MSG_RPY_CLEAR_MAC_PIB_SIZE                      2

/* HCT_MSG_TYPE_CL_ESTABLISH */
typedef struct
{
	UINT16 IdentifierLength;
  UINT16 Device_Identifier[8];
} HCT_MSG_REQ_CL_ESTABLISH_s;

#define HCT_MSG_REQ_CL_ESTABLISH_ID_LENGTH_OFFSET           0
#define HCT_MSG_REQ_CL_ESTABLISH_OFFSET_Device_Identifier   2

#define HCT_MSG_REQ_CL_ESTABLISH_SIZE_ID_LENGTH							 2
#define HCT_MSG_REQ_CL_ESTABLISH_SIZE_Max_Device_Identifier 16
#define HCT_MSG_REQ_CL_ESTABLISH_SIZE                       18

typedef struct
{
  UINT16 Status;
	UINT16 IdentifierLength;
  UINT8 Device_Identifier[16];
  UINT16 Destination_Address;
  UINT16 Base_Address;
} HCT_MSG_RPY_CL_ESTABLISH_s;

#define HCT_MSG_RPY_CL_ESTABLISH_OFFSET_Status                0
#define HCT_MSG_RPY_CL_ESTABLIST_OFFSET_Id_Length             2
#define HCT_MSG_RPY_CL_ESTABLISH_OFFSET_Device_Identifier     4
//#define HCT_MSG_RPY_CL_ESTABLISH_OFFSET_Destination_Address   18
//#define HCT_MSG_RPY_CL_ESTABLISH_OFFSET_Base_Address          20
#define HCT_MSG_RPY_CL_ESTABLISH_SIZE_Status                  2
#define HCT_MSG_RPY_CL_ESTABLIST_SIZE_ID_LENGTH				        2
//#define HCT_MSG_RPY_CL_ESTABLISH_SIZE_Device_Identifier       16
#define HCT_MSG_RPY_CL_ESTABLISH_SIZE_Destination_Address     2
#define HCT_MSG_RPY_CL_ESTABLISH_SIZE_Base_Address            2
//#define HCT_MSG_RPY_CL_ESTABLISH_SIZE                         22

/* HCT_MSG_TYPE_ATTACH */
typedef struct
{
  UINT16 Pan_ID;
  UINT16 LBA_Address;
} HCT_MSG_REQ_ATTACH_G3_s;

#define HCT_MSG_REQ_ATTACH_G3_OFFSET_Pan_ID                 0
#define HCT_MSG_REQ_ATTACH_G3_OFFSET_LBA_Address            2
#define HCT_MSG_REQ_ATTACH_G3_SIZE_Pan_ID                   2
#define HCT_MSG_REQ_ATTACH_G3_SIZE_LBA_Address              2
#define HCT_MSG_REQ_ATTACH_G3_SIZE                          4

typedef struct
{
  UINT16 Status;
  UINT16 Network_Address;
  UINT16 Pan_ID;
} HCT_MSG_RPY_ATTACH_G3_s;

#define HCT_MSG_RPY_ATTACH_G3_OFFSET_Status                 0
#define HCT_MSG_RPY_ATTACH_G3_OFFSET_Network_Address        2
#define HCT_MSG_RPY_ATTACH_G3_OFFSET_Pan_ID                 4
#define HCT_MSG_RPY_ATTACH_G3_SIZE_Status                   2
#define HCT_MSG_RPY_ATTACH_G3_SIZE_Network_Address          2
#define HCT_MSG_RPY_ATTACH_G3_SIZE_Pan_ID                   2
#define HCT_MSG_RPY_ATTACH_G3_SIZE                          6

typedef struct
{
  UINT16 Network_Address_1[4];
  UINT16 Network_Address_2[4];
  UINT16 Extended_Address[4];
  UINT16 Capability_Info_Resv;
} HCT_MSG_IND_ATTACH_G3_s;

#define HCT_MSG_IND_ATTACH_G3_OFFSET_Network_Address_1      0
#define HCT_MSG_IND_ATTACH_G3_OFFSET_Network_Address_2      8
#define HCT_MSG_IND_ATTACH_G3_OFFSET_Extended_Address       16
#define HCT_MSG_IND_ATTACH_G3_OFFSET_Capability_Info_Resv   24
#define HCT_MSG_IND_ATTACH_G3_SIZE_Network_Address_1        8
#define HCT_MSG_IND_ATTACH_G3_SIZE_Network_Address_2        8
#define HCT_MSG_IND_ATTACH_G3_SIZE_Extended_Address         8
#define HCT_MSG_IND_ATTACH_G3_SIZE_Capability_Info_Resv     2
#define HCT_MSG_IND_ATTACH_G3_SIZE                          26

#define HCT_MSG_IND_ATTACH_G3_Capability_Info_MASK          0x00ff

/* HCT_MSG_TYPE_CL_RELEASE */
typedef struct
{
  UINT16 Destination_Address;
} HCT_MSG_REQ_CL_RELEASE_s;

#define HCT_MSG_REQ_CL_RELEASE_OFFSET_Destination_Address   0
#define HCT_MSG_REQ_CL_RELEASE_SIZE_Destination_Address     2
#define HCT_MSG_REQ_CL_RELEASE_SIZE                         2

typedef struct
{
  UINT16 Status;
  UINT16 Destination_Address;
} HCT_MSG_RPY_CL_RELEASE_s;

#define HCT_MSG_RPY_CL_RELEASE_OFFSET_Status                0
#define HCT_MSG_RPY_CL_RELEASE_OFFSET_Destination_Address   2
#define HCT_MSG_RPY_CL_RELEASE_SIZE_Status                  2
#define HCT_MSG_RPY_CL_RELEASE_SIZE_Destination_Address     2
#define HCT_MSG_RPY_CL_RELEASE_SIZE                         4

/* HCT_MSG_TYPE_DETACH */
typedef struct
{
  UINT16 Extended_Address[4];
} HCT_MSG_REQ_DETACH_G3_s;

#define HCT_MSG_REQ_DETACH_G3_OFFSET_Extended_Address       0
#define HCT_MSG_REQ_DETACH_G3_SIZE_Extended_Address         8
#define HCT_MSG_REQ_DETACH_G3_SIZE                          8

typedef struct
{
  UINT16 Status;
  UINT16 Extended_Address[4];
} HCT_MSG_RPY_DETACH_G3_s;

#define HCT_MSG_RPY_DETACH_G3_OFFSET_Status                 0
#define HCT_MSG_RPY_DETACH_G3_OFFSET_Extended_Address       2
#define HCT_MSG_RPY_DETACH_G3_SIZE_Status                   2
#define HCT_MSG_RPY_DETACH_G3_SIZE_Extended_Address         8
#define HCT_MSG_RPY_DETACH_G3_SIZE                          10

typedef struct
{
  UINT16 Extended_Address[4];
} HCT_MSG_IND_DETACH_G3_s;

#define HCT_MSG_IND_DETACH_G3_OFFSET_Extended_Address       0
#define HCT_MSG_IND_DETACH_G3_SIZE_Extended_Address         8
#define HCT_MSG_IND_DETACH_G3_SIZE                          8

/* HCT_MSG_TYPE_DISCOVER_G3 */
#define HCT_MSG_DISCOVER_G3_TYPE_NETWORK                    0x0000
#define HCT_MSG_DISCOVER_G3_TYPE_ROUTE                      0x0001
#define HCT_MSG_DISCOVER_G3_TYPE_PATH                       0x0002
#define HCT_MSG_DISCOVER_G3_TYPE_MASK                       0x00ff
#define HCT_MSG_DISCOVER_G3_DURATION_MASK                   0xff00

typedef struct
{
  UINT16 Type_Duration;
} HCT_MSG_REQ_DISCOVER_G3_s;

#define HCT_MSG_REQ_DISCOVER_G3_OFFSET_Type_Duration        0
#define HCT_MSG_REQ_DISCOVER_G3_SIZE_Type_Duration          2
#define HCT_MSG_REQ_DISCOVER_G3_SIZE                        2

typedef struct
{
  UINT16 Status;
  UINT16 Pan_Count;
//  UINT16 Extended_PanID[4][Pan_Count];
//  UINT16 PanID[Pan_Count];
} HCT_MSG_RPY_DISCOVER_G3_s;

#define HCT_MSG_RPY_DISCOVER_G3_OFFSET_Status               0
#define HCT_MSG_RPY_DISCOVER_G3_OFFSET_Pan_Count            2
#define HCT_MSG_RPY_DISCOVER_G3_OFFSET_PanID_Data           4
#define HCT_MSG_RPY_DISCOVER_G3_SIZE_Status                 2
#define HCT_MSG_RPY_DISCOVER_G3_SIZE_Pan_Count              2
#define HCT_MSG_RPY_DISCOVER_G3_SIZE                        4
#define HCT_MSG_RPY_DISCOVER_G3_SIZE_Extended_PanID         8
#define HCT_MSG_RPY_DISCOVER_G3_SIZE_PanID                  2

typedef struct
{
	UINT8 CoordinatorAddressMode;
	UINT8 LQI;
	UINT16 CoordinatorPANId;
	//UINT16 or byte[8] CoordinatorAddress;
} HCT_PAN_DESCRIPTOR_s;

typedef struct
{
  UINT8 DiscoverType; // = 1 for route discovery
  UINT8 MaxHops;      // = 7 for now..
  UINT16 DstAddress;
} HCT_MSG_REQ_G3_ROUTE_DISCOVER_s;

#define HCT_MSG_REQ_G3_ROUTE_DISCOVER_OFFSET_DiscoverType    0
#define HCT_MSG_REQ_G3_ROUTE_DISCOVER_OFFSET_MaxHops         1
#define HCT_MSG_REQ_G3_ROUTE_DISCOVER_OFFSET_DstAddress      2
#define HCT_MSG_REQ_G3_ROUTE_DISCOVER_SIZE                   4

typedef struct
{
  UINT16 Status;
} HCT_MSG_RPY_G3_ROUTE_DISCOVER_s;

#define HCT_MSG_RPY_G3_ROUTE_DISCOVER_Status               0
#define HCT_MSG_RPY_G3_ROUTE_DISCOVER_SIZE                 2


typedef struct
{
  UINT8 DiscoverType; // = 2 for path
  UINT8 Reserved;     // = 0
  UINT16 DstAddress;
} HCT_MSG_REQ_G3_PATH_DISCOVER_s;

#define HCT_MSG_REQ_G3_PATH_DISCOVER_OFFSET_DiscoverType    0
#define HCT_MSG_REQ_G3_PATH_DISCOVER_OFFSET_DstAddress      2
#define HCT_MSG_REQ_G3_PATH_DISCOVER_SIZE                   4

typedef struct
{
  UINT16 Status;
  UINT16 DstAddress;
  UINT16 NumbefOfDevices;
} HCT_MSG_RPY_G3_PATH_DISCOVER_s;

#define HCT_MSG_RPY_G3_PATH_DISCOVER_OFFSET_Status          0
#define HCT_MSG_RPY_G3_PATH_DISCOVER_OFFSET_DstAddress      2
#define HCT_MSG_RPY_G3_PATH_DISCOVER_OFFSET_NumberOfDevices 4
#define HCT_MSG_RPY_G3_PATH_DISCOVER_OFFSET_Devices         6


typedef struct
{
	UINT8 coordAddressMode;
	UINT8 beaconQuality;
	UINT16 coordPandId;
	UINT8 coordAddress[8];               // max size is 8 bytes, min is 2 bytes
} HCT_MSG_PAN_DESC_G3_s;

#define HCT_MSG_RPY_PAN_DESC_OFFEST_CoordAddressMode		0
#define HCT_MSG_RPY_PAN_DESC_OFFEST_BeaconQuality				1
#define HCT_MSG_RPY_PAN_DESC_OFFEST_CoordPanId					2
#define HCT_MSG_RPY_PAN_DESC_OFFEST_CoordAddress				6
// 
// Flash message subtypes.
//
#define HCT_MSG_REQ_FIRMWARE_MESSAGE_SUBTYPE						0
#define HCT_MSG_REQ_FIRMWARE_INITIATE_UPGRADE_SUBTYPE		1
#define HCT_MSG_REQ_FIRMWARE_REQ_CRC_SUBTYPE					  2
#define HCT_MSG_REQ_FIRMWARE_REQ_FLASH_SUBTYPE				  3
#define HCT_MSG_REQ_FIRMWARE_ACTIVATE_REQ_SUBTYPE				4
#define HCT_MSG_REQ_FIRMWARE_ABORT_SUBTYPE							0x0F
//
// Flash file transfer status codes
//
#define HCT_MSG_FIRMWARE_SUCCESS									0
#define HCT_MSG_FIRMWARE_PAYLOAD_CRC_ERROR				4
#define HCT_MSG_FIRMWARE_HOST_DOES_NOT_SUPPORT		0x6001
#define HCT_MSG_FIRMWARE_HOST_NO_IMAGE						0x6002
#define HCT_MSG_FIRMWARE_HOST_IMAGE_INCOMPLETE		0x6003
#define HCT_MSG_FIRMWARE_HOST_IMAGE_FAILED_CRC		0x6004
#define HCT_MSG_FIRMWARE_HOST_IMAGE_BAD						0x6005
#define HCT_MSG_FIRMWARE_HOST_NOT_PREPARED				0x6006
#define HCT_MSG_FIRMWARE_INVALID_CONTENTS_LEN			0x6007
#define HCT_MSG_FIRMWARE_INVALID_PAGE_INDEX				0x6008
#define HCT_MSG_FIRMWARE_UNABLE_TO_ACTIVATE				0x6009
#define HCT_MSG_FIRMWARE_NOT_FLASHED							0x600A

typedef struct
{
  UINT16 SubType;    //  subtype = 1
  UINT16 Page_Size;
  UINT32 Image_Size;
  UINT32 Image_CRC32;
} HCT_MSG_REQ_FIRMWARE_UPGRADE_s;

#define HCT_MSG_REQ_FIRMWARE_SUBTYPE_OFFSET				0
#define HCT_MSG_REQ_FIRMWARE_PAGESIZE_OFFSET			2
#define HCT_MSG_REQ_FIRMWARE_IMAGESIZE_OFFSET			4
#define HCT_MSG_REQ_FIRMWARE_CRC_OFFSET						8

#define HCT_MSG_REQ_FIRMWARE_SUBTYPE_SIZE					2
#define HCT_MSG_REQ_FIRMWARE_PAGESIZE_SIZE				2
#define HCT_MSG_REQ_FIRMWARE_IMAGESIZE_SIZE				4
#define HCT_MSG_REQ_FIRMWARE_CRC_SIZE							4

#define HCT_MSG_REQ_FIRMWARE_UPGRADE_SIZE					12
//
// Generic Host Replay status message
//
typedef struct
{
  UINT16 SubType;    
  UINT16 Status;
} HCT_MSG_RPY_FIRMWARE_s;

#define HCT_MSG_RPY_FIRMWARE_SUBTYPE_OFFSET				0
#define HCT_MSG_RPY_FIRMWARE_STATUS_OFFSET				2

#define HCT_MSG_RPY_FIRMWARE_SUBTYPE_SIZE					2
#define HCT_MSG_RPY_FIRMWARE_STATUS_SIZE					2
#define HCT_MSG_RPY_FIRMWARE_STATUS_MESSAGE_SIZE					4

//////////////////////////
/*
The message struct is based on max page size.
The actual size is based on page size received in the preveious message.
*/

#define MAX_PAGE_SIZE															192

typedef struct
{
  UINT16 SubType;    // subtype = 0
  UINT32 Page_Index;
  UINT8  Page_Contents[MAX_PAGE_SIZE];
} HCT_MSG_REQ_FIRMWARE_MESSAGE_s;

#define HCT_MSG_REQ_FIRMWARE_MESSAGE_SUBTYPE_OFFSET				0
#define HCT_MSG_REQ_FIRMWARE_MESSAGE_PAGE_INDEX_OFFSET		2
#define HCT_MSG_REQ_FIRMWARE_MESSAGE_PAGE_CONTENTS_OFFSET	6

#define HCT_MSG_REQ_FIRMWARE_MESSAGE_SUBTYPE_SIZE					2
#define HCT_MSG_REQ_FIRMWARE_MESSAGE_PAGE_INDEX_SIZE			4
#define HCT_MSG_REQ_FIRMWARE_MESSAGE_PAGE_CONTENTS_SIZE		192

#define HCT_MSG_REQ_FIRMWARE_MESSAGE_SIZE					198

typedef struct
{
  UINT16 SubType;    // subtype = 0
  UINT16 Status;
  UINT32 Page_Index;
	UINT16  ValidCRC;
	UINT32 CRC32;
} HCT_MSG_RPY_FIRMWARE_MESSAGE_s;

#define HCT_MSG_RPY_FIRMWARE_MESSAGE_SUBTYPE_OFFSET					0
#define HCT_MSG_RPY_FIRMWARE_MESSAGE_STATUS_OFFSET					2
#define HCT_MSG_RPY_FIRMWARE_MESSAGE_PAGE_INDEX_OFFSET			4
#define HCT_MSG_RPY_FIRMWARE_MESSAGE_PAGE_VALID_CRC_OFFSET	8
#define HCT_MSG_RPY_FIRMWARE_MESSAGE_PAGE_CRC_OFFSET			 10

#define HCT_MSG_RPY_FIRMWARE_MESSAGE_SUBTYPE_SIZE					2
#define HCT_MSG_RPY_FIRMWARE_MESSAGE_STATUS_SIZE					2
#define HCT_MSG_RPY_FIRMWARE_MESSAGE_PAGE_INDEX_SIZE			4
#define HCT_MSG_RPY_FIRMWARE_MESSAGE_PAGE_VALID_CRC_SIZE	2
#define HCT_MSG_RPY_FIRMWARE_MESSAGE_PAGE_CRC_SIZE				4

#define HCT_MSG_RPY_FIRMWARE_MESSAGE_SIZE									14

//////////////////////////////

//
// Generic PLC command message..
//
typedef struct
{
  UINT16 SubType;    // 
} HCT_MSG_REQ_FIRMWARE_CMD_s;

#define HCT_MSG_REQ_FIRMWARE_CMD_SUBTYPE_OFFSET				0

#define HCT_MSG_REQ_FIRMWARE_CMD_SUBTYPE_SIZE					2
#define HCT_MSG_REQ_FIRMWARE_CMD_MESSAGE_SIZE					2


typedef struct
{
  UINT16 SubType;    // subtype = 2 
  UINT16 Status;
  UINT32 CRC_Value;
} HCT_MSG_RPY_FIRMWARE_CRC_s;

#define HCT_MSG_RPY_FIRMWARE_CRC_SUBTYPE_OFFSET				0
#define HCT_MSG_RPY_FIRMWARE_CRC_STATUS_OFFSET				2
#define HCT_MSG_RPY_FIRMWARE_CRC_VALUE_OFFSET					4

#define HCT_MSG_RPY_FIRMWARE_CRC_SUBTYPE_SIZE					2
#define HCT_MSG_RPY_FIRMWARE_CRC_STATUS_SIZE					2
#define HCT_MSG_RPY_FIRMWARE_CRC_VALUE_SIZE						4

#define HCT_MSG_RPY_FIRMWARE_CRC_MESSAGE_SIZE					8

////////////////////////////////

#define HCT_MSG_DO_NOT_FLASH				0
#define HCT_MSG_FLASH_ACTIVE_IMAGE	1

typedef struct
{
  UINT16 SubType;  
  UINT16 Flag;
} HCT_MSG_REQ_ABORT_s;

#define HCT_MSG_REQ_ABORT_SUBTYPE_OFFSET				0
#define HCT_MSG_REQ_ABORT_FLAG_OFFSET						2

#define HCT_MSG_REQ_ABORT_SUBTYPE_SIZE					2
#define HCT_MSG_REQ_ABORT_FLAG_SIZE							2

#define HCT_MSG_REQ_ABORT_MESSAGE_SIZE					4

//////////////////////////////

#define HTC_MSG_FLASH_SREC														0
#define HTC_MSG_FLASH_BINARY													1

#define HTC_MSG_FLASH_PAYLOAD_MAX_SIZE								256

typedef struct
{
	UINT16 PacketNumber;
	UINT16 PayloadType;
	UINT8	 Payload[HTC_MSG_FLASH_PAYLOAD_MAX_SIZE];
} HCT_MSG_FLASH_MESSAGE_s;

#define HCT_MSG_FLASH_MESSAGE_PACKET_NUMBER_OFFSET		0
#define HCT_MSG_FLASH_MESSAGE_PAYLOAD_TYPE_OFFSET			2
#define HCT_MSG_FLASH_MESSAGE_PAYLOAD_OFFSET					4

#define HCT_MSG_FLASH_MESSAGE_PACKET_NUMBER_SIZE			2
#define HCT_MSG_FLASH_MESSAGE_PAYLOAD_TYPE_SIZE				2
#define HCT_MSG_FLASH_MESSAGE_PAYLOAD_MAX_SIZE				HTC_MSG_FLASH_PAYLOAD_MAX_SIZE

#define HCT_MSG_FLASH_MESSAGE_ADDRESS_OFFSET					0
#define HCT_MSG_FLASH_MESSAGE_LENGTH_OFFSET						4
#define HCT_MSG_FLASH_MESSAGE_DATA_OFFSET							6

#define HCT_MSG_FLASH_MESSAGE_SIZE										4+HTC_MSG_FLASH_PAYLOAD_MAX_SIZE

typedef struct
{
	UINT16 PacketNumber;
	UINT16 Status;
} HCT_MSG_FLASH_MESSAGE_RPY_s;

#define HCT_MSG_FLASH_MESSAGE_RPY_PACKET_NUMBER_OFFSET		0
#define HCT_MSG_FLASH_MESSAGE_RPY_STATUS_OFFSET						2

#define HCT_MSG_FLASH_MESSAGE_RPY_PACKET_NUMBER_SIZE			2
#define HCT_MSG_FLASH_MESSAGE_RPY_STATUS_SIZE							2
#define HCT_MSG_FLASH_MESSAGE_RPY_SIZE										4

//
// Actual flash status codes sent by PLC during the actual flash 
//
#define FLASH_STATUS_SUCCESS						0
#define FLASH_STATUS_ABORT							1
#define	FLASH_STATUS_BAD_CRC						2
#define	FLASH_STATUS_MISSING_PACKET			3
#define	FLASH_STATUS_ERASE_PENDING			4
#define	FLASH_STATUS_ERASE_COMPLETE			5
#define	FLASH_STATUS_UTILTIY_MISSING		6


#define START_FLASH						0
#define ACK_FLASH_BOF					1
#define ACK_FLASH_PACKET			2
#define SEND_FLASH_EOF				3
#define ACK_FLASH_EOF					4
#define FLASH_LOAD_DONE				5
#define ACK_FLASH_ABORT				6
#define FLASH_ERROR           99

#define FLASH_BOF							0
#define FLASH_EOF             0xFFFE
#define FLASH_ABORT						0xFFFF
#define SREC_PAYLOAD_TYPE			0
#define SREC_BINARY_PAYLOAD_TYPE 1

#define BLOB_ID_CONFIG_FILE   0
#define BLOB_ID_FW_STATUS     1
#define BLOB_ID_DMEM					2
#define BLOB_ID_PMEM					3

#define ERR_HOST_MEM_FULL    14
#define ERR_CRC_CHECKSUM		 15
#define ERR_UNKNOWN_BLOB     16
#define ERR_BLOB_NOT_FOUND   17

typedef struct
{
	UINT16 Blob_Id;
	UINT16 Blob_Length;
	//UINT8  Blob_Data[32];
} HCT_MSG_BLOB_s;

typedef struct
{
	UINT16 Blob_Id;
	UINT16 Blob_Length;
} HCT_MSG_READ_BLOB_MESSAGE_s;

#define HCT_MSG_READ_BLOB_MESSAGE_BLOB_ID_OFFSET			0
#define HCT_MSG_READ_BLOB_MESSAGE_BLOB_LENGTH_OFFSET	2
#define HCT_MSG_READ_BLOB_MESSAGE_BLOB_ID_SIZE				2
#define HCT_MSG_READ_BLOB_MESSAGE_BLOB_LENGTH_SIZE		2
#define HCT_MSG_READ_BLOB_MESSAGE_BLOB_SIZE						4

typedef struct
{
	UINT16 Blob_Id;
	UINT16 Blob_Length;
//UINT8  Blob_Data[Blob_Length];
} HCT_MSG_READ_BLOB_MESSAGE_RPY_s;

#define HCT_MSG_READ_BLOB_MESSAGE_RPY_BLOB_ID_OFFSET			0
#define HCT_MSG_READ_BLOB_MESSAGE_RPY_BLOB_LENGTH_OFFSET	2
#define HCT_MSG_READ_BLOB_MESSAGE_RPY_BLOB_DATA_OFFSET		4

#define HCT_MSG_READ_BLOB_MESSAGE_RPY_BLOB_ID_SIZE				2
#define HCT_MSG_READ_BLOB_MESSAGE_RPY_BLOB_LENGTH_SIZE		2
#define HCT_MSG_READ_BLOB_MESSAGE_RPY_SIZE								4 // + blob length

typedef struct
{
	UINT16 Blob_Id;
	UINT32 Blob_Length;
//UINT8  Blob_Data[Blob_Length];
} HCT_MSG_WRITE_BLOB_MESSAGE_s;

#define HCT_MSG_WRITE_BLOB_MESSAGE_BLOB_ID_OFFSET			0
#define HCT_MSG_WRITE_BLOB_MESSAGE_BLOB_LENGTH_OFFSET	2
#define HCT_MSG_WRITE_BLOB_MESSAGE_BLOB_DATA_OFFSET		4

#define HCT_MSG_WRITE_BLOB_MESSAGE_BLOB_ID_SIZE				2
#define HCT_MSG_WRITE_BLOB_MESSAGE_BLOB_LENGTH_SIZE		2
#define HCT_MSG_WRITE_BLOB_MESSAGE_SIZE								4 // + blob length

typedef struct
{
	UINT16 Status;
} HCT_MSG_WRITE_BLOB_MESSAGE_RPY_s;

#define HCT_MSG_WRITE_BLOB_MESSAGE_RPY_STATUS_OFFSET			0
#define HCT_MSG_WRITE_BLOB_MESSAGE_RPY_STATUS_SIZE				2
#define HCT_MSG_WRITE_BLOB_MESSAGE_RPY_SIZE								2

//////////////////////////////

#if !defined(__TI_COMPILER_VERSION__)  // TI Code Composer Studio
// return to default packing
#pragma pack()
#endif // #if !defined(__TI_COMPILER_VERSION__)  // TI Code Composer Studio

#endif // #ifdef __HCT_MSG_IF_DEF_H__
