/******************************************************************************
* FILE PURPOSE: HOSTAPPEMU main.
*******************************************************************************
*
* FILE NAME: hostappemu.h
*
* DESCRIPTION:
*       This file contains the global definitions for the HOSTAPPEMU.
*
* HISTORY:
* 09/01/2007    stephen smith           initial revision
* 12/08/2009    stephen smith           port from TIWiMAXWrapper
*
* Copyright (c) 2007-2009 Texas Instruments Inc.  All rights reserved.
******************************************************************************/
#ifndef __HOSTAPPEMU_H__
#define __HOSTAPPEMU_H__

typedef signed int          SINT16;     // Signed 16-bit integer (15-bit magnitude)

#define HostAppEMU_REGISTRY_KEY         TEXT("SOFTWARE\\Texas Instruments\\HOSTAPPEMU")

// status values
typedef int HostAppEMU_STATUS;

#define HostAppEMU_STATUS_SUCCESS         (0)
#define HostAppEMU_STATUS_FAILURE         (-1)
#define HostAppEMU_STATUS_EMPTY           (-2)
#define HostAppEMU_STATUS_NO_MEMORY       (-3)
#define HostAppEMU_STATUS_BAD_LENGTH      (-4)
#define HostAppEMU_STATUS_BAD_DATA        (-5)
#define HostAppEMU_STATUS_FIFO_FULL       (-6)
#define HostAppEMU_STATUS_EOF             (-7)

// debug levels
#define HostAppEMU_DBG_LEVEL_MIN          0
#define HostAppEMU_DBG_LEVEL_ALWAYS       0
#define HostAppEMU_DBG_LEVEL_ERROR        1
#define HostAppEMU_DBG_LEVEL_WARNING      2
#define HostAppEMU_DBG_LEVEL_VERBOSE      5
#define HostAppEMU_DBG_LEVEL_COMM         7
#define HostAppEMU_DBG_LEVEL_DUMP_BUFFER  8
#define HostAppEMU_DBG_LEVEL_TRACE        9
#define HostAppEMU_DBG_LEVEL_MAX          9

// flags
extern unsigned long HostAppEMU_Flags;
#define HostAppEMU_OUTPUT_DEBUG_FILE      (1 << 0)
#define HostAppEMU_P2P                    (1 << 1)
#define HostAppEMU_MAC                    (1 << 2)
#ifdef APPEMU_IEC432
#define HostAppEMU_CL_IEC432              (1 << 3)
#endif // #ifdef APPEMU_IEC432
#define HostAppEMU_CL_LLC                 (1 << 4)
#define HostAppEMU_IPv4                   (1 << 5)
#define HostAppEMU_IPv6                   (1 << 6)
#define HostAppEMU_Use_IP                 (1 << 7)
#define HostAppEMU_G3_Node                (1 << 8)
#define HostAppEMU_G3_Conc                (1 << 9)
#ifdef APPEMU_IEC432
#define HostAppEMU_MODE_MASK              (HostAppEMU_P2P|HostAppEMU_MAC|HostAppEMU_CL_IEC432|HostAppEMU_CL_LLC|HostAppEMU_IPv4|HostAppEMU_G3_Node|HostAppEMU_G3_Conc)
#else // #ifdef APPEMU_IEC432
#define HostAppEMU_MODE_MASK              (HostAppEMU_P2P|HostAppEMU_MAC|HostAppEMU_CL_LLC|HostAppEMU_IPv4|HostAppEMU_G3_Node|HostAppEMU_G3_Conc)
#endif // #ifdef APPEMU_IEC432
#define HostAppEMU_Flash                  (1 << 15)
#define HostAppEMU_SendTextMsg            (1 << 16)
#define HostAppEMU_RecvTextMsg            (1 << 17)
#define HostAppEMU_SendFile               (1 << 18)
#define HostAppEMU_RecvFile               (1 << 19)
#define HostAppEMU_ResetDevice            (1 << 28)
#define HostAppEMU_LLC_AUTO               (1 << 29)
#define HostAppEMU_USE_RPY                (1 << 30)
#define HostAppEMU_Exit                   (1 << 31)

// fifo defines
#define HostAppEMU_MSG_FIFO_COUNT         20

// timer support
typedef int (*HostAppEMU_TIMER_CALLBACK)(DWORD dwTime);
typedef struct
{
  HostAppEMU_TIMER_CALLBACK TimerCallback;
  int ms;
  BOOL oneshot;
} HostAppEMU_TIMER_CTRL, *PHostAppEMU_TIMER_CTRL;

// function prototypes
HostAppEMU_STATUS HostAppEMU_TimerStart(HostAppEMU_TIMER_CALLBACK TimerCallback, int ms, BOOL oneshot);
HostAppEMU_STATUS HostAppEMU_TimerKill(void);

void HostAppEMU_Uninit(void);
HostAppEMU_STATUS HostAppEMU_GetModuleVersion(LPTSTR sVersion, size_t bufsize);
HostAppEMU_STATUS HostAppEMU_SetDebugLevel(int dbglevel);
HostAppEMU_STATUS HostAppEMU_GetDebugLevel(int *pdbglevel);
void HostAppEMU_DbgPrint(BOOL bPrintTime, int dbglevel, LPCTSTR lpFormat, ...);
void HostAppEMU_DbgDumpBuffer(int dbglvl, char *pbuffer, int length);
void HostAppEMU_DbgPrintLastError(void);
HostAppEMU_STATUS HostAppEMU_GetInstance(int *pinstance);
HostAppEMU_STATUS HostAppEMU_Lock(void);
HostAppEMU_STATUS HostAppEMU_Unlock(void);
void HostAppEMU_TempName(LPTSTR buf, size_t bufsize);
HostAppEMU_STATUS HostAppEMU_OpenDebugFile(void);
HostAppEMU_STATUS HostAppEMU_CloseDebugFile(void);
HostAppEMU_STATUS HostAppEMU_GetFlags(unsigned long *pflags);
HostAppEMU_STATUS HostAppEMU_SetFlags(unsigned long flags);
HostAppEMU_STATUS HostAppEMU_ClearFlags(unsigned long flags);
void hostappemu_exitapp(void);
void CRC16_UpdateChecksum(unsigned short *pcrcvalue, const void *data, int length);


WCHAR * GetHumanName(char * guid);
WCHAR * GetDeviceGuid(HKEY key, WCHAR * subkey);

#endif // #ifndef __HOSTAPPEMU_H__
