/******************************************************************************
* FILE PURPOSE: HOSTAPPEMU com port module.
*******************************************************************************
* FILE NAME: hostappemu_com.h
*
* DESCRIPTION:
*       Com port definitions.
*
* HISTORY:
* 09/01/2007    stephen smith           initial revision
* 12/08/2009    stephen smith           port from TIWiMAXWrapper
*
* Copyright (c) 2007-2009 Texas Instruments Inc.  All rights reserved.
******************************************************************************/
#ifndef __HOSTAPPEMU_COM_H__
#define __HOSTAPPEMU_COM_H__

typedef struct
{
  DWORD iComPort;
  TCHAR sComName[255];
  HANDLE hCom;
  DCB dcb;
  COMMTIMEOUTS CommTimeouts;
  ULONG bytesRead;
  ULONG bytesWrite;
  ULONG msgRead;
  ULONG msgWrite;
} HostAppEMU_COM_CONFIG;

int HostAppEMU_InitCom(void);
int HostAppEMU_UninitCom(void);
int HostAppEMU_ComPortOpen(HostAppEMU_COM_CONFIG *pComConfig);
int HostAppEMU_ComPortClose(HostAppEMU_COM_CONFIG *pComConfig);
int HostAppEMU_ComGetSettings(HostAppEMU_COM_CONFIG *pComConfig);
int HostAppEMU_ComPutSettings(HostAppEMU_COM_CONFIG *pComConfig);
int HostAppEMU_ComWrite(void *buffer, int count);

int HostAppEMU_ComApplySettings(void);
int HostAppEMU_ComSetPort(int iComport);
int HostAppEMU_ComGetPort(int *piComport);
int HostAppEMU_ComSetBaudRate(int bps);
int HostAppEMU_ComGetBaudRate(int *pbps);
int HostAppEMU_ComSetParity(TCHAR *sParity);
int HostAppEMU_ComGetParity(TCHAR *sParity, int bufsize);
int HostAppEMU_ComSetDataBits(int databits);
int HostAppEMU_ComGetDataBits(int *pdatabits);
int HostAppEMU_ComSetStopBits(int stopbits);
int HostAppEMU_ComGetStopBits(int *pstopbits);

#endif // #ifndef __HOSTAPPEMU_COM_H__
