/******************************************************************************
* FILE PURPOSE: AppEMUC data module.
*******************************************************************************
* FILE NAME: hostappemu_data.h
*
* DESCRIPTION:
*       Data module definitions.
*
* HISTORY:
* 09/01/2007    stephen smith           initial revision
* 12/08/2009    stephen smith           port from TIWiMAXWrapper
*
* Copyright (c) 2007-2009 Texas Instruments Inc.  All rights reserved.
******************************************************************************/
#ifndef __HostAppEMU_DATA_H__
#define __HostAppEMU_DATA_H__

#include "hostappemu.h"

int HostAppEMU_InitData(void);
int HostAppEMU_UninitData(void);
int HostAppEMU_ProcessDataMsg(char *buf);

void HostAppEMU_ReceivedSyncMsg(void);
int HostAppEMU_Process_Message(char *buf);
void HostAppEMU_SendMsgToPLC(UINT16 msgtype, UINT8 *msg, int msglen, BOOL b_UseRPY);
int HostAppEMU_SendSyncMsgToPLC(UINT16 msgtype, UINT8 *msg, int msglen, BOOL b_UseRPY);
BOOL HCT_MSG_is_EXT_TYPE(UINT16 msgtype);

#endif // #ifndef __HostAppEMU_DATA_H__
