/******************************************************************************
* FILE PURPOSE: HOSTAPPEMU IP module.
*******************************************************************************
* FILE NAME: hostappemu_ip.h
*
* DESCRIPTION:
*       IP definitions.
*
* HISTORY:
* 04/26/2007    stephen smith           initial revision
*
* Copyright (c) 2010 Texas Instruments Inc.  All rights reserved.
******************************************************************************/
#ifndef __HOSTAPPEMU_IP_H__
#define __HOSTAPPEMU_IP_H__

#include "hct_msg_def.h"

typedef struct
{
  int WSA_Error_Code;
  char *WSA_Error_Code_Name;
  char *short_desc;
  char *long_desc;
} WSA_Error_Desc_s;

int HostAppEMU_Init_IP(void);
int HostAppEMU_Uninit_IP(void);
int HostAppEMU_IP_SendPacket(void *buffer, int count, BOOL bMsg);
void hostappemu_ipv4_SendTextMessage(UINT8 *pui8, UINT16 len);
void hostappemu_ipv4_processPacket_DATA_TRANSFER(HCT_MSG_BUFFER_t *pmsg, UINT16 msg_len, BOOL bRPY);

#endif // #ifndef __HOSTAPPEMU_IP_H__
