/******************************************************************************
* FILE PURPOSE: Embedded Component Application.
*******************************************************************************
*
* FILE NAME: hostappemu_p2p.h
*
* DESCRIPTION:
*       Embedded Component Application header file.
*
* HISTORY:
* 05/14/2010  stephen smith   initial revision
*
* Copyright (c) 2010 Texas Instruments Inc.  All rights reserved.
******************************************************************************/
#ifndef __HOSTAPPEMU_P2P_H__
#define __HOSTAPPEMU_P2P_H__

#include "hct_msg_def.h"

#pragma pack(1) // structure members alignment is 1 byte
#define HOSTAPPEMU_P2P_FILE_TRANSFER_PACKET_SIZE      256

struct CPacketAPEHeader
{
  BYTE m_bType;

  const static BYTE MSG_SEQ_MASK = 0x0f;
  const static BYTE ORG_MASK = 0x80;
  const static BYTE ORG_HOST = 0x80;
  const static BYTE ORG_MAC = 0x80;
  const static BYTE RPY_MASK = 0x40;
  const static BYTE RPY = 0x40;
  const static BYTE NO_RPY = 0x40;
  BYTE m_bTag;

  WORD m_bLength;
};

struct CPacketAPEHeaderEx
{
  WORD HeaderCRC16;
  WORD PayloadCRC16;
};

struct CPacketDataMessage_Header
{
  const static DWORD Signature = 'CLP$';
  DWORD m_Signature;

  const static WORD SubType_Message = 1;
  const static WORD SubType_SendFileAck = 2;
  const static WORD SubType_SendFileStream = 3;
  const static WORD SubType_SendFileStatus = 4;
  const static WORD SubType_SendFileStreamNoNACK = 5;
  WORD m_SubType;
};

struct CPacket_RPY_ACK
{
  CPacketAPEHeader m_Header;
  CPacketAPEHeaderEx m_HeaderEx;
};

struct CPacket_LLC_DataTransfer_Request_Header
{
  WORD Packet_Type;
  BYTE Destination_LSAP;
  BYTE Source_LSAP;
  BYTE Destination_MAC_Address[6];
};

struct CPacket_LLC_DataTransfer_Confirm_Header
{
  WORD Packet_Type;
  BYTE Destination_LSAP;
  BYTE Source_LSAP;
  BYTE Destination_MAC_Address[6];
  WORD Transmission_Status;
};

struct CPacket_LLC_DataTransfer_Indicate_Header
{
  WORD Packet_Type;
  BYTE Destination_LSAP;
  BYTE Source_LSAP;
  BYTE Destination_MAC_Address[6];
  BYTE Source_MAC_Address[6];
};

struct CPacket_G3_DataTransfer_Request_Header
{
  CPacket_G3_DataTransfer_Request_Header()
  {
    NSDU_handle = 0;
    Flags = 0;
  }

  BYTE NSDU_handle;

  const static BYTE Flag_D_Route_Enabled = (1 << 0);
  const static BYTE Flag_SEC_Enabled = (1 << 1);
  const static BYTE Flag_QOS_Enabled = (1 << 2);
  BYTE Flags;
};

struct CPacket_G3_DataTransfer_Confirm_Header
{
  CPacket_G3_DataTransfer_Confirm_Header()
  {
    NSDU_handle = 0;
  }
  BYTE NSDU_handle;
  BYTE reserved;
  WORD Status;
};

struct CPacket_G3_DataTransfer_Indicate_Header
{
  CPacket_G3_DataTransfer_Indicate_Header()
  {
    LinkQualityIndicator = 0;
    Flags = 0;
  }

  BYTE LinkQualityIndicator;

  const static BYTE Flag_SEC_Enabled = (1 << 0);
  BYTE Flags;
};

struct CPacketTextMessage_Send
{
  CPacketAPEHeader m_Header;
  CPacketAPEHeaderEx m_HeaderEx;

  CPacket_LLC_DataTransfer_Request_Header llc_header;

  CPacketDataMessage_Header payload_hdr;
};

struct CPacketTextMessageG3_Send
{
  CPacketAPEHeader m_Header;
  CPacketAPEHeaderEx m_HeaderEx;

  CPacket_G3_DataTransfer_Request_Header g3_header;

  CPacketDataMessage_Header payload_hdr;
};

struct CPacketSendFileMessage_Payload
{
  CPacketDataMessage_Header payload_hdr;

  const static DWORD PacketNum_BOF   = 0x00000000;
  const static DWORD PacketNum_EOF   = 0xfffffffe;
  const static DWORD PacketNum_Abort = 0xffffffff;
  const static DWORD PacketNum_Min   = PacketNum_BOF + 1;
  const static DWORD PacketNum_Max   = PacketNum_EOF - 1;
  DWORD m_PacketNum;

  const static WORD PacketSizeMax   = 0x1000;
  WORD m_PacketLen;

  WORD m_CRC;
};

struct CPacketSendFileMessage
{
  CPacketAPEHeader m_Header;
  CPacketAPEHeaderEx m_HeaderEx;

  CPacket_LLC_DataTransfer_Request_Header llc_header;

  CPacketSendFileMessage_Payload payload;
};

struct CPacketSendFileMessage_G3
{
  CPacketAPEHeader m_Header;
  CPacketAPEHeaderEx m_HeaderEx;

  CPacket_G3_DataTransfer_Request_Header g3_header;

  CPacketSendFileMessage_Payload payload;
};

struct CPacketSendFileMessageReply_Payload
{
  CPacketSendFileMessage_Payload payload_hdr;

  const static WORD Status_Success = 0;
  const static WORD Status_Abort = 1;
  const static WORD Status_BadCrc = 2;
  const static WORD Status_Missing = 3;

  WORD Status;
};

struct CPacketSendFileMessageReply
{
  CPacket_LLC_DataTransfer_Request_Header llc_header;

  CPacketSendFileMessageReply_Payload payload;
};

struct CPacketSendFileMessageReply_G3
{
  CPacket_G3_DataTransfer_Request_Header g3_header;

  CPacketSendFileMessageReply_Payload payload;
};

#pragma pack()

struct CXferInformation
{
  char *m_Xfer_TX_filename;
  UINT m_Xfer_TX_packets;
  UINT m_Xfer_TX_bytes;
  UINT m_Xfer_TX_errors;
  UINT m_Xfer_TX_resend;
//  CTime m_Xfer_TX_start_time;
//  CTime m_Xfer_TX_last_time;
  LONG m_Xfer_TX_duration;
  char *m_Xfer_RX_filename;
  UINT m_Xfer_RX_packets;
  UINT m_Xfer_RX_bytes;
  UINT m_Xfer_RX_crc_errors;
  UINT m_Xfer_RX_missing_packets;
//  CTime m_Xfer_RX_start_time;
//  CTime m_Xfer_RX_last_time;
  LONG m_Xfer_RX_duration;
  UINT m_Xfer_TTL_TX_packets;
  UINT m_Xfer_TTL_TX_bytes;
  UINT m_Xfer_TTL_TX_files;
  UINT m_Xfer_TTL_TX_aborts;
  UINT m_Xfer_TTL_TX_errors;
  UINT m_Xfer_TTL_TX_resend;
  UINT m_Xfer_TTL_TX_messages;
  LONG m_Xfer_TTL_TX_duration;
  char m_Xfer_TX_Last_Error[256];
  UINT m_Xfer_TTL_RX_packets;
  UINT m_Xfer_TTL_RX_bytes;
  UINT m_Xfer_TTL_RX_files;
  UINT m_Xfer_TTL_RX_messages;
  UINT m_Xfer_TTL_RX_aborts;
  UINT m_Xfer_TTL_RX_crc_errors;
  UINT m_Xfer_TTL_RX_missing_packets;
  LONG m_Xfer_TTL_RX_duration;
  char m_Xfer_RX_Last_Error[256];
};

void hostappemu_p2p_SendTextMessage(UINT8 *pui8, UINT16 len);
void hostappemu_p2p_processPacket_DATA_TRANSFER(HCT_MSG_BUFFER_t *pmsg, UINT16 msg_len, BOOL bRPY);
void OnUpdate_XferRxInfo(const CXferInformation *pXferInfo);
bool hostappemu_p2p_SendFile(char *filename);

#endif // #ifndef __HOSTAPPEMU_TEXTMSG_H__
