/******************************************************************************
* FILE PURPOSE: Embedded Component Application.
*******************************************************************************
*
* FILE NAME: hostappemu_sn.h
*
* DESCRIPTION:
*       Embedded Component Application header file.
*
* HISTORY:
* 07/07/2009  stephen smith   initial revision
* 12/08/2009  stephen smith   ported from PRIME project
*
* Copyright (c) 2009 Texas Instruments Inc.  All rights reserved.
******************************************************************************/
#ifndef __ECA_APPEMU_H__
#define __ECA_APPEMU_H__

#include "hct_msg_if_def.h"
//#include "eca_appemu_mgh.h"

#define ECA_APPEMU_HOST_APP
struct ECA_APPEMU_MGH;

#if 0
#define DIAG_printf(level, log_id, num_params, ...) \
  { \
    if (log_id > (sizeof(eca_appemu_logger_strings) / sizeof(eca_appemu_logger_strings[0]))) \
    { \
      HostAppEMU_DbgPrint(TRUE, level, TEXT("Unknown logger message %d!\n"), log_id); \
    } \
    else \
    { \
      HostAppEMU_DbgPrint(TRUE, level, eca_appemu_logger_strings[log_id], __VA_ARGS__); \
    } \
  }
#else
#define DIAG_printf(level, log_id, num_params, ...)   HostAppEMU_DbgPrint(TRUE, level, eca_appemu_logger_strings[log_id - 200], __VA_ARGS__)
#endif

#define ALIGN16(len)    (((len) + 1) & ~1)

#define DIAG_LOG_LEVEL_APPEMU   DIAG_LOG_LEVEL_05


typedef UINT16 APPEMU_status_t;
typedef UINT32 ConnHandle_t;
#define FAKE_CONNECTION_HANDLE        (0)
#define INVALID_CONNECTION_HANDLE     (-1)

/* TODO: need global error include file that contains all errors */
#define MAC_STAT_SUCCESS              0
#define MAC_STAT_ERR_FAILURE          (HCT_MSG_STATUS_MAC_ERROR_CODE_GROUP + 1)
#define MAC_STAT_ESTABLISH_TIMEOUT    (HCT_MSG_STATUS_MAC_ERROR_CODE_GROUP + 21)
#define MAC_STAT_REG_REDUNDANT        (HCT_MSG_STATUS_MAC_ERROR_CODE_GROUP + 55)

#define ECF_TASK_TYPE_ECA_START          0x80
#define ECF_TASK_TYPE_ECA_END            0xbf

typedef UINT32 ECF_TIME_t;
#define ECF_TIME_PER_DAY        ((ECF_TIME_t) (60L * 60L * 24L))

typedef struct
{
  BOOL bRPY;
  UINT16 task_type;
  UINT16 conn_type;
  union
  {
    void * task_param;
    struct
    {
      HCT_MSG_BUFFER_t *msg;
      UINT16 msglen;
    } s;
  } u;
} ECF_TASK_s;

typedef enum
{
  ECF_STATUS_SUCCESS = 0,
  ECF_STATUS_PENDING,
  ECF_STATUS_ERROR,
  ECF_STATUS_UNSUPPORTED,
  ECF_STATUS_INVALID_PARAM
} ECF_STATUS;

typedef UINT32 ECF_TIME_t;
#define ECF_TIME_PER_DAY        ((ECF_TIME_t) (60L * 60L * 24L))

#define ECA_APPEMU_EXIT_DELAY           ((ECF_TIME_t) 5)    // number of seconds to wait until we exit
#define ECA_APPEMU_CONNECTION_DELAY     ((ECF_TIME_t) 5)    // number of seconds to wait until we ask for a connection
#define ECA_APPEMU_CONNECTION_COMPLETE_DELAY  ((ECF_TIME_t) 120)    // number of seconds to wait for connection complete
#define ECA_APPEMU_REGISTRATION_DELAY   ((ECF_TIME_t) 10)   // number of seconds to wait until we start registration
#define ECA_APPEMU_REGISTRATION_TIMEOUT ((ECF_TIME_t) 20)   // number of seconds until registration timeout
#define ECA_APPEMU_INACTIVITY_TIMEOUT   ((ECF_TIME_t) 600)  // number of seconds of inactivity until we timeout

//#define ECA_APPEMU_PROVIDER_ID          0x5854004e    // "XT_N" little endian "TXN"
#define ECA_APPEMU_PROVIDER_ID          0x4953004d    // "IS_M" little endian "SIM"
#define ECA_APPEMU_PROVIDER_ID_MASK     0xffff00ff
#define ECA_APPEMU_PROVIDER_ID_LEN      3
#define ECA_APPEMU_SERIAL_LEN           9
#define ECA_APPEMU_SERIAL_LEN_WORDS     ((ECA_APPEMU_PROVIDER_ID_LEN + ECA_APPEMU_SERIAL_LEN + 1) >> 1)
#define ECA_APPEMU_STEP_LEN             1             // ECA_APPEMU_PKT_TYPE_t
#define ECA_APPEMU_SYSTIME_LEN          6             // (000000..(SECONDS_PER_DAY * 10))
#define ECA_APPEMU_DW_MSG_SIGNATURE     0x5744        // little endian "DW"
#define ECA_APPEMU_DW_MSG_LEN           2
#define ECA_APPEMU_UP_MSG_SIGNATURE     0x5055        // little endian "UP"
#define ECA_APPEMU_DW_MSG_HEADER_LEN    (ECA_APPEMU_DW_MSG_LEN + ECA_APPEMU_PROVIDER_ID_LEN + ECA_APPEMU_STEP_LEN + ECA_APPEMU_SYSTIME_LEN)
#define ECA_APPEMU_UP_MSG_LEN           2
#define ECA_APPEMU_UP_MSG_HEADER_LEN    (ECA_APPEMU_UP_MSG_LEN + ECA_APPEMU_PROVIDER_ID_LEN + ECA_APPEMU_STEP_LEN + ECA_APPEMU_SYSTIME_LEN)
#define ECA_APPEMU_CON_TYPE             (250)

typedef enum
{
  ECA_APPEMU_STEP_None                        = 0,
  ECA_APPEMU_STEP_Loop_Inc                    = 1,

  ECA_APPEMU_STEP_Connect                     = 1,

  ECA_APPEMU_STEP_Loop_Start                  = 2,
  ECA_APPEMU_STEP_SystemTimeRead              = 2,
  ECA_APPEMU_STEP_EnergyRegisterRead          = 3,
  ECA_APPEMU_STEP_AccumulatedInformationRead  = 4,
  ECA_APPEMU_STEP_PPDU_LengthTesting          = 5,
  ECA_APPEMU_STEP_Loop_End                    = 5,

  ECA_APPEMU_STEP_Disconnect                  = 6,

  ECA_APPEMU_STEP_Count                       = 7
} ECA_APPEMU_STEP_t;

/* ECA tasks */
#define ECA_TASK_DISCONNECT                               (ECF_TASK_TYPE_ECA_START + 0)
#define ECA_TASK_PACKET_RECEIVED                          (ECF_TASK_TYPE_ECA_START + 1)
#define ECA_TASK_TIMER                                    (ECF_TASK_TYPE_ECA_START + 2)
#define ECA_TASK_REGISTER_CONFIRM                         (ECF_TASK_TYPE_ECA_START + 3)
#define ECA_TASK_UNREGISTER_INDICATE                      (ECF_TASK_TYPE_ECA_START + 4)
#define ECA_TASK_CONNECTION_ESTABLISHED                   (ECF_TASK_TYPE_ECA_START + 5)
#define ECA_TASK_RELEASE_CONFIRM                          (ECF_TASK_TYPE_ECA_START + 6)
#define ECA_TASK_DATA_CONFIRM                             (ECF_TASK_TYPE_ECA_START + 7)
#define ECA_TASK_UNREGISTER_CONFIRM                       (ECF_TASK_TYPE_ECA_START + 8)
#define ECA_TASK_SEND_RPY                                 (ECF_TASK_TYPE_ECA_START + 9)
#define ECA_TASK_EXIT                                     (ECF_TASK_TYPE_ECA_START + 10)
#define ECA_TASK_CL_ESTABLISHED                           (ECF_TASK_TYPE_ECA_START + 11)
#define ECA_TASK_SEND_MSG_TO_HOST                         (ECF_TASK_TYPE_ECA_START + 12)
#define ECA_TASK_DISCOVER_REPLY                           (ECF_TASK_TYPE_ECA_START + 13)
#define ECA_TASK_LAST                                     ECA_TASK_DISCOVER_REPLY

typedef struct
{
  UINT32 send_pkt[ECA_APPEMU_STEP_Count];
  UINT32 recv_pkt[ECA_APPEMU_STEP_Count];
  UINT16 err_send_pkt;
  UINT16 err_recv_pkt[ECA_APPEMU_STEP_Count];
  UINT16 err_out_of_memory;
  UINT16 err_rx_out_of_seq;
  UINT16 bad_recv_pkt;
  UINT16 bad_recv_pkt_signature;
  UINT16 bad_recv_pkt_provider;
  UINT16 invalid_recv_pkt_step;
  UINT16 unexpected_connect_confirm;
  UINT16 unexpected_disconnect_indicate;
  UINT16 unexpected_disconnect_confirm;
  UINT16 unexpected_data_confirm;
  UINT16 unexpected_data_indicate;
  UINT16 unexpected_mac_event;
  UINT16 err_connect;
  UINT16 err_data_indicate;
  UINT16 err_data_indicate_bad_hdl;
  UINT16 err_deregister;
  UINT16 err_disconnect_confirm;
  UINT16 err_bad_disconnect_handle;

  UINT16 ttl_connect_attempts;
  UINT16 ttl_inactivity;

  UINT16 err_bad_LLC_Dest_Addr;
  UINT16 err_bad_LLC_Src_LSAP;
  UINT16 err_bad_LLC_Dest_LSAP;

  UINT16 err_bad_G3_nsdu_handle;
} ECA_APPEMU_STATS_s;

#define ECA_APPEMU_FLAGS_USE_RPY                    (UINT32) (1 << 0)
#define ECA_APPEMU_FLAGS_MAC_AES                    (UINT32) (1 << 1)
#define ECA_APPEMU_FLAGS_MAC_ARQ                    (UINT32) (1 << 2)
#define ECA_APPEMU_FLAGS_DBPSK                      (UINT32) (1 << 3)
#define ECA_APPEMU_FLAGS_DQPSK                      (UINT32) (1 << 4)
#define ECA_APPEMU_FLAGS_D8PSK                      (UINT32) (1 << 5)
#define ECA_APPEMU_FLAGS_FEC                        (UINT32) (1 << 6)
#define ECA_APPEMU_FLAGS_AGC                        (UINT32) (1 << 7)
#define ECA_APPEMU_FLAGS_IPv6                       (UINT32) (1 << 8)
#define ECA_APPEMU_FLAGS_LLC_AUTO                   (UINT32) (1 << 9)
#define ECA_APPEMU_FLAGS_ROBO                       (UINT32) (1 << 10)
#define ECA_APPEMU_FLAGS_BLI                        (UINT32) (1 << 11)
#define ECA_APPEMU_FLAGS_SETTINGS_MASK              (UINT32) (0x0000ffff)
#define ECA_APPEMU_FLAGS_REGISTRATION_IN_PROGRESS   (UINT32) (1 << 16)
#define ECA_APPEMU_FLAGS_REGISTRATION_COMPLETE      (UINT32) (1 << 17)
#define ECA_APPEMU_FLAGS_CONNECT_IN_PROGRESS        (UINT32) (1 << 18)
#define ECA_APPEMU_FLAGS_CONNECTED                  (UINT32) (1 << 19)
#define ECA_APPEMU_FLAGS_DATA_SEND                  (UINT32) (1 << 20)
#define ECA_APPEMU_FLAGS_INACTIVITY_TIMEOUT         (UINT32) (1 << 21)
#define ECA_APPEMU_FLAGS_SEND_RPY                   (UINT32) (1 << 22)
#define ECA_APPEMU_FLAGS_DETACHING                  (UINT32) (1 << 23)
#define ECA_APPEMU_FLAGS_STATE_MASK                 (UINT32) (0xffff0000)

#define PPDU_LENGTH_TESTING_VALUES                7
#define PPDU_LENGTH_TESTING_OFFSET_DBPSK_OFF      0
#define PPDU_LENGTH_TESTING_OFFSET_DBPSK_ON       1
#define PPDU_LENGTH_TESTING_OFFSET_DQPSK_OFF      2
#define PPDU_LENGTH_TESTING_OFFSET_DQPSK_ON       3
#define PPDU_LENGTH_TESTING_OFFSET_D8PSK_OFF      4
#define PPDU_LENGTH_TESTING_OFFSET_D8PSK_ON       5
#define PPDU_LENGTH_TESTING_OFFSET_COUNT          6

#define PPDU_LENGTH_TESTING_GET_OFFSET_VALUE(NextDWLen)       ((NextDWLen) & 0xff)
#define PPDU_LENGTH_TESTING_GET_OFFSET_TYPE(NextDWLen)        (((NextDWLen) >> 8) & 0xff)
#define PPDU_LENGTH_TESTING_SET_OFFSET_VALUE(NextDWLen, v)    { (NextDWLen) &= 0x00ff; (NextDWLen) |= (v & 0xff); }
#define PPDU_LENGTH_TESTING_SET_OFFSET_TYPE(NextDWLen, v)     { (NextDWLen) &= 0xff00; (NextDWLen) |= ((v & 0xff) << 8); }



bool ECA_initialize(void);
void ECA_OutOfMemory(void);

void ECA_NETWORK_REGISTER_confirm(UINT16 status, UINT16 *pSNA, UINT16 *pEUI);
void ECA_NETWORK_UNREGISTER_indicate(void);
void ECA_Connect_confirm(UINT16 status, UINT16 Conn);

void ECA_AppEmu_DATA_handler(HCT_MSG_BUFFER_t *msg, UINT16 msglen, BOOL bRPY);
void ECA_AppEmu_Get_System_Info_Handler(HCT_MSG_BUFFER_t *msg, UINT16 msglen);
void ECA_AppEmu_Set_Info_Handler(HCT_MSG_BUFFER_t *msg, UINT16 msglen);
void ECA_AppEmu_SETUP_ALARM_Handler(HCT_MSG_BUFFER_t *msg, UINT16 msglen);
void ECA_AppEmu_ALARM_Handler(UINT16 *MsgHdr, HCT_MSG_BUFFER_t *msg, UINT16 msglen);
void ECA_AppEmu_NETWORK_REGISTER_or_NETWORK_START_handler(HCT_MSG_BUFFER_t *msg, UINT16 msglen);
void ECA_AppEmu_CONNECT_handler(HCT_MSG_BUFFER_t *pmsg, UINT16 msglen);
void ECA_AppEmu_CL_ESTABLISH_or_ATTACH_handler(HCT_MSG_BUFFER_t *pmsg, UINT16 msglen);
void ECA_AppEmu_CL_RELEASE_or_DETACH_handler(HCT_MSG_BUFFER_t *pmsg, UINT16 msglen);
void ECA_AppEmu_NETWORK_UNREGISTER_handler(HCT_MSG_BUFFER_t *msg, UINT16 msglen);
void ECA_AppEmu_DISCOVER_handler(HCT_MSG_BUFFER_t *pmsg, UINT16 msglen);
void ECA_AppEmu_Load_System_Config_Handler(HCT_MSG_BUFFER_t *msg, UINT16 msglen);
void ECA_AppEmu_Get_System_Info_Handler(HCT_MSG_BUFFER_t *msg, UINT16 msglen);
void ECA_AppEmu_Shut_Down_Handler(HCT_MSG_BUFFER_t *msg, UINT16 msglen);

void ECA_AppEmu_Get_System_Info_Handler_IP(ECA_APPEMU_MGH *pECA_AppEmu_mgh, HCT_MSG_BUFFER_t *msg, UINT16 msglen);
void ECA_AppEmu_Get_System_Info_Handler_LLC(ECA_APPEMU_MGH *pECA_AppEmu_mgh, HCT_MSG_BUFFER_t *msg, UINT16 msglen);
void ECA_AppEmu_Get_System_Info_Handler_G3(ECA_APPEMU_MGH *pECA_AppEmu_mgh, HCT_MSG_BUFFER_t *msg, UINT16 msglen);
void ECA_AppEmu_Get_System_Info_Dump_IP(HCT_MSG_BUFFER_t *msg, UINT16 msglen);
void ECA_AppEmu_Get_System_Info_Dump_LLC(HCT_MSG_BUFFER_t *msg, UINT16 msglen);
void ECA_AppEmu_Get_System_Info_Dump_G3(HCT_MSG_BUFFER_t *msg, UINT16 msglen);

void ECA_AppEmu_FirmwareFlash(HCT_MSG_BUFFER_t *msg, UINT16 len);
void ECA_AppEmu_FirmwareUpgrade(HCT_MSG_BUFFER_t *msg, UINT16 len);
void ECA_AppEmu_ReadBlob(HCT_MSG_BUFFER_t *msg, UINT16 len);
void ECA_AppEmu_WriteBlob(HCT_MSG_BUFFER_t *msg, UINT16 len);
void ECA_AppEMU_Get_MAC_PIB(HCT_MSG_BUFFER_t *msg, UINT16 len);
void ECA_AppEmu_RemoteRestart();
DWORD WINAPI HostAppEMU_FirmwareReset(LPVOID lpParam);
DWORD WINAPI HostAppEMU_RemoteReset(LPVOID lpParam);

#endif // #ifndef __ECA_APPEMU_H__
