/******************************************************************************
* FILE PURPOSE: Embedded Component Application.
*******************************************************************************
*
* FILE NAME: hostappemu_sn_g3.c
*
* DESCRIPTION:
*       ECA AppEMU application.
*
* HISTORY:
* 07/07/2009  stephen smith   initial revision
* 12/08/2009  stephen smith   ported from PRIME project
*
* LIST OF FUNCTIONS:
*
* Copyright (c) 2009 Texas Instruments Inc.  All rights reserved.
******************************************************************************/
#include "stdafx.h"
#include <crtdbg.h>

#include "hostappemu.h"
#include "diag_log.h"

#define G3
#include "hct_msg_def.h"
#include "hct_msg_if_def.h"

#include "hostappemu_sn.h"
#include "eca_appemu_mgh.h"
#include "ipv6mainheader.h"
#include "g3network.h"


extern ECA_APPEMU_MGH ECA_AppEmu_mgh;
extern UINT8 g3MACSegmentLength;
extern UINT8 macAddress[8];

/******************************************************************************
* FUNCTION NAME: ECA_AppEmu_Get_System_Info_Handler_G3
*
* DESCRIPTION:
*       HCT_MSG_TYPE_GET_SYSTEM_INFO handler.
*
* Return Value:       none
* Input Parameters:   HCT_MSG_BUFFER_t *  message payload
*                     UINT16        message payload length
* Output Parameters:  none
******************************************************************************/
void ECA_AppEmu_Get_System_Info_Handler_G3(ECA_APPEMU_MGH *pECA_AppEmu_mgh, HCT_MSG_BUFFER_t *msg, UINT16 msglen)
{
  pECA_AppEmu_mgh->G3_Address_Type = *(UINT16 *) (&msg[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_Address_Type >> 1]);
  memcpy(
      &pECA_AppEmu_mgh->G3_Long_Address,
      &msg[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_Long_Address >> 1],
      HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_G3_Long_Address
  );

	//UINT16 panId = *(UINT16 *) (&msg[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_PAN_ID >> 1]);
	//UINT16 shortAddress = *(UINT16 *) (&msg[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_Short_Address >> 1]);
  
	pECA_AppEmu_mgh->G3_Pan_ID = *(UINT16 *) (&msg[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_PAN_ID >> 1]);
  pECA_AppEmu_mgh->G3_Short_Address = *(UINT16 *) (&msg[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_Short_Address >> 1]);

	pECA_AppEmu_mgh->G3_MAC_Segment_Length = g3MACSegmentLength;
	if (msglen >=42 + 14 + 4 + 2)
	{
		pECA_AppEmu_mgh->G3_MAC_Segment_Length = *(UINT16 *)(&msg[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_MAC_Segment_Length >> 1]);
		if (pECA_AppEmu_mgh->G3_MAC_Segment_Length == 0)
		{
			pECA_AppEmu_mgh->G3_MAC_Segment_Length = g3MACSegmentLength;
		}
	}
}

/******************************************************************************
* FUNCTION NAME: ECA_AppEmu_Get_System_Info_Dump_G3
*
* DESCRIPTION:
*       HCT_MSG_TYPE_GET_SYSTEM_INFO dump.
*
* Return Value:       none
* Input Parameters:   HCT_MSG_BUFFER_t *  message payload
*                     UINT16        message payload length
* Output Parameters:  none
******************************************************************************/
void ECA_AppEmu_Get_System_Info_Dump_G3(HCT_MSG_BUFFER_t *msg, UINT16 msglen)
{
  UINT8 *pui8;
  UINT16 ui16;
	UINT16 panId;
	UINT16 shortAddress;

  pui8 = (UINT8 *) msg;

  ui16 = *((UINT16 *) &pui8[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_Address_Type]);
  HostAppEMU_DbgPrint(TRUE, DIAG_LOG_LEVEL_APPEMU, TEXT("G3 Address Type..................... %#x\n"), ui16 );

  pui8 = ((UINT8 *) &pui8[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_Long_Address]);
  HostAppEMU_DbgPrint(TRUE, DIAG_LOG_LEVEL_APPEMU, TEXT("G3 Long Address..................... %02x%02x%02x%02x%02x%02x%02x%02x\n"),
      pui8[0], pui8[1], pui8[2], pui8[3], pui8[4], pui8[5], pui8[6], pui8[7]
  );

	memcpy(macAddress, pui8, 8);

  panId = *((UINT16 *) &pui8[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_PAN_ID]);
  HostAppEMU_DbgPrint(TRUE, DIAG_LOG_LEVEL_APPEMU, TEXT("G3 Pan ID........................... 0x%4.4X\n"), (int)panId);

  shortAddress = *((UINT16 *) &pui8[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_G3_Short_Address]);
  HostAppEMU_DbgPrint(TRUE, DIAG_LOG_LEVEL_APPEMU, TEXT("G3 Short Address.................... 0x%4.4X\n"), (int)shortAddress);
	
	G3_Network::m_LocalIpAddress = IPv6Address(ECA_AppEmu_mgh.G3_Pan_ID, 0);
}
