/******************************************************************************
* FILE PURPOSE: Embedded Component Application.
*******************************************************************************
*
* FILE NAME: hostappemu_sn_ip.c
*
* DESCRIPTION:
*       ECA AppEMU application.
*
* HISTORY:
* 07/07/2009  stephen smith   initial revision
* 12/08/2009  stephen smith   ported from PRIME project
*
* LIST OF FUNCTIONS:
*
* Copyright (c) 2009 Texas Instruments Inc.  All rights reserved.
******************************************************************************/
#include "stdafx.h"
#include <crtdbg.h>

#include "hostappemu.h"
#include "diag_log.h"

#define PRIME
#define PRIME_IP
#include "hct_msg_def.h"
#include "hct_msg_if_def.h"

#include "hostappemu_sn.h"
#include "eca_appemu_mgh.h"

/******************************************************************************
* FUNCTION NAME: ECA_AppEmu_Get_System_Info_Handler_IP
*
* DESCRIPTION:
*       HCT_MSG_TYPE_GET_SYSTEM_INFO handler.
*
* Return Value:       none
* Input Parameters:   HCT_MSG_BUFFER_t *  message payload
*                     UINT16        message payload length
* Output Parameters:  none
******************************************************************************/
void ECA_AppEmu_Get_System_Info_Handler_IP(ECA_APPEMU_MGH *pECA_AppEmu_mgh, HCT_MSG_BUFFER_t *msg, UINT16 msglen)
{
  memcpy(
      &pECA_AppEmu_mgh->save_IPv4_SourceAddress,
      &msg[HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_OFFSET_SourceAddress >> 1],
      HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_SIZE_SourceAddress
  );
  memcpy(
      &pECA_AppEmu_mgh->save_IPv4_Netmask,
      &msg[HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_OFFSET_NetMask >> 1],
      HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_SIZE_NetMask
  );
  memcpy(
      &pECA_AppEmu_mgh->save_IPv4_Gateway,
      &msg[HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_OFFSET_Gateway >> 1],
      HCT_MSG_REQ_LOAD_SYSTEM_CONFIG_TYPE_CL_IP_CONFIG_SIZE_Gateway
  );
}

/******************************************************************************
* FUNCTION NAME: ECA_AppEmu_Get_System_Info_Dump_IP
*
* DESCRIPTION:
*       HCT_MSG_TYPE_GET_SYSTEM_INFO dump.
*
* Return Value:       none
* Input Parameters:   HCT_MSG_BUFFER_t *  message payload
*                     UINT16        message payload length
* Output Parameters:  none
******************************************************************************/
void ECA_AppEmu_Get_System_Info_Dump_IP(HCT_MSG_BUFFER_t *msg, UINT16 msglen)
{
  UINT8 *pui8;
  UINT16 ui16;
  UINT32 ui32;
  UINT16 flags;
  TCHAR *s;

  pui8 = (UINT8 *) msg;

  flags = ((*((UINT16 *) &pui8[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_Flags])) & HCT_MSG_GET_SYSTEM_INFO_FLAGS_MASK);
  if (flags & HCT_MSG_GET_SYSTEM_INFO_FLAGS_IP_FLAG)
  {
    s = TEXT("IPv6");
  }
  else
  {
    s = TEXT("IPv4");
  }
  HostAppEMU_DbgPrint(TRUE, DIAG_LOG_LEVEL_APPEMU, TEXT("IP Flag............................. %s\n"), s);

  ui32 = *((UINT32 *) &pui8[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV4_Source_Address]);
  HostAppEMU_DbgPrint(TRUE, DIAG_LOG_LEVEL_APPEMU, TEXT("CL IPV4 Source Address.............. %d.%d.%d.%d\n"),
    (ui32 >> 24) & 0xff,
    (ui32 >> 16) & 0xff,
    (ui32 >> 8) & 0xff,
    (ui32) & 0xff
  );

  ui32 = *((UINT32 *) &pui8[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV4_Netmask]);
  HostAppEMU_DbgPrint(TRUE, DIAG_LOG_LEVEL_APPEMU, TEXT("CL IPV4 Netmask..................... %d.%d.%d.%d\n"),
    (ui32 >> 24) & 0xff,
    (ui32 >> 16) & 0xff,
    (ui32 >> 8) & 0xff,
    (ui32) & 0xff
  );

  ui32 = *((UINT32 *) &pui8[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV4_Gateway]);
  HostAppEMU_DbgPrint(TRUE, DIAG_LOG_LEVEL_APPEMU, TEXT("CL IPV4 Gateway..................... %d.%d.%d.%d\n"),
    (ui32 >> 24) & 0xff,
    (ui32 >> 16) & 0xff,
    (ui32 >> 8) & 0xff,
    (ui32) & 0xff
  );

  ui16 = *((UINT16 *) &pui8[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_CL_IPV4_ControlPort]);
  HostAppEMU_DbgPrint(TRUE, DIAG_LOG_LEVEL_APPEMU, TEXT("CL IPV4 UDP Control Port............ %d\n"), ui16 );
}
