/******************************************************************************
* FILE PURPOSE: Embedded Component Application.
*******************************************************************************
*
* FILE NAME: hostappemu_sn_llc.c
*
* DESCRIPTION:
*       ECA AppEMU application.
*
* HISTORY:
* 07/07/2009  stephen smith   initial revision
* 12/08/2009  stephen smith   ported from PRIME project
*
* LIST OF FUNCTIONS:
*
* Copyright (c) 2009 Texas Instruments Inc.  All rights reserved.
******************************************************************************/
#include "stdafx.h"
#include <crtdbg.h>

#include "hostappemu.h"
#include "diag_log.h"

#define PRIME
#define PRIME_IEC432
#include "hct_msg_def.h"
#include "hct_msg_if_def.h"

#include "hostappemu_sn.h"
#include "eca_appemu_mgh.h"

/******************************************************************************
* FUNCTION NAME: ECA_AppEmu_Get_System_Info_Handler_LLC
*
* DESCRIPTION:
*       HCT_MSG_TYPE_GET_SYSTEM_INFO handler.
*
* Return Value:       none
* Input Parameters:   HCT_MSG_BUFFER_t *  message payload
*                     UINT16        message payload length
* Output Parameters:  none
******************************************************************************/
void ECA_AppEmu_Get_System_Info_Handler_LLC(ECA_APPEMU_MGH *pECA_AppEmu_mgh, HCT_MSG_BUFFER_t *msg, UINT16 msglen)
{
  pECA_AppEmu_mgh->destSap = *(UINT8 *) (&msg[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_LLC_Dflt_Dest_LSAP >> 1]);
  pECA_AppEmu_mgh->srcSap = *(UINT8 *) (&msg[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_LLC_Src_LSAP >> 1]);
  memcpy(
      &pECA_AppEmu_mgh->Destination_Address,
      &msg[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_LLC_Dflt_Dest_Addr >> 1],
      HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_LLC_Dflt_Dest_Addr
  );
  memcpy(
      &pECA_AppEmu_mgh->EUI[0],
      &msg[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_EUI >> 1],
      HCT_MSG_RPY_GET_SYSTEM_INFO_SIZE_EUI
  );
}

/******************************************************************************
* FUNCTION NAME: ECA_AppEmu_Get_System_Info_Dump_LLC
*
* DESCRIPTION:
*       HCT_MSG_TYPE_GET_SYSTEM_INFO dump.
*
* Return Value:       none
* Input Parameters:   HCT_MSG_BUFFER_t *  message payload
*                     UINT16        message payload length
* Output Parameters:  none
******************************************************************************/
void ECA_AppEmu_Get_System_Info_Dump_LLC(HCT_MSG_BUFFER_t *msg, UINT16 msglen)
{
  UINT8 *pui8;
  UINT16 ui16;

  pui8 = (UINT8 *) msg;

  ui16 = *((UINT16 *) &pui8[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_LLC_Src_LSAP]);
  HostAppEMU_DbgPrint(TRUE, DIAG_LOG_LEVEL_APPEMU, TEXT("LLC Source LSAP..................... %#x\n"), ui16 );

  ui16 = *((UINT16 *) &pui8[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_LLC_Dflt_Dest_LSAP]);
  HostAppEMU_DbgPrint(TRUE, DIAG_LOG_LEVEL_APPEMU, TEXT("LLC Default Destination LSAP........ %#x\n"), ui16 );

  HostAppEMU_DbgPrint(TRUE, DIAG_LOG_LEVEL_APPEMU, TEXT("LLC Default Destination Address..... %#x\n"),
    pui8[HCT_MSG_RPY_GET_SYSTEM_INFO_OFFSET_LLC_Dflt_Dest_Addr + 0]
  );
  HostAppEMU_DbgPrint(TRUE, DIAG_LOG_LEVEL_APPEMU, TEXT("\n"));
}
