/******************************************************************************
* FILE PURPOSE: OS_FIFO implementation.
*******************************************************************************
*
* FILE NAME: os_fifo.h
*
* DESCRIPTION:
*       This file contains all functions for implementing an OS_FIFO object.
*
* HISTORY:
* 09/01/2005    stephen smith           initial revision
* 10/08/2007    stephen smith           ported to use in TIWiMAXWrapper.
* 01/17/2008    stephen smith           enhanced to allow multiple processes to use
* 12/08/2009    stephen smith           port from TIWiMAXWrapper
*
* Copyright (c) 2005-2009 Texas Instruments Inc.  All rights reserved.
******************************************************************************/
#ifndef __OS_FIFO_H__
#define __OS_FIFO_H__

//#include "TIWiMAXWrapper.h"

#ifndef __OS_H__
// original object had an os abstraction, we do not, so
//  define the equivilent so we don't change to much of the code
#define OS_STATUS                 unsigned int
#define OS_STATUS_ERROR_MASK      (0x80000000)
#define OS_STATUS_USER_MASK       (0x40000000)

#define OS_STATUS_SUCCESS         (0)
#define OS_STATUS_ERROR           (OS_STATUS_ERROR_MASK|0x1001)
#define OS_STATUS_NO_MEMORY       (OS_STATUS_ERROR_MASK|0x1002)
#define OS_STATUS_INTERRUPTED     (OS_STATUS_ERROR_MASK|0x1003)
#define OS_STATUS_EOF             (OS_STATUS_ERROR_MASK|0x1004)
#define OS_STATUS_BAD_PARAM       (OS_STATUS_ERROR_MASK|0x1005)
#define OS_STATUS_SEMAPHORE_ERROR (OS_STATUS_ERROR_MASK|0x1006)

typedef int   SINT32;
typedef int * PSINT32;

#define OS_DBGPRINT(x)
#define LEN32(x)                  (x)
#define OS_MAX_NAME               32

#endif // #ifndef __OS_H__

typedef struct
{
  UINT32                curr_items;             // current items in fifo
  UINT32                max_items;              // max item count
  UINT32                max_wait_put_item;      // max wait time to put an item
  UINT32                max_wait_put_fifo;      // max wait time to gain access to put an item
  UINT32                max_wait_get_fifo;      // max wait time to gain access to get an item
} OS_FIFO_STATS, *POS_FIFO_STATS;

// OS_FIFO object definition
typedef struct
{
   BOOL                 active;
   UINT32               c_access;
   TCHAR                name[OS_MAX_NAME];
   INT                  count;
   INT                  fifo_bufsize;
   INT                  itemsize;
   INT                  ihead;
   INT                  itail;
   OS_FIFO_STATS        stats;
} OS_FIFO_CONTROL, *POS_FIFO_CONTROL;

typedef struct
{
   HANDLE               mutex;
   HANDLE               item_in;
   HANDLE               item_out;
   POS_FIFO_CONTROL     pfifo_control;
   PVOID                fifo_buf;
} OS_FIFO, *POS_FIFO;

// OS_STATUS return values
#define OS_FIFO_ERROR           (OS_STATUS_ERROR_MASK|OS_STATUS_USER_MASK|0x0001)
#define OS_FIFO_EMPTY           (OS_STATUS_ERROR_MASK|OS_STATUS_USER_MASK|0x0002)
#define OS_FIFO_FULL            (OS_STATUS_ERROR_MASK|OS_STATUS_USER_MASK|0x0003)

/* function prototypes */
#ifdef __cplusplus 
extern "C" {
#endif 
OS_STATUS os_fifo_create(POS_FIFO_CONTROL pfifo_control, TCHAR *name_ptr, UINT element_size, UINT element_count);
OS_STATUS os_fifo_delete(POS_FIFO fifo_ptr);
OS_STATUS os_fifo_open(POS_FIFO fifo_ptr, POS_FIFO_CONTROL os_fifo_control, PVOID fifo_buffer);
OS_STATUS os_fifo_close(POS_FIFO fifo_ptr);
OS_STATUS os_fifo_put(POS_FIFO fifo_ptr, PVOID pdata);
OS_STATUS os_fifo_get(POS_FIFO fifo_ptr, PVOID pdata);
OS_STATUS os_fifo_peek(POS_FIFO fifo_ptr, PVOID pdata);
OS_STATUS os_fifo_pop(POS_FIFO fifo_ptr);
OS_STATUS os_fifo_count(POS_FIFO fifo_ptr, PSINT32 pcount, PSINT32 pmaxcount);
OS_STATUS os_fifo_stats(POS_FIFO fifo_ptr, POS_FIFO_STATS pstats);
OS_STATUS os_fifo_reset_stats(POS_FIFO fifo_ptr);
#ifdef __cplusplus 
}
#endif 

#endif // #ifndef __OS_FIFO_H__
