#include "srec.h"

SREC_TYPES_s const CSREC::SREC_types[]  =
{
  { 0, 2, true },
  { 1, 2, true },
  { 2, 3, true },
  { 3, 4, true },
  { 5, 2, true },
  { 7, 4, true },
  { 8, 3, true },
  { 9, 2, true }
};

int CSREC::GetAddressBytes(int record_type)
{
  for (int i = 0; i < sizeof(SREC_types) / sizeof(SREC_types[0]); i++)
  {
    if (record_type == SREC_types[i].record_type)
    {
      return SREC_types[i].address_bytes;
    }
  }

  return 0;
}

unsigned int CSREC::axtoui(char *pc, size_t len)
{
  unsigned int ui;

  for (ui = 0; len > 0; len--, pc++)
  {
    ui <<= 4;
    if (*pc >= '0' && *pc <= '9')
    {
      ui += (*pc - '0');
    }
    else if (*pc >= 'A' && *pc <= 'F')
    {
      ui += ((*pc - 'A') + 10);
    }
    else if (*pc >= 'a' && *pc <= 'f')
    {
      ui += ((*pc - 'a') + 10);
    }
    else
    {
      ui = 0;
      break;
    }
  }

  return ui;
}

bool CSREC::parse(char *sSREC, int sSREC_len, int *psrec_type)
{
  unsigned char running_check_sum;
  int offset;
  int i;

  if (sSREC_len < 4)
  {
    return false;
  }

  // Start code, one character, an S.
  if (sSREC[0] != 'S')
  {
    return false;
  }

  // Record type, one digit, 0 to 9, defining the type of the data field.
  *psrec_type = record_type = axtoui(&sSREC[1], 1);

  // Byte count, two hex digits, indicating the number of bytes (hex digit
  //  pairs) that follow in the rest of the record (in the address, data and
  //  checksum fields).
  byte_count = axtoui(&sSREC[2], 2);
  running_check_sum = byte_count;

  // Address, four, six, or eight hex digits as determined by the record type
  //  for the memory location of the first data byte.
  unsigned short address_bytes = GetAddressBytes(record_type);
  if (address_bytes == 0)
  {
    return false;
  }

  if (byte_count < (address_bytes + 1))
  {
    return false;
  }

  address = axtoui(&sSREC[4], (address_bytes * 2));
  for (i = 0; i < address_bytes; i++)
  {
    running_check_sum += axtoui(&sSREC[4 + (i * 2)], 2);
  }

  // Data, a sequence of 2n hex digits, for n bytes of the data.
  data_len = byte_count - (address_bytes + 1);
  offset = 4 + (address_bytes * 2);
  for (i = 0; i < data_len; i++)
  {
    data[i] = axtoui(&sSREC[offset + (i * 2)], 2);
    running_check_sum += data[i];
  }

  // Checksum, two hex digits - the least significant byte of ones'
  //  complement of the sum of the values represented by the two hex digit
  //  pairs for the byte count, address and data fields.
  check_sum = axtoui(&sSREC[offset + (data_len * 2)], 2);

  running_check_sum = ~running_check_sum;
  if ((check_sum & 0xff) != (running_check_sum & 0xff))
  {
    return false;
  }

  return true;
}
