#ifndef __SREC_h__

#define ALIGN16(len)    (((len) + 1) & ~1)

typedef struct
{
  unsigned short record_type;
  unsigned short address_bytes;
  bool data_sequence;
} SREC_TYPES_s;

class CSREC
{
public:
  bool parse(char *sSREC);

  static const int MAX_SREC_BYTE_COUNT = 256;

  int record_type;
  int byte_count;
  unsigned long address;
  unsigned char data[MAX_SREC_BYTE_COUNT];
  int check_sum;

  int data_len;

  unsigned int axtoui(char *pc, size_t len);
  int GetAddressBytes(int record_type);
  bool parse(char *sSREC, int sSREC_len, int *psrec_type);

protected:
  static const SREC_TYPES_s SREC_types[];
};

#endif // #ifndef __SREC_h__