#ifndef  __PRINTF_UART_H
#define  __PRINTF_UART_H

#include <stdio.h>
#include <file.h>




typedef struct Uart_Type{
	union
	  {
	    Uint16 All;
	    struct{
	            Uint16  UartSendEableFlag     :1;  // ϴʹ
	            Uint16  UartRevFlag           :1;  //CAN  յݱ־

				Uint16  SendHallFlag          :1;  // ʹܷHALL

				Uint16  pfMathFlag            :1;  //ӡMathϢ
 
	          }Status_Bits;
	  }Mark_Para; 
	
	char *sendPtr;
}
Uart_Msg; 

extern Uart_Msg UartDBG;

//--------------------------------------------------------------------
void SCI_Init(void);
void scia_xmit(int a);
void open_uart_debug (void);
int printf(const char* str, ...); 


//---------------------------------------------------------------------
int my_open(const char *path, unsigned flags, int fno);
int my_close(int fno);
int my_read(int fno, char *buffer, unsigned count);
int my_write(int fno, const char *buffer, unsigned count);
off_t my_lseek(int fno, off_t offset, int origin);
int my_unlink(const char *path);
int my_rename(const char *old_name, const char *new_name);


#endif//  __PRINTF_UART_H


