
#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File
#include "include_head_all.h"

extern struct IQ_Para IQ;

Timer_Para Timer={0,0,0};

void Timer0_Init(void);
interrupt void cpu_timer0_isr(void);



void Timer0_Init(void)
{
   EALLOW;  // This is needed to write to EALLOW protected registers
   PieVectTable.TINT0 = &cpu_timer0_isr;
   EDIS;    // This is needed to disable write to EALLOW protected registers

    // CPU Timer 0
	// Initialize address pointers to respective timer registers:
	CpuTimer0.RegsAddr = &CpuTimer0Regs;
	// Initialize timer period to maximum:
	CpuTimer0Regs.PRD.all  = 0xFFFFFFFF;
	// Initialize pre-scale counter to divide by 1 (SYSCLKOUT):
	CpuTimer0Regs.TPR.all  = 0;
	CpuTimer0Regs.TPRH.all = 0;
	// Make sure timer is stopped:
	CpuTimer0Regs.TCR.bit.TSS = 1;
	// Reload all counter register with period value:
	CpuTimer0Regs.TCR.bit.TRB = 1;
	// Reset interrupt counters:
	CpuTimer0.InterruptCount = 0;

    ConfigCpuTimer(&CpuTimer0, 60, 1000);
    CpuTimer0Regs.TCR.all = 0x4001; // Use write-only instruction to set TSS bit = 0
	IER |= M_INT1;// Enable CPU int1 which is connected to CPU-Timer 0
// Enable TINT0 in the PIE: Group 1 interrupt 7
   PieCtrlRegs.PIEIER1.bit.INTx7 = 1;

}

		  
interrupt void cpu_timer0_isr(void)
{

	EALLOW;  
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;   // Acknowledge interrupt to PIE	
	EDIS;
	
	if(Timer.Count_1ms<10000)
		Timer.Count_1ms++;
	

//	   led ܵʱ----------------------------------------------------
//		for(i=0;i<LED_SEG_NUN;i++)
//		{
//			ShowArray[i].tick++;
//			ShowArray[i].segTick++;	   
//		}

//      Ҫʱ---------------------------------------------------
//		for(i = 0; i< TASK_NUM;i++)
//		{
//			task[i].taskTick++;
//		}
//		
//-------------------------------------------------------------	   

}


