

/***************************************************
 PID Function
 The PID(֡΢)function is used in mainly 
 control applications.

 Author:
 Time  :2011.11.27
 **************************************************/
 struct PID
 {
 	int SetPoint;     //趨ĿDesired Value
	long SumError;      //ۼ
	double Proportion;  //
	double Integral;    //ֳ
	double Derivative;  //΢ֳ
	int LastError;    //Error[-1]
	int PrevError;    //Error[-2]
 };


 struct PID sPID;         //PID͵ısPID
 struct PID *sptr=&sPID;  //ָsptrָsPID

 /**************************************************
 Initialize PID Structure   PIDʼ
 **************************************************/
 void InitPID(void)
 {
 	sPID.SumError=0;
	sPID.LastError=0;   //Error[-1]
	sPID.PrevError=0;   //Error[-2]
	sPID.Proportion=0;  //
	sPID.Integral=0;    //ֳ
	sPID.Derivative=0;  //΢ֳ
	sPID.SetPoint=0;
 }


 /*************************************************
  ʽPID
  ************************************************/
 int PIDCalc(int NextPoint)
 {
 	register int iError,PID_end;       //ǰ
	iError=sPID.SetPoint-NextPoint;   //
	PID_end=sPID.Proportion * iError - sPID.Integral*sPID.LastError+sPID.Derivative*sPID.PrevError;
	                                   //E[k]E[k-1]E[k-2]
	sPID.PrevError=sPID.LastError;
	sPID.LastError=iError;            //洢´μ

	return(PID_end);                   //ֵ
 }



