// TI File $Revision: /main/3 $
// Checkin $Date: April 21, 2008   16:03:30 $
//###########################################################################
//
// FILE:    Example_2823xGpioSetup.c
//
// TITLE:   DSP2823x Device GPIO Setup
//
// ASSUMPTIONS:
//
//    This program requires the DSP2823x header files.
//
//    Two different examples are included. Select the example
//    to execute before compiling using the #define statements
//    found at the top of the code.
//
//    As supplied, this project is configured for "boot to SARAM"
//    operation.  The 2823x Boot Mode table is shown below.
//    For information on configuring the boot mode of an eZdsp,
//    please refer to the documentation included with the eZdsp,
//
//       $Boot_Table:
//
//         GPIO87   GPIO86     GPIO85   GPIO84
//          XA15     XA14       XA13     XA12
//           PU       PU         PU       PU
//        ==========================================
//            1        1          1        1    Jump to Flash
//            1        1          1        0    SCI-A boot
//            1        1          0        1    SPI-A boot
//            1        1          0        0    I2C-A boot
//            1        0          1        1    eCAN-A boot
//            1        0          1        0    McBSP-A boot
//            1        0          0        1    Jump to XINTF x16
//            1        0          0        0    Jump to XINTF x32
//            0        1          1        1    Jump to OTP
//            0        1          1        0    Parallel GPIO I/O boot
//            0        1          0        1    Parallel XINTF boot
//            0        1          0        0    Jump to SARAM	    <- "boot to SARAM"
//            0        0          1        1    Branch to check boot mode
//            0        0          1        0    Boot to flash, bypass ADC cal
//            0        0          0        1    Boot to SARAM, bypass ADC cal
//            0        0          0        0    Boot to SCI-A, bypass ADC cal
//                                              Boot_Table_End$
//
// DESCRIPTION:
//
//
//    Configures the 2823x GPIO into two different configurations
//    This code is verbose to illustrate how the GPIO could be setup.
//    In a real application, lines of code can be combined for improved
//    code size and efficency.
//
//    This example only sets-up the GPIO.. nothing is actually done with
//    the pins after setup.
//
//    In general:
//
//       All pullup resistors are enabled.  For ePWMs this may not be desired.
//       Input qual for communication ports (eCAN, SPI, SCI, I2C) is asynchronous
//       Input qual for Trip pins (TZ) is asynchronous
//       Input qual for eCAP and eQEP signals is synch to SYSCLKOUT
//       Input qual for some I/O's and interrupts may have a sampling window
//
//
//###########################################################################
// $TI Release: DSP2833x/DSP2823x C/C++ Header Files V1.31 $
// $Release Date: August 4, 2009 $
//###########################################################################

#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File

// Select the example to compile in.  Only one example should be set as 1
// the rest should be set as 0.

#define EXAMPLE1 1  // Basic pinout configuration example
#define EXAMPLE2 0  // Communication pinout example

//--------------------------------------------------
#define  csaddr  *(unsigned int *)0x04000
#define  ledaddr  *(unsigned int *)0x04001
//#define   mydate  *(unsigned int *)0x0400
//-----------------------------------------------

int   aa=0;
int   bb=0;
Uint16 LoopCount = 0;

// Prototype statements for functions found within this file.
void Gpio_setup1(void);
void Gpio_setup2(void);


void main(void)
{

// Step 1. Initialize System Control:
// PLL, WatchDog, enable Peripheral Clocks
// This example function is found in the DSP2833x_SysCtrl.c file.
   InitSysCtrl();

// Step 2. Initalize GPIO:
// This example function is found in the DSP2833x_Gpio.c file and
// illustrates how to set the GPIO to it's default state.
   // InitGpio(); Skipped for this example

// Step 3. Clear all interrupts and initialize PIE vector table:
// Disable CPU interrupts
   DINT;

// Initialize PIE control registers to their default state.
// The default state is all PIE interrupts disabled and flags
// are cleared.
// This function is found in the DSP2833x_PieCtrl.c file.
   InitPieCtrl();

// Disable CPU interrupts and clear all CPU interrupt flags:
   IER = 0x0000;
   IFR = 0x0000;

// Initialize the PIE vector table with pointers to the shell Interrupt
// Service Routines (ISR).
// This will populate the entire table, even if the interrupt
// is not used in this example.  This is useful for debug purposes.
// The shell ISR routines are found in DSP2833x_DefaultIsr.c.
// This function is found in DSP2833x_PieVect.c.
   InitPieVectTable();


// Step 4. Initialize all the Device Peripherals:
// This function is found in DSP2833x_InitPeripherals.c
// InitPeripherals(); // Not required for this example

// Step 5. User specific code:

//#if EXAMPLE1

//     This example is a basic pinout
//    Gpio_setup1();

//#endif  // - EXAMPLE1

//#if EXAMPLE2

    // This example is a communications pinout
//    Gpio_setup2();

//#endif

//--------------------------------------------------
	
	
	
	InitXintf();

//	asm mov 4000H,#0ff00H


//   	mydate=0x0aa11;
    csaddr=0xff00 ;
	DELAY_US(0.5L)  ;
	DSP28x_usDelay(1000);
	 ledaddr=0x00ff;
	
	
	//DSP output given
//	GpioDataRegs.GPADAT.bit.GPIO0 = 0;    //   GPIO0
//	GpioDataRegs.GPADAT.bit.GPIO1 = 0;    //   GPIO1
//	GpioDataRegs.GPADAT.bit.GPIO2 = 0;    //   GPIO2
//	GpioDataRegs.GPADAT.bit.GPIO3 = 0;    //   GPIO3
//	GpioDataRegs.GPADAT.bit.GPIO4 = 0;    //   GPIO4
//	GpioDataRegs.GPADAT.bit.GPIO5 = 0;    //   GPIO5
//	GpioDataRegs.GPADAT.bit.GPIO6 = 0;    //   GPIO6= PWM-BRK
//	GpioDataRegs.GPADAT.bit.GPIO8 = 1;    //   GPIO8= EPWM5A
//	GpioDataRegs.GPADAT.bit.GPIO9 = 1;    //   GPIO9= EPWM5B
//	GpioDataRegs.GPADAT.bit.GPIO10 = 0;    //   GPIO6= PWM-OFF
//	GpioDataRegs.GPADAT.bit.GPIO11 = 0;    //   GPIO6= PAN-ON
//	GpioDataRegs.GPADAT.bit.GPIO12 = 0;    //   GPIO6= SOFT-ON
//	GpioDataRegs.GPADAT.bit.GPIO15 = 1;    //   GPIO6= U
//	GpioDataRegs.GPADAT.bit.GPIO16 = 1;    //   GPIO6= V
//	GpioDataRegs.GPADAT.bit.GPIO17 = 1;    //   GPIO6= W
//	GpioDataRegs.GPADAT.bit.GPIO18 = 0;    //   GPIO6= CANRXD
//	GpioDataRegs.GPADAT.bit.GPIO19 = 0;    //   GPIO6= CANTXD
//    GpioDataRegs.GPADAT.bit.GPIO28 = 0;    //   GPIO6= SCIRXDB
//	GpioDataRegs.GPADAT.bit.GPIO29 = 0;    //   GPIO6= SCITXDB
//	GpioDataRegs.GPADAT.bit.GPIO30 = 0;    //   GPIO6= O1 
//	GpioDataRegs.GPADAT.bit.GPIO31 = 0;    //   GPIO6= O2 SCL
//    GpioDataRegs.GPBDAT.bit.GPIO32 = 0;    //   SDA
//    GpioDataRegs.GPBDAT.bit.GPIO33 = 0;    //   SCL

//	GpioDataRegs.GPBDAT.bit.GPIO36 = 0;    //   XCS
//	GpioDataRegs.GPBDAT.bit.GPIO36 = 1;  
//   	GpioDataRegs.GPBDAT.bit.GPIO38 = 0;    //   XCS

//    GpioDataRegs.GPBDAT.bit.GPIO39 = 0;    //   O3
//    GpioDataRegs.GPBSET.bit.GPIO48=1;      //ENCA
//    GpioDataRegs.GPBSET.bit.GPIO49=1;      //ENCB
//    GpioDataRegs.GPBSET.bit.GPIO50=1;      //ENCA
//    GpioDataRegs.GPBSET.bit.GPIO51=1;      //ENCA
//    GpioDataRegs.GPBSET.bit.GPIO53=1;      //ENCZ
//    GpioDataRegs.GPBSET.bit.GPIO61=0;      // Chalf_A
//	GpioDataRegs.GPBSET.bit.GPIO62=0;      //SCIRXDA
//    GpioDataRegs.GPCSET.bit.GPIO87=0;      //O4 problem

//	GpioDataRegs.GPCSET.bit.GPIO71=0;
//		GpioDataRegs.GPCSET.bit.GPIO70=1;
//	GpioDataRegs.GPCSET.bit.GPIO71=1;
//    if(GpioDataRegs.GPBDAT.bit.GPIO34 == 1) 
//	{
//	    aa=1;
//	}



 //-----------------------------------------------------------------------------	



	
	
	for(;;) 
	{
		LoopCount++;

//		GpioDataRegs.GPADAT.bit.GPIO8=1    ;    //GPIO8=EPWM5A ,AOUT0.0.5ms
	    DELAY_US(0.5L)            ;
//	    GpioDataRegs.GPADAT.bit.GPIO8=0    ;
     	DELAY_US(0.5L)            ;
//		GpioDataRegs.GPADAT.bit.GPIO9=1    ;    //GPIO9=EPWM5B,AOUT1,0.5ms
	    DELAY_US(0.5L)            ;
//	    GpioDataRegs.GPADAT.bit.GPIO9=0    ;
     	DELAY_US(0.5L)            ;
   

	}

   //ESTOP0;  // This is a software breakpoint

//--------------------------------------------------



}


void Gpio_setup1(void)
{
   // Example 1:
   // Basic Pinout.
   // This basic pinout includes:
   // PWM1-3, ECAP1, ECAP2, TZ1-TZ4, SPI-A, EQEP1, SCI-A, I2C
   // and a number of I/O pins

   // These can be combined into single statements for improved
   // code efficiency.

   // Enable PWM1-3 on GPIO0-GPIO5
   EALLOW;
   GpioCtrlRegs.GPAPUD.bit.GPIO0 = 0;   // Enable pullup on GPIO0
   GpioCtrlRegs.GPAPUD.bit.GPIO1 = 0;   // Enable pullup on GPIO1
   GpioCtrlRegs.GPAPUD.bit.GPIO2 = 0;   // Enable pullup on GPIO2
   GpioCtrlRegs.GPAPUD.bit.GPIO3 = 0;   // Enable pullup on GPIO3
   GpioCtrlRegs.GPAPUD.bit.GPIO4 = 0;   // Enable pullup on GPIO4
   GpioCtrlRegs.GPAPUD.bit.GPIO5 = 0;   // Enable pullup on GPIO5
   GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 1;  // GPIO0 = PWM1A
   GpioCtrlRegs.GPAMUX1.bit.GPIO1 = 1;  // GPIO1 = PWM1B
   GpioCtrlRegs.GPAMUX1.bit.GPIO2 = 1;  // GPIO2 = PWM2A
   GpioCtrlRegs.GPAMUX1.bit.GPIO3 = 1;  // GPIO3 = PWM2B
   GpioCtrlRegs.GPAMUX1.bit.GPIO4 = 1;  // GPIO4 = PWM3A
   GpioCtrlRegs.GPAMUX1.bit.GPIO5 = 1;  // GPIO5 = PWM3B

   // Enable an GPIO output on GPIO6, set it high
   GpioCtrlRegs.GPAPUD.bit.GPIO6 = 0;   // Enable pullup on GPIO6
   GpioDataRegs.GPASET.bit.GPIO6 = 1;   // Load output latch
   GpioCtrlRegs.GPAMUX1.bit.GPIO6 = 0;  // GPIO6 = GPIO6
   GpioCtrlRegs.GPADIR.bit.GPIO6 = 1;   // GPIO6 = output

   // Enable eCAP1 on GPIO7
   GpioCtrlRegs.GPAPUD.bit.GPIO7 = 0;   // Enable pullup on GPIO7
   GpioCtrlRegs.GPAQSEL1.bit.GPIO7 = 0; // Synch to SYSCLOUT
   GpioCtrlRegs.GPAMUX1.bit.GPIO7 = 3;  // GPIO7 = ECAP2

   // Enable GPIO outputs on GPIO8 - GPIO11, set it high
   GpioCtrlRegs.GPAPUD.bit.GPIO8 = 0;   // Enable pullup on GPIO8
//   GpioDataRegs.GPASET.bit.GPIO8 = 1;   // Load output latch
   GpioCtrlRegs.GPAMUX1.bit.GPIO8 = 0;  // GPIO8 = GPIO8
   GpioCtrlRegs.GPADIR.bit.GPIO8 = 1;   // GPIO8 = output

   GpioCtrlRegs.GPAPUD.bit.GPIO9 = 0;   // Enable pullup on GPIO9
//   GpioDataRegs.GPASET.bit.GPIO9 = 1;   // Load output latch
   GpioCtrlRegs.GPAMUX1.bit.GPIO9 = 0;  // GPIO9 = GPIO9
   GpioCtrlRegs.GPADIR.bit.GPIO9 = 1;   // GPIO9 = output

   GpioCtrlRegs.GPAPUD.bit.GPIO10 = 0;  // Enable pullup on GPIO10
   GpioDataRegs.GPASET.bit.GPIO10 = 1;  // Load output latch
   GpioCtrlRegs.GPAMUX1.bit.GPIO10 = 0; // GPIO10 = GPIO10
   GpioCtrlRegs.GPADIR.bit.GPIO6 = 1;   // GPIO10 = output

   GpioCtrlRegs.GPAPUD.bit.GPIO11 = 0;  // Enable pullup on GPIO11
   GpioCtrlRegs.GPAMUX1.bit.GPIO11 = 0; // GPIO11 = GPIO11
   GpioCtrlRegs.GPADIR.bit.GPIO11 = 1;  // GPIO11 = output

   // Enable Trip Zone inputs on GPIO12 - GPIO15
   GpioCtrlRegs.GPAPUD.bit.GPIO12 = 0;   // Enable pullup on GPIO12
   GpioCtrlRegs.GPAPUD.bit.GPIO13 = 0;   // Enable pullup on GPIO13
   GpioCtrlRegs.GPAPUD.bit.GPIO14 = 0;   // Enable pullup on GPIO14
   GpioCtrlRegs.GPAPUD.bit.GPIO15 = 0;   // Enable pullup on GPIO15
   GpioCtrlRegs.GPAQSEL1.bit.GPIO12 = 3; // asynch input
   GpioCtrlRegs.GPAQSEL1.bit.GPIO13 = 3; // asynch input
   GpioCtrlRegs.GPAQSEL1.bit.GPIO14 = 3; // asynch input
   GpioCtrlRegs.GPAQSEL1.bit.GPIO15 = 3; // asynch input
   GpioCtrlRegs.GPAMUX1.bit.GPIO12 = 1;  // GPIO12 = TZ1
   GpioCtrlRegs.GPAMUX1.bit.GPIO13 = 1;  // GPIO13 = TZ2
   GpioCtrlRegs.GPAMUX1.bit.GPIO14 = 1;  // GPIO14 = TZ3
   GpioCtrlRegs.GPAMUX1.bit.GPIO15 = 1;  // GPIO15 = TZ4

   // Enable SPI-A on GPIO16 - GPIO19
   GpioCtrlRegs.GPAPUD.bit.GPIO16 = 0;   // Enable pullup on GPIO16
   GpioCtrlRegs.GPAPUD.bit.GPIO17 = 0;   // Enable pullup on GPIO17
   GpioCtrlRegs.GPAPUD.bit.GPIO18 = 0;   // Enable pullup on GPIO18
   GpioCtrlRegs.GPAPUD.bit.GPIO19 = 0;   // Enable pullup on GPIO19
   GpioCtrlRegs.GPAQSEL2.bit.GPIO16 = 0; // asynch input
   GpioCtrlRegs.GPAQSEL2.bit.GPIO17 = 0; // asynch input
   GpioCtrlRegs.GPAQSEL2.bit.GPIO18 = 0; // asynch input
   GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = 0; // asynch input
   GpioCtrlRegs.GPAMUX2.bit.GPIO16 = 0;  // GPIO16 = SPICLKA
   GpioCtrlRegs.GPAMUX2.bit.GPIO17 = 0 ;  // GPIO17 = SPIS0MIA
   GpioCtrlRegs.GPAMUX2.bit.GPIO18 = 1;  // GPIO18 = SPICLKA
   GpioCtrlRegs.GPAMUX2.bit.GPIO19 = 1;  // GPIO19 = SPISTEA
   GpioCtrlRegs.GPADIR.bit.GPIO16 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO17 = 0;
   // Enable EQEP1 on GPIO20 - GPIO23
   GpioCtrlRegs.GPAPUD.bit.GPIO20 = 0;   // Enable pullup on GPIO20
   GpioCtrlRegs.GPAPUD.bit.GPIO21 = 0;   // Enable pullup on GPIO21
   GpioCtrlRegs.GPAPUD.bit.GPIO22 = 0;   // Enable pullup on GPIO22
   GpioCtrlRegs.GPAPUD.bit.GPIO23 = 0;   // Enable pullup on GPIO23
   GpioCtrlRegs.GPAQSEL2.bit.GPIO20 = 0; // Synch to SYSCLKOUT
   GpioCtrlRegs.GPAQSEL2.bit.GPIO21 = 0; // Synch to SYSCLKOUT
   GpioCtrlRegs.GPAQSEL2.bit.GPIO22 = 0; // Synch to SYSCLKOUT
   GpioCtrlRegs.GPAQSEL2.bit.GPIO23 = 0; // Synch to SYSCLKOUT
   GpioCtrlRegs.GPAMUX2.bit.GPIO20 = 1;  // GPIO20 = EQEP1A
   GpioCtrlRegs.GPAMUX2.bit.GPIO21 = 1;  // GPIO21 = EQEP1B
   GpioCtrlRegs.GPAMUX2.bit.GPIO22 = 1;  // GPIO22 = EQEP1S
   GpioCtrlRegs.GPAMUX2.bit.GPIO23 = 1;  // GPIO23 = EQEP1I

   // Enable eCAP1 on GPIO24
   GpioCtrlRegs.GPAPUD.bit.GPIO24 = 0;   // Enable pullup on GPIO24
   GpioCtrlRegs.GPAQSEL2.bit.GPIO24 = 0; // Synch to SYSCLKOUT
   GpioCtrlRegs.GPAMUX2.bit.GPIO24 = 1;  // GPIO24 = ECAP1

   // Set input qualifcation period for GPIO25 & GPIO26
   GpioCtrlRegs.GPACTRL.bit.QUALPRD3=1;  // Qual period = SYSCLKOUT/2
   GpioCtrlRegs.GPAQSEL2.bit.GPIO25=2;   // 6 samples
   GpioCtrlRegs.GPAQSEL2.bit.GPIO26=2;   // 6 samples

   // Make GPIO25 the input source for Xint1
   GpioCtrlRegs.GPAMUX2.bit.GPIO25 = 0;  // GPIO25 = GPIO25
   GpioCtrlRegs.GPADIR.bit.GPIO25 = 0;   // GPIO25 = input
   GpioIntRegs.GPIOXINT1SEL.all = 25;    // Xint1 connected to GPIO25

   // Make GPIO26 the input source for XINT2
   GpioCtrlRegs.GPAMUX2.bit.GPIO26 = 0;  // GPIO26 = GPIO26
   GpioCtrlRegs.GPADIR.bit.GPIO26 = 0;   // GPIO26 = input
   GpioIntRegs.GPIOXINT2SEL.all = 26;    // XINT2 connected to GPIO26

   // Make GPIO27 wakeup from HALT/STANDBY Low Power Modes
   GpioCtrlRegs.GPAMUX2.bit.GPIO27 = 0; // GPIO27 = GPIO27
   GpioCtrlRegs.GPADIR.bit.GPIO27 = 0;  // GPIO27 = input
   GpioIntRegs.GPIOLPMSEL.bit.GPIO27=1; // GPIO27 will wake the device
   SysCtrlRegs.LPMCR0.bit.QUALSTDBY=2;  // Qualify GPIO27 by 2 OSCCLK
                                        // cycles before waking the device
                                        // from STANDBY

   // Enable SCI-A on GPIO28 - GPIO29
   GpioCtrlRegs.GPAPUD.bit.GPIO28 = 0;   // Enable pullup on GPIO28
   GpioCtrlRegs.GPAQSEL2.bit.GPIO28 = 3; // Asynch input
   GpioCtrlRegs.GPAMUX2.bit.GPIO28 = 1;  // GPIO28 = SCIRXDA
   GpioCtrlRegs.GPAPUD.bit.GPIO29 = 0;   // Enable pullup on GPIO29
   GpioCtrlRegs.GPAMUX2.bit.GPIO29 = 1;  // GPIO29 = SCITXDA

   // Enable CAN-A on GPIO30 - GPIO31
   GpioCtrlRegs.GPAPUD.bit.GPIO30 = 0;   // Enable pullup on GPIO30
   GpioCtrlRegs.GPAMUX2.bit.GPIO30 = 1;  // GPIO30 = CANTXA
   GpioCtrlRegs.GPAPUD.bit.GPIO31 = 0;   // Enable pullup on GPIO31
   GpioCtrlRegs.GPAQSEL2.bit.GPIO31 = 3; // Asynch input
   GpioCtrlRegs.GPAMUX2.bit.GPIO31 = 1;  // GPIO31 = CANRXA


   // Enable I2C-A on GPIO32 - GPIO33
   GpioCtrlRegs.GPBPUD.bit.GPIO32 = 0;   // Enable pullup on GPIO32
   GpioCtrlRegs.GPBMUX1.bit.GPIO32 = 1;  // GPIO32 = SDAA
   GpioCtrlRegs.GPBQSEL1.bit.GPIO33 = 3; // Asynch input
   GpioCtrlRegs.GPBPUD.bit.GPIO33 = 0;   // Enable pullup on GPIO33
   GpioCtrlRegs.GPBQSEL1.bit.GPIO33 = 3; // Asynch input
   GpioCtrlRegs.GPBMUX1.bit.GPIO33 = 1;  // GPIO33 = SCLA

   // Make GPIO34 an input
   GpioCtrlRegs.GPBPUD.bit.GPIO34 = 0;  // Enable pullup on GPIO34
   GpioCtrlRegs.GPBMUX1.bit.GPIO34 = 0; // GPIO34 = GPIO34
   GpioCtrlRegs.GPBDIR.bit.GPIO34 = 0;  // GPIO34 = input

   //--------------------------------------------
   GpioCtrlRegs.GPAPUD.bit.GPIO0 = 0;
   GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO0= 1;
   
   GpioCtrlRegs.GPAPUD.bit.GPIO1 = 0;
   GpioCtrlRegs.GPAMUX1.bit.GPIO1 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO1= 1;
   
   GpioCtrlRegs.GPAPUD.bit.GPIO2 = 0;
   GpioCtrlRegs.GPAMUX1.bit.GPIO2 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO2= 1;

   GpioCtrlRegs.GPAPUD.bit.GPIO3 = 0;
   GpioCtrlRegs.GPAMUX1.bit.GPIO3 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO3= 1;

   GpioCtrlRegs.GPAPUD.bit.GPIO4 = 0;
   GpioCtrlRegs.GPAMUX1.bit.GPIO4 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO4= 1;

   GpioCtrlRegs.GPAPUD.bit.GPIO5 = 0;
   GpioCtrlRegs.GPAMUX1.bit.GPIO5 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO5= 1;

   GpioCtrlRegs.GPAPUD.bit.GPIO6 = 0;
   GpioCtrlRegs.GPAMUX1.bit.GPIO6 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO6= 1;


   GpioCtrlRegs.GPAPUD.bit.GPIO8= 0;
   GpioCtrlRegs.GPAMUX1.bit.GPIO8= 0;
   GpioCtrlRegs.GPADIR.bit.GPIO8= 1;

   GpioCtrlRegs.GPAPUD.bit.GPIO9 = 0;
   GpioCtrlRegs.GPAMUX1.bit.GPIO9 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO9= 1;

   GpioCtrlRegs.GPAPUD.bit.GPIO10 = 0;
   GpioCtrlRegs.GPAMUX1.bit.GPIO10 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO10= 1;

   GpioCtrlRegs.GPAPUD.bit.GPIO11 = 0;
   GpioCtrlRegs.GPAMUX1.bit.GPIO11 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO11= 1;

   GpioCtrlRegs.GPAPUD.bit.GPIO12= 0;
   GpioCtrlRegs.GPAMUX1.bit.GPIO12 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO12= 1;
   
   GpioCtrlRegs.GPAPUD.bit.GPIO13= 0;//  ERR-IPM
   GpioCtrlRegs.GPAMUX1.bit.GPIO13 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO13= 0;
   
   GpioCtrlRegs.GPAPUD.bit.GPIO14= 0;// ERR-OC 
   GpioCtrlRegs.GPAMUX1.bit.GPIO14 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO14= 0;

   GpioCtrlRegs.GPAPUD.bit.GPIO15= 0;//  U
   GpioCtrlRegs.GPAMUX1.bit.GPIO15 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO15= 0;


   GpioCtrlRegs.GPAPUD.bit.GPIO16= 0;//  V
   GpioCtrlRegs.GPAMUX2.bit.GPIO16 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO16= 0;

   GpioCtrlRegs.GPAPUD.bit.GPIO17= 0;//  W
   GpioCtrlRegs.GPAMUX2.bit.GPIO17 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO17= 0;

   GpioCtrlRegs.GPAPUD.bit.GPIO18= 0;//  CANRXD
   GpioCtrlRegs.GPAMUX2.bit.GPIO18 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO18= 0;

   GpioCtrlRegs.GPAPUD.bit.GPIO19= 0;//  CANTXD
   GpioCtrlRegs.GPAMUX2.bit.GPIO19 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO19= 1;

   GpioCtrlRegs.GPAPUD.bit.GPIO28= 0;//  SCIRXDB
   GpioCtrlRegs.GPAMUX2.bit.GPIO28 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO28= 0;
   
   GpioCtrlRegs.GPAPUD.bit.GPIO29= 0;//  SCITXDB
   GpioCtrlRegs.GPAMUX2.bit.GPIO29 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO29= 1;

   GpioCtrlRegs.GPAPUD.bit.GPIO30= 0;//  O1
   GpioCtrlRegs.GPAMUX2.bit.GPIO30 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO30= 1;

   GpioCtrlRegs.GPAPUD.bit.GPIO31= 0;//  O2
   GpioCtrlRegs.GPAMUX2.bit.GPIO31 = 0;
   GpioCtrlRegs.GPADIR.bit.GPIO31= 1;

   GpioCtrlRegs.GPBPUD.bit.GPIO32= 0;//  SDA
   GpioCtrlRegs.GPBMUX1.bit.GPIO32 = 0;
   GpioCtrlRegs.GPBDIR.bit.GPIO32= 1;

   GpioCtrlRegs.GPBPUD.bit.GPIO33= 0;//  SCL
   GpioCtrlRegs.GPBMUX1.bit.GPIO33 = 0;
   GpioCtrlRegs.GPBDIR.bit.GPIO33= 1;

   GpioCtrlRegs.GPBPUD.bit.GPIO34= 0;//  XREADY
   GpioCtrlRegs.GPBMUX1.bit.GPIO34 = 0;
   GpioCtrlRegs.GPBDIR.bit.GPIO34= 0;
  
   GpioCtrlRegs.GPBPUD.bit.GPIO35= 0;//  XA12
   GpioCtrlRegs.GPBMUX1.bit.GPIO35 = 0;
   GpioCtrlRegs.GPBDIR.bit.GPIO35= 0;
   
   GpioCtrlRegs.GPBPUD.bit.GPIO36= 0;//  XCS
   GpioCtrlRegs.GPBMUX1.bit.GPIO36 = 0;
   GpioCtrlRegs.GPBDIR.bit.GPIO36= 1;

   GpioCtrlRegs.GPBPUD.bit.GPIO37= 0;//  DIN1
   GpioCtrlRegs.GPBMUX1.bit.GPIO37 = 0;
   GpioCtrlRegs.GPBDIR.bit.GPIO37= 0;
    
   GpioCtrlRegs.GPBPUD.bit.GPIO38= 0;//  XWE
   GpioCtrlRegs.GPBMUX1.bit.GPIO38 = 0;
   GpioCtrlRegs.GPBDIR.bit.GPIO38= 1;
   
   GpioCtrlRegs.GPBPUD.bit.GPIO39= 0;//  O3
   GpioCtrlRegs.GPBMUX1.bit.GPIO39 = 0;
   GpioCtrlRegs.GPBDIR.bit.GPIO39= 1;

   GpioCtrlRegs.GPBPUD.bit.GPIO48= 0;//  CAP5
   GpioCtrlRegs.GPBMUX2.bit.GPIO48 = 0;
   GpioCtrlRegs.GPBDIR.bit.GPIO48= 0;

   GpioCtrlRegs.GPBPUD.bit.GPIO49= 0;//  CAP6
   GpioCtrlRegs.GPBMUX2.bit.GPIO49 = 0;
   GpioCtrlRegs.GPBDIR.bit.GPIO49= 0;

   GpioCtrlRegs.GPBPUD.bit.GPIO50= 0;//  ENCA
   GpioCtrlRegs.GPBMUX2.bit.GPIO50= 0;
   GpioCtrlRegs.GPBDIR.bit.GPIO50= 0;

   GpioCtrlRegs.GPBPUD.bit.GPIO51= 0;//  ENCB
   GpioCtrlRegs.GPBMUX2.bit.GPIO51 = 0;
   GpioCtrlRegs.GPBDIR.bit.GPIO51= 0;

   GpioCtrlRegs.GPBPUD.bit.GPIO53= 0;//  ENCZ
   GpioCtrlRegs.GPBMUX2.bit.GPIO53 = 0;
   GpioCtrlRegs.GPBDIR.bit.GPIO53= 0;

   GpioCtrlRegs.GPBPUD.bit.GPIO54 = 0;
   GpioCtrlRegs.GPBMUX2.bit.GPIO54 = 0;  //SIGN 
   GpioCtrlRegs.GPBDIR.bit.GPIO54 = 0;

   GpioCtrlRegs.GPBPUD.bit.GPIO55 = 0; 
   GpioCtrlRegs.GPBMUX2.bit.GPIO55 = 0;  //PULSE
   GpioCtrlRegs.GPBDIR.bit.GPIO55 = 0;

   GpioCtrlRegs.GPBPUD.bit.GPIO61 = 0;
   GpioCtrlRegs.GPBMUX2.bit.GPIO61= 0;   //Chalf_A
   GpioCtrlRegs.GPBDIR.bit.GPIO61 = 1;  
   
   GpioCtrlRegs.GPBPUD.bit.GPIO62 = 0;
   GpioCtrlRegs.GPBMUX2.bit.GPIO62= 0;  //SCIRXDA 
   GpioCtrlRegs.GPBDIR.bit.GPIO62= 0;  
   
   GpioCtrlRegs.GPBPUD.bit.GPIO63 = 0;
   GpioCtrlRegs.GPBMUX2.bit.GPIO63= 0;  //SCITXDA 
   GpioCtrlRegs.GPBDIR.bit.GPIO63= 0;  
   
    GpioCtrlRegs.GPCPUD.bit.GPIO70 = 0;
   GpioCtrlRegs.GPCMUX1.bit.GPIO70 = 0;  
   GpioCtrlRegs.GPCDIR.bit.GPIO70 = 1;

   GpioCtrlRegs.GPCPUD.bit.GPIO71 = 0;
   GpioCtrlRegs.GPCMUX1.bit.GPIO71 = 0;  
   GpioCtrlRegs.GPCDIR.bit.GPIO71 = 1;
    

   GpioCtrlRegs.GPCPUD.bit.GPIO80 = 0;
   GpioCtrlRegs.GPCMUX2.bit.GPIO80 = 0;  //DIN2
   GpioCtrlRegs.GPCDIR.bit.GPIO80 = 0;

   GpioCtrlRegs.GPCPUD.bit.GPIO81= 0;
   GpioCtrlRegs.GPCMUX2.bit.GPIO81 = 0;  //DIN3
   GpioCtrlRegs.GPCDIR.bit.GPIO81= 0;

   GpioCtrlRegs.GPCPUD.bit.GPIO82 = 0;
   GpioCtrlRegs.GPCMUX2.bit.GPIO82 = 0;  //DIN4
   GpioCtrlRegs.GPCDIR.bit.GPIO82= 0;
  
   GpioCtrlRegs.GPCPUD.bit.GPIO83 = 0;
   GpioCtrlRegs.GPCMUX2.bit.GPIO83 = 0;  //DIN5
   GpioCtrlRegs.GPCDIR.bit.GPIO83= 0;

   GpioCtrlRegs.GPCPUD.bit.GPIO84 = 0;
   GpioCtrlRegs.GPCMUX2.bit.GPIO84 = 0;  //DIN6
   GpioCtrlRegs.GPCDIR.bit.GPIO84= 0;

   GpioCtrlRegs.GPCPUD.bit.GPIO85 = 0;
   GpioCtrlRegs.GPCMUX2.bit.GPIO85 = 0;  //DIN7
   GpioCtrlRegs.GPCDIR.bit.GPIO85= 0;

   GpioCtrlRegs.GPCPUD.bit.GPIO86 = 0;
   GpioCtrlRegs.GPCMUX2.bit.GPIO86= 0;  //DIN8
   GpioCtrlRegs.GPCDIR.bit.GPIO86= 0;

   GpioCtrlRegs.GPCPUD.bit.GPIO87 = 0;
   GpioCtrlRegs.GPCMUX2.bit.GPIO87 = 0;  //O4
   GpioCtrlRegs.GPCDIR.bit.GPIO87= 1;



   GpioDataRegs.GPASET.bit.GPIO0=1; 
   GpioDataRegs.GPASET.bit.GPIO1=1; 
   GpioDataRegs.GPASET.bit.GPIO2=1; 
   GpioDataRegs.GPASET.bit.GPIO3=1; 
   GpioDataRegs.GPASET.bit.GPIO4=1;
   GpioDataRegs.GPASET.bit.GPIO5=1;
   GpioDataRegs.GPASET.bit.GPIO6=1;
   GpioDataRegs.GPASET.bit.GPIO8=1;
   GpioDataRegs.GPASET.bit.GPIO9=1;
   GpioDataRegs.GPASET.bit.GPIO10=1;
   GpioDataRegs.GPASET.bit.GPIO11=1;
   GpioDataRegs.GPASET.bit.GPIO12=1;
   GpioDataRegs.GPASET.bit.GPIO13=1;
   GpioDataRegs.GPASET.bit.GPIO14=1;
   GpioDataRegs.GPASET.bit.GPIO15=1;
   GpioDataRegs.GPASET.bit.GPIO16=1;
   GpioDataRegs.GPASET.bit.GPIO17=1;
   GpioDataRegs.GPASET.bit.GPIO18=1;
   GpioDataRegs.GPASET.bit.GPIO19=1;
   GpioDataRegs.GPASET.bit.GPIO28=1;
   GpioDataRegs.GPASET.bit.GPIO29=1;
   GpioDataRegs.GPASET.bit.GPIO30=1;
   GpioDataRegs.GPASET.bit.GPIO31=1;
   GpioDataRegs.GPBSET.bit.GPIO32=1;
   GpioDataRegs.GPBSET.bit.GPIO33=1;
   GpioDataRegs.GPBSET.bit.GPIO34=1;
   GpioDataRegs.GPBSET.bit.GPIO35=1;
   GpioDataRegs.GPBSET.bit.GPIO36=1;
   GpioDataRegs.GPBSET.bit.GPIO37=1;
   GpioDataRegs.GPBSET.bit.GPIO38=1;
   GpioDataRegs.GPBSET.bit.GPIO39=1;
   GpioDataRegs.GPBSET.bit.GPIO48=1;
   GpioDataRegs.GPBSET.bit.GPIO49=1;
   GpioDataRegs.GPBSET.bit.GPIO50=1;
   GpioDataRegs.GPBSET.bit.GPIO51=1;
   GpioDataRegs.GPBSET.bit.GPIO53=1;
   GpioDataRegs.GPBSET.bit.GPIO54=1;
   GpioDataRegs.GPBSET.bit.GPIO55=1;
   GpioDataRegs.GPBSET.bit.GPIO61=1;
   GpioDataRegs.GPBSET.bit.GPIO62=1;
   GpioDataRegs.GPBSET.bit.GPIO63=1;
   GpioDataRegs.GPCSET.bit.GPIO80=1;
   GpioDataRegs.GPCSET.bit.GPIO81=1;
   GpioDataRegs.GPCSET.bit.GPIO82=1;
   GpioDataRegs.GPCSET.bit.GPIO83=1;
   GpioDataRegs.GPCSET.bit.GPIO84=1;
   GpioDataRegs.GPCSET.bit.GPIO85=1;
   GpioDataRegs.GPCSET.bit.GPIO86=1;
   GpioDataRegs.GPCSET.bit.GPIO87=0;
   
   GpioDataRegs.GPCSET.bit.GPIO70=0;
	GpioDataRegs.GPCSET.bit.GPIO71=0;


 
   
 

  
  
  //-----------------------------------------------



   EDIS;
}

void Gpio_setup2(void)
{
   // Example 1:
   // Communications Pinout.
   // This basic communications pinout includes:
   // PWM1-3, CAP1, CAP2, SPI-A, SPI-B, CAN-A, SCI-A and I2C
   // and a number of I/O pins

   // Enable PWM1-3 on GPIO0-GPIO5
   EALLOW;
   GpioCtrlRegs.GPAPUD.bit.GPIO0 = 0;   // Enable pullup on GPIO0
   GpioCtrlRegs.GPAPUD.bit.GPIO1 = 0;   // Enable pullup on GPIO1
   GpioCtrlRegs.GPAPUD.bit.GPIO2 = 0;   // Enable pullup on GPIO2
   GpioCtrlRegs.GPAPUD.bit.GPIO3 = 0;   // Enable pullup on GPIO3
   GpioCtrlRegs.GPAPUD.bit.GPIO4 = 0;   // Enable pullup on GPIO4
   GpioCtrlRegs.GPAPUD.bit.GPIO5 = 0;   // Enable pullup on GPIO5
   GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 1;  // GPIO0 = PWM1A
   GpioCtrlRegs.GPAMUX1.bit.GPIO1 = 1;  // GPIO1 = PWM1B
   GpioCtrlRegs.GPAMUX1.bit.GPIO2 = 1;  // GPIO2 = PWM2A
   GpioCtrlRegs.GPAMUX1.bit.GPIO3 = 1;  // GPIO3 = PWM2B
   GpioCtrlRegs.GPAMUX1.bit.GPIO4 = 1;  // GPIO4 = PWM3A
   GpioCtrlRegs.GPAMUX1.bit.GPIO5 = 1;  // GPIO5 = PWM3B

   // Enable an GPIO output on GPIO6
   GpioCtrlRegs.GPAPUD.bit.GPIO6 = 0;   // Enable pullup on GPIO6
   GpioDataRegs.GPASET.bit.GPIO6 = 1;   // Load output latch
   GpioCtrlRegs.GPAMUX1.bit.GPIO6 = 0;  // GPIO6 = GPIO6
   GpioCtrlRegs.GPADIR.bit.GPIO6 = 1;   // GPIO6 = output

   // Enable eCAP1 on GPIO7
   GpioCtrlRegs.GPAPUD.bit.GPIO7 = 0;   // Enable pullup on GPIO7
   GpioCtrlRegs.GPAQSEL1.bit.GPIO7 = 0; // Synch to SYSCLKOUT
   GpioCtrlRegs.GPAMUX1.bit.GPIO7 = 3;  // GPIO7 = ECAP2

   // Enable GPIO outputs on GPIO8 - GPIO11
   GpioCtrlRegs.GPAPUD.bit.GPIO8 = 0;   // Enable pullup on GPIO8
   GpioDataRegs.GPASET.bit.GPIO8 = 1;   // Load output latch
   GpioCtrlRegs.GPAMUX1.bit.GPIO8 = 0;  // GPIO8 = GPIO8
   GpioCtrlRegs.GPADIR.bit.GPIO8 = 1;   // GPIO8 = output

   GpioCtrlRegs.GPAPUD.bit.GPIO9 = 0;   // Enable pullup on GPIO9
   GpioDataRegs.GPASET.bit.GPIO9 = 1;   // Load output latch
   GpioCtrlRegs.GPAMUX1.bit.GPIO9 = 0;  // GPIO9 = GPIO9
   GpioCtrlRegs.GPADIR.bit.GPIO9 = 1;   // GPIO9 = output

   GpioCtrlRegs.GPAPUD.bit.GPIO10 = 0;  // Enable pullup on GPIO10
   GpioDataRegs.GPASET.bit.GPIO10 = 1;  // Load output latch
   GpioCtrlRegs.GPAMUX1.bit.GPIO10 = 0; // GPIO10 = GPIO10
   GpioCtrlRegs.GPADIR.bit.GPIO10 = 1;  // GPIO10 = output

   GpioCtrlRegs.GPAPUD.bit.GPIO11 = 0;  // Enable pullup on GPIO11
   GpioDataRegs.GPASET.bit.GPIO11 = 1;  // Load output latch
   GpioCtrlRegs.GPAMUX1.bit.GPIO11 = 0; // GPIO11 = GPIO11
   GpioCtrlRegs.GPADIR.bit.GPIO11 = 1;  // GPIO11 = output

   // Enable SPI-B on GPIO12 - GPIO15
   GpioCtrlRegs.GPAPUD.bit.GPIO12 = 0;   // Enable pullup on GPIO12 (SPISIMOB)
   GpioCtrlRegs.GPAPUD.bit.GPIO12 = 0;   // Enable pullup on GPIO13 (SPISOMIB)
   GpioCtrlRegs.GPAPUD.bit.GPIO14 = 0;   // Enable pullup on GPIO14 (SPICLKB)
   GpioCtrlRegs.GPAPUD.bit.GPIO15 = 0;   // Enable pullup on GPIO15 (SPISTEB)
   GpioCtrlRegs.GPAQSEL1.bit.GPIO12 = 3; // asynch input
   GpioCtrlRegs.GPAQSEL1.bit.GPIO13 = 3; // asynch input
   GpioCtrlRegs.GPAQSEL1.bit.GPIO14 = 3; // asynch input
   GpioCtrlRegs.GPAQSEL1.bit.GPIO15 = 3; // asynch input
   GpioCtrlRegs.GPAMUX1.bit.GPIO12 = 3;  // GPIO12 = SPISIMOB
   GpioCtrlRegs.GPAMUX1.bit.GPIO13 = 3;  // GPIO13 = SPISOMIB
   GpioCtrlRegs.GPAMUX1.bit.GPIO14 = 3;  // GPIO14 = SPICLKB
   GpioCtrlRegs.GPAMUX1.bit.GPIO15 = 3;  // GPIO15 = SPISTEB

   // Enable SPI-A on GPIO16 - GPIO19
   GpioCtrlRegs.GPAPUD.bit.GPIO16 = 0;   // Enable pullup on GPIO16 (SPICLKA)
   GpioCtrlRegs.GPAPUD.bit.GPIO17 = 0;   // Enable pullup on GPIO17 (SPIS0MIA)
   GpioCtrlRegs.GPAPUD.bit.GPIO18 = 0;   // Enable pullup on GPIO18 (SPICLKA)
   GpioCtrlRegs.GPAPUD.bit.GPIO19 = 0;   // Enable pullup on GPIO19 (SPISTEA)
   GpioCtrlRegs.GPAQSEL2.bit.GPIO16 = 3; // asynch input
   GpioCtrlRegs.GPAQSEL2.bit.GPIO17 = 3; // asynch input
   GpioCtrlRegs.GPAQSEL2.bit.GPIO18 = 3; // asynch input
   GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = 3; // asynch input
   GpioCtrlRegs.GPAMUX2.bit.GPIO16 = 1;  // GPIO16 = SPICLKA
   GpioCtrlRegs.GPAMUX2.bit.GPIO17 = 1;  // GPIO17 = SPIS0MIA
   GpioCtrlRegs.GPAMUX2.bit.GPIO18 = 1;  // GPIO18 = SPICLKA
   GpioCtrlRegs.GPAMUX2.bit.GPIO19 = 1;  // GPIO19 = SPISTEA

   // Enable EQEP1 on GPIO20 - GPIO23
   GpioCtrlRegs.GPAPUD.bit.GPIO20 = 0;   // Enable pullup on GPIO20 (EQEP1A)
   GpioCtrlRegs.GPAPUD.bit.GPIO21 = 0;   // Enable pullup on GPIO21 (EQEP1B)
   GpioCtrlRegs.GPAPUD.bit.GPIO22 = 0;   // Enable pullup on GPIO22 (EQEP1S)
   GpioCtrlRegs.GPAPUD.bit.GPIO23 = 0;   // Enable pullup on GPIO23 (EQEP1I)
   GpioCtrlRegs.GPAQSEL2.bit.GPIO20 = 0; // Synch to SYSCLKOUT
   GpioCtrlRegs.GPAQSEL2.bit.GPIO21 = 0; // Synch to SYSCLKOUT
   GpioCtrlRegs.GPAQSEL2.bit.GPIO22 = 0; // Synch to SYSCLKOUT
   GpioCtrlRegs.GPAQSEL2.bit.GPIO23 = 0; // Synch to SYSCLKOUT
   GpioCtrlRegs.GPAMUX2.bit.GPIO20 = 1;  // GPIO20 = EQEP1A
   GpioCtrlRegs.GPAMUX2.bit.GPIO21 = 1;  // GPIO21 = EQEP1B
   GpioCtrlRegs.GPAMUX2.bit.GPIO22 = 1;  // GPIO22 = EQEP1S
   GpioCtrlRegs.GPAMUX2.bit.GPIO23 = 1;  // GPIO23 = EQEP1I

   // Enable eCAP1 on GPIO24
   GpioCtrlRegs.GPAPUD.bit.GPIO24 = 0;   // Enable pullup on GPIO24 (ECAP1)
   GpioCtrlRegs.GPAQSEL2.bit.GPIO24 = 0; // Synch to SYSCLKOUT
   GpioCtrlRegs.GPAMUX2.bit.GPIO24 = 1;  // GPIO24 = ECAP1

   // Set input qualifcation period for GPIO25 & GPIO26 inputs
   GpioCtrlRegs.GPACTRL.bit.QUALPRD3=1;  // Qual period = SYSCLKOUT/2
   GpioCtrlRegs.GPAQSEL2.bit.GPIO25=2;   // 6 samples
   GpioCtrlRegs.GPAQSEL2.bit.GPIO26=1;   // 3 samples

   // Make GPIO25 the input source for Xint1
   GpioCtrlRegs.GPAMUX2.bit.GPIO25 = 0; // GPIO25 = GPIO25
   GpioCtrlRegs.GPADIR.bit.GPIO25 = 0;  // GPIO25 = input
   GpioIntRegs.GPIOXINT1SEL.all = 25;   // Xint1 connected to GPIO25

   // Make GPIO26 the input source for XINT2
   GpioCtrlRegs.GPAMUX2.bit.GPIO26 = 0; // GPIO26 = GPIO26
   GpioCtrlRegs.GPADIR.bit.GPIO26 = 0;  // GPIO26 = input
   GpioIntRegs.GPIOXINT2SEL.all = 26;   // XINT2 connected to GPIO26

   // Make GPIO27 wakeup from HALT/STANDBY Low Power Modes
   GpioCtrlRegs.GPAMUX2.bit.GPIO27 = 0; // GPIO27 = GPIO27
   GpioCtrlRegs.GPADIR.bit.GPIO27 = 0;  // GPIO27 = input
   GpioIntRegs.GPIOLPMSEL.bit.GPIO27=1; // GPIO27 will wake the device
   SysCtrlRegs.LPMCR0.bit.QUALSTDBY=2;  // Qualify GPIO27 by 2 OSCCLK
                                        // cycles before waking the device
                                        // from STANDBY

   // Enable SCI-A on GPIO28 - GPIO29
   GpioCtrlRegs.GPAPUD.bit.GPIO28 = 0;   // Enable pullup on GPIO28
   GpioCtrlRegs.GPAQSEL2.bit.GPIO28 = 3; // asynch input
   GpioCtrlRegs.GPAMUX2.bit.GPIO28 = 1;  // GPIO28 = SCIRXDA
   GpioCtrlRegs.GPAPUD.bit.GPIO29 = 0;   // Enable pullup on GPIO29
   GpioCtrlRegs.GPAMUX2.bit.GPIO29 = 1;  // GPIO29 = SCITXDA

   // Enable CAN-A on GPIO30 - GPIO31
   GpioCtrlRegs.GPAPUD.bit.GPIO30 = 0;   // Enable pullup on GPIO30
   GpioCtrlRegs.GPAMUX2.bit.GPIO30 = 1;  // GPIO30 = CANTXA
   GpioCtrlRegs.GPAPUD.bit.GPIO31 = 0;   // Enable pullup on GPIO31
   GpioCtrlRegs.GPAQSEL2.bit.GPIO31 = 3; // asynch input
   GpioCtrlRegs.GPAMUX2.bit.GPIO31 = 1;  // GPIO31 = CANRXA

   // Enable I2C-A on GPIO32 - GPIO33
   GpioCtrlRegs.GPBPUD.bit.GPIO32 = 0;   // Enable pullup on GPIO32
   GpioCtrlRegs.GPBPUD.bit.GPIO33 = 0;   // Enable pullup on GPIO33
   GpioCtrlRegs.GPBQSEL1.bit.GPIO32 = 3; // asynch input
   GpioCtrlRegs.GPBQSEL1.bit.GPIO32 = 3; // asynch input
   GpioCtrlRegs.GPBMUX1.bit.GPIO32 = 1;  // GPIO32 = SDAA
   GpioCtrlRegs.GPBMUX1.bit.GPIO33 = 1;  // GPIO33 = SCLA

   // Make GPIO34 an input
   GpioCtrlRegs.GPBPUD.bit.GPIO32 = 0;   // Enable pullup on GPIO34
   GpioCtrlRegs.GPBMUX1.bit.GPIO34 = 0;  // GPIO34 = GPIO34
   GpioCtrlRegs.GPBDIR.bit.GPIO34 = 0;   // GPIO34 = input

   EDIS;
}


//===========================================================================
// No more.
//===========================================================================

