//˴ҪļʼƬʱӣʼpll,ʼʱӡóҪʽ
#include "F2806x_Device.h"     // Headerfile Include File
#include "F2806x_Examples.h"   // Examples Include File

// Select Internal Oscillator 1 as Clock Source (default), and turn off all unused clocks to
// conserve power.
	void InitSysCtrl(void)
{

   // Disable the watchdog
   DisableDog();

   // *IMPORTANT*
   // The Device_cal function, which copies the ADC & oscillator calibration values
   // from TI reserved OTP into the appropriate trim registers, occurs automatically
   // in the Boot ROM. If the boot ROM code is bypassed during the debug process, the
   // following function MUST be called for the ADC and oscillators to function according
   // to specification. The clocks to the ADC MUST be enabled before calling this
   // function.
   // See the device data manual and/or the ADC Reference
   // Manual for more information.

        EALLOW;
        SysCtrlRegs.PCLKCR0.bit.ADCENCLK = 1; // Enable ADC peripheral clock
        (*Device_cal)();
        SysCtrlRegs.PCLKCR0.bit.ADCENCLK = 0; // Return ADC clock to original state
        EDIS;

   // Select Internal Oscillator 1 as Clock Source (default), and turn off all unused clocks to
   // conserve power.
   IntOsc1Sel();

   // Initialize the PLL control: PLLCR and CLKINDIV
   // DSP28_PLLCR and DSP28_CLKINDIV are defined in F2806x_Examples.h
   InitPll(DSP28_PLLCR,DSP28_DIVSEL);
   // Initialize the peripheral clocks
   InitPeripheralClocks();

}
void InitPll(Uint16 val, Uint16 divsel)
{
   volatile Uint16 iVol;

   // Make sure the PLL is not running in limp mode
   if (SysCtrlRegs.PLLSTS.bit.MCLKSTS != 0)
   {
      EALLOW;
      // OSCCLKSRC1 failure detected. PLL running in limp mode.
      // Re-enable missing clock logic.
      SysCtrlRegs.PLLSTS.bit.MCLKCLR = 1;
      EDIS;
      // Replace this line with a call to an appropriate
      // SystemShutdown(); function.
      asm("        ESTOP0");     // Uncomment for debugging purposes
   }

   // DIVSEL MUST be 0 before PLLCR can be changed from
   // 0x0000. It is set to 0 by an external reset XRSn
   // This puts us in 1/4
   if (SysCtrlRegs.PLLSTS.bit.DIVSEL != 0)
   {
       EALLOW;
       SysCtrlRegs.PLLSTS.bit.DIVSEL = 0;
       EDIS;
   }

   // Change the PLLCR
   if (SysCtrlRegs.PLLCR.bit.DIV != 16)
   {

      EALLOW;
      // Before setting PLLCR turn off missing clock detect logic
      SysCtrlRegs.PLLSTS.bit.MCLKOFF = 1;
      SysCtrlRegs.PLLCR.bit.DIV = 16;
      EDIS;

      // Optional: Wait for PLL to lock.
      // During this time the CPU will switch to OSCCLK/2 until
      // the PLL is stable.  Once the PLL is stable the CPU will
      // switch to the new PLL value.
      //
      // This time-to-lock is monitored by a PLL lock counter.
      //
      // Code is not required to sit and wait for the PLL to lock.
      // However, if the code does anything that is timing critical,
      // and requires the correct clock be locked, then it is best to
      // wait until this switching has completed.

      // Wait for the PLL lock bit to be set.

      // The watchdog should be disabled before this loop, or fed within
      // the loop via ServiceDog().

      // Uncomment to disable the watchdog
      DisableDog();

      while(SysCtrlRegs.PLLSTS.bit.PLLLOCKS != 1)
      {
          // Uncomment to service the watchdog
          // ServiceDog();
      }

      EALLOW;
      SysCtrlRegs.PLLSTS.bit.MCLKOFF = 0;
      EDIS;
    }

    // If switching to 1/2
    if((divsel == 1)||(divsel == 2))
    {
        EALLOW;
        SysCtrlRegs.PLLSTS.bit.DIVSEL = divsel;
        EDIS;
    }

    // If switching to 1/1
    // * First go to 1/2 and let the power settle
    //   The time required will depend on the system, this is only an example
    // * Then switch to 1/1
    if(divsel == 3)
    {
        EALLOW;
        SysCtrlRegs.PLLSTS.bit.DIVSEL = 2;
        DELAY_US(50L);
        SysCtrlRegs.PLLSTS.bit.DIVSEL = 3;
        EDIS;
    }
}
// ʼʱ
void InitPeripheralClocks(void)
{
   EALLOW;
// LOSPCP prescale register settings, normally it will be set to default values
//lospcp趨lspclkҪ1/4 SYSCLK//
   SysCtrlRegs.LOSPCP.all = 0x0002;
//Ǵ˴SYSCLKOUT160mhz//
// XCLKOUT to SYSCLKOUT ratio.  By default XCLKOUT = 1/4 SYSCLKOUT
   SysCtrlRegs.XCLK.bit.XCLKOUTDIV=01;
// Peripheral clock enables set for the selected peripherals.
// If you are not using a peripheral leave the clock off
// to save on power.
//
// Note: not all peripherals are available on all 2803x derivates.
// Refer to the datasheet for your particular device.
//
// This function is not written to be an example of efficient code.

   SysCtrlRegs.PCLKCR1.bit.EPWM1ENCLK = 0;    // ePWM1
   SysCtrlRegs.PCLKCR1.bit.EPWM2ENCLK = 0;    // ePWM2
   SysCtrlRegs.PCLKCR1.bit.EPWM3ENCLK = 0;    // ePWM3
   SysCtrlRegs.PCLKCR1.bit.EPWM4ENCLK = 0;    // ePWM4
   SysCtrlRegs.PCLKCR1.bit.EPWM5ENCLK = 0;    // ePWM5
   SysCtrlRegs.PCLKCR1.bit.EPWM6ENCLK = 0;    // ePWM6
   SysCtrlRegs.PCLKCR1.bit.EPWM7ENCLK = 0;    // ePWM7
   SysCtrlRegs.PCLKCR1.bit.EPWM8ENCLK = 0;    // ePWM8

   SysCtrlRegs.PCLKCR0.bit.HRPWMENCLK = 0;    // HRPWM
   SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;     // Enable TBCLK within the ePWM

   SysCtrlRegs.PCLKCR1.bit.EQEP1ENCLK = 0;    // eQEP1
   SysCtrlRegs.PCLKCR1.bit.EQEP2ENCLK = 0;    // eQEP2

   SysCtrlRegs.PCLKCR1.bit.ECAP1ENCLK = 0;    // eCAP1
   SysCtrlRegs.PCLKCR1.bit.ECAP2ENCLK = 0;    // eCAP2
   SysCtrlRegs.PCLKCR1.bit.ECAP3ENCLK = 0;    // eCAP3

   SysCtrlRegs.PCLKCR0.bit.ADCENCLK = 0;      // ADC
   SysCtrlRegs.PCLKCR3.bit.COMP1ENCLK = 0;    // COMP1
   SysCtrlRegs.PCLKCR3.bit.COMP2ENCLK = 0;    // COMP2
   SysCtrlRegs.PCLKCR3.bit.COMP3ENCLK = 0;    // COMP3

   SysCtrlRegs.PCLKCR3.bit.CPUTIMER0ENCLK = 0; // CPU Timer 0
   SysCtrlRegs.PCLKCR3.bit.CPUTIMER1ENCLK = 0; // CPU Timer 1
   SysCtrlRegs.PCLKCR3.bit.CPUTIMER2ENCLK = 0; // CPU Timer 2

   SysCtrlRegs.PCLKCR3.bit.DMAENCLK = 1;      // DMA

   SysCtrlRegs.PCLKCR3.bit.GPIOINENCLK = 0;   // GPIO input clock

   SysCtrlRegs.PCLKCR3.bit.CLA1ENCLK = 0;     // CLA1

   SysCtrlRegs.PCLKCR0.bit.I2CAENCLK = 0;     // I2C
   SysCtrlRegs.PCLKCR0.bit.SPIAENCLK = 0;     // SPI-A
   SysCtrlRegs.PCLKCR0.bit.SPIBENCLK = 0;     // SPI-B
   SysCtrlRegs.PCLKCR0.bit.SCIAENCLK = 0;     // SCI-A
   SysCtrlRegs.PCLKCR0.bit.SCIBENCLK = 0;     // SCI-B
   SysCtrlRegs.PCLKCR0.bit.MCBSPAENCLK = 1;         // McBSP-A
   SysCtrlRegs.PCLKCR0.bit.ECANAENCLK = 0;      // eCAN-A

   SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;     // Enable TBCLK within the ePWM

   EDIS;
}




//Ӻ
//ѡƬʱ1
void IntOsc1Sel (void) {
    EALLOW;
    SysCtrlRegs.CLKCTL.bit.INTOSC1OFF = 0;
    SysCtrlRegs.CLKCTL.bit.OSCCLKSRCSEL=0;  // Clk Src = INTOSC1
    SysCtrlRegs.CLKCTL.bit.XCLKINOFF=1;     // Turn off XCLKIN
    SysCtrlRegs.CLKCTL.bit.XTALOSCOFF=1;    // Turn off XTALOSC
    SysCtrlRegs.CLKCTL.bit.INTOSC2OFF=1;    // Turn off INTOSC2
    EDIS;
}


//ѡƬʱ
void XtalOscSel (void)  {
     EALLOW;
     SysCtrlRegs.CLKCTL.bit.XTALOSCOFF = 0;     // Turn on XTALOSC
     SysCtrlRegs.CLKCTL.bit.XCLKINOFF = 1;      // Turn off XCLKIN
     SysCtrlRegs.CLKCTL.bit.OSCCLKSRC2SEL = 0;  // Switch to external clock
     SysCtrlRegs.CLKCTL.bit.OSCCLKSRCSEL = 1;   // Switch from INTOSC1 to INTOSC2/ext clk
     SysCtrlRegs.CLKCTL.bit.WDCLKSRCSEL = 1;    // Switch Watchdog Clk Src to external clock
     SysCtrlRegs.CLKCTL.bit.INTOSC2OFF = 1;     // Turn off INTOSC2
     SysCtrlRegs.CLKCTL.bit.INTOSC1OFF = 1;     // Turn off INTOSC1
     EDIS;
}
//رտŹ
void DisableDog(void)
{
    EALLOW;
    SysCtrlRegs.WDCR= 0x0068;
    EDIS;
}

