/*
 * BMP180.c
 *
 *  Created on: 2015429
 *      Author: Administrator
 */

#include "User_include.h"

short ac1;
short ac2;
short ac3;
unsigned short ac4;
unsigned short ac5;
unsigned short ac6;
short b1;
short b2;
short mb;
short mc;
short md;

long  temperature;
long  pressure;

/*************************************************************************
*  ƣBMP180_Write
*  ޸ʱ䣺2015-04-29
*      ע
*************************************************************************/
void BMP180_Write(unsigned char REG_Address,unsigned char REG_Data)
{
	UserI2c_WriteData(BMP180_SlaveAddress,REG_Address,REG_Data);
}

/*************************************************************************
*  ƣBMP180_Read
*  ˵BMP180_
*  ˵BYTE REG_AddressĴַ
*  أBYTE REG_Data   
*  ޸ʱ䣺2015-04-29
*      ע
*************************************************************************/
unsigned char BMP180_Read(unsigned char REG_Address)
{
	unsigned char dat = 0;
	dat = UserI2c_RecivData(BMP180_SlaveAddress,REG_Address);
	return dat;
}

/******************************************************************
**   void BMP180_Delay(Uint16 n)
*******************************************************************/
void BMP180_Delay(unsigned int n)
{
	unsigned int i = 0,j = 0;
	for(i=n;i>0;i--)
	{
 		for(j=10;j>0;j--);
	}
}

//********************************************************************
long BMP180_ReadTemp(void)//¶
{
	short  temp_ut;
	BMP180_Write(0xF4,0x2E);//ѡBMP180ģ飬дʵַ
	BMP180_Delay(10);	// max time is 4.5ms
	temp_ut = BMP180_Read(0xF6);//ȡݸ߰λ
	temp_ut = (temp_ut<<8) | BMP180_Read(0xF7);//ȡݵͰλ
	return (long) temp_ut ;
}

//*************************************************************
long BMP180_ReadPressure(void)//ѹǿ
{
	long pressure_up = 0;
	BMP180_Write(0xF4,0x34);
	BMP180_Delay(10);	// max time is 4.5ms
	pressure_up = BMP180_Read(0xF6);
	pressure_up = (pressure_up<<8) | BMP180_Read(0xF7);
	pressure_up &= 0x0000FFFF;
	return pressure_up;
}
/*************************************************************************
*  ƣBPM085_Init
*  ޸ʱ䣺2015-04-29
*      ע
*************************************************************************/
void BMP180_Init(void)
{
	//Ĵʼ
	ac1 = BMP180_Read(0xAA);
	ac1 = (ac1<<8)|BMP180_Read(0xAB);

	ac2 = BMP180_Read(0xAC);
	ac2 = (ac2<<8)| BMP180_Read(0xAD);

	ac3 = BMP180_Read(0xAE);
	ac3 = (ac3<<8)| BMP180_Read(0xAF);

	ac4 = BMP180_Read(0xB0);
	ac4 = (ac4<<8)| BMP180_Read(0xB1);

	ac5 = BMP180_Read(0xB2);
	ac5 = (ac5<<8)| BMP180_Read(0xB3);

	ac6 = BMP180_Read(0xB4);
	ac6 = (ac6<<8)| BMP180_Read(0xB5);

	b1 = BMP180_Read(0xB6);
	b1 = (b1<<8)| BMP180_Read(0xB7);

	b2 = BMP180_Read(0xB8);
	b2 = (b2<<8)| BMP180_Read(0xB9);

	mb = BMP180_Read(0xBA);
	mb = (mb<<8)| BMP180_Read(0xBB);

	mc = BMP180_Read(0xBC);
	mc = (mc<<8)| BMP180_Read(0xBD);

	md = BMP180_Read(0xBE);
	md = (md<<8)| BMP180_Read(0xBF);
}
//***************************************************
//***************************************************
void UserBMP180_Read(void)
{
   	long ut;
	long up;
	long x1, x2, b5, b6, x3, b3, p;
	unsigned long b4, b7;

	ut = BMP180_ReadTemp();	   // ȡ¶
	up = BMP180_ReadPressure();  // ȡѹǿ

	x1 = ((long)ut - ac6) * ac5 >> 15;
	x2 = ((long) mc << 11) / (x1 + md);
	b5 = x1 + x2;
	temperature = (b5 + 8) >> 4;

	 //****************

	b6 = b5 - 4000;
	x1 = (b2 * (b6 * b6 >> 12)) >> 11;
	x2 = ac2 * b6 >> 11;
	x3 = x1 + x2;
	b3 = (((long)ac1 * 4 + x3) + 2)/4;
	x1 = ac3 * b6 >> 13;
	x2 = (b1 * (b6 * b6 >> 12)) >> 16;
	x3 = ((x1 + x2) + 2) >> 2;
	b4 = (ac4 * (unsigned long) (x3 + 32768)) >> 15;
	b7 = ((unsigned long) up - b3) * (50000 >> OSS);
	if( b7 < 0x80000000)
		p = (b7 * 2) / b4 ;
    else
		p = (b7 / b4) * 2;
	x1 = (p >> 8) * (p >> 8);
	x1 = (x1 * 3038) >> 16;
	x2 = (-7357 * p) >> 16;
	pressure = p + ((x1 + x2 + 3791) >> 4);
}

Uint16 Threshold = 0;
float Axis_L = 0,Axis_H = 0;
void BMP180_DisplayTemp(void)
{
	OLED_P16x16Chi(0,6,0);//
	OLED_P16x16Chi(16,6,1);//
	OLED_P8x16Str(32,6,":");//:
	Dis_Float(6,5,temperature*0.1,1);
	OLED_P16x16Chi(72,6,2);//

	if((temperature >= 200) && (temperature < 248))
	{
		Axis_H = 24.8;
		Axis_L = 20.0;
		Threshold = 200;
	}
	if((temperature >= 248) && (temperature < 296))
	{
		Axis_H = 29.6;
		Axis_L = 24.8;
		Threshold = 248;
	}
	if((temperature >= 296) && (temperature < 344))
	{
		Axis_H = 34.4;
		Axis_L = 29.6;
		Threshold = 296;
	}
	if((temperature >= 344) && (temperature < 392))
	{
		Axis_H = 39.2;
		Axis_L = 34.4;
		Threshold = 344;
	}
	Dis_Float(0,0,Axis_H,1);
	Dis_Float(4,0,Axis_L,1);
	Paint_Axis(36,0,6);// ͼ,36Уӵ0е6
	Paint_List(temperature,Threshold,1);//¶ȵͼͼбĲʾ
}
