/*
 * User_I2C.c
 *
 *  Created on: 2015429
 *      Author: Administrator
 */
#include "User_include.h"

/*************************************************************************
*  ƣUserI2c_Delay
*  ޸ʱ䣺2015-04-29
*      ע
*************************************************************************/
void UserI2c_Delay(unsigned int n)
{
	unsigned int i = 0,j = 0;
	for(i=n;i>0;i--)
	{
 		for(j=10;j>0;j--);
	}
}
/*************************************************************************
*  ƣUserI2c_Init
*  ޸ʱ䣺2015-04-29
*      ע
*************************************************************************/
void UserI2c_Init()
{
	   // Initialize I2C
	   I2caRegs.I2CMDR.all = 0x0000;
	   I2caRegs.I2CSAR = 0x77;		// Slave address - EEPROM control code
	   // I2CCLK = SYSCLK/(I2CPSC+1)
	   I2caRegs.I2CPSC.all = 8;		    // Prescaler - need 7-12 Mhz on module clk  8
	   I2caRegs.I2CCLKL = 10;			// NOTE: must be non zero
	   I2caRegs.I2CCLKH = 10;			// NOTE: must be non zero
	   I2caRegs.I2CIER.all = 0x00;		// Enable SCD & ARDY interrupts    0x24

	   I2caRegs.I2CMDR.all = 0x0020;	// Take I2C out of reset
	   									// Stop I2C when suspended
	   I2caRegs.I2CFFTX.all = 0x6000;	// Enable FIFO mode and TXFIFO
	   I2caRegs.I2CFFRX.all = 0x2040;	// Enable RXFIFO, clear RXFFINT,

	   return;
}
/*************************************************************************
*  ƣUserI2c_WriteData
*  ޸ʱ䣺2015-04-29
*      ע
*************************************************************************/
void UserI2c_WriteData(unsigned char sl_addr,unsigned char mem_addr,unsigned char dat)
{
	   // Wait until the STP bit is cleared from any previous master communication.
	   // Clearing of this bit by the module is delayed until after the SCD bit is
	   // set. If this bit is not checked prior to initiating a new message, the
	   // I2C could get confused.
	   while(I2caRegs.I2CMDR.bit.STP == 1);// Wait until the STP bit is cleared from any previous master communication.
	   // Check if bus busy
	   // Setup slave address
	   I2caRegs.I2CSAR = sl_addr;
	   // Setup number of bytes to send
	   // MsgBuffer + Address
	   I2caRegs.I2CCNT = 2;
	   // Setup data to send
	   I2caRegs.I2CDXR = mem_addr&0x00FF;
	   I2caRegs.I2CDXR = dat&0x00FF;
	   // Send start as master transmitter
	   I2caRegs.I2CMDR.all = 0x6e20; //ʹI2Cģʽд7λַinternal data counter of the I2C module counts down to 0STOP
	   //while(I2caRegs.I2CSTR.bit.BB == 1);
	   return;
}
/*************************************************************************
*  ƣUserI2c_RecivData
*  ޸ʱ䣺2015-04-29
*      ע
*************************************************************************/
int UserI2c_RecivData(int sl_addr,int mem_addr)
{
	   int dat = 0;
	   // Wait until the STP bit is cleared from any previous master communication.
	   // Clearing of this bit by the module is delayed until after the SCD bit is
	   // set. If this bit is not checked prior to initiating a new message, the
	   // I2C could get confused.
	   while(I2caRegs.I2CMDR.bit.STP == 1);
	   while(I2caRegs.I2CSTR.bit.BB == 1);
	   I2caRegs.I2CSAR = sl_addr;
	   I2caRegs.I2CCNT = 1;
	   I2caRegs.I2CDXR = mem_addr;
	   I2caRegs.I2CMDR.all = 0x6e20; //startλģʽдinternal data counter of the I2C module counts down to 0STOP
	   while(I2caRegs.I2CMDR.bit.STP == 1);
	   while (I2caRegs.I2CSTR.bit.BB == 1);  //Ƿæ
	   I2caRegs.I2CSAR = sl_addr;
	   I2caRegs.I2CCNT = 1;
	   I2caRegs.I2CMDR.all = 0x2c20;  //startλģʽstop
	   while(I2caRegs.I2CSTR.bit.RSFULL == 1);
	   UserI2c_Delay(10);
	   dat = I2caRegs.I2CDRR&0x00FF;
       return dat;
}
/*************************************************************************
*  ƣUser_I2CContinueRead
*  ޸ʱ䣺2015-04-29
*      ע
*************************************************************************/
int CRead_Buff[14] = {0};

void UserI2c_ContinueRead(int sl_addr,int mem_addrStart,unsigned char num)
{
	int i = 0;
	while(I2caRegs.I2CMDR.bit.STP == 1);
	while(I2caRegs.I2CSTR.bit.BB == 1);
	I2caRegs.I2CSAR = sl_addr;
	I2caRegs.I2CCNT = 1;
	I2caRegs.I2CDXR = mem_addrStart;
	I2caRegs.I2CMDR.all = 0x6e20; //startλģʽдinternal data counter of the I2C module counts down to 0STOP
	while(I2caRegs.I2CMDR.bit.STP == 1);
	while(I2caRegs.I2CSTR.bit.BB == 1);
	I2caRegs.I2CSAR = sl_addr;
	I2caRegs.I2CCNT = num;
	I2caRegs.I2CMDR.all = 0x2c20;  //startλģʽstop
	for(i=0;i<num;i++)
	{
		while(I2caRegs.I2CSTR.bit.RSFULL == 1);
		UserI2c_Delay(5);
		//asm("NOP");
		//asm("NOP");
		//asm("NOP");
		CRead_Buff[i] = I2caRegs.I2CDRR&0x00FF;
	}
}


