/*
 * User_Oled.c
 *
 *  Created on: 2015318
 *      Author: Administrator
 */
#include "User_include.h"

//DO
#define Oled_SCL_High GpioDataRegs.GPASET.bit.GPIO16 = 1
#define Oled_SCL_Low  GpioDataRegs.GPACLEAR.bit.GPIO16 = 1
//DI
#define Oled_SDA_High GpioDataRegs.GPASET.bit.GPIO17 = 1
#define Oled_SDA_Low  GpioDataRegs.GPACLEAR.bit.GPIO17 = 1
//RST
#define Oled_RST_High GpioDataRegs.GPASET.bit.GPIO18 = 1
#define Oled_RST_Low  GpioDataRegs.GPACLEAR.bit.GPIO18 = 1
//DC
#define Oled_DC_High  GpioDataRegs.GPASET.bit.GPIO19 = 1
#define Oled_DC_Low   GpioDataRegs.GPACLEAR.bit.GPIO19 = 1

#define XLevelL		0x00
#define XLevelH		0x10
#define XLevel	    ((XLevelH&0x0F)*16+XLevelL)
#define Max_Column	128
#define Max_Row		64
#define	Brightness	0xCF
#define X_WIDTH 128
#define Y_WIDTH 64

//======================================================
// 128X64IҺײ[8X16]
//   : 8*16ĵȡģʽʽ
// !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~
//======================================================
const unsigned char F8X16[]=
{
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0
  0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x30,0x00,0x00,0x00,//!1
  0x00,0x10,0x0C,0x06,0x10,0x0C,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,//"2
  0x40,0xC0,0x78,0x40,0xC0,0x78,0x40,0x00,0x04,0x3F,0x04,0x04,0x3F,0x04,0x04,0x00,//#3
  0x00,0x70,0x88,0xFC,0x08,0x30,0x00,0x00,0x00,0x18,0x20,0xFF,0x21,0x1E,0x00,0x00,//$4
  0xF0,0x08,0xF0,0x00,0xE0,0x18,0x00,0x00,0x00,0x21,0x1C,0x03,0x1E,0x21,0x1E,0x00,//%5
  0x00,0xF0,0x08,0x88,0x70,0x00,0x00,0x00,0x1E,0x21,0x23,0x24,0x19,0x27,0x21,0x10,//&6
  0x10,0x16,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,//'7
  0x00,0x00,0x00,0xE0,0x18,0x04,0x02,0x00,0x00,0x00,0x00,0x07,0x18,0x20,0x40,0x00,//(8
  0x00,0x02,0x04,0x18,0xE0,0x00,0x00,0x00,0x00,0x40,0x20,0x18,0x07,0x00,0x00,0x00,//)9
  0x40,0x40,0x80,0xF0,0x80,0x40,0x40,0x00,0x02,0x02,0x01,0x0F,0x01,0x02,0x02,0x00,//*10
  0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x1F,0x01,0x01,0x01,0x00,//+11
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xB0,0x70,0x00,0x00,0x00,0x00,0x00,//,12
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,//-13
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00,0x00,0x00,//.14
  0x00,0x00,0x00,0x00,0x80,0x60,0x18,0x04,0x00,0x60,0x18,0x06,0x01,0x00,0x00,0x00,///15
  0x00,0xE0,0x10,0x08,0x08,0x10,0xE0,0x00,0x00,0x0F,0x10,0x20,0x20,0x10,0x0F,0x00,//016
  0x00,0x10,0x10,0xF8,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x3F,0x20,0x20,0x00,0x00,//117
  0x00,0x70,0x08,0x08,0x08,0x88,0x70,0x00,0x00,0x30,0x28,0x24,0x22,0x21,0x30,0x00,//218
  0x00,0x30,0x08,0x88,0x88,0x48,0x30,0x00,0x00,0x18,0x20,0x20,0x20,0x11,0x0E,0x00,//319
  0x00,0x00,0xC0,0x20,0x10,0xF8,0x00,0x00,0x00,0x07,0x04,0x24,0x24,0x3F,0x24,0x00,//420
  0x00,0xF8,0x08,0x88,0x88,0x08,0x08,0x00,0x00,0x19,0x21,0x20,0x20,0x11,0x0E,0x00,//521
  0x00,0xE0,0x10,0x88,0x88,0x18,0x00,0x00,0x00,0x0F,0x11,0x20,0x20,0x11,0x0E,0x00,//622
  0x00,0x38,0x08,0x08,0xC8,0x38,0x08,0x00,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00,//723
  0x00,0x70,0x88,0x08,0x08,0x88,0x70,0x00,0x00,0x1C,0x22,0x21,0x21,0x22,0x1C,0x00,//824
  0x00,0xE0,0x10,0x08,0x08,0x10,0xE0,0x00,0x00,0x00,0x31,0x22,0x22,0x11,0x0F,0x00,//925
  0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00,//:26
  0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x60,0x00,0x00,0x00,0x00,//;27
  0x00,0x00,0x80,0x40,0x20,0x10,0x08,0x00,0x00,0x01,0x02,0x04,0x08,0x10,0x20,0x00,//<28
  0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00,//=29
  0x00,0x08,0x10,0x20,0x40,0x80,0x00,0x00,0x00,0x20,0x10,0x08,0x04,0x02,0x01,0x00,//>30
  0x00,0x70,0x48,0x08,0x08,0x08,0xF0,0x00,0x00,0x00,0x00,0x30,0x36,0x01,0x00,0x00,//?31
  0xC0,0x30,0xC8,0x28,0xE8,0x10,0xE0,0x00,0x07,0x18,0x27,0x24,0x23,0x14,0x0B,0x00,//@32
  0x00,0x00,0xC0,0x38,0xE0,0x00,0x00,0x00,0x20,0x3C,0x23,0x02,0x02,0x27,0x38,0x20,//A33
  0x08,0xF8,0x88,0x88,0x88,0x70,0x00,0x00,0x20,0x3F,0x20,0x20,0x20,0x11,0x0E,0x00,//B34
  0xC0,0x30,0x08,0x08,0x08,0x08,0x38,0x00,0x07,0x18,0x20,0x20,0x20,0x10,0x08,0x00,//C35
  0x08,0xF8,0x08,0x08,0x08,0x10,0xE0,0x00,0x20,0x3F,0x20,0x20,0x20,0x10,0x0F,0x00,//D36
  0x08,0xF8,0x88,0x88,0xE8,0x08,0x10,0x00,0x20,0x3F,0x20,0x20,0x23,0x20,0x18,0x00,//E37
  0x08,0xF8,0x88,0x88,0xE8,0x08,0x10,0x00,0x20,0x3F,0x20,0x00,0x03,0x00,0x00,0x00,//F38
  0xC0,0x30,0x08,0x08,0x08,0x38,0x00,0x00,0x07,0x18,0x20,0x20,0x22,0x1E,0x02,0x00,//G39
  0x08,0xF8,0x08,0x00,0x00,0x08,0xF8,0x08,0x20,0x3F,0x21,0x01,0x01,0x21,0x3F,0x20,//H40
  0x00,0x08,0x08,0xF8,0x08,0x08,0x00,0x00,0x00,0x20,0x20,0x3F,0x20,0x20,0x00,0x00,//I41
  0x00,0x00,0x08,0x08,0xF8,0x08,0x08,0x00,0xC0,0x80,0x80,0x80,0x7F,0x00,0x00,0x00,//J42
  0x08,0xF8,0x88,0xC0,0x28,0x18,0x08,0x00,0x20,0x3F,0x20,0x01,0x26,0x38,0x20,0x00,//K43
  0x08,0xF8,0x08,0x00,0x00,0x00,0x00,0x00,0x20,0x3F,0x20,0x20,0x20,0x20,0x30,0x00,//L44
  0x08,0xF8,0xF8,0x00,0xF8,0xF8,0x08,0x00,0x20,0x3F,0x00,0x3F,0x00,0x3F,0x20,0x00,//M45
  0x08,0xF8,0x30,0xC0,0x00,0x08,0xF8,0x08,0x20,0x3F,0x20,0x00,0x07,0x18,0x3F,0x00,//N46
  0xE0,0x10,0x08,0x08,0x08,0x10,0xE0,0x00,0x0F,0x10,0x20,0x20,0x20,0x10,0x0F,0x00,//O47
  0x08,0xF8,0x08,0x08,0x08,0x08,0xF0,0x00,0x20,0x3F,0x21,0x01,0x01,0x01,0x00,0x00,//P48
  0xE0,0x10,0x08,0x08,0x08,0x10,0xE0,0x00,0x0F,0x18,0x24,0x24,0x38,0x50,0x4F,0x00,//Q49
  0x08,0xF8,0x88,0x88,0x88,0x88,0x70,0x00,0x20,0x3F,0x20,0x00,0x03,0x0C,0x30,0x20,//R50
  0x00,0x70,0x88,0x08,0x08,0x08,0x38,0x00,0x00,0x38,0x20,0x21,0x21,0x22,0x1C,0x00,//S51
  0x18,0x08,0x08,0xF8,0x08,0x08,0x18,0x00,0x00,0x00,0x20,0x3F,0x20,0x00,0x00,0x00,//T52
  0x08,0xF8,0x08,0x00,0x00,0x08,0xF8,0x08,0x00,0x1F,0x20,0x20,0x20,0x20,0x1F,0x00,//U53
  0x08,0x78,0x88,0x00,0x00,0xC8,0x38,0x08,0x00,0x00,0x07,0x38,0x0E,0x01,0x00,0x00,//V54
  0xF8,0x08,0x00,0xF8,0x00,0x08,0xF8,0x00,0x03,0x3C,0x07,0x00,0x07,0x3C,0x03,0x00,//W55
  0x08,0x18,0x68,0x80,0x80,0x68,0x18,0x08,0x20,0x30,0x2C,0x03,0x03,0x2C,0x30,0x20,//X56
  0x08,0x38,0xC8,0x00,0xC8,0x38,0x08,0x00,0x00,0x00,0x20,0x3F,0x20,0x00,0x00,0x00,//Y57
  0x10,0x08,0x08,0x08,0xC8,0x38,0x08,0x00,0x20,0x38,0x26,0x21,0x20,0x20,0x18,0x00,//Z58
  0x00,0x00,0x00,0xFE,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x7F,0x40,0x40,0x40,0x00,//[59
  0x00,0x0C,0x30,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x06,0x38,0xC0,0x00,//\60
  0x00,0x02,0x02,0x02,0xFE,0x00,0x00,0x00,0x00,0x40,0x40,0x40,0x7F,0x00,0x00,0x00,//]61
  0x00,0x00,0x04,0x02,0x02,0x02,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,//^62
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,//_63
  0x00,0x02,0x02,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,//`64
  0x00,0x00,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x19,0x24,0x22,0x22,0x22,0x3F,0x20,//a65
  0x08,0xF8,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x3F,0x11,0x20,0x20,0x11,0x0E,0x00,//b66
  0x00,0x00,0x00,0x80,0x80,0x80,0x00,0x00,0x00,0x0E,0x11,0x20,0x20,0x20,0x11,0x00,//c67
  0x00,0x00,0x00,0x80,0x80,0x88,0xF8,0x00,0x00,0x0E,0x11,0x20,0x20,0x10,0x3F,0x20,//d68
  0x00,0x00,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x1F,0x22,0x22,0x22,0x22,0x13,0x00,//e69
  0x00,0x80,0x80,0xF0,0x88,0x88,0x88,0x18,0x00,0x20,0x20,0x3F,0x20,0x20,0x00,0x00,//f70
  0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x6B,0x94,0x94,0x94,0x93,0x60,0x00,//g71
  0x08,0xF8,0x00,0x80,0x80,0x80,0x00,0x00,0x20,0x3F,0x21,0x00,0x00,0x20,0x3F,0x20,//h72
  0x00,0x80,0x98,0x98,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x3F,0x20,0x20,0x00,0x00,//i73
  0x00,0x00,0x00,0x80,0x98,0x98,0x00,0x00,0x00,0xC0,0x80,0x80,0x80,0x7F,0x00,0x00,//j74
  0x08,0xF8,0x00,0x00,0x80,0x80,0x80,0x00,0x20,0x3F,0x24,0x02,0x2D,0x30,0x20,0x00,//k75
  0x00,0x08,0x08,0xF8,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x3F,0x20,0x20,0x00,0x00,//l76
  0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x20,0x3F,0x20,0x00,0x3F,0x20,0x00,0x3F,//m77
  0x80,0x80,0x00,0x80,0x80,0x80,0x00,0x00,0x20,0x3F,0x21,0x00,0x00,0x20,0x3F,0x20,//n78
  0x00,0x00,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x1F,0x20,0x20,0x20,0x20,0x1F,0x00,//o79
  0x80,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x80,0xFF,0xA1,0x20,0x20,0x11,0x0E,0x00,//p80
  0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x00,0x00,0x0E,0x11,0x20,0x20,0xA0,0xFF,0x80,//q81
  0x80,0x80,0x80,0x00,0x80,0x80,0x80,0x00,0x20,0x20,0x3F,0x21,0x20,0x00,0x01,0x00,//r82
  0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x33,0x24,0x24,0x24,0x24,0x19,0x00,//s83
  0x00,0x80,0x80,0xE0,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x1F,0x20,0x20,0x00,0x00,//t84
  0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x1F,0x20,0x20,0x20,0x10,0x3F,0x20,//u85
  0x80,0x80,0x80,0x00,0x00,0x80,0x80,0x80,0x00,0x01,0x0E,0x30,0x08,0x06,0x01,0x00,//v86
  0x80,0x80,0x00,0x80,0x00,0x80,0x80,0x80,0x0F,0x30,0x0C,0x03,0x0C,0x30,0x0F,0x00,//w87
  0x00,0x80,0x80,0x00,0x80,0x80,0x80,0x00,0x00,0x20,0x31,0x2E,0x0E,0x31,0x20,0x00,//x88
  0x80,0x80,0x80,0x00,0x00,0x80,0x80,0x80,0x80,0x81,0x8E,0x70,0x18,0x06,0x01,0x00,//y89
  0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x21,0x30,0x2C,0x22,0x21,0x30,0x00,//z90
  0x00,0x00,0x00,0x00,0x80,0x7C,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x3F,0x40,0x40,//{91
  0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,//|92
  0x00,0x02,0x02,0x7C,0x80,0x00,0x00,0x00,0x00,0x40,0x40,0x3F,0x00,0x00,0x00,0x00,//}93
  0x00,0x06,0x01,0x01,0x02,0x02,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,//~94

};
/******************************************************/
/*******************  ASCIIֿ    ******************/
/******************************************************/
unsigned char Draw[]=
{
  0xfc,0x04,0x07,0x01,0x01,0x07,0x04,0xfc,0xff,0x80,0x80,0x80,0x80,0x80,0x80,0xff,//û 0
  0xfc,0x04,0x07,0x01,0x01,0x07,0x04,0xfc,0xff,0x80,0xa0,0xa0,0xa0,0xa0,0x80,0xff,//һ 1
  0xfc,0x04,0x07,0x01,0x01,0x07,0x04,0xfc,0xff,0x80,0xb0,0xb0,0xb0,0xb0,0x80,0xff,//
  0xfc,0x04,0x07,0x01,0x01,0x07,0x04,0xfc,0xff,0x80,0xb8,0xb8,0xb8,0xb8,0x80,0xff,//
  0xfc,0x04,0x07,0x01,0x01,0x07,0x04,0xfc,0xff,0x80,0xbc,0xbc,0xbc,0xbc,0x80,0xff,//ĸ
  0xfc,0x04,0x07,0x01,0x01,0x07,0x04,0xfc,0xff,0x80,0xbe,0xbe,0xbe,0xbe,0x80,0xff,//
  0xfc,0x04,0x07,0x01,0x01,0x07,0x04,0xfc,0xff,0x80,0xbf,0xbf,0xbf,0xbf,0x80,0xff,//
  0xfc,0x04,0x87,0x81,0x81,0x87,0x04,0xfc,0xff,0x80,0xbf,0xbf,0xbf,0xbf,0x80,0xff,//߸
  0xfc,0x04,0xc7,0xc1,0xc1,0xc7,0x04,0xfc,0xff,0x80,0xbf,0xbf,0xbf,0xbf,0x80,0xff,//˸
  0xfc,0x04,0xe7,0xe1,0xe1,0xe7,0x04,0xfc,0xff,0x80,0xbf,0xbf,0xbf,0xbf,0x80,0xff,//Ÿ
  0xfc,0x04,0xf7,0xf1,0xf1,0xf7,0x04,0xfc,0xff,0x80,0xbf,0xbf,0xbf,0xbf,0x80,0xff,//ʮ
  0x00,0xFC,0xF8,0xF0,0xE0,0xC0,0x80,0x00,0x00,0x0F,0x07,0x07,0x1F,0x3F,0x19,0x01,//ͷ11
  0x00,0xF8,0x04,0x04,0x04,0x04,0x38,0x00,0x00,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x00,//12
  0x00,0xE0,0x10,0x10,0x10,0x10,0xE0,0x00,0x00,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x00,//13
  0x00,0x00,0x00,0xFC,0xFC,0x18,0x18,0x00,0x00,0x3C,0x7E,0x67,0x67,0x7E,0x3C,0x00,//Կ14
  0xc0,0x60,0x30,0x18,0x18,0x30,0x60,0xc0,0x01,0x01,0x1f,0x10,0x10,0x1f,0x01,0x01,//ϵ15
  0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,//ڿ16
  0xff,0x01,0x01,0x01,0x01,0x01,0x01,0xff,0xff,0x80,0x80,0x80,0x80,0x80,0x80,0xff,//17
  0xC0,0xC0,0xC0,0xC0,0xF0,0xE0,0xC0,0x80,0x01,0x01,0x01,0x01,0x07,0x03,0x01,0x00,//Ҽͷ18
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,//հ19
  0x00,0x00,0xF8,0xF8,0xF8,0xF8,0x00,0x00,0x01,0x03,0x07,0x0F,0x0F,0x07,0x03,0x01,//¼ͷ20
  0x40,0xA0,0xD0,0x68,0x68,0xD0,0xA0,0x40,0x22,0x25,0x2B,0x36,0x36,0x2B,0x25,0x22,//21
  0xE0,0xE0,0xE0,0xE0,0xF8,0xF0,0xE0,0x40,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x00,//ͷ22
};

/*----------- 16*16ĵȡģʽʽ -----------*/
unsigned char show_16x16[] =
{
	0x10,0x21,0x86,0x70,0x00,0x7E,0x4A,0x4A,0x4A,0x4A,0x4A,0x7E,0x00,0x00,0x00,0x00,
	0x02,0xFE,0x01,0x40,0x7F,0x41,0x41,0x7F,0x41,0x41,0x7F,0x41,0x41,0x7F,0x40,0x00,/*"",0*/

	0x00,0x00,0xFC,0x04,0x24,0x24,0xFC,0xA5,0xA6,0xA4,0xFC,0x24,0x24,0x24,0x04,0x00,
	0x80,0x60,0x1F,0x80,0x80,0x42,0x46,0x2A,0x12,0x12,0x2A,0x26,0x42,0xC0,0x40,0x00,/*"",1*/

	0x00,0x02,0x05,0xE2,0x18,0x04,0x02,0x02,0x02,0x02,0x02,0x02,0x04,0x1E,0x00,0x00,
	0x00,0x00,0x00,0x07,0x18,0x20,0x40,0x40,0x40,0x40,0x40,0x40,0x20,0x18,0x00,0x00,/*"",2*/

	0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,/*"һ ",3*/

	0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00,0x00,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,/*"",4*/

	0x00,0x04,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x04,0x00,0x00,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x00,/*"",5*/

	0x00,0xFC,0x04,0x04,0x04,0xFC,0x04,0x04,0x04,0xFC,0x04,0x04,0x04,0xFC,0x00,0x00,
	0x00,0x7F,0x28,0x24,0x23,0x20,0x20,0x20,0x20,0x21,0x22,0x22,0x22,0x7F,0x00,0x00,/*"",6*/

	0x00,0x02,0x42,0x42,0x42,0xC2,0x7E,0x42,0x42,0x42,0x42,0xC2,0x02,0x02,0x00,0x00,
	0x40,0x40,0x40,0x40,0x78,0x47,0x40,0x40,0x40,0x40,0x40,0x7F,0x40,0x40,0x40,0x00,/*"",7*/

	0x20,0x20,0x20,0x20,0x20,0x20,0x21,0x22,0x2C,0x20,0x20,0x20,0x20,0x20,0x20,0x00,
	0x00,0x40,0x20,0x10,0x0C,0x03,0x00,0x00,0x00,0x01,0x02,0x04,0x18,0x60,0x00,0x00,/*"",8*/

	0x40,0x40,0x42,0x42,0x42,0x42,0x42,0xFE,0x42,0x42,0x42,0x42,0x42,0x40,0x40,0x00,
	0x80,0x80,0x40,0x20,0x10,0x0C,0x03,0x00,0x03,0x0C,0x10,0x20,0x40,0x80,0x80,0x00,/*"",9*/

	0x00,0x00,0x00,0xBE,0x2A,0x2A,0x2A,0xEA,0x2A,0x2A,0x2A,0x3E,0x00,0x00,0x00,0x00,
	0x00,0x44,0x42,0x49,0x49,0x49,0x49,0x7F,0x49,0x49,0x49,0x49,0x41,0x40,0x00,0x00,/*"",10*/

	0x00,0x04,0xFF,0x24,0x24,0x24,0xFF,0x04,0x00,0xFE,0x22,0x22,0x22,0xFE,0x00,0x00,
	0x88,0x48,0x2F,0x09,0x09,0x19,0xAF,0x48,0x30,0x0F,0x02,0x42,0x82,0x7F,0x00,0x00,/*"",11*/
};
/*------------ *LCD ʱ1ms* ------------------------*/
void oled_delay_ms(unsigned int ms)
{
	while (ms--)
		;
}
/*---------------- *oledд* -------------------*/
void OLED_Write_Data(unsigned char data)
{
	unsigned char i;
	Oled_DC_High;
	for (i = 0; i < 8; i++) //һλ
	{
		if ((data << i) & 0x80)
			Oled_SDA_High;
		else
			Oled_SDA_Low;
		Oled_SCL_Low;
		Oled_SCL_High;
	}
}
/*--------------- *oledд* --------------------*/
void OLED_Write_Command(unsigned char command)
{
	unsigned char i;
	Oled_DC_Low;
	for (i = 0; i < 8; i++) //һλ
	{
		if ((command << i) & 0x80)
			Oled_SDA_High;
		else
			Oled_SDA_Low;
		Oled_SCL_Low;
		Oled_SCL_High;
	}
}
/*---------------- *LCD * ------------------*/
void OLED_Set_Pos(unsigned char x, unsigned char y)
{
	OLED_Write_Command(0xb0 + y);
	OLED_Write_Command(((x & 0xf0) >> 4) | 0x10);
	OLED_Write_Command((x & 0x0f) | 0x01);
}
/*--------------- *LCDȫ* -------------------------*/
void OLED_Full_Show(unsigned char bmp_dat)
{
	unsigned char y, x;
	for (y = 0; y < 8; y++)
	{
		OLED_Write_Command(0xb0 + y);
		OLED_Write_Command(0x01);
		OLED_Write_Command(0x10);
		for (x = 0; x < X_WIDTH; x++)
			OLED_Write_Data(bmp_dat);
	}
}
/*---------------- *LCDλ* --------------------------*/
void OLED_Clear(void)
{
	unsigned char y, x;
	for (y = 0; y < 8; y++)
	{
		OLED_Write_Command(0xb0 + y);
		OLED_Write_Command(0x01);
		OLED_Write_Command(0x10);
		for (x = 0; x < X_WIDTH; x++)
			OLED_Write_Data(0);
	}
}
/*********************LCDʼ************************************/
void UserOled_Init(void)
{
	Oled_SCL_High;
	Oled_RST_Low;
	oled_delay_ms(200);
	Oled_RST_High; //ϵ絽濪ʼʼҪ㹻ʱ䣬ȴRCλ
	OLED_Write_Command(0xae); //--turn off oled panel
	OLED_Write_Command(0x00); //---set low column address
	OLED_Write_Command(0x10); //---set high column address
	OLED_Write_Command(0x40); //--set start line address  Set Mapping RAM Display Start Line (0x00~0x3F)
	OLED_Write_Command(0x81); //--set contrast control register
	OLED_Write_Command(0xcf); // Set SEG Output Current Brightness
	OLED_Write_Command(0xa1); //--Set SEG/Column Mapping     0xa0ҷ 0xa1
	OLED_Write_Command(0xc8); //Set COM/Row Scan Direction   0xc0· 0xc8
	OLED_Write_Command(0xa6); //--set normal display
	OLED_Write_Command(0xa8); //--set multiplex ratio(1 to 64)
	OLED_Write_Command(0x3f); //--1/64 duty
	OLED_Write_Command(0xd3); //-set display offset	Shift Mapping RAM Counter (0x00~0x3F)
	OLED_Write_Command(0x00); //-not offset
	OLED_Write_Command(0xd5); //--set display clock divide ratio/oscillator frequency
	OLED_Write_Command(0x80); //--set divide ratio, Set Clock as 100 Frames/Sec
	OLED_Write_Command(0xd9); //--set pre-charge period
	OLED_Write_Command(0xf1); //Set Pre-Charge as 15 Clocks & Discharge as 1 Clock
	OLED_Write_Command(0xda); //--set com pins hardware configuration
	OLED_Write_Command(0x12);
	OLED_Write_Command(0xdb); //--set vcomh
	OLED_Write_Command(0x40); //Set VCOM Deselect Level
	OLED_Write_Command(0x20); //-Set Page Addressing Mode (0x00/0x01/0x02)
	OLED_Write_Command(0x02); //
	OLED_Write_Command(0x8d); //--set Charge Pump enable/disable
	OLED_Write_Command(0x14); //--set(0x10) disable
	OLED_Write_Command(0xa4); // Disable Entire Display On (0xa4/0xa5)
	OLED_Write_Command(0xa6); // Disable Inverse Display On (0xa6/a7)
	OLED_Write_Command(0xaf); //--turn on oled panel
	OLED_Full_Show(0x00);  //ʼ
	OLED_Set_Pos(0, 0);
}
//==============================================================
//LCD_P8x16Str(byte x,byte y,byte *p)
//дһ׼ASCIIַ
//xȡֵΪ*8yΪҳΧ0,2,4,6ch[]ΪҪʾַ
//أ
//==============================================================
void OLED_P8x16Str(unsigned char x, unsigned char y, char ch[])
{
	unsigned char c = 0, i = 0, j = 0;

	while (ch[j] != '\0')
	{
		c = ch[j] - 32;
		if (x > 120)
		{
			x = 0;
			y++;
		}
		OLED_Set_Pos(x, y);
		for (i = 0; i < 8; i++)
			OLED_Write_Data(F8X16[c * 16 + i]);
		OLED_Set_Pos(x, y + 1);
		for (i = 0; i < 8; i++)
			OLED_Write_Data(F8X16[c * 16 + i + 8]);
		x += 8;
		j++;
	}
}

/*--------------- ʾ16*16,ʾ꣨x,y),yΪҳΧ07 -------------*/
void OLED_P16x16Chi(unsigned char x, unsigned char y, unsigned char N)
{
	unsigned char wm = 0;
	unsigned int adder = 32 * N;  //
	OLED_Set_Pos(x, y);
	for (wm = 0; wm < 16; wm++)  //
	{
		OLED_Write_Data(show_16x16[adder]);
		adder += 1;
	}
	OLED_Set_Pos(x, y + 1);
	for (wm = 0; wm < 16; wm++) //
	{
		OLED_Write_Data(show_16x16[adder]);
		adder += 1;
	}
}
//x=0123456789101112131415;
//y=0246
//n1ָҺʾλ
void Dis_Num(unsigned char y, unsigned char x, Uint16 num, unsigned char n1)
{
	//unsigned char line;
	unsigned char j = 0;
	char n[6] = { 0 };
	x = x * 8;
	n[0] = (num / 10000) % 10;
	n[1] = (num / 1000) % 10;
	n[2] = (num / 100) % 10;
	n[3] = (num / 10) % 10;
	n[4] = num % 10;
	n[5] = '\0';
	for (j = 0; j < 5; j++)
		n[j] = n[j] + 16 + 32;
	OLED_P8x16Str(x, y, &n[5 - n1]); //ACSIIжȡֽڣȻдҺ
}
//x=0123456789101112131415;
//y=0246
//n2ָҺСʾλ
void Dis_Float(unsigned char Y, unsigned char X, float real, unsigned char n2)
{
	unsigned char i_Count = 1;
	char n[12] = { 0 };
	long j = 1;
	Uint16 real_int = 0;
	float decimal = 0;
	Uint16 real_decimal = 0;
	X = X * 8;
	if (real < 0)
		real = -real;
	real_int = (int) real;
	//Dis_Num(2,0,real_int,5);
	decimal = real - real_int;
	real_decimal = decimal * 1e4;
	//Dis_Num(2,6,real_decimal,4);
	while (real_int / 10 / j != 0) {
		j = j * 10;
		i_Count++;
	}
	n[0] = (real_int / 10000) % 10;
	n[1] = (real_int / 1000) % 10;
	n[2] = (real_int / 100) % 10;
	n[3] = (real_int / 10) % 10;
	n[4] = (real_int / 1) % 10;
	n[5] = '.';
	n[6] = (real_decimal / 1000) % 10;
	n[7] = (real_decimal / 100) % 10;
	n[8] = (real_decimal / 10) % 10;
	n[9] = real_decimal % 10;
	n[6 + n2] = '\0';
	for (j = 0; j < 10; j++)
		n[j] = n[j] + 16 + 32;
	n[5] = '.';
	n[6 + n2] = '\0';
	OLED_P8x16Str(X, Y, &n[5 - i_Count]);
}
/*---------------------*λ*---------------------*/
void Position_Clear(unsigned char Position)
{
  unsigned char Temp_i;
  unsigned char Temp_y,Temp_x;
  switch(Position)
  {
    case 1:Temp_x=8,Temp_y=2;break;
    case 2:Temp_x=72,Temp_y=2;break;
    case 3:Temp_x=8,Temp_y=4;break;
    case 4:Temp_x=72,Temp_y=4;break;
    case 5:Temp_x=8,Temp_y=6;break;
    case 6:Temp_x=72,Temp_y=6;break;
    default:break;
  }

  OLED_Set_Pos(Temp_x,Temp_y);
  for(Temp_i=0;Temp_i<56;Temp_i++)
    OLED_Write_Data(0x00);
  OLED_Set_Pos(Temp_x,Temp_y+1);
  for(Temp_i=0;Temp_i<56;Temp_i++)
    OLED_Write_Data(0x00);
}
////########################ʾͼ####################################
//x = 0,2,4,6
//y = 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
//Asc as the display draw
void OLED_Write_Draw(unsigned char x,unsigned char y,signed char Asc)
{
  unsigned char Temp_i;
  unsigned char Temp_Char;
	y=y*8;

  Temp_Char=Asc;

  OLED_Set_Pos(y,x);
	for(Temp_i=0;Temp_i<8;Temp_i++)
	  OLED_Write_Data(Draw[Temp_Char*16+Temp_i]);
	OLED_Set_Pos(y,x+1);
	for(Temp_i=0;Temp_i<8;Temp_i++)
	  OLED_Write_Data(Draw[Temp_Char*16+Temp_i+8]);
}
unsigned int List_NUM = 88;
int Temp_List[88];
const unsigned char Change_To_Bit[8]=
{
  0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01
};
////###############λ################################
void List_Move(signed char New_Data)
{
	static signed int Temp_i;
	signed int Temp_j;

	if(Temp_i<List_NUM)
		Temp_List[Temp_i]=New_Data;
	else
	{
		for(Temp_j=0;Temp_j<List_NUM-1;Temp_j++)
		  Temp_List[Temp_j]=Temp_List[Temp_j+1];
		Temp_List[List_NUM-1]=New_Data;
	  }

	if(Temp_i>=List_NUM)
		Temp_i=List_NUM;
	else
		Temp_i++;
}
////######## Temp_Listбһͼ#################
void List_Paint(void)
{
	unsigned char Temp_i;
	unsigned char Cross1;

	for(Cross1=0;Cross1<=5;Cross1++)
	{
		OLED_Set_Pos(128-List_NUM,5-Cross1);
		for(Temp_i=0;Temp_i<List_NUM-1;Temp_i++)
		{
			if(Temp_List[Temp_i]>>3==Cross1)
			{
				OLED_Write_Data(Change_To_Bit[ Temp_List[Temp_i]&0x07 ]);
			}
			else
			{
				OLED_Write_Data(0x00);
			}
		}
	}
}
void Paint_List(float New_Data,float Paint_Ave,float Paint_Margin)
// ĳбˢµʽʾ
{
  unsigned char Temp_Data;

  Temp_Data=(signed char)((New_Data-Paint_Ave)/Paint_Margin);
  List_Move(Temp_Data);
  List_Paint();
}
/*-------------------*ͼ*-------------------*/
//Line_xΪλãLine_yStaΪʼУLine_yEndΪֹ
void Paint_Axis(signed char Line_x,signed char Line_ySta,signed char Line_yEnd)
{
  signed char Temp_j;//Temp_i,
  for(Temp_j=Line_ySta;Temp_j<Line_yEnd;Temp_j++)
  {
    OLED_Set_Pos(Line_x,Temp_j);
	OLED_Write_Data(0xff);

  }
}

/*****************oledʾ*****************************/
void oled_display(void)
{
	//OLED_P8x16Str(12,0,"Dollar Studio");
	//OLED_P8x16Str(24,2,"Derong_lin");
}

//===========================================================================
// No more.
//===========================================================================
