//############################################################################
//
// FILE:   Example_28xxxSD_SPI.c
//
// TITLE:  DSP280xx SD Card SPI Interface Example 
//
// ASSUMPTIONS:
//
//    This program uses the DSP280xx header files already included in the  
// 	  download. 
//
//	  An SD Card interface to SPI is also required to properly test
//	  this example. A reference design is supplied in the Application Note:
//	 "Interfacing SD/MMC Flash Memory Cards with F28xxx."
//
// DESCRIPTION:
//	 
//	 This project provides an example of how to write to an SD/MMC 
//	 Memory Card. This example shows how to check card insertion,
//	initialize card, read card registers, Read, Write, and Erase Data from 
//	SD/MMC Memory Card. In order to test data written, read, and erased,
//  place a breakpoint after each read command and select View -> Memory 
//	and specify &read_buffer.Data is written to card starting with 0 and incremented
//	by 1 for each value.
//		
//############################################################################		
// Original Author: Tim Love
// Release Date: July 2007
//############################################################################


/* ***********************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY, 
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS 
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR 
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. 
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET 
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY 
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR 
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, 
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY 
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED 
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT 
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM. 
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF 
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS 
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF 
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S 
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF 
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS 
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted 
* by Texas Instruments is distributed as "freeware".  You may, 
* only under TI's copyright in the Program, use and modify the 
* Program without any charge or restriction.  You may 
* distribute to third parties, provided that you transfer a 
* copy of this license to the third party and the third party 
* agrees to these terms by its first use of the Program. You 
* must reproduce the copyright notice and any other legend of 
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains 
* copyrighted material, trade secrets and other TI proprietary 
* information and is protected by copyright laws, 
* international copyright treaties, and trade secret laws, as 
* well as other intellectual property laws.  To protect TI's 
* rights in the Program, you agree not to decompile, reverse 
* engineer, disassemble or otherwise translate any object code 
* versions of the Program to a human-readable form.  You agree 
* that in no event will you alter, remove or destroy any 
* copyright notice included in the Program.  TI reserves all 
* rights not specifically granted under this license. Except 
* as specifically provided herein, nothing in this agreement 
* shall be construed as conferring by implication, estoppel, 
* or otherwise, upon you, any license or other right under any 
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
* ********************************************************* */


#include "SD.h"
#include "DSP280x_Device.h"
#include "DSP280x_Examples.h"

Uint16 read_buffer[1024], write_buffer[1024];

//################################## MAIN ####################################
void main(void)
{
	Uint16 i, testdata = 0x0000;

// 	Step 1. Initialize System Control:
//	PLL, WatchDog, enable Peripheral Clocks
// 	This example function is found in the DSP280x_SysCtrl.c file.
   	InitSysCtrl();

//	 Step 2. Initalize GPIO: 
// 	This example function is found in the DSP280x_Gpio.c file and
// 	illustrates how to set the GPIO to it's default state.
// 	InitGpio();  // Skipped for this example  
// 	Setup only the GP I/O only for SPI-A functionality
// 	This function is found in DSP280x_Spi.c
   	InitSpiaGpio();

// 	Step 3. Clear all interrupts and initialize PIE vector table:
// 	Disable CPU interrupts 
   	DINT;

// 	Initialize PIE control registers to their default state.
// 	The default state is all PIE interrupts disabled and flags
// 	are cleared.  
// 	This function is found in the DSP280x_PieCtrl.c file.
   	InitPieCtrl();

// 	Disable CPU interrupts and clear all CPU interrupt flags:
   	IER = 0x0000;
   	IFR = 0x0000;
   
// 	Initialize the PIE vector table with pointers to the shell Interrupt 
// 	Service Routines (ISR).  
// 	This will populate the entire table, even if the interrupt
// 	is not used in this example.  This is useful for debug purposes.
// 	The shell ISR routines are found in DSP280x_DefaultIsr.c.
// 	This function is found in DSP280x_PieVect.c.
   	InitPieVectTable();
	
// 	Step 4. Initialize all the Device Peripherals:
   	spi_initialization();					//Initialize SPI	

// 	Step 5. User specific code:	

	//Initialize test data for known data to transmit to card
	for(i=0;i<1024;i++)						 
	{										
		write_buffer[i] = testdata;
		testdata += 0x0100;			//Card accepts 8 bit data so upper 8 bits are used
	}

   	led_initialization();			//Initialize all LEDs
   	sd_card_insertion();			//Check for card insertion
	sd_initialization();			//Initialize card

	sd_read_register(SEND_CSD);		//Read CSD register
	sd_read_register(READ_OCR);		//Read OCR register
	sd_read_register(SEND_CID);		//Read CID register

	for(;;)
	{
	sd_write_block(SECTOR_ZERO, write_buffer);	//Write to sector specified
	sd_read_block(SECTOR_ZERO, read_buffer);	//Read from sector specified
    sd_erase_block(SECTOR_ZERO, 1);				//Erase sector range specified
	sd_read_block(SECTOR_ZERO, read_buffer);	//Read from sector specified
	}

	sd_write_multiple_block(SECTOR_ZERO, write_buffer, 2);	//Write to multiple sectors specified	
	sd_read_multiple_block(SECTOR_ZERO, read_buffer, 2);	//Read multiple sectors	specified										//Emulation stop
    sd_erase_block(SECTOR_ZERO, 2);							//Erase sectors range specified				
	sd_read_multiple_block(SECTOR_ZERO, read_buffer, 2);	//Read multiple sectors specified	
	
    asm(" ESTOP0");				//Emulation stop
   	for(;;){};					//Loop forever
} 	
//################################## MAIN ####################################

// Step 7. Insert all local Interrupt Service Routines (ISRs) and functions here:	


