#include "DSP2833x_Device.h"
#include "DSP2833x_Examples.h"
#include "DSP2833x_GlobalPrototypes.h"
#include "rtwtypes.h"
#include "Copy_of_c28335pmsmfocorigin.h"
#include "Copy_of_c28335pmsmfocorigin_private.h"

void disableWatchdog(void)
{
  int *WatchdogWDCR = (void *) 0x7029;
  asm(" EALLOW ");
  *WatchdogWDCR = 0x0068;
  asm(" EDIS ");
}

interrupt void EQEP1_INT_isr(void)
{
  volatile unsigned int EQep1_QFLG_Register = EQep1Regs.QFLG.all;
  isr_int5pie1_task_fcn();
  EQep1Regs.QCLR.all = EQep1_QFLG_Register;
  PieCtrlRegs.PIEACK.all = PIEACK_GROUP5;/* Acknowledge to receive more interrupts*/
}

interrupt void SEQ1INT_isr(void)
{
  isr_int1pie1_task_fcn();
  EALLOW;
  AdcRegs.ADCST.bit.INT_SEQ1_CLR = 1;
  EDIS;
  PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;/* Acknowledge to receive more interrupts*/
}

void enable_interrupts()
{
  EALLOW;
  PieVectTable.EQEP1_INT = &EQEP1_INT_isr;/* Hook interrupt to the ISR*/
  EDIS;
  PieCtrlRegs.PIEIER5.bit.INTx1 = 1;   /* Enable interrupt EQEP1_INT*/
  IER |= M_INT5;
  EALLOW;
  PieVectTable.SEQ1INT = &SEQ1INT_isr; /* Hook interrupt to the ISR*/
  EDIS;
  PieCtrlRegs.PIEIER1.bit.INTx1 = 1;   /* Enable interrupt SEQ1INT*/
  IER |= M_INT1;

  /* Enable global Interrupts and higher priority real-time debug events:*/
  EINT;                                /* Enable Global interrupt INTM*/
  ERTM;                                /* Enable Global realtime interrupt DBGM*/
}

void init_SCI(void)
{                                      /* initialize SCI & FIFO registers */
  EALLOW;

  /*
   * Initialize SCI_B with following parameters:
   *    BaudRate              : 9601
   *    CharacterLengthBits   : 8
   *    EnableLoopBack        : 0
   *    NumberOfStopBits      : 1
   *    ParityMode            : None
   *    SuspensionMode        : Free_run
   *    CommMode              : Raw_data
   */
  ScibRegs.SCICCR.bit.STOPBITS = 0;    /*Number of stop bits. (0: One stop bit, 1: Two stop bits)*/
  ScibRegs.SCICCR.bit.PARITY = 0;      /*Parity mode (0: Odd parity, 1: Even parity)*/
  ScibRegs.SCICCR.bit.PARITYENA = 0;   /*Enable Pary Mode */
  ScibRegs.SCICCR.bit.LOOPBKENA = 0;   /*Loop Back enable*/
  ScibRegs.SCICCR.bit.ADDRIDLE_MODE = 0;/*ADDR/IDLE Mode control*/
  ScibRegs.SCICCR.bit.SCICHAR = 7;     /*Character length*/
  ScibRegs.SCICTL1.bit.RXERRINTENA = 0;/*Disable receive error interrupt*/
  ScibRegs.SCICTL1.bit.SWRESET = 1;    /*Software reset*/
  ScibRegs.SCICTL1.bit.TXENA = 1;      /* SCI transmitter enable*/
  ScibRegs.SCICTL1.bit.RXENA = 0;      /* SCI receiver enable*/
  ScibRegs.SCIHBAUD = 7U;
  ScibRegs.SCILBAUD = 160U;

  /*Free run, continue SCI operation regardless of suspend*/
  ScibRegs.SCIPRI.bit.FREE = 1;        /* Free emulation mode control*/
  ScibRegs.SCIPRI.bit.SOFT = 0;        /* Interrupt priority select*/
  ScibRegs.SCIFFCT.bit.ABDCLR = 0;
  ScibRegs.SCIFFCT.bit.CDC = 0;
  ScibRegs.SCIFFTX.bit.SCIRST = 1;     /* SCI reset rx/tx channels*/
  ScibRegs.SCIFFTX.bit.SCIFFENA = 1;   /* SCI FIFO enhancements are enabled.*/
  ScibRegs.SCIFFTX.bit.TXFIFOXRESET = 1;/* Re-enable transmit FIFO operation.*/
  ScibRegs.SCIFFRX.bit.RXFIFORESET = 1;/* Re-enable receive FIFO operation.*/
  EDIS;
}

void init_SCI_GPIO(void)
{
  EALLOW;
  GpioCtrlRegs.GPAPUD.bit.GPIO9 = 0;   /*Enable pull-up for GPIO9*/
  GpioCtrlRegs.GPAMUX1.bit.GPIO9 = 2;  /*Configure GPIO9 as SCITXDB*/
  EDIS;
}
