/**
  ******************************************************************************
  * @file    main.c
  * @author  оԴӹ
  * @version V1.0
  * @date    2015-xx-xx
  * @brief   1xDC_SL
  ******************************************************************************
  * @attention
  *
  * ʵƽ̨:DRV8301 
  * Ա    :http://shop108568284.taobao.com
  *
  ******************************************************************************
  */

#include "DSP28x_Project.h"		// Device Header file and Examples Include File
#include "main.h"

union DRV8301_STATUS_REG_1	DRV8301_stat_reg1;
union DRV8301_STATUS_REG_2	DRV8301_stat_reg2;
union DRV8301_CONTROL_REG_1	DRV8301_cntrl_reg1;
union DRV8301_CONTROL_REG_2	DRV8301_cntrl_reg2;

//#define FLASH

#ifdef FLASH
#pragma CODE_SECTION(MainISR, "ramfuncs");
#endif

// Prototype statements for functions found within this file.
interrupt void MainISR(void);
interrupt void Cana_receive_isr(void);
void DRV8301_Configuration(void);
void Module_Init(void);
void decode(Uint32 Rxdata);

// Global variables used in this system
_iq VRef1 = _IQ(0.0);				// Motor 1 voltge reference (pu)
_iq Vtest = _IQ(0.0);
_iq test = _IQ(0.2);
_iq test1 = _IQ(0.0);
_iq IRef1 = _IQ(0.0);				// Motor 1 current reference (pu)
_iq PRef1 = _IQ(0.0);//_IQ(-0.53);
_iq IFdbk1;							// Motor 1 current feedback (pu)
_iq IFdbk1a;							// Phase 1 current feedback (pu)
_iq IFdbk1b;							// Phase 1 current feedback (pu)
_iq PosFbk;                          // Position feedback(pu)
_iq Delta;
_iq15 IFdbk1_dlog;

//not used for this project.  Save for future use
//_iq SpeedRef1 = _IQ(0.25);			// Motor 1 Speed reference (pu)
Uint16 Rotation1 = 1;				// Motor 1 PWM direction
Uint16 Positiondata = 0;
Uint16 MOTOR_DIRFLAG = 1;
Uint16 FRIST_FLAG = 0;
Uint16 GATEON_FLAG = 0;
Uint16 F_FLAG = 0;
Uint16 V_FLAG = 0;
Uint16 MessageReceivedCount = 0;
Uint32 DirFlag = 0;//left 0 & right 1
Uint32 ReadDataL = 0;
Uint32 ReadDataH = 0;
int32 AngleSet = 0;
float Position = 0;
long IsrTicker=0;

float32 T = 0.001/ISR_FREQUENCY;    // Samping period (sec), see parameter.h

#ifdef SARAM
int DlogCh1 = 0;
int DlogCh2 = 0;
int DlogCh3 = 0;
int DlogCh4 = 0;
#endif

Uint16 RunMotor = FALSE;

//not used for this project.  Save for future use
//Uint16 SpeedLoopPrescaler = 10;      // Speed loop prescaler
//Uint16 SpeedLoopCount = 1;           // Speed loop counter

// Instance PID regulators to regulate the current, and speed
PIDREG3 pid1_i = PIDREG3_DEFAULTS;
PI_CONTROLLER pi_i  = PI_CONTROLLER_DEFAULTS;
PI_CONTROLLER pi_pos  = PI_CONTROLLER_DEFAULTS;
//not used for this project.  Save for future use
//PIDREG3 pid1_spd = PIDREG3_DEFAULTS;

// Instance a PWM driver instance
PWMGEN pwm1 = PWMGEN_DEFAULTS;

//not used for this project.  Save for future use
// Instance a QEP interface driver
//QEP qep1 = QEP_DEFAULTS;

// Instance a ramp controller to smoothly ramp the frequency
RMPCNTL rc1 = RMPCNTL_DEFAULTS;

//not used for this project.  Save for future use
// Instance a ramp generator to simulate an Angle
//RAMPGEN rg1 = RAMPGEN_DEFAULTS;

//not used for this project.  Save for future use
// Instance a speed calculator based on QEP
//SPEED_MEAS_QEP speed1 = SPEED_MEAS_QEP_DEFAULTS;

#ifdef SARAM
// Create an instance of DATALOG Module
DLOG_4CH dlog = DLOG_4CH_DEFAULTS;
#endif

struct ECAN_REGS ECanaShadow;
void main(void)
{
//	Uint16 i;
//	Uint8 rxdata = 0;
//	char TxBuf[TXBUFLEN];

// Step 1. Initialize System Control:
// PLL, WatchDog, enable Peripheral Clocks
// This example function is found in the DSP2803x_SysCtrl.c file.
	InitSysCtrl();

#ifdef FLASH
// Copy time critical code and Flash setup code to RAM
// The  RamfuncsLoadStart, RamfuncsLoadEnd, and RamfuncsRunStart
// symbols are created by the linker. Refer to the linker files.
	MemCopy(&RamfuncsLoadStart, &RamfuncsLoadEnd, &RamfuncsRunStart);

// Call Flash Initialization to setup flash waitstates
// This function must reside in RAM
	InitFlash();	// Call the flash wrapper init function
#endif

// Step 2. Initialize GPIO:
// This example function is found in the DSP2803x_Gpio.c file and
// illustrates how to set the GPIO to it's default state.
	InitGpio();
	InitECanGpio();

// Step 3. Clear all interrupts and initialize PIE vector table:
// Disable CPU interrupts
	DINT;

// Initialize PIE control registers to their default state.
// The default state is all PIE interrupts disabled and flags
// are cleared.
// This function is found in the DSP2803x_PieCtrl.c file.
	InitPieCtrl();

// Disable CPU interrupts and clear all CPU interrupt flags:
	IER = 0x0000;
	IFR = 0x0000;

// Initialize the PIE vector table with pointers to the shell Interrupt
// Service Routines (ISR).
// This will populate the entire table, even if the interrupt
// is not used in this example.  This is useful for debug purposes.
// The shell ISR routines are found in DSP2803x_DefaultIsr.c.
// This function is found in DSP2803x_PieVect.c.
	InitPieVectTable();

// Interrupts that are used in this example are re-mapped to
// ISR functions found within this file.
	EALLOW;		// This is needed to write to EALLOW protected registers
	PieVectTable.EPWM1_INT = &MainISR;
	PieVectTable.ECAN0INTA = &Cana_receive_isr;
	EDIS;		// This is needed to disable write to EALLOW protected registers

// Step 4. Initialize all the Device Peripherals:
// This function is found in DSP2803x_InitPeripherals.c
// InitPeripherals(); // Not required for this example

	EALLOW;
	SysCtrlRegs.PCLKCR0.bit.ADCENCLK = 1;		// ADC
	SysCtrlRegs.PCLKCR1.bit.EPWM1ENCLK = 1;		// ePWM1
	SysCtrlRegs.PCLKCR1.bit.EPWM2ENCLK = 1;		// ePWM2
	SysCtrlRegs.PCLKCR1.bit.EPWM3ENCLK = 1;		// ePWM3
	SysCtrlRegs.PCLKCR0.bit.SCIAENCLK = 1;		// SCI-A
	SysCtrlRegs.PCLKCR0.bit.SPIBENCLK = 1;		// SPI-B
	SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;		// Enable TBCLK
	EDIS;

// Initialize ADC module (F2803XILEG_VDC.H)
	ADC_MACRO_INIT();

// Initialize SPI for communication to the DRV8301
	DRV8301_SPI_Init(&SpibRegs);

	EPwm1Regs.TBPRD = SYSTEM_FREQUENCY*1000000*T;
	EPwm1Regs.TBCTL.bit.CLKDIV = 0;									// Time-base Clock Prescale Bits: 1
	EPwm1Regs.TBCTL.bit.HSPCLKDIV = 0;								// High Speed Time-base Clock Prescale Bits: 1
	EPwm1Regs.TBCTL.bit.CTRMODE = 0;								// Counter Mode: Up-count mode

// Initialize eCAN-A module
	InitECana();
    ECanaMboxes.MBOX0.MSGID.all = 0x9555AAA0;
// MBOX0 is configurated as received MBOX
    ECanaRegs.CANMD.all = 0x00000001;
// Enable MBOX0
    ECanaRegs.CANME.all = 0x00000001;
// Specify that 8 bits will be sent/received
    ECanaMboxes.MBOX0.MSGCTRL.bit.DLC = 8;
// Interruption configuration
    EALLOW;
    ECanaRegs.CANMIM.all = 0x00000001;   //Enable MBOX0 interruption
    ECanaRegs.CANMIL.all = 0x00000000;   //Interruption appear in line0
    ECanaRegs.CANGIF0.all = 0xFFFFFFFF;
    ECanaRegs.CANGIM.bit.I0EN = 1;       //Enable line0 interruption
    EDIS;

// Initialize the PID_REG3 module for I
//	pid1_i.Kp = _IQ(0.442);		//for 12V DC bus
	pid1_i.Kp = _IQ(1);//_IQ(0.95);		//for 24V DC bus
	pid1_i.Ki = _IQ(0.000038);//_IQ(0.000048);//_IQ(T/0.0005);
	pid1_i.Kd =_IQ(0.0); //_IQ(0.001);
	pid1_i.Kc = _IQ(0.2);
	pid1_i.OutMax = _IQ(0.9);
	pid1_i.OutMin = _IQ(-0.9);

// Initialize the PI module for I
	pi_i.Kp=_IQ(0.75);
//	pi_i.Ki=_IQ(T/0.0005);
	pi_i.Ki=_IQ(0.0005);
	pi_i.Umax =_IQ(0.98);
	pi_i.Umin =_IQ(-0.98);

// Initialize the PI module for pos
	pi_pos.Kp=_IQ(3);						//NO.1 motor = _IQ(9);			NO.4 motor =_IQ(7);
//	pi_i.Ki=_IQ(T/0.0005);
	pi_pos.Ki=_IQ(0.00001);				//NO.1 motor = _IQ(0.00001);NO.4 motor = _IQ(0.00001));
	pi_pos.Umax =_IQ(0.9);
	pi_pos.Umin =_IQ(-0.9);

//not used for this project.  Save for future use
// Initialize the PID_REG3 module for speed
//	pid1_spd.Kp = _IQ(1.0);
//	pid1_spd.Ki = _IQ(T*SpeedLoopPrescaler/0.3);
//	pid1_spd.Kd = _IQ(0/(T*SpeedLoopPrescaler));
//	pid1_spd.Kc = _IQ(0.2);
//	pid1_spd.OutMax = _IQ(0.6);
//	pid1_spd.OutMin = _IQ(-0.6);

// Initialize PWM module
	pwm1.PeriodMax = SYSTEM_FREQUENCY*1000000*T/2;  // Prescaler X1 (T1), ISR period = T x 1
	PWM_INIT_MACRO(pwm1)

//not used for this project.  Save for future use
// Initialize QEP module
//	qep1.LineEncoder = 2048;
//	qep1.MechScaler = _IQ30(0.25/qep1.LineEncoder);
//	qep1.PolePairs = POLES/2;
//	qep1.CalibratedAngle = 0;
//	QEP_INIT_MACRO(qep1)

//not used for this project.  Save for future use
// Initialize the RAMPGEN module
//	rg1.StepAngleMax = _IQ(BASE_FREQ*T);

//not used for this project.  Save for future use
// Initialize the Speed module for QEP based speed calculation
//	speed1.K1 = _IQ21(1/(BASE_FREQ*T));
//	speed1.K2 = _IQ(1/(1+T*2*PI*5));  // Low-pass cut-off frequency
//	speed1.K3 = _IQ(1)-speed1.K2;
//	speed1.BaseRpm = 120*(BASE_FREQ/POLES);

// Initialize the SCI communication module
	SciaRegs.SCICCR.bit.SCICHAR = 7;
	SciaRegs.SCICTL1.bit.TXENA = 0;
	SciaRegs.SCICTL1.bit.RXENA = 1;
	SciaRegs.SCILBAUD = 0x0F;			// Baud Rate : 115200
	SciaRegs.SCICTL1.bit.SWRESET = 1;

// Enable PIE group 3 interrupt 1 for EPWM1_INT
	PieCtrlRegs.PIEIER3.bit.INTx1 = 1;
    PieCtrlRegs.PIEIER9.bit.INTx5 = 1;     //CAN LINE0 PIE

// Enable CNT_zero interrupt using EPWM1 Time-base
	EPwm1Regs.ETSEL.bit.INTEN = 1;   // Enable EPWM1INT generation
	EPwm1Regs.ETSEL.bit.INTSEL = 1;  // Enable interrupt CNT_zero event
	EPwm1Regs.ETPS.bit.INTPRD = 1;   // Generate interrupt on the 1st event
	EPwm1Regs.ETCLR.bit.INT = 1;     // Enable more interrupts

// Enable CPU INT3 for EPWM1_INT:
	IER |= M_INT3+M_INT9;

#ifdef SARAM
// Initialize DATALOG module
	dlog.iptr1 = &DlogCh1;
	dlog.iptr2 = &DlogCh2;
	dlog.iptr3 = &DlogCh3;
	dlog.iptr4 = &DlogCh4;
	dlog.trig_value = 0x05DC;
	dlog.size = 0x00c8;
	dlog.prescalar = 300;
	dlog.init(&dlog);
#endif

// Enable global Interrupts and higher priority real-time debug events:
	EINT;	// Enable Global interrupt INTM
	ERTM;	// Enable Global realtime interrupt DBGM

// Step 5. User specific code:
	while(1)
	{
		if (CpuTimer1.InterruptCount >= 5000)    //LED BLINK
		{
			CpuTimer1.InterruptCount = 0;
			if(FRIST_FLAG == 1)
				LED_BLINK
			else
				LED_ON
		}
//		if (GpioDataRegs.GPADAT.bit.GPIO22 == 1) //If GPIO22 is connected high Vcc , Voltage is controlled by user
//		{
//			if (SciaRegs.SCIRXST.bit.RXRDY == 1)
//				rxdata = SciaRegs.SCIRXBUF.bit.RXDT;
//			if (rxdata == 0xFF)
//				SciaRegs.SCICTL1.bit.TXENA = 1;
//			if (rxdata < 50)
//				VRef1 = Vtest;//_IQ(0.15);//_IQ(rxdata / 100.0);
//		}
//		else
//			VRef1 = _IQ(0.15);
		if(RunMotor == FALSE)
			 F_FLAG = 1;
		if(VRef1 > _IQ(0.01))
			V_FLAG = 1;
		if ((RunMotor == FALSE)&& (VRef1 > _IQ(0.01)))//(fabs(VRef1) > _IQ(0.01)))
		{
			GATE_ON
			GATEON_FLAG = 1;
			DELAY_US(50000);
			DRV8301_Configuration();
			Module_Init();
			RunMotor = TRUE;
			EALLOW;
			EPwm2Regs.TZCLR.bit.OST=1;
			EPwm3Regs.TZCLR.bit.OST=1;
			EDIS;
			DRV8301_stat_reg1.all = DRV8301_SPI_Read(&SpibRegs,STAT_REG_1_ADDR);
			DRV8301_stat_reg2.all = DRV8301_SPI_Read(&SpibRegs,STAT_REG_2_ADDR);
		}
		if ((RunMotor == TRUE) && (VRef1 < _IQ(0.01)))
		{
			GATE_OFF
			GATEON_FLAG = 0;
			RunMotor = FALSE;
			EALLOW;
			EPwm2Regs.TZFRC.bit.OST=1;
			EPwm3Regs.TZFRC.bit.OST=1;
		 	EDIS;
		}
//		if (CpuTimer2.InterruptCount >= 15)
//		{
//			CpuTimer2.InterruptCount = 0;
//			TxBuf[0] = 0xFE;
//			TxBuf[1] = 0xFE;
//			TxBuf[2] = (Uint16)(AdcResult.ADCRESULT4 * VCC_3V3 * 5L) >> 8;								// Ua * 4(V)
//			TxBuf[3] = (Uint16)(AdcResult.ADCRESULT5 * VCC_3V3 * 5L) >> 8;								// Ub * 4(V)
//			TxBuf[4] = (Uint16)(AdcResult.ADCRESULT6 * VCC_3V3 * 5L) >> 8;								// Uc * 4(V)
//			TxBuf[5] = (int16)((2048L - AdcResult.ADCRESULT1) * VCC_3V3 / SAMP_RES / DRV_GAIN) >> 8;	// Ib * 16(A)
//			TxBuf[6] = (int16)((2048L - AdcResult.ADCRESULT2) * VCC_3V3 / SAMP_RES / DRV_GAIN) >> 8;	// Ic * 16(A)
//			//TxBuf[7] = (Uint16)(fabs(speed1.SpeedRpm)) >> 4;											// MotorSpeed / 16(RPM)
//			TxBuf[7] = 0;
//			TxBuf[8] = (Uint16)(AdcResult.ADCRESULT3 * VCC_3V3 * 5L) >> 8;								// SupplyVoltage * 4(V)
//			TxBuf[9] = GetTemperatureC(AdcResult.ADCRESULT7);											// ChipTemperature()
//			for(i=0; i<TXBUFLEN; i++)
//				comPutChar(TxBuf[i]);
//		}
//		comTXD();
	}
}
interrupt void MainISR(void)
{
	CpuTimer1.InterruptCount++;
	CpuTimer2.InterruptCount++;
	if( FRIST_FLAG == 0 )
		IsrTicker++;
	else
		IsrTicker = 0;
//	GpioDataRegs.GPBSET.bit.GPIO44 = 1;
//	if (RunMotor == TRUE)
//	{
// =============================== LEVEL 1 ======================================
//	  Level 1 verifies the analog-to-digital conversion, offset compensation
// ==============================================================================
// TODO: LEVEL1

#if (BUILDLEVEL==LEVEL1)

// ------------------------------------------------------------------------------
//  Connect inputs of the RMP module and call the ramp control macro
// ------------------------------------------------------------------------------
		rc1.TargetValue = VRef1;
		RC_MACRO(rc1);

// ------------------------------------------------------------------------------
//  Measure phase currents, subtract the offset and normalize from (-0.5,+0.5) to (-1,+1).
// ------------------------------------------------------------------------------
		IFdbk1b=_IQ15toIQ((AdcResult.ADCRESULT2<<3)-_IQ15(0.5))<<1;
		IFdbk1a=_IQ15toIQ((AdcResult.ADCRESULT1<<3)-_IQ15(0.5))<<1;
		IFdbk1 = (IFdbk1a - IFdbk1b) >> 1;
		Positiondata = AdcResult.ADCRESULT4;
		PosFbk = _IQ15toIQ((AdcResult.ADCRESULT4<<3)-_IQ15(0.5))<<1;  //0.5ӦöӦǼõ0λ

// ------------------------------------------------------------------------------
//  Connect inputs of the PWM_DRV module and call the PWM signal generation macro
// ------------------------------------------------------------------------------
		pwm1.MfuncC1 = (int16)_IQtoIQ15(_IQabs(rc1.SetpointValue)); // MfuncC1 is in Q15
		PWM_MACRO(pwm1)							   	   // Calculate the new PWM compare values

if(VRef1 >= 0)
	MOTOR_DIRFLAG = 1;
else
	MOTOR_DIRFLAG = 0;

if (MOTOR_DIRFLAG == 0)
	{
		EPwm2Regs.AQCSFRC.bit.CSFA = 0;
	    EPwm2Regs.CMPA.half.CMPA = pwm1.PWM1out;
		GpioDataRegs.GPACLEAR.bit.GPIO3 = 1;
		EPwm3Regs.AQCSFRC.bit.CSFA = 1;
		GpioDataRegs.GPASET.bit.GPIO5 = 1;
	}
else
	{
		EPwm3Regs.AQCSFRC.bit.CSFA = 0;
		EPwm2Regs.AQCSFRC.bit.CSFA = 1;
		GpioDataRegs.GPASET.bit.GPIO3 = 1;
		EPwm3Regs.CMPA.half.CMPA = pwm1.PWM1out;
		GpioDataRegs.GPACLEAR.bit.GPIO5 = 1;
	}

#ifdef SARAM
// ------------------------------------------------------------------------------
//  Connect inputs of the DATALOG module
// ------------------------------------------------------------------------------
		IFdbk1_dlog = _IQ15mpy(_IQtoQ15(IFdbk1) , _IQ15(100));
		DlogCh1 = Positiondata;
		DlogCh2 = _IQtoQ15(IFdbk1a);
		DlogCh3 = _IQtoQ15(IFdbk1);
		DlogCh4 = _IQtoQ15(IFdbk1);
#endif
#endif // (BUILDLEVEL==LEVEL1)

// =============================== LEVEL 2 ======================================
//	  Level 2 runs two independent axes with closed loop current control
// ==============================================================================
// TODO: LEVEL2

#if (BUILDLEVEL==LEVEL2)

		test1 = -test;
// ------------------------------------------------------------------------------
//  Connect inputs of the RMP module and call the ramp control macro
// ------------------------------------------------------------------------------
		VRef1 = Vtest;//IRef1;//IRef1;
		rc1.TargetValue = IRef1;
		RC_MACRO(rc1)

// ------------------------------------------------------------------------------
//  Measure phase currents, subtract the offset and normalize from (-0.5,+0.5) to (-1,+1).
// ------------------------------------------------------------------------------
		IFdbk1b=_IQ15toIQ((AdcResult.ADCRESULT2<<3)-_IQ15(0.5))<<1;
		IFdbk1a=_IQ15toIQ((AdcResult.ADCRESULT1<<3)-_IQ15(0.5))<<1;
		IFdbk1 = (IFdbk1a - IFdbk1b) >> 1;
		PosFbk = _IQ15toIQ((AdcResult.ADCRESULT4<<3)-_IQ15(0.5))<<1;

// ------------------------------------------------------------------------------
//  Connect inputs of the PID_REG3 module and call the PID controller macro
// ------------------------------------------------------------------------------
//		pid1_i.Ref = rc1.SetpointValue;
//		pid1_i.Fdb = IFdbk1;
//		PID_MACRO(pid1_i)
		pi_i.Ref = IRef1;//rc1.SetpointValue;
		pi_i.Fbk = IFdbk1;
		PI_MACRO(pi_i)

// ------------------------------------------------------------------------------
//  Connect inputs of the PWM_DRV module and call the PWM signal generation macro
// ------------------------------------------------------------------------------
//update PWM for Motor 1
//		Vtest = _IQabs(pi_i.Out);//_IQabs(pid1_i.Out);
//		VRef1 = Vtest;//_IQabs(pid1_i.Out);
		pwm1.MfuncC1 = (int16)_IQtoIQ15(_IQabs(pi_i.Out));	// MfuncC1 is in Q15
		PWM_MACRO(pwm1)							   	   			// Calculate the new PWM compare values

if(pi_i.Out >= 0)
		MOTOR_DIRFLAG = 0;
else
		MOTOR_DIRFLAG = 1;

if (MOTOR_DIRFLAG == 0)
	{
		EPwm2Regs.AQCSFRC.bit.CSFA = 0;
		EPwm2Regs.CMPA.half.CMPA = pwm1.PWM1out;
		GpioDataRegs.GPACLEAR.bit.GPIO3 = 1;
		EPwm3Regs.AQCSFRC.bit.CSFA = 1;
		GpioDataRegs.GPASET.bit.GPIO5 = 1;
	}
else
	{
		EPwm3Regs.AQCSFRC.bit.CSFA = 0;
		EPwm2Regs.AQCSFRC.bit.CSFA = 1;
		GpioDataRegs.GPASET.bit.GPIO3 = 1;
		EPwm3Regs.CMPA.half.CMPA = pwm1.PWM1out;
		GpioDataRegs.GPACLEAR.bit.GPIO5 = 1;
	}

#ifdef SARAM
// ------------------------------------------------------------------------------
//    Connect inputs of the DATALOG module
// ------------------------------------------------------------------------------
		DlogCh1 = (int16)_IQtoIQ15(IFdbk1);
		DlogCh2 = (int16)_IQtoIQ15(IRef1);
		DlogCh3 = (int16)_IQtoIQ15(IFdbk1);
		DlogCh4 = (int16)_IQtoIQ15(IRef1);
#endif
#endif // (BUILDLEVEL==LEVEL2)

// =============================== LEVEL 3 ======================================
//	  Level 3 runs two closed loops of position and current
// ==============================================================================
// TODO: LEVEL3

#if (BUILDLEVEL==LEVEL3)

// ------------------------------------------------------------------------------
//  Measure phase currents and position, subtract the offset and normalize from (-0.5,+0.5) to (-1,+1).
// ------------------------------------------------------------------------------
if(IsrTicker < 100){
		IFdbk1b=_IQ15toIQ((AdcResult.ADCRESULT2<<3)-_IQ15(0.5))<<1;
		IFdbk1a=_IQ15toIQ((AdcResult.ADCRESULT1<<3)-_IQ15(0.5))<<1;
		IFdbk1 = (IFdbk1a - IFdbk1b) >> 1;
		PosFbk = _IQ15toIQ((AdcResult.ADCRESULT4<<3)-_IQ15(0.5))<<1;  //0.5ӦöӦǼõ0λ
}
if(IsrTicker > 0 && FRIST_FLAG == 0)
		PRef1 = PosFbk;

// ------------------------------------------------------------------------------
//  Connect inputs of the RMP module and call the ramp control macro
// ------------------------------------------------------------------------------
		VRef1 = Vtest;//IRef1;//IRef1;
//	    Position = (float)AngleSet;
//	    PRef1 = _IQ(Position/100);
		rc1.TargetValue = PRef1;
		RC_MACRO(rc1)
//		Delta = rc1.TargetValue - rc1.SetpointValue;
		if(IsrTicker > 0){
			Delta = rc1.TargetValue - rc1.SetpointValue;
			if(_IQabs(Delta) < _IQ(0.000105)){
				FRIST_FLAG = 1;
				Vtest = _IQ(0.1);
			}
		}

// ------------------------------------------------------------------------------
//  Measure phase currents and position, subtract the offset and normalize from (-0.5,+0.5) to (-1,+1).
// ------------------------------------------------------------------------------
//		IFdbk1b=_IQ15toIQ((AdcResult.ADCRESULT2<<3)-_IQ15(0.5))<<1;
//		IFdbk1a=_IQ15toIQ((AdcResult.ADCRESULT1<<3)-_IQ15(0.5))<<1;
//		IFdbk1 = (IFdbk1a - IFdbk1b) >> 1;
//		PosFbk = _IQ15toIQ((AdcResult.ADCRESULT4<<3)-_IQ15(0.5))<<1;  //0.5ӦöӦǼõ0λ

// ------------------------------------------------------------------------------
//  Connect inputs of the PID_REG3 module and call the PID controller macro
// ------------------------------------------------------------------------------
//		pid1_i.Ref = PRef1;//rc1.SetpointValue;
//		pid1_i.Fdb = PosFbk;
//		PID_MACRO(pid1_i)
if(IsrTicker == 0 && GATEON_FLAG == 1) {
		pi_pos.Ref = rc1.SetpointValue;//PRef1;//rc1.SetpointValue;
		pi_pos.Fbk = PosFbk;
		PI_MACRO(pi_pos)
// ------------------------------------------------------------------------------
//  Connect inputs of the PID_REG3 module and call the PID controller macro
// ------------------------------------------------------------------------------
//		pid1_i.Ref = rc1.SetpointValue;
//		pid1_i.Fdb = IFdbk1;
//		PID_MACRO(pid1_i)
		pi_i.Ref = -pi_pos.Out;//pid1_i.Out;//pi_pos.Out;  //No.1 motor positive; No.2 motor negative; No.3 motor negative;No.4 motor positive;
		pi_i.Fbk = IFdbk1;
		PI_MACRO(pi_i)

// ------------------------------------------------------------------------------
//  Connect inputs of the PWM_DRV module and call the PWM signal generation macro
// ------------------------------------------------------------------------------
//update PWM for Motor 1
//		Vtest = _IQabs(pi_i.Out);//_IQabs(pid1_i.Out);
//		VRef1 = Vtest;//_IQabs(pid1_i.Out);
		pwm1.MfuncC1 = (int16)_IQtoIQ15(_IQabs(pi_i.Out));	// MfuncC1 is in Q15
		PWM_MACRO(pwm1)							   	   			// Calculate the new PWM compare values

if(pi_i.Out >= 0)
		MOTOR_DIRFLAG = 0;
else
		MOTOR_DIRFLAG = 1;

if (MOTOR_DIRFLAG == 0)
	{
		EPwm2Regs.AQCSFRC.bit.CSFA = 0;
		EPwm2Regs.CMPA.half.CMPA = pwm1.PWM1out;
		GpioDataRegs.GPACLEAR.bit.GPIO3 = 1;
		EPwm3Regs.AQCSFRC.bit.CSFA = 1;
		GpioDataRegs.GPASET.bit.GPIO5 = 1;
	}
else
	{
		EPwm3Regs.AQCSFRC.bit.CSFA = 0;
		EPwm2Regs.AQCSFRC.bit.CSFA = 1;
		GpioDataRegs.GPASET.bit.GPIO3 = 1;
		EPwm3Regs.CMPA.half.CMPA = pwm1.PWM1out;
		GpioDataRegs.GPACLEAR.bit.GPIO5 = 1;
	}
}

#ifdef SARAM
// ------------------------------------------------------------------------------
//    Connect inputs of the DATALOG module
// ------------------------------------------------------------------------------
		DlogCh1 = (int16)_IQtoIQ15(PosFbk);
		DlogCh2 = (int16)_IQtoIQ15(IRef1);
		DlogCh3 = (int16)_IQtoIQ15(IFdbk1);
		DlogCh4 = (int16)_IQtoIQ15(IRef1);
#endif
#endif // (BUILDLEVEL==LEVEL2)
//}

#ifdef SARAM
// ------------------------------------------------------------------------------
//    Call the DATALOG update function.
// ------------------------------------------------------------------------------
	dlog.update(&dlog);
#endif

// Clear ADCINT1 flag reinitialize for next SOC
	AdcRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;

// Enable more interrupts from this timer
	EPwm1Regs.ETCLR.bit.INT = 1;

// Acknowledge interrupt to recieve more interrupts from PIE group 3
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;
}

interrupt void Cana_receive_isr(void)
{
	do
    {
		ECanaShadow.CANRMP.all = ECanaRegs.CANRMP.all;
    } while(ECanaShadow.CANRMP.bit.RMP0 == 0 );

    ECanaShadow.CANRMP.all = 0;
    ECanaShadow.CANRMP.bit.RMP0 = 1;
    ECanaRegs.CANRMP.all = ECanaShadow.CANRMP.all;

    ReadDataL =  ECanaMboxes.MBOX0.MDL.all;
    ReadDataH =  ECanaMboxes.MBOX0.MDH.all;
    MessageReceivedCount++;
    decode(ReadDataL);

    PieCtrlRegs.PIEACK.bit.ACK9 = 1;
    ECanaRegs.CANOPC.all = 0;
}

// TODO: decode

void decode(Uint32 Rxdata)
{
	Uint32 Temp;
	Temp = Rxdata & 0xFF000000;
	DirFlag = Temp & 0x80000000;
	if(DirFlag > 0)
		DirFlag = 1;
	else
		DirFlag = 0;
	Temp = Temp & 0x7F000000;
	AngleSet =Temp >> 24;
	if(AngleSet > 90)
		AngleSet = 90;
	if(DirFlag == 1) //left is positive, right is negative
		AngleSet = 0 - AngleSet;
}

void DRV8301_Configuration(void)
{
	DRV8301_cntrl_reg1.bit.GATE_CURRENT = 0;		// full current 1.7A
//	DRV8301_cntrl_reg1.bit.GATE_CURRENT = 1;		// med current 0.7A
//	DRV8301_cntrl_reg1.bit.GATE_CURRENT = 2;		// min current 0.25A
	DRV8301_cntrl_reg1.bit.GATE_RESET = 0;			// Normal Mode
	DRV8301_cntrl_reg1.bit.PWM_MODE = 0;			// six independant PWMs
//	DRV8301_cntrl_reg1.bit.OC_MODE = 0;				// current limiting when OC detected
	DRV8301_cntrl_reg1.bit.OC_MODE = 1;				// latched OC shutdown
//	DRV8301_cntrl_reg1.bit.OC_MODE = 2;				// Report on OCTWn pin and SPI reg only, no shut-down
//	DRV8301_cntrl_reg1.bit.OC_MODE = 3;				// OC protection disabled
//	DRV8301_cntrl_reg1.bit.OC_ADJ_SET = 0;			// OC @ Vds=0.060V
//	DRV8301_cntrl_reg1.bit.OC_ADJ_SET = 4;			// OC @ Vds=0.097V
//	DRV8301_cntrl_reg1.bit.OC_ADJ_SET = 6;			// OC @ Vds=0.123V
//	DRV8301_cntrl_reg1.bit.OC_ADJ_SET = 9;			// OC @ Vds=0.175V
	DRV8301_cntrl_reg1.bit.OC_ADJ_SET = 15;			// OC @ Vds=0.358V
//	DRV8301_cntrl_reg1.bit.OC_ADJ_SET = 16;			// OC @ Vds=0.403V
//	DRV8301_cntrl_reg1.bit.OC_ADJ_SET = 17;			// OC @ Vds=0.454V
//	DRV8301_cntrl_reg1.bit.OC_ADJ_SET = 18;			// OC @ Vds=0.511V
	DRV8301_cntrl_reg1.bit.Reserved = 0;

//	DRV8301_cntrl_reg2.bit.OCTW_SET = 0;			// report OT and OC
	DRV8301_cntrl_reg2.bit.OCTW_SET = 1;			// report OT only
#if DRV_GAIN == 10
	DRV8301_cntrl_reg2.bit.GAIN = 0;				// CS amplifier gain = 10
#elif DRV_GAIN == 20
	DRV8301_cntrl_reg2.bit.GAIN = 1;				// CS amplifier gain = 20
#elif DRV_GAIN == 40
	DRV8301_cntrl_reg2.bit.GAIN = 2;				// CS amplifier gain = 40
#elif DRV_GAIN == 80
	DRV8301_cntrl_reg2.bit.GAIN = 3;				// CS amplifier gain = 80
#endif
	DRV8301_cntrl_reg2.bit.DC_CAL_CH1 = 0;			// not in CS calibrate mode
	DRV8301_cntrl_reg2.bit.DC_CAL_CH2 = 0;			// not in CS calibrate mode
	DRV8301_cntrl_reg2.bit.OC_TOFF = 0;				// normal mode
	DRV8301_cntrl_reg2.bit.Reserved = 0;

	//write to DRV8301 control register 1, returns status register 1
	DRV8301_stat_reg1.all = DRV8301_SPI_Write(&SpibRegs,CNTRL_REG_1_ADDR,DRV8301_cntrl_reg1.all);
	//write to DRV8301 control register 2, returns status register 1
	DRV8301_stat_reg1.all = DRV8301_SPI_Write(&SpibRegs,CNTRL_REG_2_ADDR,DRV8301_cntrl_reg2.all);
}

void Module_Init(void)
{
	pid1_i.Err=0;
	pid1_i.Fdb=0;
	pid1_i.Out=0;
	pid1_i.Ud=0;
	pid1_i.Up=0;
	pid1_i.Ui=0;
	pid1_i.Up1=0;

	pi_i.i1=_IQ(0.0);
	pi_i.ui = _IQ(0.0);
	pi_i.up = _IQ(0.0);
	pi_i.v1 = _IQ(0.0);
	pi_i.Out = _IQ(0.0);

	pi_pos.i1=_IQ(0.0);
	pi_pos.ui = _IQ(0.0);
	pi_pos.up = _IQ(0.0);
	pi_pos.v1 = _IQ(0.0);
	pi_pos.Out = _IQ(0.0);

//	rc1.TargetValue=0;
//	rc1.SetpointValue=0;
}

//===========================================================================
// No more.
//===========================================================================
