/*
 * main.h
 *
 *  Created on: 2014-9-10
 *      Author: оԴӹ
 */

#ifndef MAIN_H_
#define MAIN_H_

#include "com.h"
#include "IQmathLib.h"
#include "DRV8301_SPI.h"
#include "f2803xpwm_2xDC.h"
#include "f2803xileg_vdc.h"
#include "f2803xqep.h"
#include "pid_reg3.h"
#include "pi.h"
#include "rampgen.h"
#include "rmp_cntl.h"
#include "speed_fr.h"
#include <math.h>

#ifdef SARAM
#include "dlog4ch.h"
#endif

/*------------------------------------------------------------------------------
Following is the list of the Build Level choices.
------------------------------------------------------------------------------*/
#define LEVEL1  1           // Verify ADC, calibrate the offset
#define LEVEL2  2           // Run 2 axes closed current(torque) loop
#define LEVEL3  3           // Run two closed loops of positon and current
/*------------------------------------------------------------------------------
This line sets the BUILDLEVEL to one of the available choices.
------------------------------------------------------------------------------*/
#define   BUILDLEVEL LEVEL3


#ifndef BUILDLEVEL
#error  Critical: BUILDLEVEL must be defined !!
#endif  // BUILDLEVEL
//------------------------------------------------------------------------------

#ifndef TRUE
#define FALSE 0
#define TRUE  1
#endif

#define PI 3.14159265358979

// Define the system frequency (MHz)
#define SYSTEM_FREQUENCY 60

// Define the ISR frequency (kHz)
#define ISR_FREQUENCY 10

//not used for this project.  Save for future use
//#define POLES   8						// Number of poles

// Define the base quantites
#define BASE_VOLTAGE    66.32		    // Base peak phase voltage (volt), maximum measurable DC Bus

// Options for BASE_CURRENT based on DRV830x current-sense amplifier gain setting
//#define DRV_GAIN	10
//#define DRV_GAIN	20
//#define DRV_GAIN	40
#define DRV_GAIN	80

#if DRV_GAIN == 10
#define BASE_CURRENT    82.5           	// Base peak phase current (amp) , maximum measurable peak current (with DRV830x gain set to 10)
#elif DRV_GAIN == 20
#define BASE_CURRENT    41.25          	// Base peak phase current (amp) , maximum measurable peak current (with DRV830x gain set to 20)
#elif DRV_GAIN == 40
#define BASE_CURRENT    20.625         	// Base peak phase current (amp) , maximum measurable peak current (with DRV830x gain set to 40)
#elif DRV_GAIN == 80
#define BASE_CURRENT    10.3125        	// Base peak phase current (amp) , maximum measurable peak current (with DRV830x gain set to 80)
#else
#error  Invalid GAIN selection !!
#endif

#define BASE_FREQ      	200           	// Base electrical frequency (Hz)

// Define the type of drive board
#define DRV_TYPE	0					// A, 500W
//#define DRV_TYPE	1					// B, 350W

// Defines the direction of rotation of motor
#define MOTOR_DIR	1					// CW
//#define MOTOR_DIR	1					// CCW

#define GATE_ON		GpioDataRegs.GPBSET.bit.GPIO40 = 1;
#define GATE_OFF	GpioDataRegs.GPBCLEAR.bit.GPIO40 = 1;
#define LED_ON		GpioDataRegs.GPBCLEAR.bit.GPIO34 = 1;
#define LED_OFF		GpioDataRegs.GPBSET.bit.GPIO34 = 1;
#define LED_BLINK	GpioDataRegs.GPBTOGGLE.bit.GPIO34 = 1;

#define VCC_3V3		3.32				// V

#if DRV_TYPE == 0
#define SAMP_RES	0.002				// 
#else
#define SAMP_RES	0.005				// 
#endif

#define TXBUFLEN	10

#endif /* MAIN_H_ */
