#include  "systemInit.h"
#include  "ssi.h"

#define  PART_LM3S8962
#include  "pin_map.h"



//  SSIʼ
void ssiInit(void)
{
    unsigned long ulBitRate = TheSysClock / 3;

    SysCtlPeriEnable(SYSCTL_PERIPH_SSI0);                   //  ʹSSIģ

    SysCtlPeriEnable(SSI0CLK_PERIPH);                       //  ʹSSI0ӿڵGPIO˿
    SysCtlPeriEnable(SSI0FSS_PERIPH);
    SysCtlPeriEnable(SSI0RX_PERIPH);
    SysCtlPeriEnable(SSI0TX_PERIPH);

    GPIOPinTypeSSI(SSI0CLK_PORT, SSI0CLK_PIN);              //  GPIOΪSSI
    GPIOPinTypeSSI(SSI0FSS_PORT, SSI0FSS_PIN);
    GPIOPinTypeSSI(SSI0RX_PORT, SSI0RX_PIN);
    GPIOPinTypeSSI(SSI0TX_PORT, SSI0TX_PIN);

    //  SSIãַIʽ/ģʽλʣݿ
    SSIConfig(SSI0_BASE, SSI_FRF_TI , SSI_MODE_MASTER, ulBitRate, 16);

    SSIEnable(SSI0_BASE);                                   //  ʹSSIշ
}


// ݰҪװ÷͵DA
//mode 0  ͵Aͨ
//mode 1 ͵Bͨ
void mod_ssi(unsigned *data)
{
  
}
void data_out(unsigned int ucData , unsigned char mode)
{
  unsigned int tmode;
    if(mode==0)
    {
      tmode=0x0a;
    }
    else if(mode==1)
    {
       tmode=0x04; 
    }
    ucData=ucData|(tmode<<12);
    SSIDataPutNonBlocking(SSI0_BASE, ucData);                               //  ͨSSIݵ74HC595
}


//  ڣ
void main(void)
{
    unsigned char i;

    
    clockInit();                                            //  ʱӳʼ6MHz
    ssiInit();                                              //  SSIʼ

    for (;;)
    {
        for (i = 0;  i < 16;  i++)                          //  ѭʾ
        {
            data_out(0xaa , 0);
            SysCtlDelay(500 * (TheSysClock / 3000));
            data_out(0xaa , 1);
        }
   }
}

