//*****************************************************************************
//
// blinky.c - Simple example to blink the on-board LED.
//
// Copyright (c) 2007-2009 Luminary Micro, Inc.  All rights reserved.
// Software License Agreement
// 
// Luminary Micro, Inc. (LMI) is supplying this software for use solely and
// exclusively on LMI's microcontroller products.
// 
// The software is owned by LMI and/or its suppliers, and is protected under
// applicable copyright laws.  All rights are reserved.  You may not combine
// this software with "viral" open-source software in order to form a larger
// program.  Any use in violation of the foregoing restrictions may subject
// the user to criminal sanctions under applicable laws, as well as to civil
// liability for the breach of the terms and conditions of this license.
// 
// THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
// OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
// LMI SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
// CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 4423 of the EK-LM3S8962 Firmware Package.
//
//*****************************************************************************
#include "pbdata.h"
void RCC_Configuration(void);
void GPIO_Configuration(void);
//#include "lm3s8962.h"

//*****************************************************************************
//
//! \addtogroup example_list
//! <h1>Blinky (blinky)</h1>
//!
//! A very simple example that blinks the on-board LED.
//
//*****************************************************************************

//*****************************************************************************
//
// Blink the on-board LED.
//
//*****************************************************************************
int main(void)
{
//		RCC_Configuration();
//		GPIO_Configuration();
    while(1)
    {
     GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_4, 0x00);
	   SysCtlDelay(1000 * (SysCtlClockGet() / 3000));//1000????
	  //10????  SysCtlDelay(10 * (SysCtlClockGet() / 3000000))
       GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_4, 0xff);
      SysCtlDelay(1000 * (SysCtlClockGet() / 3000));   
    }
}
void RCC_Configuration(void)
{
 	SysCtlClockSet(SYSCTL_SYSDIV_4|SYSCTL_USE_PLL
									|SYSCTL_OSC_MAIN
									|SYSCTL_XTAL_8MHZ); 
  SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);	
}

void GPIO_Configuration(void)
{
 GPIODirModeSet(GPIO_PORTA_BASE, GPIO_PIN_4, GPIO_DIR_MODE_IN);
 GPIOPadConfigSet(GPIO_PORTA_BASE, 
								  GPIO_PIN_4, 
									GPIO_STRENGTH_4MA, 
									GPIO_PIN_TYPE_STD);
}






