


#include<stdio.h>


// ʹҪͷļ
#include "inc/hw_types.h"
#include "inc/hw_memmap.h"
#include "inc/hw_ints.h"


// ϵͳй
#include "driverlib/sysctl.h" 
#include "driverlib/systick.h"

// GPIOй
#include "driverlib/gpio.h" 
#include "driverlib/uart.h"   
#include "driverlib/interrupt.h" 

// ledڶ˿ڼ
#define GPIO_LED_SYSCTL_PERIPH  SYSCTL_PERIPH_GPIOB
#define GPIO_LED_PORT_BASE      GPIO_PORTB_BASE
#define GPIO_LED_PIN           (GPIO_PIN_6)

unsigned char  c;

void putstring(const char *x)
{
	while(*x!='\0')
	{
		UARTCharPut(UART1_BASE,*(x++));	   //ͨUARTַ
	}
}

void delay_ms(unsigned long ms)
{
  unsigned long t;

  t =  ms * (SysCtlClockGet() / 3000);
  SysCtlDelay(t); //3 cycles

  return;
}


void GPIOSetOutput(unsigned long port, unsigned char pins)
{
  GPIOPinTypeGPIOOutput(port, pins); //output
  GPIOPadConfigSet(port, pins, GPIO_STRENGTH_4MA, GPIO_PIN_TYPE_STD); //push-pull

  return;
}


void GPIOSetInput(unsigned long port, unsigned char pins)
{
  GPIOPinTypeGPIOInput(port, pins); //input
  GPIOPadConfigSet(port, pins, GPIO_STRENGTH_2MA, GPIO_PIN_TYPE_STD_WPU); //pullup

  return;
}


//-----------------------------------------------------------------------------
//
//   :  fn_uart1_init 
//   :  uart1ʼ趨˿PB0PB5ΪUARTܣ576008-N-1
//
//   :  
//
// ز  :  
// 
//-----------------------------------------------------------------------------
void fn_uart1_init(void)
{
    // Uart1ţ(PB0PB5)
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOB); 
    GPIOSetInput(GPIO_PORTB_BASE, GPIO_PIN_0); //PB0:UART0_Rx = input
    GPIOSetOutput(GPIO_PORTB_BASE, GPIO_PIN_5); //PB5:UART0_Tx, PB6:LED = output	

    // ΪRxTx   
    GPIOPinTypeUART(GPIO_PORTB_BASE, GPIO_PIN_0 | GPIO_PIN_5); 

    // ʹUartʱ
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART1); 
	
    // U1 Pin
   	GPIOPinConfigure(GPIO_PB0_U1RX);
    GPIOPinConfigure(GPIO_PB5_U1TX);
	
    SysCtlPeripheralReset(SYSCTL_PERIPH_UART1);	
    
    // uart1Ĳ 1152008λ1ֹͣλУ
    UARTConfigSetExpClk(UART1_BASE, SysCtlClockGet(), 115200,
                       (UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE |
                        UART_CONFIG_PAR_NONE)); 
//	   UARTFIFOLevelSet(UART1_BASE ,                       /*  ÷ͺͽյFIFO    */
//                     UART_FIFO_TX7_8 ,
//                     UART_FIFO_RX1_8);
                                                             
    // ʹܽжϺͽܳʱж
    UARTIntEnable(UART1_BASE,UART_INT_RT | UART_INT_RX);         
    
    // Uart
    UARTEnable(UART1_BASE); 	
  
    // ʹUartж
    IntEnable(INT_UART1);                                           
}

//-----------------------------------------------------------------------------
//
//   :  fn_uart1_send_str 
//   :  uart1ַ
//
//   :  
//
// ز  :  
// 
//-----------------------------------------------------------------------------
void fn_uart1_send_str(unsigned char *p_char,unsigned char count)
{
   unsigned char i;
   for(i = 0;i < count; i++)
   {
      // ַ
    UARTCharPut(UART1_BASE,*p_char++);  
   }
}

//-----------------------------------------------------------------------------
//
//   :  fn_uart1_interrupt 
//   :  uart1жϷ
//
//   :  
//
// ز  :  
// 
//-----------------------------------------------------------------------------
void fn_uart1_interrupt(void)
{
   // жϱ־
   UARTIntClear(UART1_BASE,UART_INT_RT | UART_INT_RX);    
   
   // յݾͽݷ       
   if(UARTCharsAvail(UART1_BASE))                                
   {
      // 
    UARTCharPutNonBlocking(UART1_BASE,UARTCharGetNonBlocking(UART1_BASE));
		 
   }
}


//unsigned long Sysclk;

//-----------------------------------------------------------------------------
//
//   :  main 
//   :  򵥵GPIOƺUARTշԳ
//
//   :  
//
// ز  :  
// 
//-----------------------------------------------------------------------------
int main (void)
{
    // ϵͳʱwΪ10M, ʹⲿ8M

    SysCtlClockSet(SYSCTL_SYSDIV_1 | SYSCTL_USE_OSC | SYSCTL_XTAL_8MHZ |
                   SYSCTL_OSC_MAIN);
/*
	  SysCtlLDOSet(SYSCTL_LDO_2_75V);
	  SysCtlClockSet(SYSCTL_XTAL_8MHZ |
	  SYSCTL_SYSDIV_20 |                    // 200/20
	  SYSCTL_USE_PLL |
	  SYSCTL_OSC_MAIN );	
*/
	
// 	  Sysclk=SysCtlClockGet();

    // ʹܶ˿PBȻPB.4Ϊ
    SysCtlPeripheralEnable(GPIO_LED_SYSCTL_PERIPH);
    GPIOPinTypeGPIOOutput(GPIO_LED_PORT_BASE, GPIO_LED_PIN);
	
	 // ϵͳʼ 
  //  fn_system_clk_init();

    // uart0ʼ
		UARTIntRegister(UART1_BASE,fn_uart1_interrupt);
    fn_uart1_init();

    // ʹж
    IntMasterEnable();                                           
    
    // ʾ뷢ַ 
    fn_uart1_send_str((unsigned char *)"Enter text: \n", 14);   



    // LED
    while(1)
    { 
      			
        // PB.6Ϊ͵ƽ
        GPIOPinWrite(GPIO_LED_PORT_BASE, GPIO_LED_PIN, 0);

        // ʱ500ms
        delay_ms(500);
			
			  // PB.6Ϊߵƽ
        GPIOPinWrite(GPIO_LED_PORT_BASE, GPIO_LED_PIN, GPIO_LED_PIN);

        // ʱ500ms
        delay_ms(500);


    }
		
}


