//*****************************************************************************
//
// images.c - Data for the images used by the application.
//
// Copyright (c) 2008-2012 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 9453 of the RDK-IDM Firmware Package.
//
//*****************************************************************************

#include "grlib/grlib.h"

//*****************************************************************************
//
// The image of the TI symbol.
//
//*****************************************************************************
const unsigned char g_pucLogo[] =
{
    IMAGE_FMT_4BPP_COMP,
    50, 0,
    50, 0,

    15,
    0x00, 0x00, 0x00,
    0x03, 0x02, 0x13,
    0x07, 0x05, 0x2a,
    0x0a, 0x08, 0x41,
    0x0d, 0x0a, 0x55,
    0x10, 0x0c, 0x68,
    0x12, 0x0e, 0x74,
    0x15, 0x10, 0x88,
    0x17, 0x12, 0x97,
    0x19, 0x14, 0xa7,
    0x1c, 0x16, 0xb8,
    0x1e, 0x18, 0xc8,
    0x20, 0x19, 0xd6,
    0x22, 0x1b, 0xe1,
    0x24, 0x1c, 0xe9,
    0x24, 0x1c, 0xed,

    0xf0, 0x07, 0x07, 0x07, 0x02, 0x04, 0xba, 0xaa, 0xaa, 0x18, 0xaa, 0xac,
    0x30, 0x07, 0x07, 0x05, 0xff, 0xff, 0x0f, 0xff, 0xff, 0xff, 0x40, 0x3f,
    0x3f, 0x3f, 0x3f, 0xc7, 0x3f, 0x3d, 0x48, 0x78, 0x50, 0x3f, 0x3f, 0x3a,
    0x1c, 0xbf, 0xff, 0x70, 0x3f, 0x3f, 0x39, 0x01, 0xdf, 0xe0, 0x12, 0x3f,
    0x3f, 0x00, 0x04, 0xff, 0xff, 0x20, 0xe1, 0x3f, 0x3f, 0x39, 0x03, 0x97,
    0x87, 0x10, 0x3f, 0xf8, 0x3f, 0x39, 0x5f, 0x3f, 0x3b, 0x96, 0x82, 0x06,
    0x00, 0x87, 0x84, 0x04, 0x87, 0x77, 0x77, 0x78, 0x30, 0xc0, 0x3f, 0x3b,
    0xff, 0xd1, 0x0d, 0xff, 0xf5, 0x09, 0xb0, 0xaa, 0x60, 0x3f, 0x3c, 0xa0,
    0x2f, 0xff, 0xf2, 0x60, 0x0c, 0x3f, 0x3f, 0xff, 0xff, 0x80, 0x4f, 0xff,
    0x30, 0xc0, 0x1e, 0x3f, 0x3f, 0xff, 0xff, 0x50, 0x7f, 0x18, 0xff, 0x90,
    0x4f, 0x3f, 0x3f, 0xfd, 0xef, 0x20, 0x06, 0xaf, 0xff, 0x70, 0x7f, 0xdd,
    0x3f, 0x3e, 0xb2, 0x01, 0x12, 0x01, 0xcf, 0xff, 0x50, 0x12, 0x07, 0x3f,
    0x80, 0x3e, 0x80, 0x00, 0x03, 0xff, 0xff, 0x30, 0x00, 0x5a, 0x08, 0x39,
    0x70, 0x3f, 0x3a, 0x60, 0x01, 0xfc, 0x10, 0x10, 0x00, 0x1b, 0x39, 0xb0,
    0x00, 0x00, 0x8c, 0x02, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xab, 0x3a, 0x40,
    0x01, 0x00, 0x07, 0xff, 0xfa, 0x00, 0x00, 0x2f, 0x39, 0x0c, 0xf6, 0x00,
    0x00, 0x7f, 0x6a, 0x4a, 0xff, 0xfd, 0x00, 0x20, 0x00, 0x0a, 0xff, 0xf7,
    0x00, 0x00, 0x4f, 0x84, 0x39, 0xfe, 0x40, 0x00, 0x29, 0x3f, 0xfe, 0xab,
    0x01, 0xa0, 0x1c, 0xff, 0xf4, 0x08, 0xca, 0xcf, 0x72, 0x08, 0xf7, 0x00,
    0x02, 0xdf, 0x37, 0xff, 0xb0, 0x2f, 0x10, 0xff, 0xf2, 0x0c, 0x8c, 0xf7,
    0x00, 0x00, 0x3f, 0x81, 0x3f, 0xff, 0x80, 0x4f, 0xff, 0xc0, 0x2e, 0x3f,
    0x20, 0x02, 0xcf, 0x37, 0x50, 0x8f, 0xff, 0xa0, 0x4f, 0x90, 0x3f, 0x00,
    0x2c, 0x3f, 0x30, 0xaf, 0xff, 0x70, 0x48, 0x7f, 0x3f, 0x00, 0x02, 0x3e,
    0xfd, 0x10, 0xcf, 0x11, 0xff, 0x40, 0x9f, 0x3f, 0x00, 0x00, 0x8f, 0x35,
    0x02, 0xfa, 0x02, 0xff, 0xfe, 0x20, 0xcf, 0x3f, 0x00, 0x20, 0x00, 0x2f,
    0x3d, 0xf8, 0x05, 0xff, 0xfd, 0x00, 0xd0, 0x3f, 0x31, 0x09, 0x3d, 0xf5,
    0x03, 0x54, 0x53, 0x12, 0x00, 0x34, 0x6e, 0x3f, 0x00, 0x04, 0x39, 0xfa,
    0x09, 0x9c, 0xff, 0xff, 0xf3, 0x9a, 0x00, 0x3f, 0x3a, 0x20, 0xa6, 0x31,
    0xa3, 0xaf, 0xff, 0xfe, 0x30, 0x01, 0x10, 0xbf, 0xff, 0xd1, 0x3b, 0x7f,
    0xff, 0xff, 0xfd, 0x40, 0x72, 0x4b, 0x00, 0x00, 0x2c, 0xff, 0xe3, 0x00,
    0x08, 0x00, 0x2d, 0xff, 0xe1, 0x3b, 0x9f, 0xff, 0xfe, 0x40, 0x71, 0x45,
    0x00, 0x01, 0x68, 0x20, 0x00, 0x00, 0x11, 0x06, 0xff, 0xf6, 0xa3, 0xbf,
    0xff, 0xb2, 0x46, 0x80, 0x15, 0xbf, 0xff, 0x94, 0x33, 0x22, 0x22, 0x23,
    0x30, 0xef, 0xf8, 0x47, 0x05, 0x6f, 0xff, 0xff, 0xfe, 0x06, 0xee, 0xee,
    0xee, 0xff, 0x70, 0x3f, 0x05, 0x1c, 0x16, 0xff, 0xff, 0xff, 0xe9, 0xf9,
    0x47, 0x06, 0x07, 0xb2, 0x3c, 0xc1, 0x3f, 0x06, 0x02, 0xdf, 0x33, 0x50,
    0xd3, 0x3f, 0x07, 0x7f, 0x3a, 0xfc, 0x10, 0x3f, 0x07, 0x59, 0x2d, 0x3a,
    0xf9, 0x47, 0x07, 0x00, 0x05, 0x3a, 0x62, 0xf7, 0x3f, 0x07, 0x00, 0x00,
    0x9f, 0x31, 0xf8, 0xc5, 0x3f, 0x07, 0x00, 0x00, 0x0a, 0x39, 0xf9, 0x3f,
    0xc1, 0x07, 0x01, 0x9f, 0xff, 0xff, 0xfc, 0x10, 0x37, 0x80, 0x07, 0x00,
    0x00, 0x06, 0xdf, 0xff, 0xff, 0x50, 0xe1, 0x3f, 0x07, 0x01, 0x15, 0x78,
    0x86, 0x20, 0x3f, 0xff, 0x07, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x00, 0x00,
};

//*****************************************************************************
//
// This is the image of a red LED that is turned off.
//
//*****************************************************************************
const unsigned char g_pucLightOff[] =
{
    IMAGE_FMT_4BPP_COMP,
    20, 0,
    20, 0,

    15,
    0x00, 0x00, 0x00,
    0x00, 0x00, 0x09,
    0x00, 0x00, 0x19,
    0x00, 0x00, 0x2a,
    0x00, 0x00, 0x30,
    0x00, 0x00, 0x34,
    0x00, 0x00, 0x37,
    0x00, 0x00, 0x3a,
    0x00, 0x00, 0x3d,
    0x00, 0x00, 0x3f,
    0x00, 0x00, 0x40,
    0x00, 0x00, 0x42,
    0x00, 0x00, 0x45,
    0x00, 0x00, 0x4a,
    0x00, 0x00, 0x50,
    0x00, 0x00, 0x56,

    0x84, 0x01, 0x13, 0xaf, 0xe8, 0x31, 0x03, 0x1b, 0xff, 0x08, 0xff, 0xee,
    0xed, 0x71, 0x01, 0x02, 0xff, 0xff, 0x00, 0xfe, 0xed, 0xdd, 0xcc, 0x20,
    0x00, 0x00, 0x2f, 0x00, 0xff, 0xfe, 0xee, 0xdd, 0xcc, 0xcb, 0xa2, 0x00,
    0x40, 0x01, 0x21, 0xdd, 0xdc, 0xcc, 0xbb, 0xa8, 0x10, 0x00, 0x09, 0xff,
    0xfe, 0xdd, 0xdc, 0xcb, 0xbb, 0xba, 0x00, 0x98, 0x30, 0x1e, 0xfe, 0xed,
    0xdc, 0xcb, 0xaa, 0x00, 0xaa, 0xaa, 0x98, 0x61, 0x3e, 0xfe, 0xdd, 0xcc,
    0x00, 0xba, 0x99, 0x9a, 0xaa, 0x98, 0x62, 0x7d, 0xee, 0x00, 0xdc, 0xcb,
    0xa9, 0x99, 0x99, 0x99, 0x88, 0x73, 0x08, 0xcd, 0xed, 0xdc, 0xba, 0xb9,
    0x99, 0x88, 0x64, 0x20, 0xcc, 0xdd, 0x6b, 0x99, 0x87, 0x63, 0x6c, 0xcc,
    0x40, 0xba, 0x1a, 0x98, 0x76, 0x42, 0x2b, 0xba, 0xaa, 0x88, 0x1b, 0x65,
    0x42, 0x1a, 0x2a, 0x99, 0x98, 0x87, 0x00, 0x64, 0x30, 0x04, 0x78, 0x88,
    0x88, 0x89, 0x99, 0x00, 0x88, 0x76, 0x54, 0x20, 0x01, 0x67, 0x77, 0x88,
    0x00, 0x88, 0x88, 0x87, 0x65, 0x43, 0x00, 0x00, 0x25, 0x00, 0x67, 0x77,
    0x77, 0x77, 0x65, 0x44, 0x31, 0x00, 0x00, 0x00, 0x01, 0x45, 0x66, 0x66,
    0x65, 0x54, 0x43, 0x00, 0x10, 0x00, 0x00, 0x00, 0x13, 0x44, 0x45, 0x44,
    0x20, 0x33, 0x20, 0xb9, 0x00, 0x00, 0x12, 0x23, 0x32, 0x80, 0x72,
};

//*****************************************************************************
//
// This is the image of a red LED that is turned on.
//
//*****************************************************************************
const unsigned char g_pucLightOn[] =
{
    IMAGE_FMT_4BPP_COMP,
    20, 0,
    20, 0,

    15,
    0x00, 0x00, 0x00,
    0x00, 0x00, 0x16,
    0x00, 0x00, 0x40,
    0x00, 0x00, 0x76,
    0x00, 0x00, 0x9b,
    0x00, 0x00, 0xac,
    0x00, 0x00, 0xb6,
    0x00, 0x00, 0xbc,
    0x00, 0x00, 0xbe,
    0x00, 0x00, 0xbf,
    0x00, 0x00, 0xc1,
    0x00, 0x00, 0xc5,
    0x00, 0x00, 0xcd,
    0x00, 0x00, 0xdb,
    0x00, 0x00, 0xef,
    0x00, 0x00, 0xfc,

    0x84, 0x01, 0x13, 0xaf, 0xe7, 0x31, 0x03, 0x1b, 0xff, 0x09, 0xff, 0xee,
    0xee, 0x51, 0x01, 0x02, 0xff, 0xb1, 0x02, 0xdd, 0xcc, 0x20, 0x00, 0x00,
    0x2f, 0xbb, 0xcc, 0x10, 0x92, 0x00, 0x01, 0x72, 0xdc, 0xcc, 0xcb, 0x96,
    0x00, 0x10, 0x07, 0xff, 0xfe, 0xed, 0xdc, 0xcc, 0xbb, 0x08, 0xba, 0x96,
    0x30, 0x1e, 0x22, 0xba, 0xaa, 0xaa, 0x10, 0x86, 0x51, 0x3e, 0x69, 0xba,
    0x99, 0x99, 0x99, 0x01, 0x76, 0x52, 0x5d, 0xee, 0xdd, 0xcb, 0xa9, 0xb2,
    0x20, 0x53, 0xcd, 0x6c, 0x98, 0x76, 0x54, 0xcc, 0xdd, 0x40, 0xcc, 0x6a,
    0x97, 0x66, 0x43, 0x5c, 0xcc, 0xba, 0x40, 0x98, 0x19, 0x87, 0x65, 0x43,
    0x3c, 0xcb, 0xa9, 0x20, 0x98, 0x89, 0x1a, 0x42, 0x1a, 0x88, 0x98, 0x77,
    0x40, 0x88, 0x69, 0x44, 0x31, 0x04, 0x67, 0x77, 0x77, 0x00, 0x78, 0x88,
    0x76, 0x55, 0x44, 0x20, 0x01, 0x55, 0x00, 0x66, 0x66, 0x77, 0x77, 0x65,
    0x54, 0x43, 0x10, 0x00, 0x00, 0x24, 0x55, 0x55, 0x66, 0x65, 0x54, 0x44,
    0x00, 0x31, 0x00, 0x00, 0x02, 0x44, 0x45, 0x55, 0x54, 0x00, 0x44, 0x33,
    0x10, 0x00, 0x00, 0x00, 0x13, 0x44, 0x08, 0x44, 0x44, 0x33, 0x21, 0xb9,
    0x00, 0x00, 0x12, 0x10, 0x33, 0x32, 0x20, 0xba,
};

//*****************************************************************************
//
// This is the image of the blue push button background.
//
//*****************************************************************************
const unsigned char g_pucBlue50x50[] =
{
    IMAGE_FMT_4BPP_COMP,
    50, 0,
    50, 0,

    15,
    0x00, 0x00, 0x00,
    0x23, 0x00, 0x00,
    0x52, 0x00, 0x00,
    0x63, 0x00, 0x00,
    0x6f, 0x00, 0x00,
    0x78, 0x00, 0x00,
    0x7c, 0x00, 0x00,
    0x7d, 0x00, 0x00,
    0x7f, 0x00, 0x00,
    0x81, 0x00, 0x00,
    0x85, 0x00, 0x00,
    0x89, 0x00, 0x00,
    0x8d, 0x00, 0x00,
    0x93, 0x00, 0x00,
    0x9b, 0x00, 0x00,
    0xa9, 0x00, 0x00,

    0x81, 0x03, 0x13, 0x9e, 0xfe, 0xff, 0xff, 0xff, 0xe9, 0x8a, 0xd1, 0xfe,
    0xd7, 0x31, 0x07, 0x2e, 0x51, 0xee, 0x35, 0xee, 0xee, 0xe9, 0xd4, 0xa2,
    0x35, 0x1e, 0x41, 0x41, 0xfe, 0x3f, 0xee, 0xee, 0xdd, 0xcc, 0x91, 0x33,
    0x40, 0x03, 0x41, 0xee, 0xee, 0xed, 0xdd, 0xdd, 0xdd, 0xc1, 0xe9, 0xd1,
    0xdc, 0xcd, 0xcc, 0xaa, 0x20, 0x32, 0x41, 0x3f, 0x41, 0xed, 0xdc, 0xcc,
    0xcc, 0xcc, 0xe9, 0x81, 0xd1, 0xbb, 0xbb, 0xcc, 0xcb, 0xba, 0x52, 0x39,
    0x40, 0x03, 0x42, 0xcc, 0xba, 0xaa, 0x99, 0x99, 0x99, 0xc0, 0xe9, 0xd1,
    0xaa, 0xaa, 0xab, 0xa9, 0x95, 0x20, 0x04, 0x00, 0x00, 0x1f, 0xff, 0xfe,
    0x41, 0x99, 0x98, 0x1c, 0x88, 0x88, 0x88, 0xe9, 0xd1, 0x29, 0x99, 0x98,
    0x00, 0x41, 0x00, 0x00, 0xef, 0xff, 0xee, 0xdc, 0xba, 0x60, 0x99, 0x4f,
    0x01, 0x89, 0x99, 0x99, 0x98, 0x53, 0x01, 0x00, 0x02, 0xff, 0xfe, 0xed,
    0xcb, 0xa9, 0x47, 0x80, 0x35, 0x98, 0x64, 0x10, 0x0d, 0xef, 0xee, 0xdc,
    0x30, 0xba, 0x98, 0x3f, 0x04, 0x99, 0x88, 0x54, 0x30, 0x06, 0x1e, 0xfe,
    0xed, 0xcb, 0xa9, 0x47, 0x06, 0x86, 0x01, 0x55, 0x41, 0x3e, 0xfe, 0xed,
    0xba, 0x98, 0x3f, 0x81, 0x3f, 0x65, 0x41, 0x5e, 0xee, 0xdc, 0xb9, 0x47,
    0x80, 0x07, 0x88, 0x65, 0x42, 0xbd, 0xee, 0xdb, 0xa9, 0xe1, 0x3f, 0x3f,
    0x39, 0xcc, 0xed, 0xcb, 0x98, 0x3f, 0x81, 0x3f, 0x88, 0x65, 0x43, 0xcc,
    0xdd, 0xca, 0x3f, 0xc3, 0x3f, 0x39, 0x42, 0xcb, 0xdc, 0xba, 0x3f, 0x3f,
    0xb0, 0x3c, 0xb9, 0x47, 0x07, 0x88, 0x88, 0x75, 0x32, 0x18, 0xcb, 0xdc,
    0xa9, 0x3f, 0x07, 0x88, 0x88, 0x65, 0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
    0x3f, 0x3f, 0x3f, 0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
    0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xff, 0x3f, 0x3f,
    0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
    0x3f, 0x3f, 0x3f, 0xf8, 0x3f, 0x3f, 0x3f, 0x07, 0x01, 0x64, 0x32, 0xcb,
    0x73, 0xcc, 0x3f, 0x3f, 0x3b, 0x9b, 0xcb, 0x3f, 0x07, 0x00, 0x88, 0x88,
    0x87, 0x54, 0x32, 0x4a, 0xba, 0x99, 0x60, 0x98, 0x37, 0x07, 0x86, 0x54,
    0x32, 0x2a, 0xaa, 0x60, 0xa9, 0x47, 0x07, 0x88, 0x75, 0x43, 0x21, 0x19,
    0x30, 0x8a, 0x99, 0x3f, 0x07, 0x88, 0x65, 0x43, 0x21, 0x0c, 0x04, 0x49,
    0x98, 0x98, 0x37, 0x06, 0x86, 0x54, 0x06, 0x33, 0x20, 0x02, 0x46, 0x68,
    0x47, 0x07, 0x76, 0x01, 0x54, 0x32, 0x10, 0x00, 0x44, 0x66, 0x66, 0x2f,
    0x80, 0x05, 0x87, 0x65, 0x43, 0x32, 0x00, 0x00, 0x13, 0x18, 0x45, 0x55,
    0x66, 0x3f, 0x04, 0x66, 0x54, 0x33, 0x00, 0x21, 0x00, 0x00, 0x01, 0x34,
    0x45, 0x56, 0x66, 0x60, 0x78, 0x2f, 0x01, 0x76, 0x54, 0x43, 0x32, 0x10,
    0x01, 0x00, 0x00, 0x00, 0x12, 0x44, 0x45, 0x55, 0x37, 0x82, 0x01, 0x66,
    0x55, 0x44, 0x33, 0x21, 0x41, 0x00, 0x00, 0x01, 0x23, 0x44, 0x44, 0x55,
    0x56, 0x66, 0x66, 0x60, 0x66, 0xe9, 0xd1, 0x65, 0x54, 0x44, 0x33, 0x22,
    0x40, 0x10, 0x3a, 0x00, 0x12, 0x33, 0x34, 0x44, 0x44, 0x61, 0x44, 0xe9,
    0xd4, 0x43, 0x33, 0x22, 0x21, 0x43, 0x86, 0x31, 0x23, 0x33, 0x33, 0x33,
    0xe9, 0xd4, 0x32, 0x80, 0x47, 0x00, 0x00, 0x01, 0x12, 0x22, 0x22, 0x22,
    0xc8, 0xe9, 0xd3, 0x21, 0x10, 0x43,
};

//*****************************************************************************
//
// This is the image of the blue push button background, used when the buttons
// are pressed.
//
//*****************************************************************************
const unsigned char g_pucBlue50x50Press[] =
{
    IMAGE_FMT_4BPP_COMP,
    50, 0,
    50, 0,

    15,
    0x00, 0x00, 0x00,
    0x23, 0x00, 0x00,
    0x52, 0x00, 0x00,
    0x63, 0x00, 0x00,
    0x6f, 0x00, 0x00,
    0x78, 0x00, 0x00,
    0x7c, 0x00, 0x00,
    0x7d, 0x00, 0x00,
    0x7f, 0x00, 0x00,
    0x81, 0x00, 0x00,
    0x85, 0x00, 0x00,
    0x89, 0x00, 0x00,
    0x8d, 0x00, 0x00,
    0x93, 0x00, 0x00,
    0x9b, 0x00, 0x00,
    0xa9, 0x00, 0x00,

    0x83, 0x03, 0x01, 0x12, 0x22, 0x22, 0x22, 0xe9, 0xd3, 0x20, 0x21, 0x10,
    0x07, 0x12, 0x22, 0x23, 0x33, 0x33, 0x64, 0x33, 0xe9, 0xd4, 0x32, 0x21,
    0x47, 0x33, 0x34, 0x19, 0x44, 0x44, 0x44, 0xe9, 0xd4, 0x43, 0x33, 0x34,
    0x00, 0x01, 0x22, 0x33, 0x44, 0x45, 0x56, 0x66, 0x66, 0x60, 0x66, 0xe9,
    0xd1, 0x65, 0x55, 0x44, 0x44, 0x32, 0x40, 0x10, 0x32, 0x12, 0x33, 0x44,
    0x55, 0x66, 0x88, 0x30, 0x88, 0x88, 0xe9, 0xd2, 0x87, 0x66, 0x55, 0x54,
    0x20, 0x44, 0x21, 0x39, 0x01, 0x23, 0x34, 0x45, 0x67, 0xc0, 0x47, 0x33,
    0x65, 0x54, 0x43, 0x10, 0x00, 0x00, 0x0c, 0x12, 0x33, 0x45, 0x66, 0x47,
    0x04, 0x66, 0x55, 0x00, 0x54, 0x31, 0x00, 0x00, 0x23, 0x34, 0x56, 0x78,
    0xc0, 0x3f, 0x04, 0x86, 0x66, 0x66, 0x44, 0x00, 0x01, 0x18, 0x23, 0x45,
    0x67, 0x47, 0x2f, 0x86, 0x64, 0x20, 0x0c, 0x02, 0x33, 0x45, 0x68, 0x3f,
    0x06, 0x89, 0x89, 0x06, 0x94, 0x40, 0x12, 0x34, 0x56, 0x47, 0x07, 0x88,
    0x03, 0x99, 0xa8, 0x91, 0x12, 0x34, 0x57, 0x3f, 0x07, 0x01, 0x88, 0x9a,
    0xaa, 0xa2, 0x23, 0x45, 0x68, 0x3f, 0x80, 0x07, 0x89, 0x99, 0xab, 0xa4,
    0x23, 0x45, 0x78, 0xc0, 0x3f, 0x07, 0x88, 0x9a, 0xbc, 0xb9, 0x23, 0x46,
    0xe7, 0x47, 0x3f, 0x39, 0xcc, 0xbc, 0x3f, 0x3f, 0x3b, 0x0f, 0xcd, 0xbc,
    0x23, 0x56, 0x3f, 0x3f, 0x3f, 0x3f, 0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
    0x3f, 0x3f, 0x3f, 0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
    0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xff, 0x3f, 0x3f,
    0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0xff, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
    0x3f, 0x3f, 0x3f, 0xb0, 0x39, 0x57, 0x3f, 0x07, 0x88, 0x88, 0x9b, 0xcd,
    0x18, 0xbc, 0x24, 0x56, 0x3f, 0x07, 0x88, 0x89, 0xab, 0xe1, 0x3f, 0x3f,
    0x3c, 0xac, 0xdd, 0xcc, 0x34, 0x3f, 0xc3, 0x3f, 0x39, 0xbc, 0xde, 0xcc,
    0x24, 0x3f, 0x07, 0x03, 0x88, 0x88, 0x9a, 0xbd, 0xee, 0xdb, 0x3f, 0x07,
    0x80, 0x01, 0x9b, 0xcd, 0xee, 0xe5, 0x14, 0x56, 0x68, 0xc0, 0x37, 0x06,
    0x89, 0xab, 0xde, 0xef, 0xe3, 0x14, 0x60, 0x55, 0x3f, 0x07, 0x9a, 0xbc,
    0xde, 0xef, 0xe1, 0x0c, 0x03, 0x45, 0x88, 0x99, 0x37, 0x04, 0x89, 0xab,
    0x00, 0xcd, 0xee, 0xfe, 0xd0, 0x01, 0x46, 0x89, 0x99, 0x60, 0x98, 0x37,
    0x03, 0x9a, 0xbc, 0xde, 0xef, 0xff, 0x06, 0x20, 0x00, 0x35, 0x89, 0x99,
    0x37, 0x03, 0x99, 0x00, 0xab, 0xcd, 0xee, 0xff, 0xfe, 0x00, 0x00, 0x14,
    0x04, 0x89, 0x99, 0xaa, 0x99, 0x99, 0x37, 0x89, 0x99, 0x00, 0xab, 0xcc,
    0xde, 0xef, 0xff, 0xf1, 0x00, 0x00, 0x05, 0x02, 0x59, 0x9a, 0xba, 0xaa,
    0x29, 0x99, 0xe9, 0xa0, 0xd1, 0xaa, 0x41, 0xee, 0xff, 0xff, 0x30, 0x00,
    0x00, 0x00, 0x00, 0x25, 0xab, 0xbc, 0xcc, 0xbb, 0xbb, 0x1a, 0xcc, 0xcc,
    0xcc, 0xe9, 0xd1, 0xcd, 0x42, 0xf3, 0x80, 0x41, 0x00, 0x02, 0xaa, 0xcc,
    0xdc, 0xcd, 0xdd, 0x32, 0xdd, 0xdd, 0xe9, 0xd1, 0xde, 0xee, 0x41, 0xff,
    0x40, 0x30, 0x3a, 0x00, 0x19, 0xcc, 0xdd, 0xee, 0xee, 0x6a, 0xee, 0xe9,
    0xd3, 0xef, 0x41, 0xe1, 0x43, 0x00, 0x3a, 0x00, 0x2a, 0x47, 0x01, 0x41,
    0xe2, 0x45, 0x00, 0x0e, 0x00, 0x13, 0x7d, 0xef, 0x81, 0x69, 0x51, 0xef,
    0x20, 0xe9, 0x31, 0x43,
};

//*****************************************************************************
//
// Vertical "Temperature" image used in the slider widget example.
//
//*****************************************************************************
const unsigned char g_pucGettingHotter28x160[] =
{
    IMAGE_FMT_8BPP_COMP,
    28, 0,
    160, 0,

    63,
    0x00, 0x0e, 0x41,
    0x00, 0x14, 0x72,
    0x00, 0x35, 0x3c,
    0x00, 0x29, 0x56,
    0x00, 0x0a, 0xc0,
    0x00, 0x38, 0x6c,
    0x00, 0x23, 0x99,
    0x00, 0x0d, 0xe0,
    0x00, 0x03, 0xff,
    0x00, 0x55, 0x69,
    0x00, 0x18, 0xe3,
    0x00, 0x47, 0x8d,
    0x00, 0x0e, 0xfe,
    0x00, 0x2c, 0xc5,
    0x00, 0x19, 0xfc,
    0x00, 0x2a, 0xde,
    0x00, 0x27, 0xfb,
    0x00, 0x43, 0xc4,
    0x00, 0x52, 0xae,
    0x00, 0x3e, 0xe2,
    0x00, 0x69, 0x94,
    0x00, 0x36, 0xf9,
    0x00, 0x4d, 0xe3,
    0x00, 0x81, 0x7e,
    0x00, 0x45, 0xf8,
    0x00, 0x6c, 0xad,
    0x00, 0x57, 0xdd,
    0x00, 0x6d, 0xc2,
    0x00, 0x54, 0xf6,
    0x00, 0x69, 0xde,
    0x00, 0x62, 0xf5,
    0x00, 0x92, 0x9d,
    0x00, 0x76, 0xd8,
    0x00, 0x6c, 0xf3,
    0x00, 0xa2, 0x96,
    0x00, 0x8f, 0xbc,
    0x00, 0x74, 0xf2,
    0x00, 0x7b, 0xf2,
    0x00, 0x86, 0xe2,
    0x00, 0x92, 0xd3,
    0x00, 0x83, 0xf1,
    0x00, 0x8b, 0xf0,
    0x00, 0xaa, 0xba,
    0x00, 0x91, 0xf0,
    0x00, 0x98, 0xef,
    0x00, 0xa1, 0xe0,
    0x00, 0xa9, 0xd5,
    0x00, 0xa2, 0xee,
    0x00, 0xab, 0xed,
    0x00, 0xb2, 0xe0,
    0x00, 0xb3, 0xec,
    0x00, 0xbb, 0xeb,
    0x00, 0xcf, 0xcb,
    0x00, 0xc2, 0xea,
    0x00, 0xcc, 0xe9,
    0x00, 0xd5, 0xde,
    0x00, 0xd3, 0xe9,
    0x00, 0xda, 0xe8,
    0x00, 0xe2, 0xdb,
    0x00, 0xdf, 0xe7,
    0x00, 0xe6, 0xe7,
    0x00, 0xec, 0xe6,
    0x00, 0xf3, 0xe5,
    0x00, 0xfb, 0xe4,

    0x1f, 0x08, 0x08, 0x08, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0xfc, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x08, 0x25, 0x03, 0x33, 0x3f, 0x3f, 0x18, 0x15,
    0x1c, 0x07, 0x07, 0x00, 0x08, 0x0e, 0x36, 0x3f, 0x3f, 0x3f, 0x3f, 0x05,
    0x1b, 0x20, 0x3f, 0x27, 0x1f, 0x07, 0x33, 0x2a, 0x22, 0x34, 0x3f, 0x12,
    0x1f, 0x05, 0x18, 0x2b, 0x3f, 0x05, 0x06, 0x27, 0x3f, 0x3f, 0x34, 0x04,
    0x1f, 0x04, 0x24, 0xab, 0x21, 0x1f, 0x21, 0x2e, 0xc1, 0x01, 0x27, 0x04,
    0x05, 0x33, 0x3f, 0x3f, 0x14, 0x00, 0x21, 0x04, 0x21, 0x73, 0x05, 0x27,
    0x27, 0x42, 0x05, 0x04, 0xbb, 0x1d, 0x10, 0x0c, 0x0c, 0x0c, 0xe9, 0x0c,
    0x33, 0x3e, 0x3e, 0x01, 0x14, 0x04, 0x3e, 0x3e, 0x05, 0x04, 0x39, 0xda,
    0xc1, 0x5d, 0x25, 0x29, 0x3e, 0x3e, 0x3a, 0x1b, 0x01, 0x06, 0x2e, 0x3e,
    0x3e, 0x3e, 0x03, 0x27, 0x04, 0x1c, 0xe3, 0x61, 0x49, 0xd2, 0x34, 0x00,
    0x07, 0x27, 0x04, 0x4c, 0x37, 0x1f, 0x14, 0x00, 0x2f, 0x05, 0x15, 0x3a,
    0x8c, 0x1d, 0x1f, 0x00, 0x04, 0x27, 0x06, 0x0f, 0x1f, 0x86, 0x1a, 0x34,
    0x14, 0x00, 0x01, 0x2f, 0x07, 0x0c, 0x00, 0x07, 0x01, 0x05, 0x05, 0x05,
    0x00, 0x00, 0x04, 0xc4, 0x2f, 0x06, 0x21, 0x32, 0x1e, 0x01, 0x04, 0x04,
    0x60, 0x07, 0x37, 0x07, 0x0c, 0x2f, 0x3d, 0x3d, 0x35, 0xe0, 0x4f, 0x07,
    0x04, 0x32, 0x3d, 0x3d, 0x2a, 0x01, 0xc4, 0x1f, 0x05, 0x0e, 0x0e, 0x0e,
    0xe9, 0x0e, 0x1e, 0x0e, 0x3d, 0x3d, 0x3a, 0x0b, 0xa5, 0x6d, 0x97, 0x15,
    0x00, 0x20, 0x3d, 0x3d, 0x3d, 0x31, 0x28, 0x25, 0x25, 0x1b, 0x25, 0x25,
    0x25, 0x07, 0x05, 0x25, 0x29, 0x11, 0xb1, 0xd3, 0x04, 0x27, 0x25, 0x3c,
    0x3c, 0x3c, 0xe9, 0xbe, 0xd3, 0x00, 0x27, 0x27, 0x27, 0x27, 0x05, 0x21,
    0x0f, 0x2e, 0x2a, 0x2a, 0x2a, 0xe9, 0xd2, 0x27, 0x06, 0x0f, 0x04, 0x01,
    0x01, 0x01, 0xe9, 0xd3, 0x27, 0x07, 0xe1, 0x77, 0x2f, 0x05, 0x1c, 0x25,
    0x25, 0x25, 0xe9, 0xc4, 0xd3, 0x07, 0x10, 0x10, 0x10, 0xe9, 0x10, 0x25,
    0x1b, 0x3b, 0x3b, 0x3b, 0xe9, 0xd3, 0x06, 0x65, 0x2d, 0xd8, 0x27, 0x02,
    0x00, 0x27, 0x25, 0x39, 0x39, 0x39, 0xf0, 0xe9, 0xd3, 0x27, 0x05, 0x21,
    0x2e, 0x2a, 0x2a, 0x00, 0x2a, 0x2a, 0x2a, 0x36, 0x39, 0x39, 0x23, 0x14,
    0xc2, 0x27, 0x06, 0x06, 0x01, 0x01, 0x01, 0xe9, 0x23, 0x0e, 0x39, 0x36,
    0x0b, 0x06, 0x27, 0x07, 0x73, 0x1c, 0x0e, 0x39, 0x39, 0x2a, 0x0f, 0x27,
    0x07, 0x03, 0x21, 0x0c, 0x38, 0x38, 0x38, 0x05, 0x27, 0x04, 0x1c, 0x25,
    0x25, 0x25, 0x25, 0xe9, 0x28, 0x36, 0x22, 0x0f, 0x1f, 0xb9, 0x03, 0x25,
    0x61, 0x49, 0xd3, 0x05, 0x0d, 0x25, 0x14, 0x15, 0x15, 0x15, 0xe9, 0x15,
    0x27, 0x38, 0x38, 0x18, 0x35, 0x00, 0x0d, 0x5d, 0x26, 0x36, 0x36, 0x36,
    0xcc, 0xe9, 0xd2, 0x09, 0x00, 0x2f, 0x04, 0x24, 0x2d, 0x10, 0x23, 0x23,
    0x23, 0xe9, 0x23, 0x14, 0x03, 0x00, 0x61, 0x0d, 0x27, 0x05, 0x06, 0x01,
    0x01, 0x01, 0xe9, 0x0f, 0x01, 0x01, 0x06, 0x0f, 0x2f, 0x07, 0x77, 0x2f,
    0x84, 0x06, 0x25, 0x35, 0x35, 0x2f, 0x03, 0x2c, 0x30, 0x62, 0x35, 0x27,
    0x27, 0x35, 0x23, 0x01, 0x1a, 0x2f, 0x10, 0x35, 0x35, 0x05, 0x1f, 0x15,
    0x15, 0x21, 0x25, 0x24, 0x25, 0x25, 0x69, 0x2e, 0x19, 0xc1, 0x28, 0x33,
    0xa0, 0x21, 0x0f, 0x1f, 0x15, 0x1e, 0x35, 0x35, 0x35, 0xe4, 0xe9, 0xd4,
    0xa1, 0x05, 0x0d, 0x25, 0x18, 0x18, 0x19, 0x18, 0x18, 0x2d, 0x1f, 0x03,
    0x03, 0x0d, 0x5a, 0xc3, 0x3a, 0x19, 0x1e, 0x33, 0x33, 0x33, 0xe9, 0xd4,
    0x0c, 0x33, 0x19, 0x00, 0x13, 0x27, 0x01, 0x20, 0x23, 0x01, 0x2e, 0x33,
    0x33, 0x31, 0x23, 0x23, 0x23, 0xe9, 0x18, 0x0b, 0x00, 0x06, 0x2f, 0x03,
    0x06, 0x19, 0x33, 0x02, 0x33, 0x23, 0x00, 0x01, 0x01, 0x01, 0xe9, 0x0d,
    0xc1, 0x2f, 0x05, 0x1c, 0x12, 0x05, 0x05, 0x01, 0x5f, 0xc0, 0x17, 0x04,
    0x13, 0x11, 0x1d, 0x20, 0x25, 0x25, 0x58, 0x25, 0xe9, 0x30, 0x07, 0x06,
    0x24, 0x30, 0x32, 0x36, 0x32, 0x32, 0xe9, 0xd1, 0x03, 0x1f, 0x04, 0x1c,
    0x89, 0x37, 0x32, 0x32, 0x00, 0x5f, 0x1c, 0x1c, 0xe9, 0x3c, 0x1c, 0x25,
    0x27, 0x21, 0x65, 0x2d, 0x1c, 0x29, 0x00, 0x32, 0x32, 0x2d, 0x27, 0x32,
    0x2d, 0x23, 0x2d, 0x18, 0x32, 0x2d, 0x05, 0x27, 0x05, 0x2b, 0x30, 0x30,
    0x00, 0x0b, 0x05, 0x30, 0x2d, 0x00, 0x05, 0x27, 0x30, 0x30, 0x0b, 0x11,
    0x27, 0x27, 0x05, 0x11, 0x2f, 0x30, 0x06, 0x05, 0x1c, 0x24, 0x30, 0x27,
    0x27, 0x27, 0x30, 0x10, 0x14, 0x11, 0x2b, 0xe1, 0x21, 0x30, 0x30, 0x05,
    0xc0, 0x27, 0x04, 0x29, 0x30, 0x30, 0x2d, 0x12, 0x25, 0xcc, 0xe1, 0xb9,
    0x05, 0x16, 0x1f, 0x03, 0x25, 0x2f, 0x0c, 0x2f, 0x2f, 0x14, 0x1b, 0xd9,
    0xc1, 0x05, 0x11, 0x89, 0x25, 0x1e, 0x1e, 0x1e, 0xe9, 0x1e, 0x21, 0x62,
    0x4c, 0x12, 0x24, 0x03, 0x11, 0x5d, 0x25, 0x1e, 0x26, 0x91, 0x21, 0x11,
    0x29, 0x1a, 0x1b, 0x00, 0x1a, 0x27, 0x80, 0x05, 0x19, 0x27, 0x00, 0x11,
    0x21, 0x27, 0x2f, 0x0c, 0x2f, 0x27, 0x03, 0x05, 0x2f, 0x07, 0x0b, 0x03,
    0x00, 0x1e, 0x1e, 0x1a, 0x0b, 0x05, 0x00, 0x03, 0x1a, 0xc4, 0x27, 0x04,
    0x25, 0x29, 0x24, 0x74, 0x11, 0x11, 0xc3, 0x37, 0x06, 0x29, 0x2c, 0x2c,
    0x26, 0x5f, 0x27, 0x98, 0x27, 0x1b, 0x03, 0x1f, 0x05, 0x21, 0x21, 0x21,
    0x81, 0xe9, 0x21, 0x25, 0x2c, 0x2c, 0x26, 0x0b, 0xa5, 0xc0, 0x6d, 0x97,
    0x21, 0x20, 0x2b, 0x2b, 0x2b, 0x26, 0x03, 0x28, 0x25, 0x25, 0x25, 0x25,
    0x25, 0x07, 0x05, 0x77, 0x25, 0x29, 0x11, 0xd3, 0x0b, 0x27, 0x27, 0x17,
    0x44, 0x00, 0x26, 0x24, 0x24, 0x24, 0xe9, 0x24, 0x25, 0x1b, 0x29, 0x29,
    0x29, 0xe9, 0xd3, 0x00, 0x65, 0x2d, 0x03, 0x24, 0x25, 0x20, 0x1b, 0x1b,
    0x1b, 0xe9, 0xd2, 0xc3, 0x27, 0x06, 0x12, 0x05, 0x05, 0x05, 0xe9, 0xd3,
    0xf1, 0x27, 0x07, 0x77, 0x2f, 0x25, 0x25, 0x25, 0xe9, 0x8e, 0xd3, 0x28,
    0x28, 0x28, 0x97, 0x4f, 0x36, 0x28, 0x07, 0x28, 0x05, 0x20, 0x28, 0x20,
    0x2f, 0x2f, 0x2b, 0x9c, 0x22, 0x28, 0x12, 0x1f, 0x07, 0x73, 0x05, 0x20,
    0x11, 0x25, 0x25, 0x1b, 0x1f, 0x28, 0x28, 0x28, 0xe9, 0x39, 0x28, 0x28,
    0x01, 0x61, 0x22, 0x25, 0x05, 0x66, 0x8a, 0x2f, 0x25, 0x0b, 0x00, 0x21,
    0x1b, 0x22, 0x25, 0xcb, 0x27, 0x26, 0x05, 0x12, 0x26, 0x1b, 0x27, 0x24,
    0x03, 0x24, 0x24, 0x0b, 0x1b, 0x24, 0x24, 0x21, 0xda, 0x8a, 0x25, 0x29,
    0x29, 0x29, 0xe9, 0x29, 0x21, 0x1d, 0x80, 0x21, 0x0b, 0x20, 0x24, 0x24,
    0x24, 0x03, 0x1b, 0xdc, 0x5d, 0x25, 0x28, 0x61, 0x49, 0xd2, 0x1d, 0x02,
    0x63, 0x20, 0x27, 0x04, 0x21, 0x21, 0x21, 0xe9, 0xd2, 0x22, 0x0b, 0x03,
    0x2e, 0x2b, 0x2b, 0x2b, 0xe9, 0x2b, 0x11, 0x2b, 0x29, 0x1d, 0x15, 0x12,
    0x02, 0x14, 0x66, 0x88, 0x26, 0x2b, 0x20, 0x12, 0x1a, 0x1d, 0x0b, 0x02,
    0x60, 0x0b, 0x2f, 0x07, 0x2b, 0x26, 0x0b, 0x05, 0x05, 0x08, 0x05, 0x02,
    0x03, 0x14, 0x2f, 0x2b, 0x2c, 0x2c, 0x61, 0x2c, 0xe9, 0xd4, 0x2c, 0x1b,
    0x1b, 0x20, 0x87, 0xc0, 0x3f, 0x01, 0x2b, 0x28, 0x21, 0x1e, 0x1e, 0x1e,
    0x33, 0x24, 0x28, 0x1f, 0x07, 0x2c, 0x28, 0x39, 0x21, 0x1a, 0x1e, 0x1e,
    0x1d, 0x1f, 0x06, 0x2b, 0x2e, 0x1e, 0x1a, 0x1e, 0x12, 0x2b, 0x17, 0x04,
    0x25, 0x27, 0x1e, 0x22, 0x1e, 0x14, 0x26, 0x2f, 0x2f, 0x2f, 0xe9, 0x2f,
    0x41, 0x21, 0x21, 0x1a, 0x0b, 0x0b, 0x12, 0x1a, 0x01, 0x60, 0x05, 0x5e,
    0x27, 0x1e, 0x12, 0x02, 0x05, 0x14, 0x26, 0x14, 0x0b, 0x19, 0x05, 0x23,
    0x27, 0x03, 0x25, 0x08, 0x1c, 0x1c, 0x05, 0x09, 0x6a, 0x21, 0x1c, 0x1c,
    0x61, 0x03, 0x27, 0x04, 0x2c, 0x1c, 0x1c, 0x12, 0x6a, 0x98, 0xc2, 0x02,
    0x2d, 0x27, 0x24, 0x24, 0x1c, 0x1c, 0x00, 0x1a, 0x28, 0x28, 0x25, 0x1c,
    0x1c, 0x1c, 0x0b, 0x04, 0x12, 0x28, 0x28, 0x28, 0x2c, 0x0a, 0x30, 0x30,
    0x4f, 0x30, 0xe9, 0x30, 0x28, 0x59, 0x41, 0xd4, 0xa1, 0x38, 0x19, 0x27,
    0x3d, 0x27, 0x07, 0x1c, 0x05, 0x23, 0xf8, 0x27, 0x27, 0x27, 0x27, 0x21,
    0x1a, 0x11, 0x11, 0x64, 0x11, 0xe9, 0xd4, 0x11, 0x11, 0x23, 0x32, 0x32,
    0x40, 0x32, 0xe9, 0x32, 0x32, 0x19, 0x09, 0x09, 0x09, 0xef, 0xe9, 0xd4,
    0xa1, 0x27, 0x3e, 0xc6, 0x87, 0x3f, 0x87, 0x04, 0x2f, 0x28, 0x28, 0x28,
    0xe9, 0xd1, 0x07, 0x86, 0x06, 0x25, 0x18, 0x18, 0x18, 0xe9, 0xd2, 0x14,
    0xd1, 0x1f, 0x04, 0x29, 0x2f, 0x18, 0x18, 0x02, 0x26, 0x13, 0x33, 0x33,
    0x33, 0xe9, 0x33, 0x21, 0x27, 0x21, 0xc8, 0x65, 0x2d, 0x33, 0x1e, 0x21,
    0x13, 0x11, 0x11, 0x5a, 0x11, 0xe9, 0x11, 0x27, 0x05, 0x21, 0x29, 0x02,
    0x0a, 0x02, 0x09, 0x09, 0x09, 0xe9, 0x09, 0x26, 0x35, 0x20, 0x35, 0x35,
    0xe9, 0x35, 0x2b, 0x15, 0x15, 0x11, 0x38, 0x02, 0x31, 0x9d, 0x65, 0x97,
    0x1a, 0x15, 0x15, 0x70, 0x12, 0x2f, 0x07, 0x04, 0x30, 0x15, 0x15, 0x15,
    0xf2, 0xe9, 0xd2, 0x07, 0x05, 0x32, 0x18, 0x27, 0x15, 0x6e, 0x02, 0x1f,
    0x04, 0x21, 0x2f, 0x27, 0x07, 0x1c, 0xc1, 0x27, 0x27, 0x35, 0x35, 0x36,
    0x36, 0x36, 0xe9, 0x42, 0x36, 0x22, 0x06, 0x05, 0x05, 0x05, 0xe9, 0x05,
    0x60, 0x02, 0x65, 0x2d, 0x36, 0x28, 0x15, 0x15, 0x0d, 0x05, 0x02, 0x1f,
    0x2a, 0x2a, 0x2a, 0xe9, 0x2a, 0x27, 0x83, 0x04, 0x35, 0x15, 0x10, 0x0f,
    0x09, 0x67, 0x1f, 0x80, 0x03, 0x33, 0x25, 0x10, 0x10, 0x0f, 0x25, 0x28,
    0x31, 0x28, 0x28, 0xe9, 0x07, 0x38, 0x38, 0x38, 0xe9, 0x06, 0x38, 0x28,
    0x10, 0x10, 0x10, 0xe9, 0xd3, 0x1f, 0xf7, 0x65, 0x2d, 0x27, 0x02, 0x02,
    0x27, 0x27, 0x27, 0xc1, 0x27, 0x05, 0x2b, 0x13, 0x0d, 0x0d, 0x0d, 0xe9,
    0xe1, 0xd2, 0x27, 0x06, 0x1f, 0x09, 0x09, 0x09, 0xe9, 0xc6, 0xd3, 0x26,
    0x39, 0x39, 0x39, 0xe9, 0xd2, 0x28, 0x03, 0x1c, 0x10, 0x10, 0x30, 0x32,
    0x2c, 0x7f, 0x37, 0x00, 0x39, 0x36, 0x18, 0x10, 0x10, 0x10, 0x10, 0x05,
    0x18, 0x1d, 0x10, 0x1a, 0x1f, 0x07, 0x1c, 0x0e, 0x0e, 0x00, 0x0e, 0x0e,
    0x0e, 0x05, 0x1d, 0x0e, 0x0e, 0x19, 0x89, 0x1f, 0x3b, 0x3b, 0x3b, 0xe9,
    0x3b, 0x30, 0x2b, 0x01, 0x0e, 0x05, 0x1a, 0x0e, 0x0e, 0x0f, 0x2a, 0x65,
    0x95, 0x2d, 0x3b, 0x28, 0x21, 0x06, 0x21, 0x16, 0xc1, 0x6a, 0x09, 0x27,
    0x04, 0x1c, 0x29, 0x02, 0x21, 0x2a, 0x99, 0x21, 0x05, 0x37, 0x27, 0x26,
    0x05, 0x1f, 0x22, 0x62, 0x18, 0xda, 0x25, 0x3c, 0x3c, 0x3c, 0xe9, 0x3c,
    0x97, 0x21, 0x06, 0x2a, 0x22, 0x15, 0x22, 0x5d, 0x25, 0x05, 0x24, 0x0e,
    0x0e, 0x0e, 0x1b, 0x01, 0x16, 0xc1, 0x6e, 0x03, 0x27, 0x04, 0x2f, 0x21,
    0x09, 0xd2, 0x0a, 0x34, 0x02, 0x34, 0x27, 0x04, 0x10, 0x1f, 0x06, 0x09,
    0xc1, 0x2f, 0x05, 0x33, 0x0e, 0x0c, 0x0c, 0x0c, 0xe9, 0x08, 0x0c, 0x06,
    0x02, 0x1f, 0x26, 0x3d, 0x3d, 0x3d, 0xc8, 0xe9, 0xd1, 0x2e, 0x0d, 0x1a,
    0x0a, 0x06, 0x02, 0x61, 0x17, 0x6f, 0x21, 0x2b, 0x28, 0x28, 0x28, 0x01,
    0x00, 0x34, 0x17, 0x05, 0x05, 0x05, 0x02, 0x09, 0x1f, 0xc1, 0x2f, 0x02,
    0x18, 0x0c, 0x0c, 0x0c, 0x22, 0x73, 0x19, 0x2a, 0x2a, 0x34, 0x37, 0x27,
    0x0c, 0x02, 0x67, 0xf8, 0x27, 0x27, 0x27, 0x07, 0x01, 0x3e, 0x3e, 0x3e,
    0xfc, 0x23, 0xc1, 0xa9, 0xd4, 0xa7, 0x24, 0x06, 0x28, 0x3f, 0x28, 0x28,
    0xe9, 0xd3, 0x27, 0x25, 0x09, 0xd4, 0xb1, 0xa1, 0x22, 0x27, 0x21, 0x08,
    0x08, 0x08, 0xe9, 0xdf, 0xd4, 0xa1, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27,
    0xe3, 0x27, 0x27, 0x26, 0x06, 0x06, 0x06, 0xe9, 0xd4, 0x88, 0x27, 0x3f,
    0x3f, 0x3f, 0x22, 0x02, 0x22, 0x22, 0x7f, 0x22, 0xe9, 0xd4, 0x61, 0x49,
    0xd3, 0x23, 0x87, 0xff, 0x3f, 0x27, 0x27, 0x27, 0x27, 0x27, 0x07, 0x05,
    0x0e, 0x2c, 0x11, 0x06, 0x06, 0x27, 0x07, 0x05, 0x22, 0x1f, 0x22, 0x22,
    0x22, 0x27, 0x07, 0x77, 0x2f, 0x07, 0xf0, 0x07, 0x07, 0x07, 0x02,
};

//*****************************************************************************
//
// Vertical "Temperature" background image used in the slider widget example.
//
//*****************************************************************************
const unsigned char g_pucGettingHotter28x160Mono[] =
{
    IMAGE_FMT_4BPP_COMP,
    28, 0,
    160, 0,

    15,
    0x00, 0x00, 0x00,
    0x11, 0x10, 0x00,
    0x22, 0x21, 0x00,
    0x33, 0x31, 0x00,
    0x44, 0x42, 0x00,
    0x55, 0x52, 0x00,
    0x66, 0x62, 0x00,
    0x77, 0x73, 0x00,
    0x88, 0x83, 0x00,
    0x99, 0x94, 0x00,
    0xaa, 0xa4, 0x00,
    0xbb, 0xb4, 0x00,
    0xcc, 0xc5, 0x00,
    0xdd, 0xd5, 0x00,
    0xee, 0xe6, 0x00,
    0xff, 0xf6, 0x00,

    0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x00, 0x7b, 0x10, 0xff, 0x43,
    0x50, 0x07, 0x1c, 0xff, 0xff, 0x47, 0x54, 0xf8, 0x07, 0xbf, 0x91, 0xff,
    0x1e, 0x04, 0xff, 0x04, 0xff, 0xff, 0x49, 0xff, 0xc0, 0x1d, 0x07, 0xff,
    0x04, 0xf9, 0xff, 0x4a, 0xff, 0xf1, 0x25, 0x0b, 0xff, 0x04, 0x70, 0xff,
    0x41, 0xff, 0xf4, 0x97, 0x40, 0xff, 0x20, 0x40, 0xbf, 0x97, 0xff, 0x60,
    0xff, 0x40, 0xdf, 0x80, 0x26, 0x08, 0xff, 0xe6, 0xff, 0x7a, 0xff, 0xf2,
    0x80, 0x25, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x95, 0x25, 0x00,
    0xdf, 0x8a, 0x70, 0x96, 0x3e, 0x19, 0x41, 0xf9, 0x2e, 0x00, 0x02, 0x9f,
    0xff, 0xfd, 0x2f, 0x93, 0x01, 0x44, 0x30, 0x2f, 0x06, 0xb5, 0x47, 0x01,
    0x10, 0x0a, 0xff, 0xc0, 0x8f, 0x00, 0x00, 0x0b, 0xff, 0x41, 0xb0, 0x1f,
    0x00, 0x00, 0x05, 0xff, 0xe3, 0x27, 0x00, 0x00, 0x00, 0x02, 0x7f, 0xff,
    0xb8, 0x77, 0x77, 0x40, 0x70, 0x05, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x78, 0xf0, 0x97, 0x97, 0x27, 0x26, 0x06, 0xbb, 0xbb, 0x0f, 0xbb, 0xbb,
    0xbb, 0xb0, 0x25, 0x5d, 0x97, 0x4f, 0x80, 0x01, 0x04, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x70, 0x80, 0x05, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xf0, 0x97, 0x97, 0x27, 0x26, 0x06, 0xbb, 0xbb, 0xbb, 0x18, 0xef, 0xfa,
    0x70, 0x25, 0x02, 0x0a, 0xfe, 0x30, 0x82, 0x97, 0x00, 0x00, 0x04, 0xff,
    0xb0, 0x27, 0x00, 0x08, 0x00, 0x06, 0xff, 0xf2, 0x46, 0x77, 0x77, 0x77,
    0x10, 0x8e, 0xff, 0xf4, 0x25, 0x07, 0xff, 0xff, 0xff, 0x6d, 0xff, 0x97,
    0x94, 0xe0, 0x27, 0x1a, 0x50, 0x25, 0x03, 0x06, 0xbb, 0xbb, 0xbb, 0xbb,
    0x82, 0x2d, 0x65, 0xe0, 0x97, 0x4f, 0x02, 0x07, 0xff, 0xb0, 0x00, 0x00,
    0x32, 0xac, 0xf0, 0x97, 0x91, 0xbf, 0xf3, 0x03, 0x05, 0x00, 0x77, 0x7b,
    0xff, 0xd7, 0x77, 0x78, 0xef, 0xf4, 0x85, 0x23, 0x04, 0xff, 0xff, 0xff,
    0xe9, 0xff, 0x94, 0x2a, 0x00, 0xbf, 0x8c, 0xf2, 0x94, 0x4f, 0x1c, 0x90,
    0x80, 0x24, 0x07, 0xbd, 0xff, 0xeb, 0xbb, 0xbb, 0xa6, 0xcc, 0x2c, 0x89,
    0xff, 0xb0, 0xae, 0x01, 0x02, 0x44, 0x60, 0x30, 0x97, 0x01, 0x01, 0x67,
    0x77, 0x77, 0x77, 0x40, 0xd0, 0x06, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xb6, 0x05, 0x02, 0x9a, 0x97, 0x07, 0x97, 0x0a, 0x09, 0x02, 0xff, 0xed,
    0xfe, 0xbe, 0xfe, 0x40, 0x25, 0x0b, 0x02, 0xff, 0x53, 0xfe, 0x01, 0xcf,
    0x50, 0x97, 0x40, 0x08, 0xef, 0x40, 0x6f, 0xd0, 0x27, 0x70, 0xbf, 0x80,
    0x20, 0x4f, 0xf2, 0x25, 0x0a, 0xff, 0xe5, 0x7f, 0xe5, 0x20, 0xaf, 0xf4,
    0x25, 0x07, 0xff, 0xf7, 0x5f, 0xff, 0x40, 0xff, 0x96, 0x03, 0xff, 0xf4,
    0x2f, 0xff, 0xff, 0x40, 0xf2, 0x25, 0x00, 0x9f, 0xf4, 0x0b, 0xff, 0xff,
    0x40, 0xb0, 0x96, 0x07, 0xd0, 0x03, 0xdf, 0xfc, 0x20, 0xc9, 0x26, 0x01,
    0x04, 0x40, 0x2e, 0x06, 0xb5, 0x4f, 0x88, 0x01, 0x0a, 0xff, 0xc0, 0x8f,
    0x00, 0x00, 0x0b, 0x20, 0xff, 0xb0, 0x1f, 0x00, 0x00, 0x05, 0xff, 0xe3,
    0x80, 0x27, 0x00, 0x00, 0x02, 0x7f, 0xff, 0xb8, 0x77, 0x20, 0x77, 0x70,
    0x05, 0x07, 0xff, 0xff, 0xff, 0xff, 0x3c, 0xff, 0xf0, 0x97, 0x97, 0x27,
    0x26, 0x06, 0xbb, 0x07, 0xbb, 0xbb, 0xbb, 0xbb, 0xb0, 0x25, 0x5d, 0x97,
    0xc2, 0x4f, 0x03, 0x7b, 0xff, 0x43, 0x50, 0x07, 0x1c, 0x0a, 0xff, 0xff,
    0x47, 0xf8, 0x07, 0xbf, 0x91, 0xff, 0x80, 0x1e, 0x04, 0xff, 0xff, 0xff,
    0x49, 0xff, 0xc0, 0x80, 0x1d, 0x07, 0xff, 0xf9, 0xff, 0x4a, 0xff, 0xf1,
    0x80, 0x25, 0x0b, 0xff, 0x70, 0xff, 0x41, 0xff, 0xf4, 0x84, 0x97, 0x40,
    0xff, 0x40, 0xbf, 0x97, 0xff, 0x60, 0x10, 0xff, 0x40, 0xdf, 0x26, 0x08,
    0xff, 0xe6, 0xff, 0x10, 0x7a, 0xff, 0xf2, 0x25, 0x05, 0xff, 0xff, 0xff,
    0x12, 0xff, 0xff, 0xd0, 0x25, 0x00, 0xdf, 0x8a, 0x70, 0xa8, 0x96, 0x3e,
    0x19, 0xf9, 0x2e, 0x00, 0x02, 0x9f, 0x33, 0xff, 0xfd, 0x2f, 0x01, 0x44,
    0x30, 0x9f, 0x57, 0x82, 0x0c, 0x01, 0x7c, 0xff, 0xfb, 0x60, 0x1f, 0x5e,
    0x04, 0xff, 0xff, 0xff, 0xfc, 0x10, 0x05, 0x02, 0xef, 0x94, 0x91, 0xff,
    0x80, 0x1d, 0x08, 0x9a, 0xff, 0xf1, 0x80, 0x25, 0x0b, 0xff, 0xfc, 0x77,
    0x9e, 0xff, 0xf4, 0x84, 0x97, 0x90, 0x00, 0x01, 0xef, 0x96, 0x08, 0xff,
    0x04, 0x40, 0x00, 0x00, 0xbf, 0xf1, 0x25, 0x02, 0xef, 0x18, 0x90, 0x00,
    0x03, 0x01, 0x95, 0x8f, 0xfc, 0x77, 0x04, 0x8e, 0xff, 0x87, 0x77, 0x72,
    0x13, 0x07, 0xff, 0x27, 0xff, 0xff, 0xe9, 0xff, 0xf4, 0x97, 0x97, 0x27,
    0x84, 0x24, 0x06, 0xbb, 0xbb, 0xbb, 0xe9, 0xbb, 0xb3, 0xf8, 0x23, 0x6b,
    0xb7, 0x6f, 0x24, 0x02, 0x77, 0x77, 0x10, 0x77, 0x77, 0x70, 0x06, 0x8f,
    0xff, 0xff, 0xff, 0x2d, 0xff, 0xf0, 0x05, 0x06, 0x9a, 0x97, 0x0a, 0x97,
    0x80, 0x0a, 0x0b, 0xff, 0xfe, 0xbb, 0xbb, 0xbb, 0xb0, 0xb3, 0x27, 0xd1,
    0x45, 0x0a, 0x05, 0xff, 0x46, 0x0b, 0x30, 0x9f, 0xf7, 0x97, 0x01, 0x3e,
    0xff, 0xff, 0xff, 0x26, 0xff, 0xf0, 0x05, 0x02, 0xef, 0x97, 0x01, 0x09,
    0xd8, 0x2a, 0x27, 0x0b, 0x97, 0x94, 0xf7, 0x44, 0x44, 0x23, 0x44, 0x40,
    0x25, 0x07, 0xff, 0xb0, 0x45, 0x0a, 0x10, 0x01, 0xef, 0xe1, 0x97, 0x00,
    0x00, 0x02, 0x7f, 0x04, 0xfd, 0x77, 0x77, 0x77, 0x70, 0x05, 0x07, 0xff,
    0x07, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x97, 0x97, 0x27, 0x80, 0x26, 0x06,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb0, 0xe1, 0x25, 0x5d, 0x97, 0x7b, 0xff,
    0x43, 0x50, 0x2f, 0x05, 0x1c, 0xff, 0xff, 0x47, 0xf8, 0x07, 0xbf, 0x91,
    0x40, 0xff, 0x1e, 0x04, 0xff, 0xff, 0xff, 0x49, 0xff, 0x40, 0xc0, 0x1d,
    0x07, 0xff, 0xf9, 0xff, 0x4a, 0xff, 0x40, 0xf1, 0x25, 0x0b, 0xff, 0x70,
    0xff, 0x41, 0xff, 0x42, 0xf4, 0x97, 0x40, 0xff, 0x40, 0xbf, 0x97, 0xff,
    0x08, 0x60, 0xff, 0x40, 0xdf, 0x26, 0x08, 0xff, 0xe6, 0x08, 0xff, 0x7a,
    0xff, 0xf2, 0x25, 0x05, 0xff, 0xff, 0x09, 0xff, 0xff, 0xff, 0xd0, 0x25,
    0x00, 0xdf, 0x8a, 0x54, 0x70, 0x96, 0x3e, 0x19, 0xf9, 0x2e, 0x00, 0x02,
    0x12, 0x9f, 0xff, 0xfd, 0x2d, 0x06, 0x77, 0xb9, 0x44, 0x47, 0x30, 0x2d,
    0x0b, 0xff, 0xf0, 0xb5, 0x97, 0x97, 0xf0, 0x27, 0x27, 0x27, 0x21, 0xf7,
    0x77, 0x77, 0x77, 0x12, 0x77, 0x77, 0x70, 0x25, 0xff, 0xff, 0xe9, 0xff,
    0x7e, 0xf0, 0x97, 0x97, 0x27, 0x27, 0x27, 0x22, 0xf7, 0x03, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x70, 0x25, 0x54, 0xfc, 0x2b, 0x97, 0x97, 0x27, 0x27,
    0x05, 0x06, 0x77, 0x7e, 0x70, 0x27, 0x4f, 0x77, 0x2f, 0x07, 0x07,
};

//*****************************************************************************
//
// Green horizontal slider image.
//
//*****************************************************************************
const unsigned char g_pucGreenSlider195x37[] =
{
    IMAGE_FMT_8BPP_COMP,
    195, 0,
    37, 0,

    63,
    0x04, 0x04, 0x04,
    0x16, 0x16, 0x16,
    0x01, 0x29, 0x01,
    0x20, 0x21, 0x20,
    0x01, 0x3a, 0x01,
    0x17, 0x35, 0x17,
    0x2d, 0x2e, 0x2d,
    0x01, 0x50, 0x01,
    0x23, 0x43, 0x23,
    0x3a, 0x3a, 0x3a,
    0x01, 0x67, 0x01,
    0x2e, 0x4c, 0x2e,
    0x1a, 0x63, 0x1a,
    0x4b, 0x4b, 0x4b,
    0x02, 0x7e, 0x02,
    0x2f, 0x65, 0x2f,
    0x19, 0x76, 0x19,
    0x46, 0x59, 0x46,
    0x02, 0x8b, 0x02,
    0x02, 0x97, 0x02,
    0x5a, 0x5a, 0x5a,
    0x17, 0x90, 0x17,
    0x50, 0x6c, 0x50,
    0x02, 0xa3, 0x02,
    0x05, 0xa4, 0x05,
    0x0a, 0xa6, 0x0a,
    0x68, 0x68, 0x68,
    0x0f, 0xa8, 0x0f,
    0x13, 0xa9, 0x13,
    0x1f, 0xad, 0x1f,
    0x38, 0x9c, 0x38,
    0x73, 0x73, 0x73,
    0x6b, 0x7c, 0x6b,
    0x2a, 0xb1, 0x2a,
    0x7c, 0x7e, 0x7c,
    0x33, 0xb5, 0x33,
    0x4d, 0xa5, 0x4d,
    0x6d, 0x93, 0x6d,
    0x56, 0xa4, 0x56,
    0x63, 0xa0, 0x63,
    0x42, 0xba, 0x42,
    0x89, 0x89, 0x89,
    0x56, 0xb7, 0x56,
    0x4e, 0xbf, 0x4e,
    0x91, 0x91, 0x91,
    0x8f, 0x95, 0x8f,
    0x59, 0xc3, 0x59,
    0x71, 0xb9, 0x71,
    0x9e, 0x9e, 0x9e,
    0x64, 0xc7, 0x64,
    0x87, 0xb4, 0x87,
    0x6c, 0xca, 0x6c,
    0xa8, 0xa8, 0xa8,
    0x75, 0xcd, 0x75,
    0x7b, 0xcf, 0x7b,
    0x82, 0xd2, 0x82,
    0x8d, 0xcf, 0x8d,
    0x8b, 0xd5, 0x8b,
    0x98, 0xce, 0x98,
    0x92, 0xd7, 0x92,
    0x95, 0xd8, 0x95,
    0x9c, 0xdb, 0x9c,
    0xa3, 0xdc, 0xa3,
    0xa9, 0xe0, 0xa9,

    0x80, 0x07, 0x06, 0x20, 0x32, 0x3a, 0x3d, 0x3d, 0x3c, 0x0f, 0x3c, 0x3b,
    0x3b, 0x3b, 0xe9, 0xd4, 0xa7, 0x5f, 0xff, 0x17, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xfc, 0x07, 0x07, 0x07, 0x07, 0x07, 0x06, 0x39, 0x39,
    0x00, 0x39, 0x37, 0x2f, 0x27, 0x16, 0x0b, 0x03, 0x00, 0x38, 0x00, 0x00,
    0xe9, 0xd4, 0xa7, 0x0b, 0x32, 0x3e, 0x00, 0x3f, 0x3e, 0x3d, 0x3d, 0x3c,
    0x3b, 0x3b, 0x39, 0x3f, 0x39, 0x39, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf0, 0x07, 0x07,
    0x07, 0x07, 0x37, 0x37, 0x37, 0x36, 0x00, 0x35, 0x33, 0x31, 0x24, 0x0f,
    0x05, 0x01, 0x00, 0x38, 0x00, 0x00, 0xe9, 0xd4, 0xa3, 0x25, 0x3e, 0x3f,
    0x00, 0x3f, 0x3e, 0x3d, 0x3c, 0x3b, 0x39, 0x39, 0x37, 0x3f, 0x37, 0x37,
    0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf0, 0x07, 0x07, 0x07, 0x07, 0x37, 0x36, 0x36, 0x35,
    0x00, 0x35, 0x33, 0x31, 0x2e, 0x2b, 0x28, 0x1e, 0x0f, 0x06, 0x01, 0x01,
    0x00, 0x00, 0x00, 0xe9, 0xd4, 0x00, 0x00, 0x03, 0x32, 0x3f, 0x3f, 0x3f,
    0x3e, 0x3d, 0x3b, 0x00, 0x39, 0x37, 0x37, 0x36, 0x36, 0x35, 0x35, 0x35,
    0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xc0, 0x07, 0x07, 0x35, 0x33, 0x33,
    0x33, 0x31, 0x2e, 0x00, 0x2e, 0x2b, 0x28, 0x23, 0x21, 0x10, 0x05, 0x01,
    0x0c, 0x01, 0x00, 0x00, 0x00, 0xe9, 0xd2, 0x03, 0x32, 0x00, 0x3f, 0x3f,
    0x3e, 0x3d, 0x3c, 0x39, 0x37, 0x36, 0x03, 0x35, 0x33, 0x33, 0x31, 0x31,
    0x31, 0xe9, 0xd4, 0xff, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x80, 0x02, 0x2e,
    0x2e, 0x2e, 0x2b, 0x28, 0x23, 0x21, 0x00, 0x1d, 0x1c, 0x10, 0x06, 0x03,
    0x01, 0x00, 0x00, 0x60, 0x00, 0xe9, 0xd1, 0x32, 0x3e, 0x3e, 0x3e, 0x3d,
    0x08, 0x3b, 0x37, 0x36, 0x33, 0x01, 0x2b, 0x2b, 0x2b, 0xff, 0xe9, 0xd4,
    0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xe0, 0x07, 0x07, 0x05, 0x28, 0x28, 0x28, 0x23, 0x21,
    0x00, 0x1c, 0x19, 0x17, 0x10, 0x06, 0x03, 0x01, 0x00, 0x20, 0x00, 0x00,
    0xe9, 0x00, 0x25, 0x3d, 0x3d, 0x3d, 0x04, 0x3c, 0x39, 0x37, 0x33, 0x31,
    0x12, 0x23, 0x23, 0x7f, 0x23, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf0, 0x07, 0x07,
    0x07, 0x07, 0x23, 0x21, 0x1d, 0x1b, 0x00, 0x17, 0x13, 0x13, 0x0f, 0x06,
    0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x38, 0x3c, 0x3b,
    0x02, 0x3b, 0x37, 0x36, 0x31, 0x2b, 0x28, 0x31, 0x1d, 0x1f, 0x1c, 0x1c,
    0x1c, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xfc, 0x07, 0x07, 0x07, 0x07, 0x07, 0x03, 0x1d, 0x1d,
    0x40, 0x1d, 0xe9, 0x1c, 0x18, 0x17, 0x13, 0x12, 0x10, 0x00, 0x0b, 0x06,
    0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x39, 0x39, 0x39, 0x37,
    0x35, 0x31, 0x2b, 0x00, 0x23, 0x21, 0x1c, 0x1b, 0x19, 0x18, 0x18, 0x17,
    0x3f, 0x17, 0x17, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf0, 0x07, 0x07, 0x07, 0x07, 0x17,
    0x17, 0x18, 0x18, 0x00, 0x19, 0x19, 0x1b, 0x1c, 0x1c, 0x1c, 0x19, 0x17,
    0x00, 0x13, 0x12, 0x12, 0x0e, 0x0f, 0x09, 0x06, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x05, 0x36, 0x37, 0x36, 0x36, 0x00, 0x33, 0x31, 0x2b, 0x23, 0x1d,
    0x1c, 0x19, 0x18, 0x0f, 0x18, 0x17, 0x17, 0x17, 0xe9, 0xd4, 0xa7, 0x5f,
    0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfe, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x05, 0x18, 0x00, 0x18, 0x19, 0x19, 0x19, 0x17,
    0x13, 0x13, 0x12, 0x00, 0x0e, 0x0e, 0x10, 0x11, 0x09, 0x03, 0x01, 0x00,
    0x00, 0x00, 0x16, 0x35, 0x35, 0x35, 0x33, 0x31, 0x2b, 0x00, 0x23, 0x1d,
    0x1c, 0x19, 0x18, 0x17, 0x17, 0x17, 0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0x17,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xe0, 0x07, 0x07, 0x07, 0x17, 0x17, 0x18, 0x18, 0x18, 0x00, 0x17, 0x13,
    0x12, 0x0e, 0x0e, 0x0a, 0x0a, 0x16, 0x00, 0x0d, 0x06, 0x01, 0x00, 0x00,
    0x26, 0x33, 0x31, 0x00, 0x31, 0x2e, 0x2b, 0x28, 0x21, 0x1c, 0x19, 0x18,
    0xff, 0x03, 0xdb, 0xb7, 0x6f, 0x27, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf0, 0x07, 0x07, 0x07, 0x07, 0x13,
    0x12, 0x0e, 0x0a, 0x00, 0x0a, 0x0a, 0x0f, 0x14, 0x09, 0x03, 0x01, 0x00,
    0x00, 0x2a, 0x2e, 0x2e, 0x2e, 0x2b, 0x28, 0x23, 0x1d, 0x3f, 0x1b, 0x18,
    0x07, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x17, 0x13, 0x12,
    0x00, 0x0e, 0x0e, 0x0a, 0x0a, 0x07, 0x0c, 0x1a, 0x0d, 0x00, 0x06, 0x01,
    0x00, 0x2b, 0x2b, 0x2b, 0x2b, 0x28, 0x07, 0x23, 0x21, 0x1c, 0x19, 0x18,
    0x07, 0xbf, 0x77, 0xff, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x17, 0x13,
    0x12, 0x0e, 0x0a, 0x0a, 0x07, 0x07, 0x00, 0x07, 0x1f, 0x14, 0x09, 0x03,
    0x00, 0x28, 0x28, 0x01, 0x28, 0x28, 0x28, 0x23, 0x1d, 0x1c, 0x18, 0x07,
    0xff, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xc0, 0x07, 0x07, 0x17, 0x17, 0x13,
    0x12, 0x0e, 0x0a, 0x00, 0x0a, 0x07, 0x07, 0x04, 0x22, 0x14, 0x09, 0x03,
    0x00, 0x01, 0x23, 0x23, 0x23, 0x23, 0x23, 0x21, 0x1d, 0x3f, 0x1b, 0x18,
    0x07, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x17, 0x17, 0x13,
    0x00, 0x12, 0x0e, 0x0a, 0x07, 0x07, 0x04, 0x04, 0x29, 0x00, 0x1a, 0x09,
    0x03, 0x01, 0x21, 0x21, 0x21, 0x21, 0x0f, 0x21, 0x1d, 0x1c, 0x19, 0x07,
    0xbf, 0x77, 0x2f, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x01, 0x00, 0x13, 0x0e,
    0x0a, 0x0a, 0x07, 0x04, 0x04, 0x05, 0x00, 0x29, 0x1a, 0x0d, 0x06, 0x01,
    0x1d, 0x1d, 0x1d, 0x07, 0x1d, 0x1d, 0x1c, 0x1c, 0x19, 0x07, 0xbf, 0x77,
    0xff, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x17, 0x17, 0x13, 0x12, 0x0e,
    0x0a, 0x07, 0x04, 0x00, 0x04, 0x02, 0x0b, 0x29, 0x1a, 0x0d, 0x06, 0x01,
    0x00, 0x15, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x19, 0x18, 0xff, 0x07, 0xbf,
    0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xe0, 0x07, 0x07, 0x07, 0x17, 0x13, 0x13, 0x0e, 0x0a,
    0x00, 0x07, 0x07, 0x04, 0x02, 0x02, 0x11, 0x29, 0x1a, 0x0f, 0x0d, 0x06,
    0x01, 0x10, 0x07, 0xbf, 0x77, 0x2f, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05,
    0x00, 0x13, 0x13, 0x12, 0x0e, 0x0a, 0x07, 0x04, 0x02, 0x00, 0x02, 0x02,
    0x20, 0x29, 0x1a, 0x0d, 0x06, 0x01, 0x09, 0x08, 0x13, 0x13, 0x13, 0xe9,
    0x13, 0x13, 0x05, 0xff, 0xcd, 0x97, 0x4f, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xc0, 0x07, 0x07,
    0x17, 0x17, 0x13, 0x13, 0x12, 0x0e, 0x00, 0x0a, 0x07, 0x04, 0x02, 0x02,
    0x02, 0x08, 0x2d, 0x00, 0x29, 0x1a, 0x09, 0x03, 0x01, 0x03, 0x10, 0x12,
    0x23, 0x12, 0x12, 0xe9, 0x13, 0x13, 0x13, 0x02, 0xe2, 0xff, 0xc6, 0x87,
    0x3f, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xc0, 0x07, 0x03, 0x13, 0x13, 0x12, 0x12, 0x0e, 0x0a,
    0x00, 0x07, 0x04, 0x02, 0x02, 0x02, 0x02, 0x16, 0x30, 0x00, 0x22, 0x14,
    0x09, 0x03, 0x01, 0x03, 0x0b, 0x0e, 0x20, 0x0e, 0x0e, 0xe9, 0x0e, 0x12,
    0x12, 0x12, 0x13, 0x3f, 0x13, 0x13, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf8, 0x07, 0x07,
    0x07, 0x07, 0x05, 0x12, 0x12, 0x0e, 0x00, 0x0e, 0x0a, 0x0a, 0x07, 0x04,
    0x02, 0x02, 0x02, 0x00, 0x02, 0x08, 0x2d, 0x2c, 0x1f, 0x14, 0x09, 0x03,
    0x0a, 0x00, 0x01, 0x06, 0x0c, 0x61, 0x0a, 0xe9, 0x0e, 0x3f, 0x0e, 0x0e,
    0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0e, 0x0a, 0x0a,
    0x00, 0x0a, 0x07, 0x04, 0x04, 0x02, 0x02, 0x02, 0x02, 0x00, 0x02, 0x20,
    0x30, 0x29, 0x1a, 0x0d, 0x06, 0x01, 0x07, 0x00, 0x01, 0x06, 0x0d, 0x0c,
    0x49, 0x31, 0xd4, 0xff, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xc0, 0x07, 0x05,
    0x07, 0x07, 0x07, 0x04, 0x02, 0x02, 0x40, 0x02, 0xe9, 0x16, 0x34, 0x2c,
    0x22, 0x14, 0x09, 0x00, 0x03, 0x01, 0x00, 0x01, 0x03, 0x09, 0x11, 0x0c,
    0xff, 0x41, 0x29, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x03,
    0x04, 0x04, 0x04, 0x10, 0x02, 0x02, 0x02, 0xe9, 0x02, 0x16, 0x30, 0x30,
    0x00, 0x29, 0x1a, 0x0d, 0x06, 0x01, 0x00, 0x00, 0x00, 0x07, 0x01, 0x06,
    0x09, 0x11, 0x0c, 0x23, 0x09, 0xd4, 0xff, 0xa7, 0x5f, 0x17, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x83, 0x07, 0x04, 0x04, 0x02, 0x02, 0x02, 0xe9, 0xd1, 0x00, 0x16, 0x30,
    0x30, 0x29, 0x1f, 0x14, 0x09, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
    0x01, 0x06, 0x0d, 0x3f, 0x1a, 0x0f, 0x17, 0xd4, 0xa7, 0x5f, 0x17, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfc, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x05, 0x08, 0x20, 0x00, 0x34, 0x30, 0x2c, 0x1f, 0x14,
    0x09, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x09,
    0x0f, 0x0d, 0x1a, 0x16, 0x08, 0x07, 0xbf, 0x77, 0x2f, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfe, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x08, 0x00, 0x16, 0x2d, 0x34, 0x30, 0x29, 0x1f, 0x14, 0x0d,
    0x02, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00, 0xe9, 0x01, 0x00, 0x03, 0x09,
    0x0d, 0x1a, 0x22, 0x20, 0x11, 0x08, 0x7f, 0x05, 0x02, 0xe2, 0xc6, 0x87,
    0x3f, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xf8, 0x07, 0x07, 0x07, 0x07, 0x01, 0x05, 0x0b, 0x16, 0x00, 0x22, 0x30,
    0x34, 0x30, 0x2c, 0x29, 0x1f, 0x14, 0x01, 0x0d, 0x06, 0x03, 0x01, 0x00,
    0x00, 0x00, 0xe9, 0x00, 0x00, 0x00, 0x01, 0x03, 0x09, 0x0d, 0x14, 0x1f,
    0x01, 0x22, 0x2c, 0x30, 0x30, 0x34, 0x34, 0x34, 0xe9, 0xff, 0xd4, 0xa7,
    0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xc0, 0x07, 0x07, 0x30, 0x30, 0x2c, 0x29, 0x22, 0x1a,
    0x00, 0x14, 0x09, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00, 0xc0, 0xe9, 0xd2,
    0x01, 0x03, 0x06, 0x09, 0x0d, 0x1a, 0x01, 0x1f, 0x22, 0x29, 0x29, 0x2c,
    0x2c, 0x2c, 0xe9, 0xff, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xc0, 0x07, 0x05,
    0x29, 0x29, 0x22, 0x1f, 0x1a, 0x14, 0x00, 0x0d, 0x09, 0x06, 0x03, 0x01,
    0x00, 0x00, 0x00, 0xc0, 0xe9, 0xd4, 0x01, 0x01, 0x06, 0x09, 0x0d, 0x0d,
    0x03, 0x14, 0x1a, 0x1a, 0x1f, 0x1f, 0x1f, 0xe9, 0xd4, 0xff, 0xa7, 0x5f,
    0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x80, 0x05, 0x1a, 0x1a, 0x14, 0x14, 0x0d, 0x09, 0x06,
    0x03, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0xe9, 0xd4, 0x00, 0x00, 0x00,
    0x01, 0x01, 0x03, 0x06, 0x06, 0x09, 0x0f, 0x09, 0x0d, 0x0d, 0x0d, 0xe9,
    0xd4, 0xa7, 0x5f, 0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xfe, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x09, 0x00, 0x09, 0x09,
    0x06, 0x03, 0x01, 0x01, 0x00, 0x00, 0x70, 0x00, 0xe9, 0xd4, 0xa4, 0x01,
    0x01, 0x01, 0x03, 0x0f, 0x03, 0x06, 0x06, 0x06, 0xe9, 0xd4, 0xa7, 0x5f,
    0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfe, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x03, 0x01, 0x03, 0x03, 0x01, 0x01, 0x00,
    0x00, 0x00, 0xe9, 0xc1, 0xd4, 0xa7, 0x00, 0x00, 0x01, 0x01, 0x01, 0xe9,
    0xff, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xe3, 0x07, 0x07, 0x02, 0x00, 0x00,
    0x00, 0xe9, 0xd4, 0xff, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfc, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x06,
};

//*****************************************************************************
//
// Red horizontal slider image.
//
//*****************************************************************************
const unsigned char g_pucRedSlider195x37[] =
{
    IMAGE_FMT_8BPP_COMP,
    195, 0,
    37, 0,

    63,
    0x04, 0x04, 0x04,
    0x00, 0x00, 0x40,
    0x16, 0x16, 0x16,
    0x00, 0x00, 0x5b,
    0x0c, 0x0c, 0x48,
    0x23, 0x23, 0x23,
    0x00, 0x00, 0x7c,
    0x20, 0x20, 0x35,
    0x15, 0x15, 0x52,
    0x00, 0x00, 0x93,
    0x2e, 0x2e, 0x2e,
    0x00, 0x00, 0xa1,
    0x00, 0x00, 0xb4,
    0x27, 0x27, 0x59,
    0x00, 0x00, 0xc7,
    0x14, 0x14, 0x9d,
    0x3d, 0x3d, 0x3e,
    0x25, 0x25, 0x79,
    0x00, 0x00, 0xd9,
    0x1f, 0x1f, 0xa3,
    0x00, 0x00, 0xec,
    0x13, 0x13, 0xc3,
    0x00, 0x00, 0xf3,
    0x00, 0x00, 0xfa,
    0x30, 0x30, 0x8a,
    0x4c, 0x4c, 0x4c,
    0x00, 0x00, 0xff,
    0x46, 0x46, 0x65,
    0x05, 0x05, 0xff,
    0x0b, 0x0b, 0xff,
    0x11, 0x11, 0xff,
    0x5a, 0x5a, 0x5a,
    0x50, 0x50, 0x7e,
    0x21, 0x21, 0xff,
    0x36, 0x36, 0xd5,
    0x68, 0x68, 0x68,
    0x32, 0x32, 0xff,
    0x73, 0x73, 0x73,
    0x6b, 0x6b, 0x88,
    0x51, 0x51, 0xd4,
    0x67, 0x67, 0xb6,
    0x4c, 0x4c, 0xff,
    0x55, 0x55, 0xef,
    0x85, 0x85, 0x85,
    0x5a, 0x5a, 0xff,
    0x8e, 0x8e, 0x96,
    0x91, 0x91, 0x91,
    0x63, 0x63, 0xff,
    0x70, 0x70, 0xe3,
    0x93, 0x93, 0x9e,
    0x6b, 0x6b, 0xff,
    0x9b, 0x9b, 0x9b,
    0x86, 0x86, 0xcd,
    0x74, 0x74, 0xff,
    0xa0, 0xa0, 0xa2,
    0x7a, 0x7a, 0xfe,
    0x81, 0x81, 0xff,
    0xa8, 0xa8, 0xa8,
    0x8c, 0x8c, 0xf6,
    0x8a, 0x8a, 0xff,
    0x97, 0x97, 0xee,
    0x91, 0x91, 0xff,
    0x9a, 0x9a, 0xff,
    0xa5, 0xa5, 0xfe,

    0x80, 0x07, 0x07, 0x26, 0x34, 0x3c, 0x3e, 0x3e, 0x3e, 0x1f, 0x3d, 0x3d,
    0x3d, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x3b, 0x3b, 0x3b,
    0x00, 0x38, 0x30, 0x28, 0x20, 0x0d, 0x02, 0x00, 0x00, 0x70, 0x00, 0xe9,
    0xd4, 0xa7, 0x10, 0x34, 0x3f, 0x3f, 0x00, 0x3f, 0x3e, 0x3e, 0x3d, 0x3d,
    0x3d, 0x3b, 0x3b, 0x7f, 0x3b, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xe0, 0x07, 0x07,
    0x07, 0x38, 0x38, 0x38, 0x37, 0x35, 0x00, 0x32, 0x2f, 0x27, 0x18, 0x07,
    0x02, 0x00, 0x00, 0x70, 0x00, 0xe9, 0xd4, 0xa3, 0x28, 0x3f, 0x3f, 0x3f,
    0x00, 0x3f, 0x3e, 0x3e, 0x3d, 0x3b, 0x3b, 0x38, 0x38, 0x7f, 0x38, 0xe9,
    0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xe0, 0x07, 0x07, 0x07, 0x38, 0x37, 0x37, 0x35, 0x35,
    0x00, 0x32, 0x2f, 0x2c, 0x29, 0x29, 0x22, 0x11, 0x02, 0x0c, 0x02, 0x00,
    0x00, 0x00, 0xe9, 0xd4, 0x00, 0x07, 0x00, 0x34, 0x3f, 0x3f, 0x3f, 0x3f,
    0x3e, 0x3d, 0x3b, 0x01, 0x38, 0x38, 0x37, 0x37, 0x35, 0x35, 0x35, 0xe9,
    0xff, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x80, 0x07, 0x35, 0x32, 0x32, 0x32,
    0x2f, 0x2c, 0x2c, 0x00, 0x29, 0x24, 0x24, 0x21, 0x13, 0x07, 0x02, 0x02,
    0x18, 0x00, 0x00, 0x00, 0xe9, 0xd2, 0x07, 0x34, 0x3f, 0x00, 0x3f, 0x3f,
    0x3e, 0x3e, 0x3b, 0x38, 0x37, 0x35, 0x07, 0x32, 0x32, 0x2f, 0x2f, 0x2f,
    0xe9, 0xd4, 0xa7, 0xff, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x01, 0x00, 0x2c, 0x2c,
    0x2c, 0x2c, 0x29, 0x29, 0x24, 0x24, 0x00, 0x21, 0x1e, 0x13, 0x07, 0x02,
    0x02, 0x00, 0x00, 0x60, 0x00, 0xe9, 0xd1, 0x34, 0x3f, 0x3f, 0x3e, 0x3e,
    0x05, 0x3d, 0x38, 0x37, 0x32, 0x2f, 0x0a, 0x29, 0xe9, 0xff, 0xd4, 0xa7,
    0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xc0, 0x07, 0x07, 0x24, 0x24, 0x21, 0x1e, 0x1d, 0x1a,
    0x01, 0x13, 0x0a, 0x05, 0x02, 0x00, 0x00, 0x00, 0xe9, 0x00, 0x00, 0x28,
    0x3e, 0x3e, 0x3e, 0x3d, 0x3b, 0x38, 0x2f, 0x32, 0x2f, 0x1b, 0x24, 0xe9,
    0xd4, 0xa7, 0x5f, 0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xfe, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x24, 0x00, 0x24, 0x21,
    0x21, 0x1e, 0x1a, 0x16, 0x14, 0x18, 0x00, 0x0a, 0x05, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0d, 0x3a, 0x3d, 0x3d, 0x3d, 0x38, 0x37, 0x2f,
    0x27, 0x29, 0x29, 0x32, 0x1e, 0x1e, 0xe9, 0xd4, 0xa7, 0xff, 0x5f, 0x17,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x05, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x1e, 0x1c, 0x16,
    0x00, 0x14, 0x12, 0x15, 0x1b, 0x0a, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x28, 0x3b, 0x3b, 0x3b, 0x38, 0x00, 0x35, 0x2f, 0x29, 0x24, 0x21,
    0x1e, 0x1e, 0x1d, 0x0f, 0x1c, 0x1a, 0x1a, 0x1a, 0xe9, 0xd4, 0xa7, 0x5f,
    0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfe, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x02, 0x1c, 0x00, 0x1c, 0x1d, 0x1d, 0x1e, 0x1e,
    0x1e, 0x1c, 0x17, 0x00, 0x14, 0x12, 0x12, 0x0e, 0x18, 0x10, 0x0a, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x07, 0x37, 0x38, 0x37, 0x37, 0x00, 0x32, 0x2f,
    0x29, 0x24, 0x21, 0x1e, 0x1d, 0x1c, 0x1f, 0x1a, 0x1a, 0x1a, 0xe9, 0xd4,
    0xa7, 0x5f, 0x17, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xfc, 0x07, 0x07, 0x07, 0x07, 0x07, 0x06, 0x1c, 0x1c, 0x00, 0x1c, 0x1d,
    0x1c, 0x1a, 0x16, 0x14, 0x12, 0x0e, 0x00, 0x0c, 0x0f, 0x1b, 0x10, 0x05,
    0x02, 0x00, 0x00, 0x00, 0x20, 0x35, 0x35, 0x35, 0x32, 0x2c, 0x29, 0x24,
    0x27, 0x21, 0x1e, 0x39, 0x1a, 0x1a, 0xe9, 0xd4, 0xa7, 0xff, 0x5f, 0x17,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x00, 0x1a, 0x1a, 0x1c, 0x1c, 0x1a, 0x17, 0x14, 0x12,
    0x00, 0x0e, 0x0c, 0x0c, 0x0b, 0x20, 0x19, 0x0a, 0x02, 0x00, 0x00, 0x00,
    0x27, 0x32, 0x2f, 0x2f, 0x2c, 0x29, 0x07, 0x24, 0x21, 0x1e, 0x1d, 0x1c,
    0x03, 0xdb, 0xb7, 0xff, 0x6f, 0x27, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x80, 0x06, 0x16,
    0x14, 0x12, 0x0e, 0x0c, 0x0b, 0x09, 0x00, 0x18, 0x1f, 0x10, 0x05, 0x02,
    0x00, 0x2a, 0x2c, 0x00, 0x2c, 0x2c, 0x29, 0x29, 0x24, 0x21, 0x1d, 0x1c,
    0xff, 0x07, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xe0, 0x07, 0x07, 0x07, 0x1a, 0x16,
    0x12, 0x0e, 0x0c, 0x00, 0x0b, 0x09, 0x09, 0x11, 0x23, 0x19, 0x0a, 0x02,
    0x00, 0x00, 0x29, 0x29, 0x29, 0x29, 0x29, 0x24, 0x21, 0x3f, 0x1e, 0x1c,
    0x07, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x1a, 0x1a, 0x16,
    0x00, 0x12, 0x0e, 0x0c, 0x0b, 0x09, 0x06, 0x06, 0x25, 0x00, 0x1f, 0x0a,
    0x02, 0x00, 0x29, 0x29, 0x29, 0x29, 0x07, 0x24, 0x24, 0x21, 0x1e, 0x1c,
    0x07, 0xbf, 0x77, 0xff, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x1a, 0x17,
    0x14, 0x12, 0x0e, 0x0b, 0x09, 0x06, 0x00, 0x06, 0x03, 0x2b, 0x1f, 0x10,
    0x05, 0x02, 0x24, 0x01, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x1d, 0x07,
    0xff, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xc0, 0x07, 0x07, 0x1a, 0x1a, 0x17,
    0x14, 0x0e, 0x0c, 0x00, 0x0b, 0x06, 0x06, 0x03, 0x03, 0x2b, 0x23, 0x10,
    0x00, 0x05, 0x02, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x3f, 0x1e, 0x1d,
    0x07, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x1a, 0x17, 0x16,
    0x00, 0x14, 0x0e, 0x0c, 0x09, 0x06, 0x03, 0x03, 0x08, 0x00, 0x2b, 0x23,
    0x19, 0x05, 0x02, 0x21, 0x21, 0x21, 0x07, 0x21, 0x21, 0x1e, 0x1e, 0x1c,
    0x07, 0xbf, 0x77, 0xff, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x1a, 0x17,
    0x14, 0x12, 0x0c, 0x0b, 0x06, 0x03, 0x00, 0x03, 0x01, 0x0d, 0x2e, 0x23,
    0x19, 0x0a, 0x02, 0x0b, 0x15, 0x1d, 0x1d, 0x1d, 0xe9, 0x1c, 0x07, 0xbf,
    0xff, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x80, 0x07, 0x17, 0x16, 0x14, 0x0e,
    0x0b, 0x09, 0x06, 0x00, 0x03, 0x01, 0x01, 0x1b, 0x2e, 0x23, 0x19, 0x0a,
    0x03, 0x02, 0x0f, 0x17, 0x17, 0x17, 0x17, 0x49, 0xda, 0xff, 0x02, 0xd4,
    0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf0, 0x07, 0x07, 0x07, 0x01, 0x17, 0x16, 0x14, 0x12,
    0x00, 0x0c, 0x09, 0x06, 0x03, 0x01, 0x01, 0x01, 0x26, 0x00, 0x2b, 0x23,
    0x19, 0x05, 0x02, 0x0d, 0x14, 0x14, 0x41, 0x14, 0xe9, 0x16, 0x16, 0x16,
    0x17, 0x17, 0x01, 0xff, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xe0, 0x07, 0x07,
    0x06, 0x17, 0x17, 0x16, 0x14, 0x12, 0x00, 0x0e, 0x0b, 0x06, 0x03, 0x01,
    0x01, 0x01, 0x0d, 0x00, 0x2d, 0x2b, 0x23, 0x10, 0x05, 0x02, 0x05, 0x15,
    0x10, 0x12, 0x12, 0x12, 0xe9, 0x14, 0x14, 0x16, 0x16, 0x07, 0x17, 0x17,
    0x1a, 0x1a, 0x1a, 0xe9, 0xd4, 0xa7, 0xff, 0x5f, 0x17, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x02,
    0x00, 0x17, 0x17, 0x16, 0x14, 0x12, 0x12, 0x0c, 0x0b, 0x00, 0x06, 0x03,
    0x01, 0x01, 0x01, 0x01, 0x20, 0x33, 0x00, 0x2b, 0x1f, 0x10, 0x05, 0x02,
    0x05, 0x0d, 0x0e, 0x20, 0x0e, 0x0e, 0xe9, 0x0e, 0x12, 0x12, 0x12, 0x14,
    0x3f, 0x14, 0x14, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x05,
    0x12, 0x12, 0x0e, 0x00, 0x0e, 0x0c, 0x09, 0x06, 0x03, 0x01, 0x01, 0x01,
    0x00, 0x01, 0x0d, 0x2d, 0x2e, 0x25, 0x1f, 0x0a, 0x02, 0x01, 0x00, 0x02,
    0x0a, 0x13, 0x0c, 0x0c, 0x0c, 0xe9, 0x8f, 0xd1, 0x0e, 0x0e, 0x0e, 0xe9,
    0xd4, 0xa7, 0x5f, 0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xfe, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x0c, 0x00, 0x0c, 0x0b,
    0x09, 0x06, 0x03, 0x03, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x26, 0x36,
    0x2b, 0x23, 0x19, 0x00, 0x0a, 0x02, 0x00, 0x02, 0x05, 0x10, 0x0f, 0x0b,
    0x00, 0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0b, 0x0b, 0x7f, 0x0b, 0xe9,
    0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf0, 0x07, 0x07, 0x07, 0x05, 0x09, 0x09, 0x06, 0x06,
    0x04, 0x06, 0x03, 0x01, 0x01, 0x01, 0xe9, 0x20, 0x39, 0x00, 0x2e, 0x25,
    0x1f, 0x10, 0x05, 0x02, 0x00, 0x02, 0x0f, 0x05, 0x0a, 0x1b, 0x0f, 0x3a,
    0x21, 0xd4, 0xa7, 0xff, 0x5f, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x81, 0x02, 0x03,
    0x03, 0x03, 0x01, 0x01, 0x01, 0xe9, 0x00, 0x01, 0x1b, 0x36, 0x33, 0x2b,
    0x23, 0x19, 0x0a, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x05, 0x10, 0x1b,
    0x7f, 0x11, 0x23, 0x09, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xff, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x03, 0x03, 0x01, 0x30, 0x01, 0x01, 0xe9, 0xd1, 0x20, 0x36, 0x36, 0x2e,
    0x00, 0x25, 0x1f, 0x10, 0x05, 0x02, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02,
    0x0a, 0x19, 0x23, 0x11, 0x17, 0xd4, 0xff, 0xa7, 0x5f, 0x17, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xc0, 0x07, 0x05, 0x0d, 0x26, 0x39, 0x36, 0x2e, 0x25, 0x00, 0x1f, 0x10,
    0x0a, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x0a, 0x19,
    0x23, 0x20, 0x0d, 0xff, 0x07, 0xbf, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07,
    0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xe0, 0x07, 0x07,
    0x07, 0x0d, 0x20, 0x31, 0x39, 0x33, 0x00, 0x2e, 0x25, 0x1f, 0x19, 0x0a,
    0x02, 0x02, 0x00, 0x20, 0x00, 0x00, 0xe9, 0x02, 0x05, 0x10, 0x19, 0x23,
    0x07, 0x25, 0x25, 0x1b, 0x0d, 0x04, 0x02, 0xe2, 0xc6, 0xff, 0x87, 0x3f,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x80, 0x01, 0x08, 0x0d, 0x20, 0x26, 0x36, 0x39, 0x36,
    0x00, 0x2e, 0x2b, 0x25, 0x1f, 0x19, 0x0a, 0x05, 0x02, 0x10, 0x00, 0x00,
    0x00, 0xe9, 0x00, 0x00, 0x02, 0x05, 0x00, 0x0a, 0x19, 0x1f, 0x25, 0x2b,
    0x2e, 0x33, 0x36, 0x0f, 0x36, 0x39, 0x39, 0x39, 0xe9, 0xd4, 0xa7, 0x5f,
    0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfe, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x05, 0x36, 0x00, 0x36, 0x33, 0x2e, 0x2b, 0x25,
    0x23, 0x1f, 0x10, 0x03, 0x0a, 0x05, 0x02, 0x00, 0x00, 0x00, 0xe9, 0xd2,
    0x00, 0x02, 0x05, 0x0a, 0x10, 0x19, 0x23, 0x25, 0x25, 0x07, 0x2b, 0x2b,
    0x2e, 0x2e, 0x2e, 0xe9, 0xd4, 0xa7, 0xff, 0x5f, 0x17, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05,
    0x00, 0x2b, 0x2b, 0x2b, 0x25, 0x23, 0x1f, 0x19, 0x10, 0x03, 0x0a, 0x02,
    0x02, 0x00, 0x00, 0x00, 0xe9, 0xd4, 0x00, 0x02, 0x02, 0x05, 0x0a, 0x10,
    0x19, 0x1f, 0x23, 0x0f, 0x23, 0x25, 0x25, 0x25, 0xe9, 0xd4, 0xa7, 0x5f,
    0xff, 0x17, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xfe, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x05, 0x23, 0x00, 0x23, 0x1f, 0x1f, 0x19, 0x10,
    0x0a, 0x05, 0x02, 0x0c, 0x02, 0x00, 0x00, 0x00, 0xe9, 0xd4, 0x00, 0x00,
    0x00, 0x02, 0x02, 0x05, 0x05, 0x0a, 0x10, 0x10, 0x19, 0x3f, 0x19, 0x19,
    0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x10, 0x10, 0x0a,
    0x01, 0x0a, 0x05, 0x02, 0x02, 0x00, 0x00, 0x00, 0xe9, 0xc0, 0xd4, 0xa4,
    0x02, 0x02, 0x02, 0x05, 0x05, 0x0a, 0x3f, 0x0a, 0x0a, 0xe9, 0xd4, 0xa7,
    0x5f, 0x17, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xf8, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x02, 0x07, 0x02, 0x02,
    0x00, 0x00, 0x00, 0xe9, 0xd4, 0xa7, 0x3f, 0x00, 0x00, 0x31, 0x19, 0xd4,
    0xa7, 0x5f, 0x17, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xfe, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x02, 0x00, 0x3f, 0x00, 0x00,
    0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0xff, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0xc0, 0x07, 0x06,
};
