//*****************************************************************************
//
// images.c - Data for images used in the user interface.
//
// Copyright (c) 2008-2012 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 9453 of the RDK-IDM Firmware Package.
//
//*****************************************************************************

#include "grlib/grlib.h"

//*****************************************************************************
//
// This image contains the Texas Instruments name, used in the splash screen
// and across the top of the main screen.
//
//*****************************************************************************
const unsigned char g_pucTIName[] =
{
    IMAGE_FMT_4BPP_COMP,
    240, 0,
    13, 0,

    15,
    0x00, 0x00, 0x00,
    0x25, 0x26, 0x25,
    0x53, 0x53, 0x52,
    0x79, 0x7a, 0x79,
    0x92, 0x92, 0x90,
    0xa1, 0xa1, 0xa0,
    0xad, 0xae, 0xab,
    0xba, 0xbb, 0xb9,
    0xc5, 0xc6, 0xc4,
    0xd1, 0xd1, 0xcf,
    0xdc, 0xdc, 0xdb,
    0xe2, 0xe3, 0xe1,
    0xe8, 0xe8, 0xe7,
    0xed, 0xee, 0xed,
    0xf5, 0xf5, 0xf4,
    0xfc, 0xfc, 0xfb,

    0xe0, 0x07, 0x07, 0x04, 0x28, 0x88, 0x77, 0x78, 0x88, 0x67, 0x30, 0x07,
    0x07, 0x17, 0x78, 0x5f, 0x1f, 0x7f, 0xff, 0x37, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x02, 0x03, 0x8f, 0xdd, 0xff, 0xfd, 0xdf, 0xc0, 0x07, 0x07,
    0x1f, 0x09, 0xfe, 0x10, 0x5f, 0x17, 0x77, 0x2f, 0x07, 0xfc, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x01, 0x51, 0x00, 0x0c, 0x7f, 0xb0, 0x00, 0x41, 0x07,
    0x07, 0x04, 0xfd, 0xff, 0x67, 0x1f, 0x77, 0x2f, 0x07, 0x07, 0x07, 0x07,
    0xe0, 0x07, 0x07, 0x04, 0x6f, 0xa0, 0x08, 0xcc, 0xdd, 0x00, 0xdd, 0x25,
    0xdc, 0xb2, 0x04, 0xdb, 0x20, 0x03, 0x02, 0xda, 0x10, 0x00, 0x1a, 0xee,
    0x97, 0x01, 0x04, 0x00, 0xfd, 0x03, 0xbc, 0x30, 0x01, 0x8c, 0x40, 0x4d,
    0x00, 0xec, 0x92, 0x1c, 0xdc, 0xbc, 0xdd, 0x35, 0xcb, 0x00, 0xcd, 0xc7,
    0x10, 0x4c, 0xc6, 0x00, 0x1a, 0xc3, 0x00, 0x3c, 0xc7, 0x00, 0x00, 0x3c,
    0xc5, 0x2a, 0xbc, 0x00, 0xcc, 0xd8, 0x07, 0xca, 0x10, 0x03, 0xba, 0x2a,
    0x80, 0x19, 0x30, 0x2c, 0xed, 0x83, 0x00, 0x00, 0x00, 0xfc, 0xe9, 0xd4,
    0xa7, 0x5f, 0x17, 0x07, 0x00, 0x00, 0x00, 0x6f, 0xa0, 0x02, 0xff, 0x87,
    0x7d, 0x80, 0xaf, 0x00, 0xd0, 0x04, 0xf3, 0x00, 0x0b, 0xff, 0x30, 0x01,
    0x00, 0xee, 0x66, 0xdf, 0x10, 0x00, 0x00, 0x04, 0xfd, 0x00, 0x00, 0xdf,
    0xf2, 0x00, 0x6f, 0x14, 0xfb, 0x58, 0x00, 0xf8, 0x4e, 0x7c, 0xfd, 0x6d,
    0x91, 0xff, 0x97, 0x00, 0xcf, 0xe1, 0x1f, 0xf2, 0x00, 0x07, 0xf1, 0x0e,
    0x00, 0xff, 0x10, 0x00, 0xdf, 0xf1, 0x0a, 0xfc, 0x77, 0x00, 0x9e, 0x12,
    0xff, 0xa0, 0x00, 0xe9, 0x3e, 0x7b, 0x00, 0xfe, 0x6c, 0xa1, 0xfd, 0x67,
    0xed, 0x00, 0x00, 0x7e, 0x00, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x00,
    0x00, 0x00, 0x6f, 0xa0, 0x01, 0xfe, 0x00, 0x00, 0x30, 0x00, 0x1e, 0xf6,
    0x1e, 0x40, 0x00, 0x2e, 0xaf, 0x90, 0x00, 0x04, 0xf4, 0x00, 0x03, 0x20,
    0x00, 0x00, 0x04, 0x00, 0xfd, 0x00, 0xbf, 0xfe, 0x20, 0x4e, 0x0c, 0xf1,
    0x00, 0x00, 0x16, 0x41, 0x04, 0xf7, 0x00, 0x31, 0xfe, 0x00, 0x10, 0x0c,
    0xf4, 0x0e, 0xf1, 0x00, 0x05, 0xe0, 0x00, 0x0d, 0xef, 0x70, 0x03, 0xff,
    0xe1, 0x07, 0xf4, 0x00, 0x00, 0x01, 0x11, 0xef, 0xf9, 0x00, 0xc7, 0x31,
    0x00, 0x04, 0xf9, 0x00, 0x38, 0xf2, 0x00, 0x05, 0x10, 0x1f, 0x00, 0x00,
    0x00, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x80, 0x07, 0x00, 0x6f, 0xa0, 0x01,
    0xfe, 0x10, 0x13, 0x00, 0x00, 0x02, 0xfe, 0xda, 0x00, 0x00, 0x7c, 0x2f,
    0x04, 0xf1, 0x03, 0xfe, 0x83, 0x10, 0x01, 0x04, 0xfd, 0x00, 0x00, 0xc8,
    0x9f, 0xd0, 0x4e, 0x0a, 0xfb, 0x62, 0x80, 0xa1, 0xf7, 0x00, 0x01, 0xfe,
    0x00, 0x0d, 0xf3, 0x00, 0x0e, 0xf1, 0x00, 0x05, 0xe0, 0x0d, 0x7f, 0xe1,
    0x00, 0x0d, 0xae, 0xe1, 0x08, 0xf5, 0x00, 0x22, 0x01, 0x00, 0xe4, 0xef,
    0x70, 0xc8, 0x00, 0x04, 0xf9, 0x00, 0x01, 0x05, 0xfd, 0x73, 0x10, 0x00,
    0x00, 0x00, 0xe9, 0xf8, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x00, 0x00, 0x6f,
    0x00, 0xa0, 0x01, 0xff, 0xee, 0xfc, 0x00, 0x00, 0x7f, 0x00, 0xf2, 0x00,
    0x00, 0xe4, 0x0b, 0xf6, 0x00, 0xaf, 0x00, 0xff, 0xfa, 0x10, 0x00, 0x00,
    0x04, 0xfd, 0x00, 0x00, 0xc7, 0x0d, 0xfb, 0x5e, 0x02, 0xef, 0xff, 0xe5,
    0x00, 0x00, 0x04, 0xf7, 0x00, 0x01, 0xef, 0x75, 0xbf, 0x00, 0xa0, 0x1e,
    0xf1, 0x00, 0x05, 0xe0, 0x0e, 0x39, 0x00, 0xf5, 0x1e, 0x2f, 0xe1, 0x08,
    0xfe, 0xee, 0xf3, 0x00, 0x01, 0xf1, 0x3f, 0xf3, 0xc8, 0x00, 0x04, 0xf9,
    0x00, 0x00, 0x01, 0xcf, 0xff, 0xf8, 0x00, 0x00, 0x00, 0xfc, 0xe9, 0xd4,
    0xa7, 0x5f, 0x17, 0x07, 0x00, 0x00, 0x00, 0x6f, 0xa0, 0x01, 0xfe, 0x22,
    0x36, 0x00, 0x00, 0x00, 0xaf, 0xf9, 0x00, 0x03, 0xf3, 0x28, 0xfd, 0x00,
    0x00, 0x02, 0x6b, 0xff, 0xb0, 0x00, 0x00, 0x04, 0xfd, 0x00, 0x00, 0xc7,
    0x01, 0xdf, 0xee, 0x10, 0x13, 0x8d, 0x00, 0xff, 0x30, 0x04, 0xf7, 0x00,
    0x01, 0xef, 0xad, 0x00, 0xfb, 0x10, 0x1e, 0xf1, 0x00, 0x05, 0xf0, 0x0d,
    0x00, 0x32, 0xfc, 0xa8, 0x1f, 0xe1, 0x08, 0xf8, 0x22, 0x00, 0x52, 0x01,
    0xe2, 0x05, 0xff, 0xf7, 0x00, 0x04, 0x00, 0xf9, 0x00, 0x00, 0x03, 0x7c,
    0xff, 0x80, 0x00, 0x3f, 0x00, 0x00, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07,
    0x04, 0x00, 0x6f, 0xa0, 0x01, 0xfe, 0x01, 0x06, 0xe2, 0x00, 0xef, 0x30,
    0x0b, 0xec, 0xdd, 0xff, 0x22, 0x10, 0x00, 0x00, 0x2e, 0xe0, 0x00, 0x00,
    0x04, 0xfd, 0x00, 0x04, 0xc7, 0x00, 0x2e, 0xfe, 0x12, 0x01, 0x70, 0x04,
    0x00, 0xf7, 0x00, 0x01, 0xee, 0x00, 0xbf, 0x90, 0x0e, 0x00, 0xf1, 0x00,
    0x05, 0xe0, 0x0e, 0x30, 0xdf, 0xf2, 0x00, 0x1f, 0xe1, 0x08, 0xf4, 0x00,
    0x00, 0x01, 0xf2, 0x00, 0x00, 0x7f, 0xf7, 0x00, 0x04, 0xf9, 0x00, 0x02,
    0x01, 0x00, 0x00, 0x2f, 0xd0, 0x00, 0x00, 0x00, 0xe9, 0xf8, 0xd4, 0xa7,
    0x5f, 0x17, 0x07, 0x00, 0x6f, 0xa0, 0x00, 0x01, 0xfe, 0x00, 0x00, 0x51,
    0x2f, 0x40, 0x4f, 0x00, 0xe1, 0x1e, 0x30, 0x00, 0xaf, 0x74, 0xc1, 0x00,
    0x00, 0x1f, 0xd0, 0x00, 0x00, 0x04, 0xfd, 0x00, 0xc7, 0x00, 0x00, 0x02,
    0xfe, 0x1b, 0x50, 0x00, 0x5f, 0x40, 0x00, 0x04, 0xf7, 0x00, 0x01, 0xfe,
    0x10, 0x2f, 0xf2, 0x00, 0x0c, 0xf4, 0x00, 0x0b, 0xe0, 0x0e, 0x30, 0x4f,
    0x00, 0xc0, 0x1f, 0xe1, 0x07, 0xf5, 0x00, 0x01, 0x41, 0x00, 0xe2, 0x00,
    0x09, 0xf7, 0x00, 0x04, 0xf9, 0x00, 0x00, 0x09, 0xa0, 0x00, 0x2f, 0xb0,
    0x00, 0x00, 0x00, 0xfc, 0xe9, 0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x00, 0xcf,
    0x00, 0xe1, 0x04, 0xff, 0xcb, 0xce, 0xd2, 0xee, 0x10, 0x00, 0x1e, 0xfc,
    0xaf, 0x20, 0x00, 0x8f, 0xf4, 0xfe, 0x00, 0xca, 0xef, 0x20, 0x00, 0x00,
    0x0a, 0xff, 0x11, 0x00, 0xed, 0x10, 0x00, 0x4e, 0x07, 0xfd, 0xbc, 0xfb,
    0x00, 0x10, 0x09, 0xfc, 0x10, 0x03, 0xff, 0x20, 0x08, 0x00, 0xff, 0x32,
    0xef, 0xca, 0xdf, 0x30, 0x2f, 0x80, 0x00, 0x0e, 0x30, 0x3f, 0xf3, 0x0c,
    0xfe, 0xbc, 0xcf, 0x00, 0x43, 0xf5, 0x00, 0x00, 0xc8, 0x00, 0x08, 0xfd,
    0x00, 0x10, 0x03, 0xfe, 0xbb, 0xfe, 0x20, 0x00, 0x00, 0x7e, 0x00, 0xe9,
    0xd4, 0xa7, 0x5f, 0x17, 0x07, 0x01, 0x00, 0x65, 0x62, 0x04, 0x55, 0x66,
    0x66, 0x24, 0x65, 0x00, 0x20, 0x25, 0x56, 0x65, 0x20, 0x00, 0x45, 0x63,
    0x10, 0x23, 0x8a, 0x61, 0x01, 0x15, 0x55, 0x32, 0x66, 0x01, 0x20, 0x00,
    0x03, 0x01, 0x25, 0x99, 0x30, 0xa1, 0x00, 0x20, 0x04, 0x55, 0x30, 0x00,
    0x39, 0x60, 0x14, 0x00, 0x99, 0x71, 0x00, 0x36, 0x51, 0x02, 0x10, 0x35,
    0x00, 0x53, 0x25, 0x55, 0x66, 0x65, 0x14, 0x54, 0x00, 0x00, 0x00, 0x13,
    0x00, 0x15, 0x56, 0x20, 0x01, 0x23, 0x07, 0x99, 0x51, 0x00, 0x00, 0x00,
    0xe9, 0xd4, 0xa7, 0x80, 0x5f,
};

//*****************************************************************************
//
// This is the image of the blue push button background, used for the keys on
// the keypad.
//
//*****************************************************************************
const unsigned char g_pucBlue70x60[] =
{
    IMAGE_FMT_4BPP_COMP,
    70, 0,
    60, 0,

    15,
    0x00, 0x00, 0x00,
    0x13, 0x00, 0x00,
    0x3d, 0x00, 0x00,
    0x59, 0x00, 0x00,
    0x69, 0x00, 0x00,
    0x73, 0x00, 0x00,
    0x79, 0x00, 0x00,
    0x7d, 0x00, 0x00,
    0x7f, 0x00, 0x00,
    0x81, 0x00, 0x00,
    0x85, 0x00, 0x00,
    0x89, 0x00, 0x00,
    0x8d, 0x00, 0x00,
    0x93, 0x00, 0x00,
    0x9b, 0x00, 0x00,
    0xa9, 0x00, 0x00,

    0x81, 0x03, 0x24, 0x9e, 0xfe, 0xff, 0xff, 0xff, 0xe9, 0xc4, 0xd4, 0xa5,
    0xfe, 0xd7, 0x32, 0x05, 0x00, 0x00, 0x47, 0x3e, 0x01, 0xee, 0xee, 0xee,
    0xe9, 0xd4, 0xa7, 0x20, 0xee, 0xa2, 0x03, 0x00, 0x00, 0x2e, 0xff, 0xff,
    0x38, 0xff, 0xfe, 0x07, 0x07, 0x71, 0xdd, 0xcc, 0x92, 0x80, 0x01, 0x00,
    0x00, 0x03, 0xff, 0xff, 0xff, 0xee, 0x07, 0xee, 0xed, 0xdd, 0xdd, 0xdd,
    0xe9, 0xd4, 0xa5, 0x00, 0xdc, 0xcd, 0xcc, 0xaa, 0x30, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x4f, 0xff, 0xff, 0xee, 0xed, 0xdc, 0xcc, 0x38, 0xcc, 0xcc,
    0xe9, 0xd4, 0xa5, 0xbb, 0xbb, 0xcc, 0x00, 0xcb, 0xba, 0x62, 0x00, 0x00,
    0x00, 0x03, 0xff, 0x00, 0xff, 0xee, 0xed, 0xcc, 0xba, 0xaa, 0x99, 0x99,
    0x70, 0x99, 0xe9, 0xd4, 0xa5, 0xaa, 0xaa, 0xab, 0xa9, 0x00, 0x95, 0x20,
    0x00, 0x00, 0x2f, 0xff, 0xfe, 0xed, 0x01, 0xcc, 0xba, 0x99, 0x98, 0x88,
    0x88, 0x88, 0xe9, 0xc0, 0xd4, 0xa5, 0x99, 0x99, 0xaa, 0x99, 0x98, 0x51,
    0x00, 0x00, 0x00, 0xef, 0xff, 0xee, 0xdc, 0xba, 0x99, 0xe0, 0x07, 0x07,
    0x72, 0x89, 0x99, 0x99, 0x98, 0x64, 0x01, 0x00, 0x03, 0xff, 0xfe, 0xed,
    0xcb, 0xa9, 0x07, 0xc0, 0x07, 0x74, 0x89, 0x99, 0x98, 0x75, 0x20, 0x0d,
    0x07, 0xef, 0xee, 0xdc, 0xba, 0x98, 0x07, 0x07, 0x75, 0x00, 0x99, 0x88,
    0x65, 0x30, 0x2e, 0xfe, 0xed, 0xcb, 0x70, 0xa9, 0x07, 0x07, 0x77, 0x87,
    0x65, 0x41, 0x3e, 0x0e, 0xfe, 0xed, 0xba, 0x98, 0x07, 0x07, 0x77, 0x87,
    0x03, 0x65, 0x42, 0x6e, 0xee, 0xdc, 0xb9, 0x07, 0x07, 0x80, 0x77, 0x88,
    0x88, 0x65, 0x42, 0xbd, 0xee, 0xdb, 0x70, 0xa9, 0x07, 0x07, 0x77, 0x88,
    0x88, 0x65, 0x53, 0x0e, 0xcc, 0xed, 0xcb, 0x98, 0x07, 0x07, 0x77, 0x88,
    0x01, 0x88, 0x66, 0x53, 0xcc, 0xdd, 0xca, 0x98, 0x07, 0xc0, 0x07, 0x77,
    0x88, 0x88, 0x76, 0x43, 0xcb, 0xdc, 0x38, 0xba, 0x98, 0x07, 0x07, 0x77,
    0x88, 0x88, 0x75, 0x0f, 0x43, 0xcb, 0xdc, 0xb9, 0x07, 0x07, 0x77, 0x29,
    0x07, 0x75, 0x43, 0xcb, 0xdc, 0xa9, 0x07, 0x07, 0x77, 0x83, 0x29, 0x75,
    0x43, 0xcb, 0xdc, 0xa9, 0x07, 0x07, 0xc1, 0x77, 0x29, 0x75, 0x43, 0xcb,
    0xdc, 0xa9, 0x07, 0xe0, 0x07, 0x77, 0x29, 0x75, 0x43, 0xcb, 0xdc, 0xa9,
    0xf0, 0x07, 0x07, 0x77, 0x29, 0x75, 0x43, 0xcb, 0xdc, 0x78, 0xa9, 0x07,
    0x07, 0x77, 0x29, 0x75, 0x43, 0xcb, 0x3c, 0xdc, 0xa9, 0x07, 0x07, 0x77,
    0x29, 0x75, 0x43, 0x1e, 0xcb, 0xdc, 0xa9, 0x07, 0x07, 0x77, 0x29, 0x75,
    0x0f, 0x43, 0xcb, 0xdc, 0xa9, 0x07, 0x07, 0x77, 0x29, 0x07, 0x75, 0x43,
    0xcb, 0xdc, 0xa9, 0x07, 0x07, 0x77, 0x83, 0x29, 0x75, 0x43, 0xcb, 0xdc,
    0xa9, 0x07, 0x07, 0xc1, 0x77, 0x29, 0x75, 0x43, 0xcb, 0xdc, 0xa9, 0x07,
    0xe0, 0x07, 0x77, 0x29, 0x75, 0x43, 0xcb, 0xdc, 0xa9, 0xf0, 0x07, 0x07,
    0x77, 0x29, 0x75, 0x43, 0xcb, 0xdc, 0x78, 0xa9, 0x07, 0x07, 0x77, 0x29,
    0x75, 0x43, 0xcb, 0x3c, 0xdc, 0xa9, 0x07, 0x07, 0x77, 0x29, 0x75, 0x43,
    0x1e, 0xcb, 0xdc, 0xa9, 0x07, 0x07, 0x77, 0x29, 0x75, 0x0f, 0x43, 0xcb,
    0xdc, 0xa9, 0x07, 0x07, 0x77, 0x29, 0x07, 0x75, 0x43, 0xcb, 0xdc, 0xa9,
    0x07, 0x07, 0x77, 0x83, 0x29, 0x75, 0x43, 0xcb, 0xdc, 0xa9, 0x07, 0x07,
    0xc1, 0x77, 0x29, 0x75, 0x43, 0xcb, 0xdc, 0xa9, 0x07, 0xe0, 0x07, 0x77,
    0x29, 0x75, 0x43, 0xcb, 0xdc, 0xa9, 0xf0, 0x07, 0x07, 0x77, 0x29, 0x75,
    0x43, 0xcb, 0xdc, 0x78, 0xa9, 0x07, 0x07, 0x77, 0x29, 0x75, 0x43, 0xcb,
    0x3c, 0xdc, 0xa9, 0x07, 0x07, 0x77, 0x29, 0x75, 0x43, 0x1e, 0xcb, 0xdc,
    0xa9, 0x07, 0x07, 0x77, 0x29, 0x75, 0x0f, 0x43, 0xcb, 0xdc, 0xa9, 0x07,
    0x07, 0x77, 0x29, 0x07, 0x75, 0x43, 0xcb, 0xdc, 0xa9, 0x07, 0x07, 0x77,
    0x83, 0x29, 0x75, 0x43, 0xcb, 0xdc, 0xa9, 0x07, 0x07, 0xc1, 0x77, 0x29,
    0x75, 0x43, 0xcb, 0xdc, 0xa9, 0x07, 0xe0, 0x07, 0x77, 0x29, 0x65, 0x43,
    0xcb, 0xcc, 0xa9, 0xf0, 0x07, 0x07, 0x77, 0x29, 0x65, 0x43, 0x9b, 0xcb,
    0x70, 0xa9, 0x07, 0x07, 0x77, 0x88, 0x88, 0x87, 0x65, 0x07, 0x42, 0x4a,
    0xba, 0x99, 0x98, 0x07, 0x07, 0x77, 0x01, 0x88, 0x87, 0x54, 0x32, 0x3a,
    0xaa, 0xa9, 0x07, 0xc0, 0x07, 0x77, 0x88, 0x88, 0x76, 0x54, 0x32, 0x29,
    0x38, 0x8a, 0x99, 0x07, 0x07, 0x77, 0x88, 0x88, 0x75, 0x03, 0x54, 0x31,
    0x04, 0x59, 0x98, 0x98, 0x07, 0x07, 0x80, 0x77, 0x87, 0x65, 0x43, 0x20,
    0x02, 0x56, 0x78, 0xe0, 0x07, 0x07, 0x77, 0x88, 0x76, 0x54, 0x43, 0x10,
    0x07, 0x00, 0x44, 0x67, 0x67, 0x78, 0x07, 0x07, 0x75, 0x00, 0x87, 0x65,
    0x54, 0x32, 0x00, 0x00, 0x24, 0x55, 0x38, 0x66, 0x67, 0x07, 0x07, 0x75,
    0x76, 0x55, 0x43, 0x00, 0x31, 0x00, 0x00, 0x02, 0x35, 0x55, 0x66, 0x67,
    0x70, 0x78, 0x07, 0x07, 0x72, 0x77, 0x65, 0x54, 0x33, 0x00, 0x10, 0x00,
    0x00, 0x00, 0x23, 0x45, 0x55, 0x56, 0x30, 0x67, 0x78, 0x07, 0x07, 0x88,
    0x88, 0x77, 0x65, 0x00, 0x54, 0x43, 0x32, 0x00, 0x00, 0x00, 0x00, 0x02,
    0x00, 0x34, 0x55, 0x55, 0x55, 0x66, 0x67, 0x77, 0x77, 0x70, 0x77, 0xe9,
    0xd4, 0xa4, 0x66, 0x55, 0x54, 0x43, 0x00, 0x33, 0x10, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x12, 0x03, 0x34, 0x44, 0x44, 0x55, 0x55, 0x55, 0xe9, 0xd4,
    0x86, 0xa7, 0x44, 0x43, 0x33, 0x21, 0x01, 0xe9, 0x00, 0x01, 0x12, 0x33,
    0x34, 0x44, 0x33, 0x33, 0x33, 0xe9, 0xcc, 0xd4, 0xa7, 0x33, 0x21, 0x03,
    0xda, 0x11, 0x22, 0x0e, 0x32, 0x22, 0x22, 0x22, 0xe9, 0xd4, 0xa7, 0x11,
    0x80, 0x05,
};

//*****************************************************************************
//
// This is the image of the blue push button background, used for the keys on
// the keypad when they are pressed.
//
//*****************************************************************************
const unsigned char g_pucBlue70x60Press[] =
{
    IMAGE_FMT_4BPP_COMP,
    70, 0,
    60, 0,

    15,
    0x00, 0x00, 0x00,
    0x13, 0x00, 0x00,
    0x3d, 0x00, 0x00,
    0x59, 0x00, 0x00,
    0x69, 0x00, 0x00,
    0x73, 0x00, 0x00,
    0x79, 0x00, 0x00,
    0x7d, 0x00, 0x00,
    0x7f, 0x00, 0x00,
    0x81, 0x00, 0x00,
    0x85, 0x00, 0x00,
    0x89, 0x00, 0x00,
    0x8d, 0x00, 0x00,
    0x93, 0x00, 0x00,
    0x9b, 0x00, 0x00,
    0xa9, 0x00, 0x00,

    0x87, 0x03, 0x11, 0x22, 0x22, 0x22, 0xe9, 0xd4, 0xa7, 0x10, 0x23, 0x22,
    0x11, 0x05, 0x00, 0x00, 0x12, 0x33, 0x38, 0x33, 0x33, 0xe9, 0xd4, 0xa7,
    0x33, 0x44, 0x43, 0x20, 0x33, 0x21, 0x03, 0x00, 0x00, 0x12, 0x33, 0x34,
    0x0e, 0x44, 0x55, 0x55, 0x55, 0xe9, 0xd4, 0xa7, 0x44, 0x10, 0x44, 0x43,
    0x21, 0x01, 0x00, 0x00, 0x01, 0x33, 0x01, 0x34, 0x45, 0x55, 0x66, 0x77,
    0x77, 0x77, 0xe9, 0xc0, 0xd4, 0xa4, 0x76, 0x66, 0x55, 0x55, 0x55, 0x43,
    0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x23, 0x34, 0x45, 0x07, 0x56, 0x77,
    0x88, 0x88, 0x88, 0xe9, 0xd4, 0xa6, 0x00, 0x87, 0x76, 0x65, 0x55, 0x54,
    0x32, 0x00, 0x00, 0x03, 0x00, 0x01, 0x33, 0x45, 0x56, 0x77, 0x07, 0x07,
    0x80, 0x72, 0x87, 0x76, 0x66, 0x55, 0x53, 0x20, 0x00, 0x07, 0x00, 0x13,
    0x34, 0x55, 0x67, 0x07, 0x07, 0x75, 0x00, 0x76, 0x66, 0x55, 0x42, 0x00,
    0x00, 0x23, 0x45, 0x38, 0x56, 0x78, 0x07, 0x07, 0x75, 0x87, 0x76, 0x76,
    0x03, 0x44, 0x00, 0x01, 0x34, 0x45, 0x67, 0x07, 0x07, 0x80, 0x77, 0x88,
    0x87, 0x65, 0x20, 0x02, 0x34, 0x56, 0x70, 0x78, 0x07, 0x07, 0x77, 0x89,
    0x89, 0x95, 0x40, 0x1c, 0x13, 0x45, 0x57, 0x07, 0x07, 0x77, 0x88, 0x88,
    0x03, 0x99, 0xa8, 0x92, 0x23, 0x45, 0x67, 0x07, 0x07, 0x80, 0x77, 0x88,
    0x88, 0x9a, 0xaa, 0xa3, 0x23, 0x45, 0x70, 0x78, 0x07, 0x07, 0x77, 0x88,
    0x89, 0x99, 0xab, 0x0e, 0xa4, 0x24, 0x56, 0x78, 0x07, 0x07, 0x77, 0x88,
    0x03, 0x88, 0x9a, 0xbc, 0xb9, 0x34, 0x56, 0x07, 0x07, 0xc1, 0x77, 0x29,
    0x9a, 0xcc, 0xbc, 0x34, 0x56, 0x07, 0xe0, 0x07, 0x77, 0x29, 0x9a, 0xcd,
    0xbc, 0x34, 0x57, 0xf0, 0x07, 0x07, 0x77, 0x29, 0x9a, 0xcd, 0xbc, 0x34,
    0x78, 0x57, 0x07, 0x07, 0x77, 0x29, 0x9a, 0xcd, 0xbc, 0x3c, 0x34, 0x57,
    0x07, 0x07, 0x77, 0x29, 0x9a, 0xcd, 0x1e, 0xbc, 0x34, 0x57, 0x07, 0x07,
    0x77, 0x29, 0x9a, 0x0f, 0xcd, 0xbc, 0x34, 0x57, 0x07, 0x07, 0x77, 0x29,
    0x07, 0x9a, 0xcd, 0xbc, 0x34, 0x57, 0x07, 0x07, 0x77, 0x83, 0x29, 0x9a,
    0xcd, 0xbc, 0x34, 0x57, 0x07, 0x07, 0xc1, 0x77, 0x29, 0x9a, 0xcd, 0xbc,
    0x34, 0x57, 0x07, 0xe0, 0x07, 0x77, 0x29, 0x9a, 0xcd, 0xbc, 0x34, 0x57,
    0xf0, 0x07, 0x07, 0x77, 0x29, 0x9a, 0xcd, 0xbc, 0x34, 0x78, 0x57, 0x07,
    0x07, 0x77, 0x29, 0x9a, 0xcd, 0xbc, 0x3c, 0x34, 0x57, 0x07, 0x07, 0x77,
    0x29, 0x9a, 0xcd, 0x1e, 0xbc, 0x34, 0x57, 0x07, 0x07, 0x77, 0x29, 0x9a,
    0x0f, 0xcd, 0xbc, 0x34, 0x57, 0x07, 0x07, 0x77, 0x29, 0x07, 0x9a, 0xcd,
    0xbc, 0x34, 0x57, 0x07, 0x07, 0x77, 0x83, 0x29, 0x9a, 0xcd, 0xbc, 0x34,
    0x57, 0x07, 0x07, 0xc1, 0x77, 0x29, 0x9a, 0xcd, 0xbc, 0x34, 0x57, 0x07,
    0xe0, 0x07, 0x77, 0x29, 0x9a, 0xcd, 0xbc, 0x34, 0x57, 0xf0, 0x07, 0x07,
    0x77, 0x29, 0x9a, 0xcd, 0xbc, 0x34, 0x78, 0x57, 0x07, 0x07, 0x77, 0x29,
    0x9a, 0xcd, 0xbc, 0x3c, 0x34, 0x57, 0x07, 0x07, 0x77, 0x29, 0x9a, 0xcd,
    0x1e, 0xbc, 0x34, 0x57, 0x07, 0x07, 0x77, 0x29, 0x9a, 0x0f, 0xcd, 0xbc,
    0x34, 0x57, 0x07, 0x07, 0x77, 0x29, 0x07, 0x9a, 0xcd, 0xbc, 0x34, 0x57,
    0x07, 0x07, 0x77, 0x83, 0x29, 0x9a, 0xcd, 0xbc, 0x34, 0x57, 0x07, 0x07,
    0xc1, 0x77, 0x29, 0x9a, 0xcd, 0xbc, 0x34, 0x57, 0x07, 0xe0, 0x07, 0x77,
    0x29, 0x9a, 0xcd, 0xbc, 0x34, 0x57, 0xf0, 0x07, 0x07, 0x77, 0x29, 0x9a,
    0xcd, 0xbc, 0x34, 0x78, 0x57, 0x07, 0x07, 0x77, 0x29, 0x9a, 0xcd, 0xbc,
    0x3c, 0x34, 0x57, 0x07, 0x07, 0x77, 0x29, 0x9b, 0xcd, 0x1c, 0xbc, 0x34,
    0x57, 0x07, 0x07, 0x77, 0x88, 0x88, 0x03, 0x89, 0xab, 0xcd, 0xbc, 0x34,
    0x67, 0x07, 0x07, 0x80, 0x77, 0x88, 0x88, 0x89, 0xac, 0xdd, 0xcc, 0x35,
    0x70, 0x66, 0x07, 0x07, 0x77, 0x88, 0x88, 0x89, 0xbc, 0x0e, 0xde, 0xcc,
    0x35, 0x56, 0x07, 0x07, 0x77, 0x88, 0x01, 0x88, 0x9a, 0xbd, 0xee, 0xdb,
    0x24, 0x56, 0x07, 0xc0, 0x07, 0x77, 0x88, 0x88, 0x9b, 0xcd, 0xee, 0xe6,
    0x1c, 0x24, 0x56, 0x78, 0x07, 0x07, 0x77, 0x89, 0xab, 0x03, 0xde, 0xef,
    0xe3, 0x14, 0x56, 0x78, 0x07, 0x07, 0x80, 0x77, 0x9a, 0xbc, 0xde, 0xef,
    0xe2, 0x03, 0x56, 0x38, 0x88, 0x99, 0x07, 0x07, 0x75, 0x89, 0xab, 0xcd,
    0x00, 0xee, 0xfe, 0xd0, 0x02, 0x57, 0x89, 0x99, 0x98, 0xe0, 0x07, 0x07,
    0x74, 0x9a, 0xbc, 0xde, 0xef, 0xff, 0x01, 0x30, 0x00, 0x46, 0x89, 0x99,
    0x99, 0x98, 0x07, 0xc0, 0x07, 0x72, 0x99, 0xab, 0xcd, 0xee, 0xff, 0xfe,
    0x00, 0x00, 0x00, 0x15, 0x89, 0x99, 0xaa, 0x99, 0x99, 0xc0, 0x07, 0x07,
    0x88, 0x89, 0x99, 0xab, 0xcc, 0xde, 0x00, 0xef, 0xff, 0xf2, 0x00, 0x00,
    0x02, 0x59, 0x9a, 0x03, 0xba, 0xaa, 0xaa, 0x99, 0x99, 0x99, 0xe9, 0xd4,
    0x80, 0xa5, 0xaa, 0xab, 0xcc, 0xde, 0xee, 0xff, 0xff, 0x00, 0x30, 0x00,
    0x00, 0x00, 0x26, 0xab, 0xbc, 0xcc, 0x07, 0xbb, 0xbb, 0xcc, 0xcc, 0xcc,
    0xe9, 0xd4, 0xa5, 0x00, 0xcd, 0xde, 0xee, 0xff, 0xff, 0xf4, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x03, 0xaa, 0xcc, 0xdc, 0xcd, 0xdd, 0x38, 0xdd, 0xdd,
    0xe9, 0xd4, 0xa5, 0xde, 0xee, 0xee, 0x00, 0xff, 0xff, 0xff, 0x30, 0x00,
    0x00, 0x00, 0x00, 0x01, 0x00, 0x29, 0xcc, 0xdd, 0xee, 0xee, 0xee, 0xe9,
    0xc1, 0xd4, 0xa7, 0xef, 0xff, 0xff, 0xff, 0xe2, 0x01, 0x9c, 0xe9, 0x00,
    0x2a, 0x07, 0x07, 0x72, 0xff, 0xff, 0x31, 0xff, 0xe3, 0x03, 0xda, 0x23,
    0x7d, 0xef, 0x81, 0xe2, 0x69, 0xd4, 0xa5, 0xef, 0xe9, 0x42, 0x05,
};
