#include <std.h>
#include "ads1298evm.h"
#include "mmb0.h"
#include "utilfiles.h"
#include "t1298_fn.h"
#include "i2c.h"
#include "eeprom.h"
#include "clk.h"
#include "ads1298_acquire.h"
#include "ads1298_version.h"

extern void mmb0_clkfreq_set(u32 f);

static unsigned long reset=0;
static int sleep = 0;
/****************************************************************/
/* offset calibration was removed                               */
/* static int offcal = 0;                                       */
/****************************************************************/

#define CONFIG1_MASK                (0x00000018u)
#define CONFIG2_MASK                (0x000000E8u)
#define CONFIG3_MASK                (0x00000003u)
#define CONFIG3_SETMASK             (0x00000040u)
#define CHnSET_MASK                 (0x00000008u)
#define PACE_MASK                   (0x000000E0u)
#define RESP_MASK                   (0x000000E0u)
#define CONFIG4_MASK                (0x00000015u)


/****************************************************************/
/* offset calibration was removed
 * void ads1298evm_offcal_set(int i)
 * {
 *    if (i != offcal) {
 *        offcal = i;
 *        dc_control(&Ads1298_1,ADS1298_CMD_OFFCAL,0);
 *    }
 *    offcal = 0;
 * }
 *
 * int ads1298evm_offcal_get(void)
 * {
 *    return offcal;
 * }
*/
/****************************************************************/

void ads1298evm_sleep_set(int i)
{
    if (i != sleep) {
        sleep = i;
        if (sleep == 0) {
            (void)dc_control(&Ads1298_1,ADS1298_CMD_WAKEUP,0);
        }
        if (sleep == 1) {
            (void)dc_control(&Ads1298_1,ADS1298_CMD_STANDBY,0);
        }
    }
}

int ads1298evm_sleep_get(void)
{
    return sleep;
}

u32 ads1298evm_reset_get(void)
{
    return reset;
}

void ads1298evm_reset_set(u32 i)
{
    if (i == 1) {
        reset = i;
        (void)dc_control(&Ads1298_1,ADS1298_CMD_RESET,0);
    }
    if (i == 2) {
        reset = i;
        (void)dc_control(&Ads1298_1,ADS1298_CMD_INITDEVICE,0);
    }
    
    reset = 0;
}


u32 ads1298evm_devid_get(void)
{
    unsigned int val = ADS1298_REG_DEVID;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long)val;
}

/****************************************************************/
/* devid is a read only register
 * void ads1298evm_devid_set(u32 i)
 * {
 *     unsigned long val = i;
 *     unsigned int reg = ADS1298_REG_DEVID;
 *     Ads1298_1.regs.devid.value = val;
 *     dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
 * }
*/
/****************************************************************/

u32 ads1298evm_config1_get(void)
{
    unsigned int val = ADS1298_REG_CONFIG1;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long)val;
}

void ads1298evm_config1_set(u32 i)
{
    unsigned long val = i & ~CONFIG1_MASK;
    unsigned int reg = ADS1298_REG_CONFIG1;
    Ads1298_1.regs.config1.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}


u32 ads1298evm_config2_get(void)
{
    unsigned int val = ADS1298_REG_CONFIG2;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long)val;
}

void ads1298evm_config2_set(u32 i)
{
    unsigned long val = i & ~CONFIG2_MASK;
    unsigned int reg = ADS1298_REG_CONFIG2;
    Ads1298_1.regs.config2.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_config3_get(void)
{
    unsigned int val = ADS1298_REG_CONFIG3;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long)val;
}

void ads1298evm_config3_set(u32 i)
{
    unsigned long val = (i | CONFIG3_SETMASK) & ~CONFIG3_MASK;
    unsigned int reg = ADS1298_REG_CONFIG3;
    Ads1298_1.regs.config3.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_loff_get(void)
{
    unsigned int val = ADS1298_REG_LOFF;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long)val;
}

void ads1298evm_loff_set(u32 i)
{
    unsigned long val = i;
    unsigned int reg = ADS1298_REG_LOFF;
    Ads1298_1.regs.loff.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_ch1set_get(void)
{
    unsigned int val = ADS1298_REG_CH1SET;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_ch1set_set(u32 i)
{
    unsigned long val = i & ~CHnSET_MASK;
    unsigned int reg = ADS1298_REG_CH1SET;
    Ads1298_1.regs.ch1set.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_ch2set_get(void)
{
    unsigned int val = ADS1298_REG_CH2SET;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_ch2set_set(u32 i)
{
    unsigned long val = i & ~CHnSET_MASK;
    unsigned int reg = ADS1298_REG_CH2SET;
    Ads1298_1.regs.ch2set.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_ch3set_get(void)
{
    unsigned int val = ADS1298_REG_CH3SET;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_ch3set_set(u32 i)
{
    unsigned long val = i & ~CHnSET_MASK;
    unsigned int reg = ADS1298_REG_CH3SET;
    Ads1298_1.regs.ch3set.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_ch4set_get(void)
{
    unsigned int val = ADS1298_REG_CH4SET;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_ch4set_set(u32 i)
{
    unsigned long val = i & ~CHnSET_MASK;
    unsigned int reg = ADS1298_REG_CH4SET;
    Ads1298_1.regs.ch4set.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_ch5set_get(void)
{
    unsigned int val = ADS1298_REG_CH5SET;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_ch5set_set(u32 i)
{
    unsigned long val = i & ~CHnSET_MASK;
    unsigned int reg = ADS1298_REG_CH5SET;
    Ads1298_1.regs.ch5set.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_ch6set_get(void)
{
    unsigned int val = ADS1298_REG_CH6SET;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_ch6set_set(u32 i)
{
    unsigned long val = i & ~CHnSET_MASK;
    unsigned int reg = ADS1298_REG_CH6SET;
    Ads1298_1.regs.ch6set.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_ch7set_get(void)
{
    unsigned int val = ADS1298_REG_CH7SET;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_ch7set_set(u32 i)
{
    unsigned long val = i & ~CHnSET_MASK;
    unsigned int reg = ADS1298_REG_CH7SET;
    Ads1298_1.regs.ch7set.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_ch8set_get(void)
{
    unsigned int val = ADS1298_REG_CH8SET;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_ch8set_set(u32 i)
{
    unsigned long val = i & ~CHnSET_MASK;
    unsigned int reg = ADS1298_REG_CH8SET;
    Ads1298_1.regs.ch8set.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_rldsensp_get(void)
{
    unsigned int val = ADS1298_REG_RLDSENSP;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_rldsensp_set(u32 i)
{
    unsigned long val = i;
    unsigned int reg = ADS1298_REG_RLDSENSP;
    Ads1298_1.regs.rldsensp.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_rldsensn_get(void)
{
    unsigned int val = ADS1298_REG_RLDSENSN;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_rldsensn_set(u32 i)
{
    unsigned long val = i;
    unsigned int reg = ADS1298_REG_RLDSENSN;
    Ads1298_1.regs.rldsensn.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_loffsensp_get(void)
{
    unsigned int val = ADS1298_REG_LOFFSENSP;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_loffsensp_set(u32 i)
{
    unsigned long val = i;
    unsigned int reg = ADS1298_REG_LOFFSENSP;
    Ads1298_1.regs.loffsensp.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_loffsensn_get(void)
{
    unsigned int val = ADS1298_REG_LOFFSENSN;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_loffsensn_set(u32 i)
{
    unsigned long val = i;
    unsigned int reg = ADS1298_REG_LOFFSENSN;
    Ads1298_1.regs.loffsensn.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_loffflip_get(void)
{
    unsigned int val = ADS1298_REG_LOFFFLIP;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_loffflip_set(u32 i)
{
    unsigned long val = i;
    unsigned int reg = ADS1298_REG_LOFFFLIP;
    Ads1298_1.regs.loffflip.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_loffstatp_get(void)
{
    unsigned int val = ADS1298_REG_LOFFSTATP;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

u32 ads1298evm_loffstatn_get(void)
{
    unsigned int val = ADS1298_REG_LOFFSTATN;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

u32 ads1298evm_gpio_get(void)
{
    unsigned int val = ADS1298_REG_GPIO;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_gpio_set(u32 i)
{
    unsigned long val = i;
    unsigned int reg = ADS1298_REG_GPIO;
    Ads1298_1.regs.gpio.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_pace_get(void)
{
    unsigned int val = ADS1298_REG_PACE;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_pace_set(u32 i)
{
    unsigned long val = i & ~PACE_MASK;
    unsigned int reg = ADS1298_REG_PACE;
    Ads1298_1.regs.pace.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_resp_get(void)
{
   unsigned int val = ADS1298_REG_RESP;
   (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
   return (unsigned long) val;
}

void ads1298evm_resp_set(u32 i)
{
   unsigned long val = i & ~RESP_MASK;
   unsigned int reg = ADS1298_REG_RESP;
   Ads1298_1.regs.resp.value = val;
   dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_config4_get(void)
{
    unsigned int val = ADS1298_REG_CONFIG4;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_config4_set(u32 i)
{
    unsigned long val = i & ~CONFIG4_MASK;
    unsigned int reg = ADS1298_REG_CONFIG4;
    Ads1298_1.regs.config4.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_wct1_get(void)
{
    unsigned int val = ADS1298_REG_WCT1;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_wct1_set(u32 i)
{
    unsigned long val = i;
    unsigned int reg = ADS1298_REG_WCT1;
    Ads1298_1.regs.wct1.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

u32 ads1298evm_wct2_get(void)
{
    unsigned int val = ADS1298_REG_WCT2;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_RREG,&val);
    return (unsigned long) val;
}

void ads1298evm_wct2_set(u32 i)
{
    unsigned long val = i;
    unsigned int reg = ADS1298_REG_WCT2;
    Ads1298_1.regs.wct2.value = val;
    (void)dc_control(&Ads1298_1,ADS1298_CMD_WREG,&reg);
}

int ads1298evm_mkdir(estyx_server_t *srv, estyx_file_t *parent)
{
    estyx_file_t *evm, *conf, *eprom;
    int iStatus;

    /* make all GPIO's input to avoid conflict with the I2C     */
    /* all features of the device are controlled by the I2C and */
    /* not by the GPIO pins                                     */
    /* GPIO2 is connected to the converters RESET pin           */
    /* Make it an output and set it to high and toggle it later */
    pin_dir_GPIO0(1);
    pin_set_GPIO0(0);
    pin_dir_GPIO2(1);
    pin_set_GPIO2(1);
    pin_dir_GPIO3(0);
    pin_dir_GPIO4(0);

    /* set the reset pin low. It will be high again after all the
       configuration is done. This make sure that there is no
       glitch on the SPI                                        */
    pin_set_GPIO2(0);
    connect_DSPCLKX_DCCLKX();
    connect_DSPFSX_DCFSX();

    mmb0_clkfreq_set((unsigned long)12e6);
    mmb0_activate_card();


    /* create file-system for the EVM files                     */
    /* create the root files and directories                    */
    if (!(evm=estyx_mkdir(srv,parent,"ads1298evm"))) return -1;
    if (!(conf=estyx_mkdir(srv,evm,"conf"))) return -1;
    if (!estyx_file_msg_make(srv,0,"id",FW_ID)) return -1;
    if (!estyx_file_msg_make(srv,0,"version",FW_VERSION)) return -1;
    // if (!(eprom=estyx_mkdir(srv,evm,"eprom"))) return -1;

    /* create the support files for the converter configuration */
    if (!estyx_file_u32_make(srv,conf,"wct2",ads1298evm_wct2_get,ads1298evm_wct2_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"wct1",ads1298evm_wct1_get,ads1298evm_wct1_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"config4",ads1298evm_config4_get,ads1298evm_config4_set,2)) return -1;
    if (!estyx_file_bool_make(srv,conf,"sleep",ads1298evm_sleep_get,ads1298evm_sleep_set)) return -1;
    if (!estyx_file_u32_make(srv,conf,"reset",ads1298evm_reset_get,ads1298evm_reset_set,0)) return -1;
    if (!estyx_file_u32_make(srv,conf,"rldsensp",ads1298evm_rldsensp_get,ads1298evm_rldsensp_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"rldsensn",ads1298evm_rldsensn_get,ads1298evm_rldsensn_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"resp",ads1298evm_resp_get,ads1298evm_resp_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"pace",ads1298evm_pace_get,ads1298evm_pace_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"loffstatp",ads1298evm_loffstatp_get,0,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"loffstatn",ads1298evm_loffstatn_get,0,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"loffsensp",ads1298evm_loffsensp_get,ads1298evm_loffsensp_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"loffsensn",ads1298evm_loffsensn_get,ads1298evm_loffsensn_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"loffflip",ads1298evm_loffflip_get,ads1298evm_loffflip_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"loff",ads1298evm_loff_get,ads1298evm_loff_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"gpio",ads1298evm_gpio_get,ads1298evm_gpio_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"devid",ads1298evm_devid_get,0,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"config3",ads1298evm_config3_get,ads1298evm_config3_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"config2",ads1298evm_config2_get,ads1298evm_config2_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"config1",ads1298evm_config1_get,ads1298evm_config1_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"ch8set",ads1298evm_ch8set_get,ads1298evm_ch8set_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"ch7set",ads1298evm_ch7set_get,ads1298evm_ch7set_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"ch6set",ads1298evm_ch6set_get,ads1298evm_ch6set_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"ch5set",ads1298evm_ch5set_get,ads1298evm_ch5set_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"ch4set",ads1298evm_ch4set_get,ads1298evm_ch4set_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"ch3set",ads1298evm_ch3set_get,ads1298evm_ch3set_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"ch2set",ads1298evm_ch2set_get,ads1298evm_ch2set_set,2)) return -1;
    if (!estyx_file_u32_make(srv,conf,"ch1set",ads1298evm_ch1set_get,ads1298evm_ch1set_set,2)) return -1;

    /* create the files for the EEPROM                          */
    //  (void)eeprom_mkdir(srv, eprom);

    /* create the files for the data acquisition                */
    if (acquire_init(srv,evm)<0) return -1;

    iStatus = dc_configure(&Ads1298_1);

    return iStatus;
}
