/**************************************************************************************************************************************************
*       ADS1x9x_Functions.c  -  Sets up the Functions for Operating the ADS1x9x.  All initialization calls are initiated from main.c                                      *
*                                                                                                                                                 *
*       Author:             Luke Duncan                                                                                                         *
*                                                                                                                                                 *
*       Revision Date:      June 2009                                                                                                             *
*                                                                                                                                                 *
*       Revision Level:     1st pass                                                                                                              *
*                                                                                                                                                 *
*       For Support:        https://e2e.ti.com/support/development_tools/mavrk/default.aspx                                                       *
*                                                                                                                                                 *
***************************************************************************************************************************************************
*       Copyright  2009-2010 Texas Instruments Incorporated - http://www.ti.com/                                                                 *
***************************************************************************************************************************************************
*  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: *
*                                                                                                                                                 *
*    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.                 *
*                                                                                                                                                 *
*    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the        *
*    documentation and/or other materials provided with the distribution.                                                                         *
*                                                                                                                                                 *
*    Neither the name of Texas Instruments Incorporated nor the names of its contributors may be used to endorse or promote products derived      *
*    from this software without specific prior written permission.                                                                                *
*                                                                                                                                                 *
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          *
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT     *
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT         *
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    *
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      *
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                           *
***************************************************************************************************************************************************
*                                 MODULE CHANGE LOG                                                                                               *
*                                                                                                                                                 *
*       Date Changed:                             Developer:                                                            *
*       Change Description:                                                            *
*                                                                                                                                                 *
**************************************************************************************************************************************************/
/**************************************************************************************************************************************************
*                                 Included Headers                                                                                                *
**************************************************************************************************************************************************/
#include "stdef.h"                                // Common Expression Definitions
#include "ADS1x9x.h"
#include "F5438_io.h"
#include "F5438_Modular_EVM_IO.h"

/**************************************************************************************************************************************************
*                                 Prototypes                                                                                                      *
**************************************************************************************************************************************************/

/**************************************************************************************************************************************************
*                                 Global Variables                                                                                                *
**************************************************************************************************************************************************/
/**************************************************************************************************************************************************
*                                 External Variables                                                                                              *
**************************************************************************************************************************************************/
extern volatile unsigned char ADS1x9x_Config_2;
extern volatile ADS1x9x_Config_2_Register_type *ADS1x9x_Config_2_register;

extern unsigned char ADS1x9x_SPI_data;
extern volatile ADS1x9x_Status_Flags_type ADS1x9x_Status_Flags;

// MM TODO:  check for correct usage with hardware configuration
#if (defined __MSP430F5438__) | (defined __MSP430F5438A__)
extern volatile PORT_OUTPUT_register_type *const PORT_4_OUTPUT_register;
#endif /* (defined __MSP430F5438__) | (defined __MSP430F5438A__) */

/**********************************************************************************************************
*                            Enable the ADS1x9x Test Mode                                                       *
**********************************************************************************************************/
unsigned char Enable_ADS1x9x_Test_Mode (unsigned char device_slot, unsigned char Test_Signal_Source, unsigned char Test_Signal_Reference, unsigned char Test_Signal_Type)
{
    unsigned char Verify_status = ADS_1x9x_INIT_SUCCESS;                                      // Error state set Clear

    enable_ADS1x9x_Interrupt (device_slot);
    
// Load Values set in the ADS1x9x
    ADS1x9x_SPI_Address_Byte_Count (device_slot, READ_CONFIG_2_REGISTER, SINGLE_BYTE_READ_WRITE);          // Read Device ID, Single Byte the Part Number
    ADS1x9x_Config_2 = ADS1x9x_SPI_Data (device_slot, SPI_TEST_DATA);                                      // Send Dummy variable (0x55) to return the part number (Chip Select Cleared automatically)

//  Modify Values for the ADS1x9x    
    ADS1x9x_Config_2_register->Test_Signal_Frequency = Test_Signal_Type;                      // DEFAULT_PULSED_AT_CLOCK_FREQUENCY_DIVIDED_BY_2_TO_THE_21ST
                                                                                              // PULSED_AT_CLOCK_FREQUENCY_DIVIDED_BY_2_TO_THE_20TH
                                                                                              // AT_DC 
    ADS1x9x_Config_2_register->Test_Signal_Amplitude = Test_Signal_Reference;                 // DEFAULT_PLUS_MINUS_1_MV_TIMES_VREF_DIVIDED_BY_2_4
                                                                                              // PLUS_MINUS_2_MV_TIMES_VREF_DIVIDED_BY_2_4
                                                                                              // PLUS_MINUS_10_MV_TIMES_VREF_DIVIDED_BY_2_4
                                                                                              // PLUS_MINUS_1V_TIMES_VREF_DIVIDED_BY_2_4 
    ADS1x9x_Config_2_register->Test_Source = Test_Signal_Source;                              // DEFAULT_TEST_SIGNALS_ARE_DRIVEN_EXTERNALLY, TEST_SIGNALS_ARE_DRIVEN_INTERNALLY

// Program Values into ADS1x9x
    ADS1x9x_SPI_Address_Byte_Count (device_slot, WRITE_CONFIG_2_REGISTER, SINGLE_BYTE_READ_WRITE);         // Read Device ID, Single Byte the Part Number
    ADS1x9x_SPI_data = ADS1x9x_SPI_Data (device_slot, ADS1x9x_Config_2);                                   // Send Dummy variable (0x55) to return the part number (Chip Select Cleared automatically)

#ifdef VERIFY
    //  Read Back Register    
    ADS1x9x_SPI_Address_Byte_Count (device_slot, READ_CONFIG_2_REGISTER, SINGLE_BYTE_READ_WRITE);          // Read Device ID, Single Byte the Part Number
    ADS1x9x_SPI_data = ADS1x9x_SPI_Data (device_slot, SPI_TEST_DATA);                                      // Read the Value from the SPI port   
    if (ADS1x9x_SPI_data != ADS1x9x_Config_2)
    {
        Verify_status = ADS_1x9x_VERIFY_ERROR;
    }        
//  -----------------------------------
#endif /* VERIFY */    
    return Verify_status;    
}

/**********************************************************************************************************
* Initialize ADS1x9x GPIO                                                                                 *
**********************************************************************************************************/
void enable_ADS1x9x_Conversion (unsigned char device_slot)
{    
    enable_ADS1x9x_Interrupt (device_slot);                                     // Interrupts must be enabled to transmit and receive data
    
    Start_Read_Data_Continuous (device_slot);                                   // Enable continuous conversion mode
    
    Hard_Start_ReStart_ADS1x9x (device_slot);                                   // Pull START pin high
    
    ADS1x9x_Status_Flags.ADC_Data_Ready = CLEAR;                                // Clear Data Ready flag
    
    Set_ADS1x9x_Chip_Enable (device_slot);                                      // latch the gpio values on the module
    Clear_ADS1x9x_Chip_Enable (device_slot);
}

void Wake_Up_ADS1x9x (unsigned char device_slot)
{
    Set_ADS1x9x_Chip_Enable (device_slot); 
    ADS1x9x_SPI_Data (device_slot, WAKE_CONVERTER_FROM_SLEEP);                  // Send 0x02 to the ADS1x9x                                                      
}

void Put_ADS1x9x_In_Sleep (unsigned char device_slot)
{
    Set_ADS1x9x_Chip_Enable (device_slot); 
    ADS1x9x_SPI_Data (device_slot, PLACE_CONVERTER_IN_SLEEP_MODE);              // Send 0x04 to the ADS1x9x
}

void Soft_Reset_ADS1x9x (unsigned char device_slot)
{
    Set_ADS1x9x_Chip_Enable (device_slot); 
    ADS1x9x_SPI_Data (device_slot, RESET_CONVERTER);                            // Send 0x06 to the ADS1x9x
}

void Soft_Start_ReStart_ADS1x9x (unsigned char device_slot)
{
    unsigned char i;
  	
    set_ADS1x9x_Start_Pin(LOW);                                                 // Start Pin LOW   
    for (i = 200; i > 0; i--);                                                  // Small Delay   
    ADS1x9x_SPI_Data (device_slot, START_RESTART_CONVERSION);                   // Send 0x08 to the ADS1x9x
    Clear_ADS1x9x_Chip_Enable (device_slot);                                                       
}

void Hard_Start_ReStart_ADS1x9x (void)
{
    set_ADS1x9x_Start_Pin(HIGH);                                                // Start Pin HIGH to Start Conversions                                                      
}

void Soft_Stop_ADS1x9x (unsigned char device_slot)
{
    unsigned char i;
  	
    set_ADS1x9x_Start_Pin(LOW);                                                 // Start Pin LOW   
    for (i = 200; i > 0; i--);                                                  // Small Delay   
    Set_ADS1x9x_Chip_Enable (device_slot); 
    ADS1x9x_SPI_Data (device_slot, STOP_CONVERSION);                            // Send 0x0A to the ADS1x9x
}

void Hard_Stop_ADS1x9x (void)
{
    set_ADS1x9x_Start_Pin(LOW);                                                 // Start Pin HIGH to Start Conversions                                                      
}

void Stop_Read_Data_Continuous (unsigned char device_slot)
{
    Set_ADS1x9x_Chip_Enable (device_slot); 
    ADS1x9x_SPI_Data (device_slot, STOP_READ_DATA_CONTINUOUSLY);
}

void Start_Read_Data_Continuous (unsigned char device_slot)
{
    Set_ADS1x9x_Chip_Enable (device_slot); 
    ADS1x9x_SPI_Data (device_slot, SET_READ_DATA_CONTINUOUSLY);
}

