/**************************************************************************************************************************************************
*       Main.c              Set's up the MSP430 uC Peripherals.  All calls are initiated from this routine.   While Loop cycles 65,535 times      *
*                           before putting the MCU in Sleep mode.  ISR must pull Sleep mode out of the Status Register to restart Idle_count      *
*                                                                                                                                                 *
*       Author:             Mike Claassen                                                                                                         *
*                                                                                                                                                 *
*       Revision Date:      August 2009                                                                                                           *
*                                                                                                                                                 *
*       Revision Level:     1st pass                                                                                                              *
*                                                                                                                                                 *
*       For Support:        https://e2e.ti.com/support/development_tools/mavrk/default.aspx                                                       *
*                                                                                                                                                 *
***************************************************************************************************************************************************
*       Copyright  2009-2010 Texas Instruments Incorporated - http://www.ti.com/                                                                 *
***************************************************************************************************************************************************
*  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: *
*                                                                                                                                                 *
*    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.                 *
*                                                                                                                                                 *
*    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the        *
*    documentation and/or other materials provided with the distribution.                                                                         *
*                                                                                                                                                 *
*    Neither the name of Texas Instruments Incorporated nor the names of its contributors may be used to endorse or promote products derived      *
*    from this software without specific prior written permission.                                                                                *
*                                                                                                                                                 *
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          *
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT     *
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT         *
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    *
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      *
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                           *
***************************************************************************************************************************************************
*                                 MODULE CHANGE LOG                                                                                               *
*                                                                                                                                                 *
*       Date Changed:             {date of change}                Developer:       {developer name}                                               *
*       Change Description:       {describe change}                                                                                               *
*                                                                                                                                                 *
**************************************************************************************************************************************************/
/**************************************************************************************************************************************************
*                                 Included Headers                                                                                                *
**************************************************************************************************************************************************/
#include "stdef.h"                                // Common Expression Definitions
#include "ADS1x9x.h"                              // ADS1298 device defintions


/**************************************************************************************************************************************************
*                                 Definitions                                                                                                     *
**************************************************************************************************************************************************/
#define ADS1298_DATA_LENGTH 27

/**************************************************************************************************************************************************
*                                 Prototypes                                                                                                      *
**************************************************************************************************************************************************/
/**************************************************************************************************************************************************
*                                 Global Variables                                                                                              *
**************************************************************************************************************************************************/
signed char ADS1x9x_Data [ADS1298_DATA_LENGTH];

/**************************************************************************************************************************************************
*                                 External Variables                                                                                              *
**************************************************************************************************************************************************/
extern volatile PORT_INTERRUPT_FLAG_register_type *const PORT_2_INTERRUPT_FLAG_register;
extern volatile PORT_INPUT_register_type *const PORT_2_INPUT_register;
extern volatile PORT_INTERRUPT_EDGE_SELECT_register_type *const PORT_2_INTERRUPT_EDGE_SELECT_register;

extern unsigned char ADS1x9x_SPI_Settings [6];
extern volatile ADS1x9x_Status_Flags_type ADS1x9x_Status_Flags;

/**************************************************************************************************************************************************
*                                 main.c   -   Initialization                                                                                     *
**************************************************************************************************************************************************/
void main (void)
{
    unsigned char ErrChk;                                                       // Used to check for errors
    
/*************************************************************************************************************************************************/
/*    Initialize the MPS430                                                                                                                      */
/*************************************************************************************************************************************************/    

// Set up system power management system, watchdog timer, system clock, UART, interrupts, etc. here
    
/*************************************************************************************************************************************************/
/*    setup the SPI for the ADS1298                                                                                                                           */
/*************************************************************************************************************************************************/    
    
	//Setup the SPI for the ADS1x9x
	ErrChk = setup_SPI ((unsigned char*) ADS1x9x_SPI_Settings);
    if (BUS_SETUP_SUCCESSFUL != ErrChk)                             
    {
        // Handle Errors...
    }
/*************************************************************************************************************************************************/

/*************************************************************************************************************************************************/
/*    Initialize ADS1x9x Peripherals                                                                                                                     */
/*************************************************************************************************************************************************/     
    ErrChk = init_ADS1x9x (ADS1x9x_DEVICE_SLOT);  
    if (ADS_1x9x_INIT_SUCCESS != ErrChk)                             
    {
		// Handle Errors...
	}
    
	//Start Conversions
    enable_ADS1x9x_Conversion (ADS1x9x_DEVICE_SLOT);
    
/**************************************************************************************************************************************************
*                             main.c   -   Background Tasks                                                                                       *
**************************************************************************************************************************************************/
    while (1)
    { 
		if (ADS1x9x_Status_Flags.ADC_Data_Ready == SET)  
		{
			Set_ADS1x9x_Chip_Enable (device_slot);                              // Set the Chip ENABLE to start the SPI transaction

			for (i = 0; i < ADS1298_DATA_LENGTH; i++)                      		// Read ADC Data (status + all channels)
			{
				ADS1x9x_Data [i] = ADS1x9x_SPI_Burst (device_slot, SPI_TEST_DATA); 
			}
			// Zero Out the Rest of the Payload
			for (w = ECG_PC_Interface_Data_Length; w < ECG_TX_PC_Interface_Header_Structure->PC_Interface_Header_Bytes.Payload_Length; w++)
			{
				ADS1x9x_Data [w] = 0;
			}      
     
			Clear_ADS1x9x_Chip_Enable (device_slot);                            // Clear the Chip ENABLE 

			// Process the data...
			
			ADS1x9x_Status_Flags.ADC_Data_Ready = CLEAR;
			
		}
    ADS1x9x_Status_Flags.ADC_Data_Ready = CLEAR;
       
   
                       
    }
}
/**************************************************************************************************************************************************
*    ISR Called Subroutines                                                                                                                       *
**************************************************************************************************************************************************/
/*************************************************************************************************************************************************/
void IO_Port_2_ISR ()
{
	//Handle the DRDY interrupt from the ADS1298
    if (PORT_2_INTERRUPT_FLAG_register->Pin_2)
    {
        PORT_2_INTERRUPT_FLAG_register->Pin_2 = CLEAR;                          // CLEAR ISR Flag
        ADS1x9x_Status_Flags.ADC_Data_Ready = SET;
    }

}

