/**************************************************************************************************************************************************
*       ADS_SPI_Functions.c  -  SPI Communication for ADS Devices.  All initialization calls are initiated from main.c                                      *
*                                                                                                                                                 *
*       Author:             Luke Duncan                                                                                                         *
*                                                                                                                                                 *
*       Revision Date:      June 2009                                                                                                             *
*                                                                                                                                                 *
*       Revision Level:     1st pass                                                                                                              *
*                                                                                                                                                 *
*       For Support:        https://e2e.ti.com/support/development_tools/mavrk/default.aspx                                                       *
*                                                                                                                                                 *
***************************************************************************************************************************************************
*       Copyright  2009-2010 Texas Instruments Incorporated - http://www.ti.com/                                                                 *
***************************************************************************************************************************************************
*  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: *
*                                                                                                                                                 *
*    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.                 *
*                                                                                                                                                 *
*    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the        *
*    documentation and/or other materials provided with the distribution.                                                                         *
*                                                                                                                                                 *
*    Neither the name of Texas Instruments Incorporated nor the names of its contributors may be used to endorse or promote products derived      *
*    from this software without specific prior written permission.                                                                                *
*                                                                                                                                                 *
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          *
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT     *
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT         *
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    *
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      *
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                           *
***************************************************************************************************************************************************
*                                 MODULE CHANGE LOG                                                                                               *
*                                                                                                                                                 *
*       Date Changed:                             Developer:                                                            *
*       Change Description:                                                            *
*                                                                                                                                                 *
**************************************************************************************************************************************************/
/**************************************************************************************************************************************************
*                                 Included Headers                                                                                                *
**************************************************************************************************************************************************/
#include "stdef.h"
#include "ADS1x9x.h"
#include "F5438_usci.h"
#include "F5438_usci_Defs.h"
#include "F5438_Modular_EVM_IO.h"

/**************************************************************************************************************************************************
*                                 Prototypes                                                                                                      *
**************************************************************************************************************************************************/

/**************************************************************************************************************************************************
*                                 Global Variables                                                                                                *
**************************************************************************************************************************************************/

/**************************************************************************************************************************************************
*                                 External Variables                                                                                              *
**************************************************************************************************************************************************/

extern volatile unsigned char* ADS1x9x_SPI_TX_BUFFER;
extern volatile unsigned char* ADS1x9x_SPI_RX_BUFFER;
extern volatile USCI_Interrupt_Flag_Status_type *ADS1x9x_Interrupt_Flags;
extern volatile USCI_SPI_Control_0_register_type *ADS1x9x_SPI_Control_0_register;
extern volatile USCI_SPI_Control_1_register_type *ADS1x9x_SPI_Control_1_register;

/**********************************************************************************************************
* ADS1298 Device SPI Interchip Communication                                                              *
*       This code is used to communicate to the ADS1298                                                   *
**********************************************************************************************************/
void ADS1x9x_SPI_Address_Byte_Count (unsigned char device_slot, unsigned char Read_Write_Address, unsigned char Number_Of_Bytes)
{ 
    unsigned char module_index;

    // Determine the module index based on the device slot
    // Assumes enumerated values are in consecutive order
    module_index = device_slot - MAVRK_AFE1;
    
    Clear_ADS1x9x_Chip_Enable (device_slot);   

    ADS1x9x_SPI_Control_0_register->Clock_Polarity = DEFAULT_INACTIVE_LOW;       // DEFAULT_INACTIVE_LOW, INACTIVE_HIGH

    ADS1x9x_SPI_Control_0_register->Clock_Phase = DEFAULT_RETARDED;              // DEFAULT_RETARDED, ADVANCED
    
    Set_ADS1x9x_Chip_Enable (device_slot);                                              // Set the Chip ENABLE to start the SPI transaction

    ADS1x9x_Interrupt_Flags->SPI_Data_Received_Flag = CLEAR; 

    *(ADS1x9x_SPI_TX_BUFFER) = Read_Write_Address;               // Transmit the Funtion/Address payload

    while (ADS1x9x_Interrupt_Flags->SPI_Data_Received_Flag == CLEAR);

    ADS1x9x_Interrupt_Flags->SPI_Data_Transmitted_Flag = CLEAR;
    ADS1x9x_Interrupt_Flags->SPI_Data_Received_Flag = CLEAR;

    *(ADS1x9x_SPI_TX_BUFFER) = Number_Of_Bytes;                  // Transmit the Number of Bytes payload

    while (ADS1x9x_Interrupt_Flags->SPI_Data_Received_Flag == CLEAR);
    
    ADS1x9x_Interrupt_Flags->SPI_Data_Transmitted_Flag = CLEAR;
    ADS1x9x_Interrupt_Flags->SPI_Data_Received_Flag = CLEAR;

}

unsigned char ADS1x9x_SPI_Data (unsigned char device_slot, unsigned char Data)  // Complements the SPI_Address command 
{
    unsigned char module_index;
    
    // Determine the module index based on the device slot
    // Assumes enumerated values are in consecutive order
    module_index = device_slot - MAVRK_AFE1;
    
    ADS1x9x_SPI_Control_0_register->Clock_Polarity = DEFAULT_INACTIVE_LOW;       // DEFAULT_INACTIVE_LOW, INACTIVE_HIGH

    ADS1x9x_SPI_Control_0_register->Clock_Phase = DEFAULT_RETARDED;              // DEFAULT_RETARDED, ADVANCED

    ADS1x9x_Interrupt_Flags->SPI_Data_Received_Flag = CLEAR;
    
    *(ADS1x9x_SPI_TX_BUFFER) = Data;                             // Send the data sitting at the pointer Data to the TX Buffer

    while (ADS1x9x_Interrupt_Flags->SPI_Data_Received_Flag == CLEAR);
    
    ADS1x9x_Interrupt_Flags->SPI_Data_Transmitted_Flag = CLEAR;
    ADS1x9x_Interrupt_Flags->SPI_Data_Received_Flag = CLEAR;
    
    Clear_ADS1x9x_Chip_Enable (device_slot);                                    // Clear the Chip ENABLE to terminate the SPI transaction
    
    return *(ADS1x9x_SPI_RX_BUFFER);                             // Return Status Data or Requested Read Data
}
    
unsigned char ADS1x9x_SPI_Burst (unsigned char device_slot, unsigned char Data) // Complements the SPI_Address command 
{                                                                               //  But allows multiple transactions (no Clear Chip ENABLE)
    unsigned char module_index;
    
    // Determine the module index based on the device slot
    // Assumes enumerated values are in consecutive order
    module_index = device_slot - MAVRK_AFE1;
    
    ADS1x9x_Interrupt_Flags->SPI_Data_Received_Flag = CLEAR; 
    
    *(ADS1x9x_SPI_TX_BUFFER) = Data;                                     // Send the 8 bit data to the TX Buffer

    while (ADS1x9x_Interrupt_Flags->SPI_Data_Received_Flag == CLEAR);

    ADS1x9x_Interrupt_Flags->SPI_Data_Received_Flag = CLEAR;
    ADS1x9x_Interrupt_Flags->SPI_Data_Transmitted_Flag= CLEAR;
        
    return *(ADS1x9x_SPI_RX_BUFFER);                                      // Return Status Data or Requested Read Data
}