/**************************************************************************************************************************************************
*       F5438_Modular_EVM_IO.c  -  Set's up and controls the I/O (GPIOs and LEDs) for the Modular EVM Board                                       *
*                                                                                                                                                 *
*       Author:             Mike Claassen                                                                                                         *
*                                                                                                                                                 *
*       Revision Date:      August 2009                                                                                                           *
*                                                                                                                                                 *
*       Revision Level:     1st pass                                                                                                              *
*                                                                                                                                                 *
*       For Support:        https://e2e.ti.com/support/development_tools/mavrk/default.aspx                                                       *
*                                                                                                                                                 *
***************************************************************************************************************************************************
*       Copyright  2009-2010 Texas Instruments Incorporated - http://www.ti.com/                                                                 *
***************************************************************************************************************************************************
*  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: *
*                                                                                                                                                 *
*    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.                 *
*                                                                                                                                                 *
*    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the        *
*    documentation and/or other materials provided with the distribution.                                                                         *
*                                                                                                                                                 *
*    Neither the name of Texas Instruments Incorporated nor the names of its contributors may be used to endorse or promote products derived      *
*    from this software without specific prior written permission.                                                                                *
*                                                                                                                                                 *
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          *
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT     *
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT         *
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    *
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      *
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                           *
***************************************************************************************************************************************************
*                                 MODULE CHANGE LOG                                                                                               *
*                                                                                                                                                 *
*       Date Changed:             February 2010                Developer:       Sivasubramanian                                                   *
*       Change Description:       Changed the include file F5438_Modular_EVM_IO.h                                                                 *
*                                                                                                                                                 *
*       Date Changed:             March 3, 2010                Developer:       Mary Metelko                                                      *
*       Change Description:       Changed include filename for register & command definitions                                                     *
*                                                                                                                                                 *
**************************************************************************************************************************************************/
/**************************************************************************************************************************************************
*                                 Included Headers                                                                                                *
**************************************************************************************************************************************************/
#include "F5438_io.h"                             // F5438 General Purpose Interrupt Structure Defintions
#include "stdef.h"                                // Standard definitions common to files (Enable, Disable, etc...)
#include <intrinsics.h>                           // found in MSP430 system directory
#include "F5438_Modular_EVM_IO.h"                 // Defines the Board Headers for the F5438 Modular EVM
/**************************************************************************************************************************************************
*                                 Global Variables                                                                                                *
**************************************************************************************************************************************************/

/**************************************************************************************************************************************************
*                                 Global Defines                                                                                                *
**************************************************************************************************************************************************/

/**************************************************************************************************************************************************
*                                 External Variables                                                                                              *
**************************************************************************************************************************************************/
extern volatile PORT_DIRECTION_register_type *const PORT_1_DIRECTION_register;
extern volatile PORT_FUNCTION_SELECT_register_type *const PORT_1_FUNCTION_SELECT_register;
extern volatile PORT_OUTPUT_register_type *const PORT_1_OUTPUT_register;

extern volatile PORT_DIRECTION_register_type *const PORT_2_DIRECTION_register;
extern volatile PORT_FUNCTION_SELECT_register_type *const PORT_2_FUNCTION_SELECT_register;
extern volatile PORT_INTERRUPT_FLAG_register_type *const PORT_2_INTERRUPT_FLAG_register;
extern volatile PORT_INTERRUPT_ENABLE_register_type *const PORT_2_INTERRUPT_ENABLE_register;
extern volatile PORT_INTERRUPT_EDGE_SELECT_register_type *const PORT_2_INTERRUPT_EDGE_SELECT_register;
extern volatile PORT_PULLUP_RESISTOR_ENABLE_register_type *const PORT_2_PULL_UP_ENABLE_register;
extern volatile PORT_OUTPUT_register_type *const PORT_2_OUTPUT_register;

extern volatile PORT_DIRECTION_register_type *const PORT_3_DIRECTION_register;
extern volatile PORT_FUNCTION_SELECT_register_type *const PORT_3_FUNCTION_SELECT_register;
extern volatile PORT_OUTPUT_register_type *const PORT_3_OUTPUT_register;

extern volatile PORT_DIRECTION_register_type *const PORT_4_DIRECTION_register;
extern volatile PORT_FUNCTION_SELECT_register_type *const PORT_4_FUNCTION_SELECT_register;
extern volatile PORT_OUTPUT_register_type *const PORT_4_OUTPUT_register;

extern volatile PORT_DIRECTION_register_type *const PORT_5_DIRECTION_register;
extern volatile PORT_FUNCTION_SELECT_register_type *const PORT_5_FUNCTION_SELECT_register;
extern volatile PORT_OUTPUT_register_type *const PORT_5_OUTPUT_register;

extern volatile PORT_DIRECTION_register_type *const PORT_8_DIRECTION_register;
extern volatile PORT_FUNCTION_SELECT_register_type *const PORT_8_FUNCTION_SELECT_register;
extern volatile PORT_OUTPUT_register_type *const PORT_8_OUTPUT_register;

extern volatile PORT_DIRECTION_register_type *const PORT_10_DIRECTION_register;
extern volatile PORT_FUNCTION_SELECT_register_type *const PORT_10_FUNCTION_SELECT_register;
extern volatile PORT_OUTPUT_register_type *const PORT_10_OUTPUT_register;

extern volatile PORT_DIRECTION_register_type *const PORT_11_DIRECTION_register;
extern volatile PORT_FUNCTION_SELECT_register_type *const PORT_11_FUNCTION_SELECT_register;
extern volatile PORT_OUTPUT_register_type *const PORT_11_OUTPUT_register;


/**************************************************************************************************************************************************
*         F5438_Modular_EVM_IO_Functions.c                                                                                                        *
**************************************************************************************************************************************************/

/**********************************************************************************************************
* Device SPI Chip Select Manipulation                                                                  *
**********************************************************************************************************/
void Set_ADS1x9x_Chip_Enable (unsigned char device_slot)                        // ADS1x9x module uses GPIO as the SPI CS
{
    unsigned char i;

    switch (device_slot)
    {
        case (MAVRK_AFE1):
        {
            // for GPIO Latch
            PORT_10_OUTPUT_register->Pin_0 = HIGH;                              // LOW, HIGH
            // for SPI CS
            PORT_4_OUTPUT_register->Pin_2 = LOW;                                // HIGH, LOW
            break;
        }
        case (MAVRK_AFE2):
        {
            // for GPIO Latch            
            PORT_11_OUTPUT_register->Pin_1 = HIGH;                              // LOW, HIGH
            // for SPI CS
            PORT_8_OUTPUT_register->Pin_2 = LOW;                                // HIGH, LOW

            break;
        }
        case (MAVRK_AFE3):
        {
            // for GPIO Latch
            PORT_10_OUTPUT_register->Pin_4 = HIGH;                               // LOW, HIGH
            // for SPI CS
            PORT_4_OUTPUT_register->Pin_2 = LOW;                                // HIGH, LOW
            break;
        }
        case (MAVRK_AFE4):
        {
            // for GPIO Latch
            PORT_10_OUTPUT_register->Pin_6 = HIGH;                              // LOW, HIGH
            // for SPI CS
            PORT_8_OUTPUT_register->Pin_2 = LOW;                                // HIGH, LOW
            break;
        }        
    }   
    
    for (i = 50; i > 0; i--);                                                   // Short Delay before invoking the SPI Port
}

void Clear_ADS1x9x_Chip_Enable (unsigned char device_slot)                      // ADS1x9x uses GPIO for SPI CS
{
    unsigned char i;

    switch (device_slot)
    {
        case (MAVRK_AFE1):
        {
            // for SPI CS
            PORT_8_OUTPUT_register->Pin_2 = HIGH;                               // HIGH, LOW
            // for GPIO Latch
            PORT_10_OUTPUT_register->Pin_0 = LOW;                               // LOW, HIGH
            break;
        }
        case (MAVRK_AFE2):
        {
            // for SPI CS
            PORT_8_OUTPUT_register->Pin_2 = HIGH;                               // HIGH, LOW
            // for GPIO Latch
            PORT_11_OUTPUT_register->Pin_1 = LOW;                               // LOW, HIGH
            break;
        }
        case (MAVRK_AFE3):
        {
            // for SPI CS
            PORT_8_OUTPUT_register->Pin_2 = HIGH;                               // HIGH, LOW
            // for GPIO Latch
            PORT_10_OUTPUT_register->Pin_4 = LOW;                               // LOW, HIGH
            break;
        }
        case (MAVRK_AFE4):
        {
            // for SPI CS
            PORT_8_OUTPUT_register->Pin_2 = HIGH;                               // HIGH, LOW
            // for GPIO Latch
            PORT_10_OUTPUT_register->Pin_6 = LOW;                               // LOW, HIGH

            break;
        }        
    }
            
    for (i = 50; i > 0; i--);   
}

/**********************************************************************************************************
                ADS1x9x Functions                                                                         *
**********************************************************************************************************/
void init_ADS1x9x_Data_Ready_Interrupt (unsigned char device_slot)
{
    switch (device_slot)
    {
        case MAVRK_AFE1:
        {
            PORT_2_DIRECTION_register->Pin_0 = DEFAULT_INPUT;                   // DEFAULT_INPUT, OUTPUT    
            PORT_2_PULL_UP_ENABLE_register->Pin_0 = ENABLE;                     // DEFAULT_DISABLE, ENABLE
            PORT_2_OUTPUT_register->Pin_0 = HIGH;                               // to enable the pull-up
            PORT_2_INTERRUPT_FLAG_register->Pin_0 = CLEAR;                      // CLEAR, SET
            PORT_2_INTERRUPT_ENABLE_register->Pin_0 = DEFAULT_DISABLE;          // DEFAULT_DISABLE, ENABLE
            PORT_2_INTERRUPT_EDGE_SELECT_register->Pin_0 = HIGH_TO_LOW;
            break;
        }
        case MAVRK_AFE2:
        {
            PORT_2_DIRECTION_register->Pin_4 = DEFAULT_INPUT;                   // DEFAULT_INPUT, OUTPUT    
            PORT_2_PULL_UP_ENABLE_register->Pin_4 = ENABLE;                     // DEFAULT_DISABLE, ENABLE
            PORT_2_OUTPUT_register->Pin_4 = HIGH;                               // to enable the pull-up
            PORT_2_INTERRUPT_FLAG_register->Pin_4 = CLEAR;                      // CLEAR, SET
            PORT_2_INTERRUPT_ENABLE_register->Pin_4 = DEFAULT_DISABLE;          // DEFAULT_DISABLE, ENABLE
            PORT_2_INTERRUPT_EDGE_SELECT_register->Pin_4 = HIGH_TO_LOW;
            break;
        }
        case MAVRK_AFE3:
        {
            PORT_2_DIRECTION_register->Pin_2 = DEFAULT_INPUT;                   // DEFAULT_INPUT, OUTPUT    
            PORT_2_PULL_UP_ENABLE_register->Pin_2 = ENABLE;                     // DEFAULT_DISABLE, ENABLE
            PORT_2_OUTPUT_register->Pin_2 = HIGH;                               // to enable the pull-up
            PORT_2_INTERRUPT_FLAG_register->Pin_2 = CLEAR;                      // CLEAR, SET
            PORT_2_INTERRUPT_ENABLE_register->Pin_2 = DEFAULT_DISABLE;          // DEFAULT_DISABLE, ENABLE
            PORT_2_INTERRUPT_EDGE_SELECT_register->Pin_2 = HIGH_TO_LOW;
            break;
        }
        case MAVRK_AFE4:
        {
            PORT_2_DIRECTION_register->Pin_6 = DEFAULT_INPUT;                   // DEFAULT_INPUT, OUTPUT    
            PORT_2_PULL_UP_ENABLE_register->Pin_6 = ENABLE;                     // DEFAULT_DISABLE, ENABLE
            PORT_2_OUTPUT_register->Pin_6 = HIGH;                               // to enable the pull-up
            PORT_2_INTERRUPT_FLAG_register->Pin_6 = CLEAR;                      // CLEAR, SET
            PORT_2_INTERRUPT_ENABLE_register->Pin_6 = DEFAULT_DISABLE;          // DEFAULT_DISABLE, ENABLE
            PORT_2_INTERRUPT_EDGE_SELECT_register->Pin_6 = HIGH_TO_LOW;
            break;
        }        
    }
}
void enable_ADS1x9x_Interrupt (unsigned char device_slot)
{
    unsigned char module_index;
    
    // Determine the index for the device and enable DRDY interrupt
    switch (device_slot)
    {
        case MAVRK_AFE1:
        {
            module_index = 0;
            PORT_2_INTERRUPT_ENABLE_register->Pin_0 = ENABLE;                   // DEFAULT_DISABLE, ENABLE

            break;
        }
        case MAVRK_AFE2:
        {
            module_index = 1;
            PORT_2_INTERRUPT_ENABLE_register->Pin_4 = ENABLE;                   // DEFAULT_DISABLE, ENABLE
            break;
        }
        case MAVRK_AFE3:
        {
            module_index = 2;
            PORT_2_INTERRUPT_ENABLE_register->Pin_2 = ENABLE;                   // DEFAULT_DISABLE, ENABLE
            break;
        }
        case MAVRK_AFE4:
        {
            module_index = 3;
            PORT_2_INTERRUPT_ENABLE_register->Pin_6 = ENABLE;                   // DEFAULT_DISABLE, ENABLE
            break;
        }
    }
    
    // Enable UART interrupts
    ADS1x9x_SPI_Interrupt_Enable_register [module_index]->USCI_B_Receive_Interrupt = ENABLE;    // DEFAULT_DISABLE, ENABLE
    ADS1x9x_SPI_Interrupt_Enable_register [module_index]->USCI_B_Transmit_Interrupt = ENABLE;   // DEFAULT_DISABLE, ENABLE
}

void disable_ADS1x9x_Interrupt (unsigned char device_slot)
{
    unsigned char module_index;
    
    // Determine the index for the device and enable DRDY interrupt
    switch (device_slot)
    {
        case MAVRK_AFE1:
        {
            module_index = 0;
            PORT_2_INTERRUPT_ENABLE_register->Pin_0 = DEFAULT_DISABLE;          // DEFAULT_DISABLE, ENABLE
            break;
        }
        case MAVRK_AFE2:
        {
            module_index = 1;
            PORT_2_INTERRUPT_ENABLE_register->Pin_4 = DEFAULT_DISABLE;          // DEFAULT_DISABLE, ENABLE
            break;
        }
        case MAVRK_AFE3:
        {
            module_index = 2;
            PORT_2_INTERRUPT_ENABLE_register->Pin_2 = DEFAULT_DISABLE;          // DEFAULT_DISABLE, ENABLE
            break;
        }
        case MAVRK_AFE4:
        {
            module_index = 3;
            PORT_2_INTERRUPT_ENABLE_register->Pin_6 = DEFAULT_DISABLE;          // DEFAULT_DISABLE, ENABLE
            break;
        }
    }
    
    ADS1x9x_SPI_Interrupt_Enable_register [module_index]->USCI_B_Receive_Interrupt = DEFAULT_DISABLE;   // DEFAULT_DISABLE, ENABLE   
    ADS1x9x_SPI_Interrupt_Enable_register [module_index]->USCI_B_Transmit_Interrupt = DEFAULT_DISABLE;  // DEFAULT_DISABLE, ENABLE

}

void set_ADS1x9x_Start_Pin (unsigned char state)
{
    PORT_4_OUTPUT_register->Pin_3 = state;                                      // Start Pin LOW
}