/**************************************************************************************************************************************************
*       ADS1x9x_Device_Status.c  -  Status handling for ADS1x9x devices.  All initialization calls are initiated from main.c                                      *
*                                                                                                                                                 *
*       Author:             Luke Duncan                                                                                                         *
*                                                                                                                                                 *
*       Revision Date:      June 2009                                                                                                             *
*                                                                                                                                                 *
*       Revision Level:     1st pass                                                                                                              *
*                                                                                                                                                 *
*       For Support:        https://e2e.ti.com/support/development_tools/mavrk/default.aspx                                                       *
*                                                                                                                                                 *
***************************************************************************************************************************************************
*       Copyright  2009-2010 Texas Instruments Incorporated - http://www.ti.com/                                                                 *
***************************************************************************************************************************************************
*  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: *
*                                                                                                                                                 *
*    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.                 *
*                                                                                                                                                 *
*    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the        *
*    documentation and/or other materials provided with the distribution.                                                                         *
*                                                                                                                                                 *
*    Neither the name of Texas Instruments Incorporated nor the names of its contributors may be used to endorse or promote products derived      *
*    from this software without specific prior written permission.                                                                                *
*                                                                                                                                                 *
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          *
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT     *
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT         *
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    *
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      *
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                           *
***************************************************************************************************************************************************
*                                 MODULE CHANGE LOG                                                                                               *
*                                                                                                                                                 *
*       Date Changed:                             Developer:                                                            *
*       Change Description:                                                            *
*                                                                                                                                                 *
**************************************************************************************************************************************************/
/**************************************************************************************************************************************************
*                                 Included Headers                                                                                                *
**************************************************************************************************************************************************/
#include "ADS1x9x.h"
#include "F5438_Modular_EVM_IO.h"

/**************************************************************************************************************************************************
*                                 Prototypes                                                                                                      *
**************************************************************************************************************************************************/

/**************************************************************************************************************************************************
*                                 Global Variables                                                                                                *
**************************************************************************************************************************************************/
volatile ADS1x9x_Status_Flags_type ADS1x9x_Status_Flags = {0x00,0x00,0x00,0x00};

/**************************************************************************************************************************************************
*                                 External Variables                                                                                              *
**************************************************************************************************************************************************/
extern unsigned char ADS1x9x_SPI_data;

/**********************************************************************************************************
*               ADS1x9x Status Registers                                                                  *
**********************************************************************************************************/
unsigned char ADS1x9x_Read_Version (unsigned char device_slot)  
{
    unsigned char Version_ID = 0;
    ADS1x9x_SPI_Address_Byte_Count (device_slot, READ_DEVICE_ID, SINGLE_BYTE_READ_WRITE);    // Read Device ID, Single Byte the Part Number
    Version_ID = ADS1x9x_SPI_Data (device_slot, SPI_TEST_DATA);                              // Send Dummy variable (0x55) to return the part number (Chip Select Cleared automatically)
    return Version_ID;
}  

/**********************************************************************************************************
* Verify the ADS1x9x using a Constants Table of known good settings                        *
**********************************************************************************************************/
unsigned char verify_ADS1x9x_Registers (unsigned char device_slot, unsigned char* constant_pointer)
{   
    unsigned char i;
    unsigned char error = ADS_1x9x_INIT_SUCCESS;                                // Set Error as defaulted clear

    ADS1x9x_SPI_Address_Byte_Count (device_slot, DEFAULT_READ_NUMBER_OF_REGISTERS, ADS1x9x_TOP_REGISTER_SIZE);

    for (i = 0; i <= ADS1x9x_TOP_REGISTER_SIZE; i++)                            // Loop through registers to load the hex data value pairs
    {                              
        ADS1x9x_SPI_data = ADS1x9x_SPI_Burst (device_slot, SPI_TEST_DATA);
          
        if (ADS1x9x_SPI_data != constant_pointer [i])                           // Do the values match?  Assuming the Addresses match
        {
            error = ADS_1x9x_VERIFY_ERROR;                                      // Set the Error
        }
    }
    Clear_ADS1x9x_Chip_Enable (device_slot);                                    // Clear the Chip ENABLE to terminate any previous SPI transactions

    ADS1x9x_SPI_Address_Byte_Count (device_slot, (DEFAULT_READ_NUMBER_OF_REGISTERS + ADS1x9x_TOP_REGISTER_SIZE + 2), ADS1x9x_BOTTOM_REGISTER_SIZE);
    
    for (i = 0; i < ADS1x9x_BOTTOM_REGISTER_SIZE; i++)                          // Loop through registers to load the hex data value pairs
    {                              
        ADS1x9x_SPI_data = ADS1x9x_SPI_Burst (device_slot, SPI_TEST_DATA);
          
        if (ADS1x9x_SPI_data != constant_pointer [ADS1x9x_REGISTER_OFFSET])     // Do the values match?  Assuming the Addresses match
        {
            error = ADS_1x9x_VERIFY_ERROR;                                      // Set the Error
        }
    }
    Clear_ADS1x9x_Chip_Enable (device_slot);                                    // Clear the Chip ENABLE to terminate any previous SPI transactions

    return error;                                                               // Return the error back from the routine
}