/**************************************************************************************************************************************************
*       ADS1x9x_Device_Interface.c  -  Interface for ADS1x9x devices.  All initialization calls are initiated from main.c                         *
*                                                                                                                                                 *
*       Author:             Luke Duncan                                                                                                           *
*                                                                                                                                                 *
*       Revision Date:      June 2009                                                                                                             *
*                                                                                                                                                 *
*       Revision Level:     1st pass                                                                                                              *
*                                                                                                                                                 *
*       For Support:        https://e2e.ti.com/support/development_tools/mavrk/default.aspx                                                       *
*                                                                                                                                                 *
***************************************************************************************************************************************************
*       Copyright  2009-2010 Texas Instruments Incorporated - http://www.ti.com/                                                                 *
***************************************************************************************************************************************************
*  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: *
*                                                                                                                                                 *
*    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.                 *
*                                                                                                                                                 *
*    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the        *
*    documentation and/or other materials provided with the distribution.                                                                         *
*                                                                                                                                                 *
*    Neither the name of Texas Instruments Incorporated nor the names of its contributors may be used to endorse or promote products derived      *
*    from this software without specific prior written permission.                                                                                *
*                                                                                                                                                 *
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          *
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT     *
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT         *
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    *
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      *
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                           *
***************************************************************************************************************************************************
*                                 MODULE CHANGE LOG                                                                                               *
*                                                                                                                                                 *
*       Date Changed:                             Developer:                                                                                      *
*       Change Description:                                                                                                                       *
*                                                                                                                                                 *
**************************************************************************************************************************************************/
/**************************************************************************************************************************************************
*                                 Included Headers                                                                                                *
**************************************************************************************************************************************************/
#include "stdef.h"
#include "F5438_io.h"
/**************************************************************************************************************************************************
*                                 Prototypes                                                                                                      *
**************************************************************************************************************************************************/

/**************************************************************************************************************************************************
*                                 Global Variables                                                                                                *
**************************************************************************************************************************************************/
/**************************************************************************************************************************************************
*                                 External Variables                                                                                              *
**************************************************************************************************************************************************/
extern volatile PORT_DIRECTION_register_type *const PORT_4_DIRECTION_register;
extern volatile PORT_FUNCTION_SELECT_register_type *const PORT_4_FUNCTION_SELECT_register;
extern volatile PORT_OUTPUT_register_type *const PORT_4_OUTPUT_register;
extern volatile PORT_PULLUP_RESISTOR_ENABLE_register_type *const PORT_4_PULL_UP_ENABLE_register;

extern volatile PORT_DIRECTION_register_type *const PORT_8_DIRECTION_register;
extern volatile PORT_FUNCTION_SELECT_register_type *const PORT_8_FUNCTION_SELECT_register;
extern volatile PORT_OUTPUT_register_type *const PORT_8_OUTPUT_register;
extern volatile PORT_PULLUP_RESISTOR_ENABLE_register_type *const PORT_8_PULL_UP_ENABLE_register;

extern volatile PORT_DIRECTION_register_type *const PORT_10_DIRECTION_register;
extern volatile PORT_FUNCTION_SELECT_register_type *const PORT_10_FUNCTION_SELECT_register;
extern volatile PORT_OUTPUT_register_type *const PORT_10_OUTPUT_register;
extern volatile PORT_PULLUP_RESISTOR_ENABLE_register_type *const PORT_10_PULL_UP_ENABLE_register;

extern volatile PORT_DIRECTION_register_type *const PORT_11_DIRECTION_register;
extern volatile PORT_FUNCTION_SELECT_register_type *const PORT_11_FUNCTION_SELECT_register;
extern volatile PORT_OUTPUT_register_type *const PORT_11_OUTPUT_register;
extern volatile PORT_PULLUP_RESISTOR_ENABLE_register_type *const PORT_11_PULL_UP_ENABLE_register;
/*******************************************************************************************************************************************************/
void POR_Reset_ADS1x9x (unsigned char device_slot)
{
    unsigned char t, w;
    unsigned int i;
    
    if (device_slot == MAVRK_AFE1 | device_slot == MAVRK_AFE3)
    {    
        //LD TODO: Use universal clock settings to set delays
        for (t = 0x20; t > 0; t--);                                                 // Small Delay 
        PORT_4_OUTPUT_register->Pin_0 = HIGH;                                       // Reset HIGH
        for (i = 0xFFFF; i > 0; i--)
        {
            for (w = 0x09; w > 0; w--);                                             // Large Delay
        }                                                      
        PORT_4_OUTPUT_register->Pin_0 = LOW;                                        // Reset LOW    
        for (t = 0x10; t > 0; t--);                                                 // Small Delay   
        PORT_4_OUTPUT_register->Pin_0 = HIGH;                                       // Reset HIGH
        for (t = 0x90; t > 0; t--);        
    }
    else /*MAVRK_AFE2 or MAVRK_AFE4*/
    {
        //LD TODO: Use universal clock settings to set delays
        for (t = 0x20; t > 0; t--);                                                 // Small Delay 
        PORT_8_OUTPUT_register->Pin_1 = HIGH;                                       // Reset HIGH
        for (i = 0xFFFF; i > 0; i--)
        {
            for (w = 0x09; w > 0; w--);                                             // Large Delay
        }                                                      
        PORT_8_OUTPUT_register->Pin_1 = LOW;                                        // Reset LOW    
        for (t = 0x10; t > 0; t--);                                                 // Small Delay   
        PORT_8_OUTPUT_register->Pin_1 = HIGH;                                       // Reset HIGH
        for (t = 0x90; t > 0; t--);
    }
}

void Power_Down_ADS1x9x (unsigned char device_slot)
{
    
    if (device_slot == MAVRK_AFE1 | device_slot == MAVRK_AFE3)
    {
        PORT_4_OUTPUT_register->Pin_1 = LOW;
        PORT_4_OUTPUT_register->Pin_5 = LOW;
    }
    else /*MAVRK_AFE2 or MAVRK_AFE4*/
    {
        PORT_8_OUTPUT_register->Pin_0 = LOW;
        PORT_8_OUTPUT_register->Pin_5 = LOW;
    }
}

void Power_Up_ADS1x9x (unsigned char device_slot)
{    
    if (device_slot == MAVRK_AFE1 | device_slot == MAVRK_AFE3)
    {
        PORT_4_OUTPUT_register->Pin_1 = HIGH;
        PORT_4_OUTPUT_register->Pin_5 = HIGH;
    }
    else /*MAVRK_AFE2 or MAVRK_AFE4*/
    {
        PORT_8_OUTPUT_register->Pin_0 = HIGH;
        PORT_8_OUTPUT_register->Pin_5 = HIGH;
    }
}

/**********************************************************************************************************
* Initialize ADS1298 GPIO                                                                                 *
**********************************************************************************************************/
void init_ADS1x9x_IO (unsigned char device_slot)
{
  // LD TODO:  This could probably be modularized in a better way (less repeated code)
#if (defined __MSP430F5438__) | (defined __MSP430F5438A__)
    if (device_slot == MAVRK_AFE1 | device_slot == MAVRK_AFE3)
    {
        // Power Down Pin (ACTIVE LOW)
        PORT_4_FUNCTION_SELECT_register->Pin_1 = DEFAULT_GPIO;                      // DEFAULT_GPIO      
        PORT_4_DIRECTION_register->Pin_1 = OUTPUT;                                  // DEFAULT_INPUT, OUTPUT
        PORT_4_OUTPUT_register->Pin_1 = LOW;                                       // HIGH, LOW
        
        // RESET Pin (ACTIVE LOW)
        PORT_4_FUNCTION_SELECT_register->Pin_0 = DEFAULT_GPIO;                      // DEFAULT_GPIO     
        PORT_4_DIRECTION_register->Pin_0 = OUTPUT;                                  // DEFAULT_INPUT, OUTPUT
        PORT_4_OUTPUT_register->Pin_0 = HIGH;                                       // HIGH, LOW
        
        // Chip Select Pin for SPI Connection (ACTIVE LOW)
        PORT_4_PULL_UP_ENABLE_register->Pin_2 = ENABLE;                             // DISABLE, ENABLE
        PORT_4_FUNCTION_SELECT_register->Pin_2 = DEFAULT_GPIO;                      // DEFAULT_GPIO     
        PORT_4_DIRECTION_register->Pin_2 = OUTPUT;                                  // DEFAULT_INPUT, OUTPUT
        PORT_4_OUTPUT_register->Pin_2 = HIGH;                                       // HIGH, LOW

        if (device_slot == MAVRK_AFE1)
        {
            // Chip Select Pin for GPIO Latch (ACTIVE HIGH)
            PORT_10_PULL_UP_ENABLE_register->Pin_0 = ENABLE;                            // DISABLE, ENABLE
            PORT_10_FUNCTION_SELECT_register->Pin_0 = DEFAULT_GPIO;                     // DEFAULT_GPIO     
            PORT_10_DIRECTION_register->Pin_0 = OUTPUT;                                 // DEFAULT_INPUT, OUTPUT
            PORT_10_OUTPUT_register->Pin_0 = HIGH;                                      // HIGH, LOW
        }
        else /* MAVRK_AFE3 */
        {
            // Chip Select Pin for GPIO Latch (ACTIVE HIGH)
            PORT_10_PULL_UP_ENABLE_register->Pin_4 = ENABLE;                            // DISABLE, ENABLE
            PORT_10_FUNCTION_SELECT_register->Pin_4 = DEFAULT_GPIO;                     // DEFAULT_GPIO     
            PORT_10_DIRECTION_register->Pin_4 = OUTPUT;                                 // DEFAULT_INPUT, OUTPUT
            PORT_10_OUTPUT_register->Pin_4 = HIGH;                                      // HIGH, LOW
        }
        
        // Start (ACTIVE High)
        PORT_4_FUNCTION_SELECT_register->Pin_3 = DEFAULT_GPIO;                      // DEFAULT_GPIO     
        PORT_4_DIRECTION_register->Pin_3 = OUTPUT;                                  // DEFAULT_INPUT, OUTPUT
        PORT_4_OUTPUT_register->Pin_3 = LOW;                                        // HIGH, LOW  
    
        // Clock Enable (ACTIVE High)
        PORT_4_FUNCTION_SELECT_register->Pin_5 = DEFAULT_GPIO;                      // DEFAULT_GPIO     
        PORT_4_DIRECTION_register->Pin_5 = OUTPUT;                                  // DEFAULT_INPUT, OUTPUT
        PORT_4_OUTPUT_register->Pin_5 = LOW;                                        // HIGH, LOW  
    
        // Clock Select (Low -> External Clock, High -> Internal Clock)
        PORT_4_FUNCTION_SELECT_register->Pin_4 = DEFAULT_GPIO;                      // DEFAULT_GPIO     
        PORT_4_DIRECTION_register->Pin_4 = OUTPUT;                                  // DEFAULT_INPUT, OUTPUT
        PORT_4_OUTPUT_register->Pin_4 = LOW;     
    }
    else /* MAVRK_AFE2 or MAVRK_AFE4 */
    {
        // Power Down Pin (ACTIVE LOW)
        PORT_8_FUNCTION_SELECT_register->Pin_0 = DEFAULT_GPIO;                      // DEFAULT_GPIO      
        PORT_8_DIRECTION_register->Pin_0 = OUTPUT;                                  // DEFAULT_INPUT, OUTPUT
        PORT_8_OUTPUT_register->Pin_0 = LOW;                                       // HIGH, LOW
        
        // RESET Pin (ACTIVE LOW)
        PORT_8_FUNCTION_SELECT_register->Pin_1 = DEFAULT_GPIO;                      // DEFAULT_GPIO     
        PORT_8_DIRECTION_register->Pin_1 = OUTPUT;                                  // DEFAULT_INPUT, OUTPUT
        PORT_8_OUTPUT_register->Pin_1 = HIGH;                                       // HIGH, LOW
        
        // Chip Select Pin for SPI Connection (ACTIVE LOW)
        PORT_8_PULL_UP_ENABLE_register->Pin_2 = ENABLE;                             // DISABLE, ENABLE
        PORT_8_FUNCTION_SELECT_register->Pin_2 = DEFAULT_GPIO;                      // DEFAULT_GPIO     
        PORT_8_DIRECTION_register->Pin_2 = OUTPUT;                                  // DEFAULT_INPUT, OUTPUT
        PORT_8_OUTPUT_register->Pin_2 = HIGH;                                       // HIGH, LOW
    
        if (device_slot == MAVRK_AFE2)
        {
            // Chip Select Pin for GPIO Latch (ACTIVE HIGH)
            PORT_11_PULL_UP_ENABLE_register->Pin_1 = ENABLE;                            // DISABLE, ENABLE
            PORT_11_FUNCTION_SELECT_register->Pin_1 = DEFAULT_GPIO;                     // DEFAULT_GPIO     
            PORT_11_DIRECTION_register->Pin_1 = OUTPUT;                                 // DEFAULT_INPUT, OUTPUT
            PORT_11_OUTPUT_register->Pin_1 = HIGH;                                      // HIGH, LOW
        }
        else /* MAVRK_AFE4 */
        {
            // Chip Select Pin for GPIO Latch (ACTIVE HIGH)
            PORT_10_PULL_UP_ENABLE_register->Pin_6 = ENABLE;                            // DISABLE, ENABLE
            PORT_10_FUNCTION_SELECT_register->Pin_6 = DEFAULT_GPIO;                     // DEFAULT_GPIO     
            PORT_10_DIRECTION_register->Pin_6 = OUTPUT;                                 // DEFAULT_INPUT, OUTPUT
            PORT_10_OUTPUT_register->Pin_6 = HIGH;                                      // HIGH, LOW
        }
        
        // Start (ACTIVE High)
        PORT_8_FUNCTION_SELECT_register->Pin_3 = DEFAULT_GPIO;                      // DEFAULT_GPIO     
        PORT_8_DIRECTION_register->Pin_3 = OUTPUT;                                  // DEFAULT_INPUT, OUTPUT
        PORT_8_OUTPUT_register->Pin_3 = LOW;                                        // HIGH, LOW  
    
        // Clock Enable (ACTIVE High)
        PORT_8_FUNCTION_SELECT_register->Pin_5 = DEFAULT_GPIO;                      // DEFAULT_GPIO     
        PORT_8_DIRECTION_register->Pin_5 = OUTPUT;                                  // DEFAULT_INPUT, OUTPUT
        PORT_8_OUTPUT_register->Pin_5 = LOW;                                        // HIGH, LOW  
    
        // Clock Select (Low -> External Clock, High -> Internal Clock)
        PORT_8_FUNCTION_SELECT_register->Pin_4 = DEFAULT_GPIO;                      // DEFAULT_GPIO     
        PORT_8_DIRECTION_register->Pin_4 = OUTPUT;                                  // DEFAULT_INPUT, OUTPUT
        PORT_8_OUTPUT_register->Pin_4 = LOW;     
    } 
#endif /*(defined __MSP430F5438__) | (defined __MSP430F5438A__)*/
}