
#ifndef GUARD_ads_h
#define GUARD_ads_h

#include "common.h"
#include "task.h"
/* Commands are easy to figure out and will change depending on what features
are being used for the device.   These calls are generally called from config.c, 
qconfig.c and console.c.*/

void ads_init(void);

void ads_set_monitor(xTaskHandle mon);
void ads_set_directmonitor(xTaskHandle mon);
void ads_set_speed(int spd);
int ads_get_speed(void);
//void ads_set_buffer(int buf);
//int ads_get_buffer(void);

void ads_set_ch(int chp, int chm);
int ads_get_ch(int chm);

void ads_set_gpio0(int buf);
int ads_get_gpio0(void);
void ads_set_gpio1(int buf);
int ads_get_gpio1(void);
void ads_set_gpio2(int spd);
int ads_get_gpio2(void);
void ads_set_gpio3(int spd);
int ads_get_gpio3(void);
void ads_set_gpio4(int spd);
int ads_get_gpio4(void);
void ads_set_gpio5(int spd);
int ads_get_gpio5(void);

void ads_set_pga(int pga);
int ads_get_pga(void);
int ads_get_gain(void);

void ads_set_bo(int bo);
int ads_get_bo(void);
void ads_set_bias(int bias);
int ads_get_bias(void);
void ads_set_gconfig(int gpio);
int ads_get_gconfig(void);
void ads_set_gio(int gpio);
int ads_get_gio(void);
void ads_set_gdat(int gpio);
int ads_get_gdat(void);
void ads_set_vref(int vref);
int ads_get_vref(void);
void ads_set_supply(int supply);
int ads_get_supply(void);
void ads_set_reset(void);
void ads_set_pwrdn(int pwrdn);
int ads_get_pwrdn(void);
void ads_set_iref(int iref);
int ads_get_iref(void);
void ads_set_idac0(int idac);
int ads_get_idac0(void);
void ads_set_idac1(int idac);
int ads_get_idac1(void);
void ads_set_current(int idac);
int ads_get_current(void);
void ads_set_mux(int mux);
int ads_get_mux(void);

int ads_newdata(void);
void ads_get(s32 *);

void ads_go(void);
void ads_stop(void);
void ads_cal(void);
void ads_standby(void);
void ads_powerdown(void);
void ads_reg_read(void);
void ads_write(void);
void ads_write_off(void);
void ads_write_full(void);
int ads_get_gin(void);
#endif
