/*{{TIDC_Wizard Auto Code Start                                 */
/****************************************************************/
/* don't change anything here until you know what you are doing!*/
/* the plug-in will change all text between the code marks      */
/* without user interaction!                                    */
/*                                                              */
/****************************************************************/

/****************************************************************/
/* software generated by Data Converter Plug-in (DCP)           */
/* based on <C:\CCSTUD~1.1\PLUGINS\AAP_DEV\c5500\d1258_55.c> */
/****************************************************************/
/****************************************************************/
/* ADS1258 Interface Software Version 1.0 for the TMS320C5500   */
/* Copyright (C) 2005 Texas Instruments Incorporated            */
/* All Rights Reserved                                          */
/*--------------------------------------------------------------*/
/** \file
 * This interface software needs one interrupt to be mapped in
 * either the DSP/BIOS configuration file or the interrupt
 * vector table:
 *    - Interrupt of the used DMA channel:
 *       -  _ADS1258_rblock_finished
 *
 * This interface software uses two peripherals:
 *     - Two DMA channels for the data transfer
 *     - One McBSP for the data transfer
 *
 * <b>Restrictions:
 *    - This software needs the START pin connected
 *      to one of the GPIO pins of the device. In the current
 *      version, it assumes that the GPIO0-pin is used for that.
 *      If a different GPIO pin is used, the
 *      ADS1258_GPIO_USED_FOR_START macro at the beginning of this
 *      file has to be changed. If none of the GPIO pins is used to
 *      control the START pin, the function ADS1258_setStartPin()
 *      has to be rewritten to match the actual H/W setup.
 *    - It is only possible to submit two buffers at a time. If
 *      a third buffer needs to be submitted, the application has
 *      to wait until the iXferInProgress member of the data
 *      converter structure is less than two.</b>               */
/*--------------------------------------------------------------*/
/* $Revision: 14 $                        $JustDate: 12/02/05 $ */
/* $Author: A0746714 $                                          */
/****************************************************************/
#undef _INLINE


/* include the interface files for the data converter software  */
#include "dc_conf.h"
#include "t1258_fn.h"


/* include the interface files for the chip support library     */
#include <csl.h>
#include <csl_irq.h>
#include <string.h>


/****************************************************************/
/* define and initialize data converter object(s)               */
/****************************************************************/
TADS1258 Ads1258_1 = {
    &ADS1258_configure,
    &ADS1258_control,
    &ADS1258_readsample,
    &ADS1258_writesample,
    &ADS1258_readblock,
    &ADS1258_writeblock,
    &ADS1258_close,
    0, 0, 3,            /* reserved                              */
    &serial1,           /* serial port config struct             */
    ADC1_ADS1258CONFIG0,/* Configuration Register 0               */
    ADC1_ADS1258CONFIG1,/* Configuration Register 1               */
    ADC1_ADS1258MUXSCH, /* Mux Fixed-Channel Register             */
    ADC1_ADS1258MUXDIF, /* Mux Differential Input Select Register */
    ADC1_ADS1258MUXSG0, /* Mux Single-Ended Input Select Reg 0    */
    ADC1_ADS1258MUXSG1, /* Mux Single-Ended Input Select Reg 1    */
    ADC1_ADS1258SYSRED, /* System Reading Select Register         */
    ADC1_ADS1258GPIOC,  /* GPIO Configuration Register 0          */
    ADC1_ADS1258GPIOD,  /* GPIO Configuration Register 1          */
    ADC1_ADS1258ID,     /* Device ID Register                     */
    ADC1_ADS1258CONFIG0,/* Configuration Register 0               */
    ADC1_ADS1258CONFIG1,/* Configuration Register 1               */
    ADC1_ADS1258MUXSCH, /* Mux Fixed-Channel Register             */
    ADC1_ADS1258MUXDIF, /* Mux Differential Input Select Register */
    ADC1_ADS1258MUXSG0, /* Mux Single-Ended Input Select Reg 0    */
    ADC1_ADS1258MUXSG1, /* Mux Single-Ended Input Select Reg 1    */
    ADC1_ADS1258SYSRED, /* System Reading Select Register         */
    ADC1_ADS1258GPIOC,  /* GPIO Configuration Register 0          */
    ADC1_ADS1258GPIOD,  /* GPIO Configuration Register 1          */
    ADC1_ADS1258ID,     /* Device ID Register                     */
    0, 0, 0, 0,         /* Data Buffer Object 0                  */
    0, 0, 0, 0,         /* Data Buffer Object 1                  */
    0,                  /* (E)Dma handle (for receive)           */
    0,                  /* (E)Dma handle (for transmit)          */
    ADC1_DMACHAN,       /* used DMA Channel                      */
    ADC1_INTNUM,        /* Interrupt used for BUSY Signal        */
    ADC1_MCBSP_CLKDIV,  /* McBsp Period (to generate McBsp clock)*/
    0,                  /* Transfer-In-Progress Flag             */
    0,                  /* Shadow for DMACCR receive register    */
    0,                  /* Shadow for DMACCR transmit register   */
    0                   /* Buffer Object Index                   */
};



/****************************************************************/
/* define and initialize the serial port object                 */
/****************************************************************/
DCP_SERIAL serial1 =
{
    0,                                /* McBSP handle            */
    ADC1_SERPORT,                    /* serial port number      */
    0                               /* INT used by serial port */
};


/****************************************************************/
/* DSP function prototypes                                      */
/****************************************************************/
static TTIDCSTATUS ADS1258_initDevice(TADS1258 *pADS);
static TTIDCSTATUS ADS1258_initMcbsp(DCP_SERIAL *serial,
                                     unsigned int clkdiv);
static TTIDCSTATUS ADS1258_initRcvDma(MCBSP_Handle hMcbsp,
                                      int iChanNum,
                                      DMA_Handle *hDma,
                                      unsigned int *pCcr);
static TTIDCSTATUS ADS1258_initXmtDma(MCBSP_Handle hMcbsp,
                                      unsigned int uiIrq,
                                      DMA_Handle *hDma,
                                      unsigned int *pCcr);
static TTIDCSTATUS ADS1258_submitBlock(DMA_Handle hDmaIn,
                                       DMA_Handle hDmaOut,
                                       unsigned int uiCcrIn,
                                       unsigned int uiCcrOut,
                                       unsigned int uiCnt,
                                       unsigned long ulDst);
static TTIDCSTATUS ADS1258_setWordLength(MCBSP_Handle hMcbsp,
                                     unsigned int uiLength);
static unsigned int ADS1258_setStartPin(TADS1258 *pADS, int iLevel);


/****************************************************************/
/* global variables                                             */
/****************************************************************/
/* define a global pointer to the data converter object in use  */
static TADS1258 *pgADS;
static unsigned long ulDummy = 0;   /* needed for the DMA xfer  */


/****************************************************************/
/* definitions used by the code                                 */
/****************************************************************/
#define ADS1258_WORDLENGTH_8BIT   (0x0000u)
#define ADS1258_WORDLENGTH_16BIT  (0x0002u)
#define ADS1258_WORDLENGTH_24BIT  (0x0004u)
#define ADS1258_WORDLENGTH_32BIT  (0x0005u)
#define ADS1258_GPIO_FOR_START_CONTROL regs.gpioc.control_bit.cio0
#define ADS1258_GPIO_FOR_START_DATA    regs.gpiod.control_bit.dio0


/****************************************************************/
/* ADS1258_configure()                                          */
/**
 * Operation:     The following operations are performed:
 *     - Open, configure and start the McBSP the converter is
 *       connected to; return on error
 *     - Open and pre-configure the DMA channels used for the
 *       data transfer; return on error.
 *     - Initialize the registers of he ADS1258 to the values
 *       given in dc_conf.h
 *
 * Parameters:
 *     - void* pDC: Data converter object
 *
 * Return values: Status code of type TTIDCSTATUS
 *     - TIDC_NO_ERR: Call was successful
 *     - TIDC_ERR_NODEVICE: No object was passed to the function
 *     - TIDC_ERR_MCBSP: The McBSP couldn't be opened
 *     - TIDC_ERR_DMA: The DMA channel could not be opened
 *     - TIDC_ERR_XFERPROG: dc_configure was called during an
 *       ongoing transfer
 *     - TIDC_ERR_BADARGS: An invalid argument was passed to the
 *       function
 *     - TIDC_ERR_REGS: The initialization of the registers failed
 *
 * Globals modified:
 *     -Serial port object in the data converter object
 *
 * Resources used:
 *     - One McBSP
 *     - Two DMA channels
*/
/****************************************************************/
TTIDCSTATUS ADS1258_configure(void *pDC)
{
    TADS1258 *pADS = pDC;
    TTIDCSTATUS iStatus = TIDC_NO_ERR;


    /* return, if no device object available                    */
    if (pADS == 0)
        return TIDC_ERR_NODEVICE;


    /* be sure no block transfer is in progress                 */
    if (pADS->iXferInProgress != 0)
        return TIDC_ERR_XFERPROG;


    /* open & configure the McBSP needed for the data transfer  */
    iStatus = ADS1258_initMcbsp(pADS->serial, pADS->uiMcbspPeriod);


    if (iStatus != TIDC_NO_ERR)
        return iStatus;


    /* open the DMA channel for the transmit and receive side   */
    /* and do a basic configuration for them                    */
    iStatus = ADS1258_initXmtDma(pADS->serial->hMcbsp,
                                 pADS->uiDrdyIntNum,
                                 &(pADS->hDmaXmt),
                                 &(pADS->uiXmtCcrValue));
    if (iStatus != TIDC_NO_ERR)
    {
        (void)ADS1258_close(pADS);
        return iStatus;
    }


    iStatus = ADS1258_initRcvDma(pADS->serial->hMcbsp,
                                 pADS->iDmaChanNumber,
                                 &(pADS->hDmaRcv),
                                 &(pADS->uiRcvCcrValue));
    if (iStatus != TIDC_NO_ERR)
    {
        (void)ADS1258_close(pADS);
        return iStatus;
    }


    /* configure the registers of the device                    */
    iStatus = ADS1258_initDevice(pADS);


    if (iStatus != TIDC_NO_ERR)
    {
        (void) ADS1258_close(pADS);
        return iStatus;
    }


    /* make sure the converter does not start                   */
    (void)ADS1258_setStartPin(pADS, ADS1258_STARTPIN_LOW);


    return TIDC_NO_ERR;
}




/****************************************************************/
/* ADS1258_control()                                            */
/** Operation:
 *     - Translates the command macros to the proper commands for
 *       the ADS1258.
 *     - Sets the word-length of the McBSP before sending the
 *       command.
 *
 * Parameters:
 *     - void* pDC: Data converter object
 *     - int iCmd:  Action to be performed. Valid are:
 *           - ADS1258_CMD_REGISTERREAD:
 *                 Reads the register specified by the parameter
 *                 pValue and returns the read value in pValue.
 *           - ADS1258_CMD_REGISTERWRITE:
 *                 The register specified by the parameter pValue
 *                 will be initialized with the value in the
 *                 register structure of the pDC object. The
 *                 register will be read back and compared to the
 *                 sent value. If they do not match, the
 *                 register value read will be returned in pValue.
 *           - ADS1258_CMD_PULSESTOP
 *                 Sends the "pulse convert or stop convert"
 *                 command to the ADS1258.
 *           - ADS1258_CMD_CONTINUOUS:
 *                 Sends the "continuous convert" command to the
 *                 ADS1258.
 *           - ADS1258_CMD_RESET:
 *                 Sends the "reset" command to the ADS1258.
 *           - Note: Data read operation are performed by either
 *                 the  ADS1258_readsample() or
 *                 ADS1258_readblock() functions, so the data
 *                 read commands are not implemented.
 *     - void *pValue: Additional parameters for the command
 *                 (see above).
 *
 * Return values: Status code of type TTIDCSTATUS:
 *     - TIDC_NO_ERR:   No problem occurred.
 *     - TIDC_ERR_BADARGS: Either the command or the value has
 *       been invalid.
 *     - TIDC_ERR_REGS: The register could not be written. The
 *       compare between the intended value and the value read
 *       back failed.
 *
 * Globals modified:
 *     - None
 *
 * Resources used:
 *     - None
 */
/****************************************************************/
TTIDCSTATUS ADS1258_control(void *pDc, int iCmd, void *pValue)
{
    TADS1258 *pADS = pDc;
    int iValue = *(int*)pValue;
    int temp;


    /* return, if no device object available                    */
    if (pADS == 0)
        return TIDC_ERR_NODEVICE;


    /* decide, which word-length is needed                      */
    switch (iCmd)
    {
        case ADS1258_CMD_RESET:
        case ADS1258_CMD_PULSESTOP:
        case ADS1258_CMD_CONTINUOUS:
                 /* set the word-length to 8 bit                */
                 (void)ADS1258_setWordLength(pADS->serial->hMcbsp,
                                         ADS1258_WORDLENGTH_8BIT);
                 break;
        case ADS1258_CMD_REGISTERREAD:
        case ADS1258_CMD_REGISTERWRITE:
                 /* set the word-length to 16 bit               */
                 (void)ADS1258_setWordLength(pADS->serial->hMcbsp,
                                        ADS1258_WORDLENGTH_16BIT);
                 break;
        default: return TIDC_ERR_BADARGS;
    }


    /************************************************************/
    /* send the "simple" commands to the device                 */
    /************************************************************/
    if ((iCmd == ADS1258_CMD_RESET)
        || (iCmd == ADS1258_CMD_PULSESTOP)
        || (iCmd == ADS1258_CMD_CONTINUOUS))
    {
        /* send command to the converter                        */
        while (MCBSP_FGETH(pADS->serial->hMcbsp,SPCR2,XRDY) != 1);
        MCBSP_write16(pADS->serial->hMcbsp, (unsigned int)iCmd);


        /* receive the dummy word from the converter            */
        while (MCBSP_FGETH(pADS->serial->hMcbsp,SPCR1,RRDY) != 1);
        (void)MCBSP_read16(pADS->serial->hMcbsp);
    }


    /************************************************************/
    /* assemble the read register command and read the register */
    /************************************************************/
    if (iCmd == ADS1258_CMD_REGISTERREAD)
    {
        /* send the register read command to the converter      */
        while (MCBSP_FGETH(pADS->serial->hMcbsp, SPCR2, XRDY) != 1);
        MCBSP_write16(pADS->serial->hMcbsp,
                      (unsigned int)((*(int*)pValue & 0xFF00)
                   | ADS1258_CMD_REGISTERREAD));


        /* receive the register content from the converter      */
        while (MCBSP_FGETH(pADS->serial->hMcbsp, SPCR1, RRDY) != 1);
        *(int*)pValue =(int)MCBSP_read16(pADS->serial->hMcbsp) & 0x00FF;
    }


    /************************************************************/
    /* assemble the write register command, send it to the      */
    /* device, read the register back and compare it to the     */
    /* value sent. If it does not match, return the value read  */
    /* in pValue.                                               */
    /************************************************************/
    if (iCmd == ADS1258_CMD_REGISTERWRITE)
    {
        switch (*(int*)pValue)
        {
            case ADS1258_CONFIG0:
                iValue |= pADS->regs.config0.value;
                break;
            case ADS1258_CONFIG1:
                iValue |= pADS->regs.config1.value;
                break;
            case ADS1258_MUXSCH:
                iValue |= pADS->regs.muxsch.value;
                break;
            case ADS1258_MUXDIF:
                iValue |= pADS->regs.muxdif.value;
                break;
            case ADS1258_MUXSG0:
                iValue |= pADS->regs.muxsg0.value;
                break;
            case ADS1258_MUXSG1:
                iValue |= pADS->regs.muxsg1.value;
                break;
            case ADS1258_SYSRED:
                iValue |= pADS->regs.sysred.value;
                break;
            case ADS1258_GPIOC:
                iValue |= pADS->regs.gpioc.value;
                break;
            case ADS1258_GPIOD:
                iValue |= pADS->regs.gpiod.value;
                break;
            default: return TIDC_ERR_BADARGS;
        }


        /* send the register write command to the converter     */
        while (MCBSP_FGETH(pADS->serial->hMcbsp,SPCR2,XRDY) != 1);
        MCBSP_write16(pADS->serial->hMcbsp,
                  (unsigned int)(iValue | iCmd));
        /* receive the dummy word from the converter            */
        while (MCBSP_FGETH(pADS->serial->hMcbsp,SPCR1,RRDY) != 1);
        (void)MCBSP_read16(pADS->serial->hMcbsp);


        /* now that the register is written, read it back       */
        while (MCBSP_FGETH(pADS->serial->hMcbsp,SPCR2,XRDY) != 1);
        MCBSP_write16(pADS->serial->hMcbsp,
                      (unsigned int)((iValue & 0xFF00)
                  | ADS1258_CMD_REGISTERREAD));
        /* receive the register content from the converter      */
        while (MCBSP_FGETH(pADS->serial->hMcbsp,SPCR1,RRDY) != 1);
        temp = (int)MCBSP_read16(pADS->serial->hMcbsp);


        /* now compare it with the value sent                   */
        if (((temp & 0x00FF) != (iValue & 0x00FF))
              && ((iValue & 0x0F00) != ADS1258_GPIOD))
        {
            *(int*)pValue = temp;   /* return the wrong value   */
            return TIDC_ERR_REGS;
        }
    }


    return TIDC_NO_ERR;
}




/****************************************************************/
/* ADS1258_readsample()                                         */
/** Operation:
 *     - Reads a single data word from the converter.
 *     - Waiting for the next word to be received is a blocking
 *       statement, so the code can hang!
 *
 * Parameters:
 *     - void* pDC: Data converter object.
 *     - long *lData: Memory location used to return the
 *                    conversion result (out-parameter).
 *
 * Return value:  Status code of type TTIDCSTATUS
 *     - TIDC_NO_ERR: Call was successfull.
 *     - TIDC_ERR_NODEVICE: No object was passed to the function.
 *
 * Globals modified:
 *     - None
 *
 * Resources used:
 *     - None
 */
/****************************************************************/
TTIDCSTATUS ADS1258_readsample(void *pDC, long *lData)
{
    TADS1258 *pADS = pDC;


    /* return, if no device object available                    */
    if (pADS == 0)
        return TIDC_ERR_NODEVICE;


    (void)ADS1258_setWordLength(pADS->serial->hMcbsp,
                                ADS1258_WORDLENGTH_8BIT);


    IRQ_clear(pADS->uiDrdyIntNum);


    /* send pulse convert command to the converter              */
    while (MCBSP_FGETH(pADS->serial->hMcbsp, SPCR2, XRDY) != 1);
    MCBSP_write16(pADS->serial->hMcbsp, ADS1258_CMD_PULSESTOP);


    /* receive the dummy word from the converter            */
    while (MCBSP_FGETH(pADS->serial->hMcbsp, SPCR1, RRDY) != 1);
    (void)MCBSP_read16(pADS->serial->hMcbsp);


    /* fixed-channel mode, auto-scan mode used or status        */
    /* byte disabled?                                           */
    if ((pADS->regs.config0.control_bit.muxmod == 1)
         || (pADS->regs.config0.control_bit.stat == 0))
        (void)ADS1258_setWordLength(pADS->serial->hMcbsp,
                                    ADS1258_WORDLENGTH_24BIT);
    else
        (void)ADS1258_setWordLength(pADS->serial->hMcbsp,
                                    ADS1258_WORDLENGTH_32BIT);


    /* wait for the conversion result to be available           */
    while (IRQ_test(pADS->uiDrdyIntNum) == 0);


    /* send "no command" to read conversion result              */
    while (MCBSP_FGETH(pADS->serial->hMcbsp, SPCR2, XRDY) != 1);
    MCBSP_write32(pADS->serial->hMcbsp, 0x00000000);


    /* retrieve the conversion result from the converter        */
    while (MCBSP_FGETH(pADS->serial->hMcbsp, SPCR1, RRDY) != 1);
   *lData = (long)MCBSP_read32(pADS->serial->hMcbsp);


    return TIDC_NO_ERR;
}




/****************************************************************/
/* ADS1258_readblock()                                          */
/** Operation:
 *     - Initializes the transfer of a block of data from the data
 *       converter. Once the transfer is started, the function
 *       returns to the application level.
 *     - It uses two DMA channels for the data transfer: One to
 *       trigger the SPI port and one to collect the conversion
 *       results. The DMA channel for the SPI port trigger will be
 *       selected by the code, while the DMA channel for the
 *       sample-read is fixed and was selected in the GUI of
 *       the DCP
 *     - Once the DMA transfer for the conversion results
 *       finishes, the ADS1258_rblock_finished ISR will be
 *       triggered , which will reset the iXferInProgress
 *       semaphore and will call the callback function, if
 *       requested.
 *
 * Parameters:
 *     - void* pDC: Data converter object
 *     - void pData: Pointer to the data buffer.
 *           - This buffer must be a multiple of the channels
 *             selected for conversion, otherwise not all channels
 *             will be read.
 *     - unsigned long ulCount: Size of the buffer in samples.
 *     - void *callback: Optional pointer to the callback function.
 *
 * Return value:  Status code of type TTIDCSTATUS
 *     - TIDC_NO_ERR: Call was successfull.
 *     - TIDC_ERR_NODEVICE: No object was passed to the function.
 *     - TIDC_ERR_BADARGS: An invalid argument was passed to the
 *       function
 *     - TIDC_ERR_REGS: The register could not be written. The
 *       compare between the intended value and the value read
 *       back failed.
 *
 * Globals modified:
 *     - In data converter object:
 *           - *ulBufPtr
 *           - uiBufSize
 *           - ptrCallBack
 *           - iferInProgress
 *           - hDmaRcv
 *           - hDmaXmt
 *     - TADS1258* pgADS: File scoped pointer to data converter
 *                        object
 *
 * Remarks: Only one data transfer is allowed to be in progress
 *          at one time
 *
 * Resources used:
 *     - The two DMA channels opened by ADS1258_configure
 */
/****************************************************************/
TTIDCSTATUS ADS1258_readblock(void *pDC,
                           void *pData,
                           unsigned long ulCount,
                           void (*callback) (void *))
{
    TADS1258 *pADS = pDC;
    TTIDCSTATUS iStatus;


    /* return, if no device object available                    */
    if (pADS == 0)
        return TIDC_ERR_NODEVICE;


    if ((ulCount > (unsigned long)0x0000FFFF)
      || (ulCount < (unsigned long)2))
        return TIDC_ERR_BADARGS;


    /* set tranfer in progress flag                             */
    if (pADS->iXferInProgress == 2)
        return TIDC_ERR_XFERPROG;
    else
        pADS->iXferInProgress += 1;


    /* select the next free buffer object                       */
    if (pADS->xferBuffer[0].uiStatus == 0)
        pADS->iObjectIndex = 0; /* object 0 is free             */
    else
        pADS->iObjectIndex = 1; /* object 1 is free             */


    pADS->xferBuffer[pADS->iObjectIndex].ptrCallBack = callback;
    pADS->xferBuffer[pADS->iObjectIndex].ulBufPtr = (unsigned long *)pData;
    pADS->xferBuffer[pADS->iObjectIndex].uiBufSize = (unsigned int)ulCount;
    pADS->xferBuffer[pADS->iObjectIndex].uiStatus = 1;


    pgADS = pADS;


    if (pADS->iXferInProgress == 1)
    {
    /* set the continous conversion mode                        */
        iStatus = ADS1258_setStartPin(pADS, ADS1258_STARTPIN_HIGH);


        /* now configure the McBSP to match the word-length for */
        /* the fixed-channel mode and the auto-scan mode with   */
        /* status byte disabled (CONFIG0:1 = 0)                 */
    if ((pADS->regs.config0.control_bit.muxmod == 1)
         || (pADS->regs.config0.control_bit.stat == 0))
        (void)ADS1258_setWordLength(pADS->serial->hMcbsp,
                                    ADS1258_WORDLENGTH_24BIT);
        /* auto-scan mode with status byte enabled              */
        /* (CONFIG0:1 = 1)                                      */
    else
        (void)ADS1258_setWordLength(pADS->serial->hMcbsp,
                                    ADS1258_WORDLENGTH_32BIT);
    }


    /* configure the DMA channels for the transfer              */
    iStatus = ADS1258_submitBlock(pADS->hDmaRcv,
                                  pADS->hDmaXmt,
                                  pADS->uiRcvCcrValue,
                                  pADS->uiXmtCcrValue,
                                  (unsigned int)ulCount,
                                  (unsigned long)pData);


    if (iStatus != TIDC_NO_ERR)
    {
        (void)ADS1258_setStartPin(pADS, ADS1258_STARTPIN_LOW);
        pADS->iXferInProgress -= 1;
        return iStatus;
    }


    (void)IRQ_enable(DMA_getEventId(pADS->hDmaRcv));


    if (pADS->iXferInProgress == 1)
    {
        DMA_start(pADS->hDmaRcv);
        DMA_start(pADS->hDmaXmt);
    }


    return TIDC_NO_ERR;
}




/****************************************************************/
/* ADS1258_writesample()                                        */
/** Operation:     Not implemented. This function just returns.
 *
 * Parameters:
 *     - void* pDC: Data converter object
 *     - long lData: Data to be written to the converter
 *
 * Return value:  Status code of type TTIDCSTATUS
 *     - TIDC_ERR_FXNNULL: This function is not implemented
 *
 * Globals modified:
 *     - None
 *
 * Resources used:
 *     - None
 */
/****************************************************************/
TTIDCSTATUS ADS1258_writesample(void *pDC, long lData)
{
    return TIDC_ERR_FXNNULL;
}




/****************************************************************/
/**
 * ADS1258_writeblock()
 * Operation:     Not implemented. This function just returns.
 *
 * Parameters:
 *     - void* pDC: Data converter object
 *     - void* lData: Pointer to the block of data to be written
 *     - unsigned long ulCount: Number of words
 *     - void (*callback): Pointer to the callback function
 *
 * Return value:  Status code of type TTIDCSTATUS
 *     - TIDC_ERR_FXNNULL: This function is not implemented
 *
 * Globals modified:
 *     - None
 *
 * Resources used:
 *     - None
 */
/****************************************************************/
TTIDCSTATUS ADS1258_writeblock(void *pDC, void *pData,
                              unsigned long ulCount,
                              void (*callback) (void *))
{
    return TIDC_ERR_FXNNULL;
}




/****************************************************************/
/* ADS1258_close()                                              */
/** Operation:
 *     - Closes all the resources used on the DSP.
 *     - Resets the converter and initializes the register array
 *       back to the original values to ensure that the converter
 *       can be re-opened again.
 *
 * Parameters:
 *     - void* pDC: Data converter object
 *
 * Return value:  Status code of type TTIDCSTATUS
 *     - TIDC_NO_ERR: No problem occurred
 *
 * Globals modified: The following items are modified inside
 *                   data converter object:
 *     - Handle to the serial port
 *     - Handle to the DMA channel for the data xfer
 *     - Handle to the DMA channel for the SCLK generation
 *     - The register structure for the data converter
 *     - iXferInProgress
 *
 * Resources used:
 *     - Two DMA channels (closed)
 *     - One McBSP channel (closed)
 */
/****************************************************************/
TTIDCSTATUS ADS1258_close(void *pDC)
{
    TADS1258 *pADS = pDC;


    /* return, if no device object available                    */
    if (pADS == 0)
        return TIDC_ERR_NODEVICE;


    /* reset the device and stop conversions                    */
    (void)ADS1258_control(pADS, ADS1258_CMD_RESET, 0);
    (void)ADS1258_setStartPin(pADS, ADS1258_STARTPIN_LOW);


    /* close the transmit side DMA channel, if it was open      */
    if ((pADS->hDmaXmt != 0) && (pADS->hDmaXmt != INV))
    {
        DMA_close(pADS->hDmaXmt);
        pADS->hDmaXmt = 0;
    }


    /* close the receive side DMA channel, if it was open       */
    if ((pADS->hDmaRcv != 0) && (pADS->hDmaRcv != INV))
    {
        DMA_close(pADS->hDmaRcv);
        pADS->hDmaRcv = 0;
    }


    /* close the McBSP, if it was open                          */
    if ((pADS->serial->hMcbsp != 0) && (pADS->serial->hMcbsp != INV))
    {
        MCBSP_close(pADS->serial->hMcbsp);
        pADS->serial->hMcbsp = 0;
    }


    /* copy the original register values back to the working    */
    /* register set                                             */
    pADS->regs.config0.value = pADS->initRegs.config0.value;
    pADS->regs.config1.value = pADS->initRegs.config1.value;
    pADS->regs.muxsch.value = pADS->initRegs.muxsch.value;
    pADS->regs.muxdif.value = pADS->initRegs.muxdif.value;
    pADS->regs.muxsg0.value = pADS->initRegs.muxsg0.value;
    pADS->regs.muxsg1.value = pADS->initRegs.muxsg1.value;
    pADS->regs.sysred.value = pADS->initRegs.sysred.value;
    pADS->regs.gpioc.value = pADS->initRegs.gpioc.value;
    pADS->regs.gpiod.value = pADS->initRegs.gpiod.value;
    pADS->regs.devid.value = pADS->initRegs.devid.value;


    /* reset the transfer in progress semaphore                 */
    pADS->iXferInProgress = 0;


    return TIDC_NO_ERR;
}




/****************************************************************/
/* ADS1258_initDevice()                                         */
/** Operation:
 *     - Initializes the registers of the ADS1258 and verifies
 *       the settings. The sequence follows the recommendation in
 *       the data sheet
 *
 * Parameter:
 *     - void* pDC: Data converter object
 *
 * Return value:  Status code of type TTIDCSTATUS
 *     - TIDC_NO_ERR:   No problem occurred
 *     - TIDC_ERR_REGS: Register initialization failed
 *
 * Globals modified:
 *     - ID register in register structure
 *
 * Resources used:
 *     - None
 */
/****************************************************************/
static TTIDCSTATUS ADS1258_initDevice(TADS1258 *pADS)
{
    int iCmdValue[10] = {ADS1258_CONFIG0, ADS1258_CONFIG1,
                         ADS1258_MUXSCH,  ADS1258_MUXDIF,
                         ADS1258_MUXSG0,  ADS1258_MUXSG1,
                         ADS1258_SYSRED,  ADS1258_GPIOC,
                         ADS1258_GPIOD,   ADS1258_ID};
    TTIDCSTATUS iStatus =  TIDC_NO_ERR;
    unsigned int i;


    /* stop and reset the converter                             */
    (void)ADS1258_control(pADS, ADS1258_CMD_PULSESTOP, 0);
    (void)ADS1258_control(pADS, ADS1258_CMD_RESET, 0);


    /* send the register values                                 */
    for (i = 0; i < 9; i++)
    {
        iStatus = ADS1258_control(pADS,
                                  ADS1258_CMD_REGISTERWRITE,
                                  &iCmdValue[i]);
        if (iStatus != TIDC_NO_ERR)
        return iStatus;
    }


    /* populate the device id register                          */
    iStatus = ADS1258_control(pADS,
                              ADS1258_CMD_REGISTERREAD,
                              &iCmdValue[9]);


    pADS->regs.devid.value = (unsigned int)iCmdValue[9];


    return TIDC_NO_ERR;
}




/****************************************************************/
/* ADS1258_initMcbsp()                                          */
/** Operation:
 *     - Opens, initializes and starts the McBSP given by the port
 *       variable in the serial port structure.
 *
 * Parameters:
 *     - DCP_SERIAL serial: Serial port object.
 *     - unsigned int clkdiv: Divider for the sample rate
                            generator.
 *
 * Return value:  Status code of type TTIDCSTATUS
 *     - TIDC_NO_ERR:   No problem occurred.
 *     - TIDC_ERR_MCBSP: The serial port couldn't be opened.
 *
 * Globals modified:
 *     - Handle in the serial port structure.
 *     - Interrupt number in the serial port structure.
 *
 * Resources used:
 *     - None
 */
/****************************************************************/
static TTIDCSTATUS ADS1258_initMcbsp(DCP_SERIAL *serial,
                                     unsigned int clkdiv)
{
    /* clear the serial port structure                          */
    memset(&serial->sConfig,
           0x0000,
           sizeof(serial->sConfig));


    /* open the port and return on fail                         */
    serial->hMcbsp = MCBSP_open((int)serial->port,
                                MCBSP_OPEN_RESET);
    if (serial->hMcbsp == INV)
        return TIDC_ERR_MCBSP;


    /* initialize the serial port structure                     */
    /*  Serial Port Control Register 1                          */
    serial->sConfig.spcr1 =
          MCBSP_FMK(SPCR1, DLB, MCBSP_SPCR1_DLB_OFF)
        | MCBSP_FMK(SPCR1, RJUST, MCBSP_SPCR1_RJUST_RSE)
        | MCBSP_FMK(SPCR1, CLKSTP, MCBSP_SPCR1_CLKSTP_DELAY)
        | MCBSP_FMK(SPCR1, DXENA, MCBSP_SPCR1_DXENA_OFF)
        | MCBSP_FMK(SPCR1, ABIS, MCBSP_SPCR1_ABIS_DISABLE)
        | MCBSP_FMK(SPCR1, RINTM, MCBSP_SPCR1_RINTM_RRDY)
        | MCBSP_FMK(SPCR1, RSYNCERR, MCBSP_SPCR1_RSYNCERR_NO)
        | MCBSP_FMK(SPCR1, RFULL, MCBSP_SPCR1_RFULL_NO)
        | MCBSP_FMK(SPCR1, RRDY, MCBSP_SPCR1_RRDY_NO)
        | MCBSP_FMK(SPCR1, RRST, MCBSP_SPCR1_RRST_DISABLE);


    /*  Serial Port Control Register 2                          */
    serial->sConfig.spcr2 =
        MCBSP_FMK(SPCR2, FREE, MCBSP_SPCR2_FREE_YES)
        | MCBSP_FMK(SPCR2, SOFT, MCBSP_SPCR2_SOFT_YES)
        | MCBSP_FMK(SPCR2, FRST, MCBSP_SPCR2_FRST_RESET)
        | MCBSP_FMK(SPCR2, GRST, MCBSP_SPCR2_GRST_RESET)
        | MCBSP_FMK(SPCR2, XINTM, MCBSP_SPCR2_XINTM_XRDY)
        | MCBSP_FMK(SPCR2, XSYNCERR, MCBSP_SPCR2_XSYNCERR_NO)
        | MCBSP_FMK(SPCR2, XEMPTY, MCBSP_SPCR2_XEMPTY_NO)
        | MCBSP_FMK(SPCR2, XRDY, MCBSP_SPCR2_XRDY_NO)
        | MCBSP_FMK(SPCR2, XRST, MCBSP_SPCR2_XRST_DISABLE);


    /*  Receive Control Register 1                              */
    serial->sConfig.rcr1 =
        MCBSP_FMK(RCR1, RFRLEN1, MCBSP_RCR1_RFRLEN1_OF(0))
        | MCBSP_FMK(RCR1, RWDLEN1, MCBSP_RCR1_RWDLEN1_8BIT);


    /*  Receive Control Register 2                              */
    serial->sConfig.rcr2 =
        MCBSP_FMK(RCR2, RPHASE, MCBSP_RCR2_RPHASE_SINGLE)
        | MCBSP_FMK(RCR2, RFRLEN2, MCBSP_RCR2_RFRLEN2_OF(0))
        | MCBSP_FMK(RCR2, RWDLEN2, MCBSP_RCR2_RWDLEN2_8BIT)
        | MCBSP_FMK(RCR2, RCOMPAND, MCBSP_RCR2_RCOMPAND_MSB)
        | MCBSP_FMK(RCR2, RFIG, MCBSP_RCR2_RFIG_NO)
        | MCBSP_FMK(RCR2, RDATDLY, MCBSP_RCR2_RDATDLY_1BIT);


    /*  Transmit Control Register 1                             */
    serial->sConfig.xcr1 =
        MCBSP_FMK(XCR1, XFRLEN1, MCBSP_XCR1_XFRLEN1_OF(0))
        | MCBSP_FMK(XCR1, XWDLEN1, MCBSP_XCR1_XWDLEN1_8BIT);


    /*  Transmit Control Register 2                             */
    serial->sConfig.xcr2 =
        MCBSP_FMK(XCR2, XPHASE, MCBSP_XCR2_XPHASE_SINGLE)
        | MCBSP_FMK(XCR2, XFRLEN2, MCBSP_XCR2_XFRLEN2_OF(0))
        | MCBSP_FMK(XCR2, XWDLEN2, MCBSP_XCR2_XWDLEN2_8BIT)
        | MCBSP_FMK(XCR2, XCOMPAND, MCBSP_XCR2_XCOMPAND_MSB)
        | MCBSP_FMK(XCR2, XFIG, MCBSP_XCR2_XFIG_NO)
        | MCBSP_FMK(XCR2, XDATDLY, MCBSP_XCR2_XDATDLY_1BIT);


    /*  Sample Rate Generator Register 1                        */
    serial->sConfig.srgr1 =
        MCBSP_FMK(SRGR1, FWID, MCBSP_SRGR1_FWID_OF(0))
        | MCBSP_FMK(SRGR1, CLKGDV, MCBSP_SRGR1_CLKGDV_OF(clkdiv));




    /*  Sample Rate Generator Register 2                        */
    serial->sConfig.srgr2 =
        MCBSP_FMK(SRGR2, GSYNC, MCBSP_SRGR2_GSYNC_FREE)
        | MCBSP_FMK(SRGR2, CLKSP, MCBSP_SRGR2_CLKSP_RISING)
        | MCBSP_FMK(SRGR2, CLKSM, MCBSP_SRGR2_CLKSM_INTERNAL)
        | MCBSP_FMK(SRGR2, FSGM, MCBSP_SRGR2_FSGM_DXR2XSR)
        | MCBSP_FMK(SRGR2, FPER, MCBSP_SRGR2_FPER_OF(0));


    /*  Pin Control Register                                    */
    serial->sConfig.pcr =
        MCBSP_FMK(PCR, IDLEEN, MCBSP_PCR_IDLEEN_RESET)
        | MCBSP_FMK(PCR, XIOEN, MCBSP_PCR_XIOEN_SP)
        | MCBSP_FMK(PCR, RIOEN, MCBSP_PCR_RIOEN_SP)
        | MCBSP_FMK(PCR, FSXM, MCBSP_PCR_FSXM_INTERNAL)
        | MCBSP_FMK(PCR, FSRM, MCBSP_PCR_FSRM_EXTERNAL)
        | MCBSP_FMK(PCR, SCLKME, MCBSP_PCR_SCLKME_NO)
        | MCBSP_FMK(PCR, CLKSSTAT, MCBSP_PCR_CLKSSTAT_0)
        | MCBSP_FMK(PCR, DXSTAT, MCBSP_PCR_DXSTAT_0)
        | MCBSP_FMK(PCR, DRSTAT, MCBSP_PCR_DRSTAT_0)
        | MCBSP_FMK(PCR, CLKXM, MCBSP_PCR_CLKXM_OUTPUT)
        | MCBSP_FMK(PCR, CLKRM, MCBSP_PCR_CLKRM_INPUT)
        | MCBSP_FMK(PCR, FSXP, MCBSP_PCR_FSXP_ACTIVELOW)
        | MCBSP_FMK(PCR, FSRP, MCBSP_PCR_FSRP_ACTIVELOW)
        | MCBSP_FMK(PCR, CLKXP, MCBSP_PCR_CLKXP_RISING)
        | MCBSP_FMK(PCR, CLKRP, MCBSP_PCR_CLKRP_RISING);


    /* configure the port                                       */
    MCBSP_config(serial->hMcbsp, &serial->sConfig);


    serial->intnum = MCBSP_getRcvEventId(serial->hMcbsp);


    /* and start it                                             */
    (void)MCBSP_start(serial->hMcbsp,
                      MCBSP_XMIT_START
                      | MCBSP_RCV_START
                      | MCBSP_SRGR_START
                      | MCBSP_SRGR_FRAMESYNC,
                      0xE000);


    return TIDC_NO_ERR;
}




/****************************************************************/
/* ADS1258_setWordLength()                                      */
/** Operation:
 *     - Changes the receive and transmit wordlength of the serial
 *       port in use, if the paremeter length does not match the
 *       current setting.
 *
 * Parameters:
 *     - MCBSP_Handle hMcbsp: Handle to the McBSP
 *     - unsigned int uiLength: Desired wordlength
 *
 * Return value:  Status code of type TTIDCSTATUS
 *     - TIDC_NO_ERR:   No problem occurred
 *
 * Globals modified:
 *     - None
 *
 * Resources used:
 *     - None
 */
/****************************************************************/
static TTIDCSTATUS ADS1258_setWordLength(MCBSP_Handle hMcbsp,
                                         unsigned int uiLength)
{
    /* only change the word-length, if it is not already set    */
    if (MCBSP_FGETH(hMcbsp, RCR1, RWDLEN1) != uiLength)
    {
        /* if no, make sure the port is inactive                */
        while(MCBSP_FGETH(hMcbsp, SPCR2, XEMPTY) == 1);


        /* place receiver and transmitter in reset              */
        MCBSP_FSETH(hMcbsp, SPCR1, RRST,MCBSP_SPCR1_RRST_DISABLE);
        MCBSP_FSETH(hMcbsp, SPCR2, XRST,MCBSP_SPCR2_XRST_DISABLE);


        /* set the new word-length                              */
        MCBSP_FSETH(hMcbsp, RCR1, RWDLEN1, uiLength);
        MCBSP_FSETH(hMcbsp, XCR1, XWDLEN1, uiLength);


        /* re-enable the receiver and transmitter               */
        MCBSP_FSETH(hMcbsp, SPCR1, RRST, MCBSP_SPCR1_RRST_ENABLE);
        MCBSP_FSETH(hMcbsp, SPCR2, XRST, MCBSP_SPCR2_XRST_ENABLE);
    }


    return TIDC_NO_ERR;
}




/****************************************************************/
/* ADS1258_initRcvDma()                                         */
/**Operation:
 *     - Opens the DMA channel needed for reading words from the
 *       converter; returns on error.
 *     - Pre-initializes the DMA configuration with the values
 *       which are not dependend on the buffer-address and the
 *       buffer size.
 *     - The final configuration will be done by the
 *       ADS1258_submitBlock() function.
 *     - This function does not touch the DMA Global control
 *       register and does not enable the interrupts associated
 *       with the channels.
 *     - It also does not start the DMA channel. This is the task
 *       of the ADS1258_readblock() function.
 *
 * Parameters:
 *     - MCBSP_Handle hMcbsp: Handle for the McBSP used
 *     - int iChanNum: The number of the channel to be used
 *     - DMA_Handle: Pointer to the hDmaRcv handle in the data
 *              converter structure
 *     - unsigned int *pCcr: Pointer to the DMA control register
 *              variable in the data converter object.
 *
 * Return value:
 *     - TIDC_NO_ERR in case everything was OK
 *     - TIDC_ERR_DMA if the DMA channel could not be opened.
 *
 * Globals modified: Inside the data converter object:
 *     - hDmaRcv
 *     - uiRcvCcrValue
 *
 * Resources used:
 *     - One DMA channel
 */
/****************************************************************/
static TTIDCSTATUS ADS1258_initRcvDma(MCBSP_Handle hMcbsp,
                                      int iChanNum,
                                      DMA_Handle *hDma,
                                      unsigned int *pCcr)
{
    DMA_Config cfgDma;                /* defined in the CSL     */
    unsigned long ulSrc;              /* holds destination addr */
    unsigned int uiIrq;               /* sync-event ID          */


    *hDma = DMA_open(iChanNum, 0);
    if (*hDma == INV)
        return TIDC_ERR_DMA;


    /* get the default values of the channel registers          */
    DMA_getConfig(*hDma, &cfgDma);


    /* DMACCR (channel control register) setup                  */
    /* First, select the synchronization event; as they are not */
    /* linear, they cannot be used directly.                    */
    /* The macros of the events are based on the event ID's from*/
    /* the chip support library                                 */
    uiIrq = MCBSP_getRcvEventId(hMcbsp);


    switch (uiIrq)
    {


        case IRQ_EVT_RINT0: uiIrq = 1;    /* IRQ_EVT_RINT0 = 5  */
                            break;
        case IRQ_EVT_RINT1: uiIrq = 5;    /* IRQ_EVT_RINT1 = 6  */
                            break;
        case IRQ_EVT_RINT2: uiIrq = 9;    /* IRQ_EVT_RINT2 = 12 */
                            break;        /* not C5501          */
        default:            return TIDC_ERR_BADARGS;
    }


    /* now create the correct settings for the DMACCR register  */
    *pCcr = ADS1258_DMACCR_INPUT_VALUE | uiIrq;


    /* DMACICR (channel interrupt control) setup                */
    cfgDma.dmacicr = ADS1258_DMACICR_INPUT_VALUE;


    /* DMACSSAL/AU (channel source start address low/high) setup*/
    /* type DMA_AdrPtr is defined in the CSL                    */
    ulSrc = ((unsigned long)MCBSP_ADDRH(hMcbsp, DRR2)) << 1;
    cfgDma.dmacssal = (DMA_AdrPtr)(ulSrc);
    cfgDma.dmacssau = (Uint16)((ulSrc >> 16));


    /* DMACEN (channel element number) setup                    */
    cfgDma.dmacen = 0;


    /* DMACFN (channel frame number) setup                      */
    cfgDma.dmacfn = 1; /* we will only transfer a single frame  */


    /* Now that all registers are set-up, to the actual         */
    /* configuration of the DMA channel                         */
    DMA_config(*hDma, &cfgDma);


    return TIDC_NO_ERR;
}




/****************************************************************/
/* ADS1258_initXmtDma()                                         */
/**Operation:
 *     - Opens the DMA channel needed for triggering the SCLK;
 *       returns on error.
 *     - Pre-initializes the DMA configuration with the values
 *       which are not dependend on the buffer-address and the
 *       buffer size.
 *     - The final configuration will be done by the
 *       ADS1258_submitBlock() function.
 *     - This function does not touch the DMA Global control
 *       register and does not enable the interrupts associated
 *       with the channels.
 *     - It also does not start the DMA channel. This is the task
 *       of the ADS1258_readblock() function.
 *
 * Parameters:
 *     - MCBSP_Handle hMcbsp: Handle for the McBSP used
 *     - unsigned int uiIrq: Interrupt number for the DRDY signal
 *     - DMA_Handle: Pointer to the hDmaXmt handle in the data
 *              converter structure
 *     - unsigned int *pCcr: Pointer to the DMA control register
 *              variable in the data converter object.
 *
 * Return value:
 *     - TIDC_NO_ERR in case everything was OK
 *     - TIDC_ERR_DMA if the DMA channel could not be opened.
 *
 * Globals modified: Inside the data converter object:
 *     - hDmaRcv
 *     - uiXmtCcrValue
 *
 * Resources used:
 *     - One DMA channel
 */
/****************************************************************/
static TTIDCSTATUS ADS1258_initXmtDma(MCBSP_Handle hMcbsp,
                                      unsigned int uiIrq,
                                      DMA_Handle *hDma,
                                      unsigned int *pCcr)
{
    DMA_Config cfgDma;                /* defined in the CSL     */
    unsigned int uiSrcPort;           /* holds the memory type  */
    unsigned long ulDst;
    unsigned long ulSrc;


    *hDma = DMA_open(DMA_CHA_ANY, 0);
    if (*hDma == INV)
        return TIDC_ERR_DMA;


    /* get the default values of the channel registers          */
    DMA_getConfig(*hDma, &cfgDma);


    /* DMACCR (channel control register) setup                  */
    /* First, select the synchronization event; as they are not */
    /* linear, they cannot be used directly.                    */
    /* The macros of the events are based on the event ID's from*/
    /* the chip support library                                 */
    switch (uiIrq)
    {
        case IRQ_EVT_INT0:  uiIrq = 15;   /* IRQ_EVT_INT0 = 2   */
                            break;
        case IRQ_EVT_INT1:  uiIrq = 16;   /* IRQ_EVT_INT1 = 16  */
                            break;
        case IRQ_EVT_INT2:  uiIrq = 17;   /* IRQ_EVT_INT2 = 3   */
                            break;
        case IRQ_EVT_INT3:  uiIrq = 18;   /* IRQ_EVT_INT3 = 11  */
                            break;
        case IRQ_EVT_INT4:  uiIrq = 19;   /* IRQ_EVT_INT4 = 19  */
                            break;        /* only C5509 & C5510 */
        case IRQ_EVT_INT5:  uiIrq = 20;   /* IRQ_EVT_INT5 = 23  */
                            break;        /* only C5510         */
        default:            return TIDC_ERR_BADARGS;
    }


    /* now create the correct settings for the DMACCR register  */
    *pCcr = ADS1258_DMACCR_OUTPUT_VALUE | uiIrq;


    /* DMACSDP (channel source destination paramter setup       */
    ulSrc = (unsigned long)&ulDummy << 1;
    uiSrcPort = ADS1258_DMACSDP_EMIF_SRC;
    /* is the address in DARAM ?                            */
    if (ulSrc < DCP_DARAM_END)
        uiSrcPort = ADS1258_DMACSDP_DARAM_SRC;
    /* is the address in SARAM                              */
    if (ulSrc >= DCP_SARAM_START && ulSrc <= DCP_SARAM_END)
        uiSrcPort = ADS1258_DMACSDP_SARAM_SRC;


    cfgDma.dmacsdp = ADS1258_DMACSDP_OUTPUT_VALUE
                     | uiSrcPort;         /* src memory type    */


    /* DMACICR (channel interrupt control) setup                */
    /* modify value according to requested end of xfer interrupt*/
    cfgDma.dmacicr = ADS1258_DMACICR_OUTPUT_VALUE;


    /* DMACSSAL/AU (channel source start address low/high) setup*/
    /* type DMA_AdrPtr is defined in the CSL                    */
    cfgDma.dmacssal = (DMA_AdrPtr)(ulSrc);
    cfgDma.dmacssau = (Uint16)((ulSrc >> 16));


    /* DMACDSAL/AU (channel dest. start address low/high) setup */
    ulDst = ((unsigned long)MCBSP_ADDRH(hMcbsp, DXR2)) << 1;
    cfgDma.dmacdsal = (DMA_AdrPtr)(ulDst);
    cfgDma.dmacdsau = (unsigned short)(ulDst >> 16);


    /* DMACEN (channel element number) setup                    */
    cfgDma.dmacen = 0;


    /* DMACFN (channel frame number) setup                      */
    cfgDma.dmacfn = 1; /* we will only transfer a single frame  */


    /* Now that all registers are set-up, to the actual         */
    /* configuration of the DMA channel                         */
    DMA_config(*hDma, &cfgDma);


    return TIDC_NO_ERR;
}




/****************************************************************/
/* ADS1258_submitBlock()                                        */
/**Operation:
 *     - Initializes the DMA channels which have been opened and
 *       pre-configured by the ADS1258_initRcvDma() and
 *       ADS1258_initXmtDma() functions with the correct values
 *       for the DMA channel control registers, the transfer count
 *       registers.
 *     - Initializes the destination address register of the
 *       receive channel to match the buffer passed into the
 *       fucntion.
 *     - If the EN bit is set in the CCR register passed into the
 *       function, the DMA channel will be started.
 *
 * Parameters:
 *     - DMA_Handle hDmaRcv: Handle for the receive DMA channel
 *     - DMA_Handle hDmaXmt: Handle for the transit DMA channel
 *     - unsigned int uiCcrRcv: DMA control register value for the
 *              receive channel.
 *     - unsigned int uiCcrXmt: DMA control register value for the
 *              transmit channel
 *     - unsigned int uiCnt: Number of words to be transferred.
 *     - unsigned long ulDst: Address of the buffer to be filled.
 *
 * Return value:
 *     - TIDC_NO_ERR in case everything was OK
 *
 * Globals modified:
 *     - None
 *
 * Resources used:
 *     - DMA channels opened by ADS1258_initRcvDma() and
 *              ADS1258_initXmtDma().
 */
/****************************************************************/
static TTIDCSTATUS ADS1258_submitBlock(DMA_Handle hDmaRcv,
                                       DMA_Handle hDmaXmt,
                                       unsigned int uiCcrRcv,
                                       unsigned int uiCcrXmt,
                                       unsigned int uiCnt,
                                       unsigned long ulDst)
{
    unsigned int uiDstPort;


    /* the DMA controller needs byte addresses                  */
    ulDst = ulDst << 1;


    /* wait until the channel is ready to program               */
    while ((DMA_RGETH(hDmaRcv, DMACCR) & ADS1258_DMA_ENDPROG) != 0);


    /* first configure the transmit channel                     */
    /* set the DMA Channel Element Number (DMACEN) register     */
    DMA_RSETH(hDmaXmt, DMACEN, uiCnt);


    /* set the Dma Channel Control Register (DMACCR)            */
    DMA_RSETH(hDmaXmt, DMACCR, uiCcrXmt);


    /* now configure the receive channel                        */
    /* decide, in which memory area the buffer is located       */
    uiDstPort = ADS1258_DMACSDP_EMIF_DST;


    /* is the address in DARAM?                                 */
    if (ulDst <= DCP_DARAM_END)
        uiDstPort = ADS1258_DMACSDP_DARAM_DST;


    /* is the address in SARAM?                                 */
    if (ulDst >= DCP_SARAM_START && ulDst <= DCP_SARAM_END)
        uiDstPort = ADS1258_DMACSDP_SARAM_DST;


    /* set the DMA Channel Source & Destination Parameter reg.  */
    DMA_RSETH(hDmaRcv,
              DMACSDP,
              ADS1258_DMACSDP_INPUT_VALUE | uiDstPort);


    /* set the Dma Channel Control Register (DMACCR)            */
    DMA_RSETH(hDmaRcv, DMACEN, uiCnt);


    /* set the DMA Channel Destination Start Address register   */
    DMA_RSETH(hDmaRcv, DMACDSAL,  (unsigned int)ulDst);
    DMA_RSETH(hDmaRcv, DMACDSAU, ((unsigned int)(ulDst >> 16)));


    /* set the Dma Channel Control Register (DMACCR)            */
    DMA_RSETH(hDmaRcv, DMACCR, uiCcrRcv);




   return TIDC_NO_ERR;
}




/****************************************************************/
/* ADS1258_getFinishedBufferAddress()                           */
/**Operation:
 *     - Returns the address of the just finished buffer
 *     - This function can be used inside the callback function
 *       to obtain the address.
 *
 * Parameters:
 *     - TADS1258 *pADS: Data converter object
 *
 * Return value:
 *     - Address of the finished buffer
 *
 * Globals modified:
 *     - None
 *
 * Resources used:
 *     - None
 */
/****************************************************************/
unsigned long ADS1258_getFinishedBufferAddress(TADS1258 *pADS)
{
    int iIndex;


    iIndex = pgADS->iObjectIndex;
    if (pgADS->iXferInProgress == 2)
        iIndex = (pgADS->iObjectIndex + 1) & 0x0001;


    return (unsigned long)pADS->xferBuffer[iIndex].ulBufPtr;
}




/****************************************************************/
/* ADS1258_getFinishedBufferSize()                              */
/**Operation:
 *     - Returns the size of the just finished buffer
 *     - This function can be used inside the callback function
 *       to obtain the size.
 *
 * Parameters:
 *     - TADS1258 *pADS: Data converter object
 *
 * Return value:
 *     - Size of the finished buffer
 *
 * Globals modified:
 *     - None
 *
 * Resources used:
 *     - None
 */
/****************************************************************/
unsigned int ADS1258_getFinishedBufferSize(TADS1258 *pADS)
{
    int iIndex;


    iIndex = pgADS->iObjectIndex;
    if (pgADS->iXferInProgress == 2)
        iIndex = (pgADS->iObjectIndex + 1) & 0x0001;


    return pADS->xferBuffer[iIndex].uiBufSize;
}


/****************************************************************/
/* ADS1258_setStartPin()                                        */
/**Operation:
 *     - Sets the START pin of the ADS1258 either to low or
 *       to high.
 *     - Note: This function assumes that the GPIO0-pin is
 *             connected to the START pin. If a different GPIO
 *             pin is used, the ADS1258_GPIO_USED_FOR_START macro
 *             at the beginning of this file has to be changed.
 *             If none of the GPIO pins is used to control the
 *             START pin, this function has to be rewritten to
 *             match the actual H/W setup.
 *
 * Parameters:
 *     - int iLevel: Can be one of two:
 *           - ADS1258_STARTPIN_LOW: Set it to low
 *           - ADS1258_STARTPIN_HIGH: Set it to high
 *
 * Return value:
 *     - TTIDCSTATUS TIDC_NO_ERR: Everything was fine
 *
 * Globals modified:
 *     - GPIOD register value in the data converter object
 *
 * Resources used:
 *     - None
 */
/****************************************************************/
static unsigned int ADS1258_setStartPin(TADS1258 *pADS, int iLevel)
{
    int iCmd;


    /* configure the GPIO0 as output and set it to high         */
    iCmd = ADS1258_GPIOC;
    pADS->ADS1258_GPIO_FOR_START_CONTROL = ADS1258_GPIO0_OUT;
    (void)ADS1258_control(pADS, ADS1258_CMD_REGISTERWRITE, &iCmd);


    iCmd = ADS1258_GPIOD;
    pADS->regs.gpiod.control_bit.dio0 = iLevel;
    (void)ADS1258_control(pADS, ADS1258_CMD_REGISTERWRITE, &iCmd);


   return TIDC_NO_ERR;
}




/****************************************************************/
/* ADS1258_rblock_finished()                                    */
/**Operation:
 *     - Clears the DMA channel control register of the two
 *       channels used, if this was the last transfer in a chain.
 *     - Disables the DMA interrupt, if this was the last transfer
 *       in a chain.
 *     - Sets the status flag of the finished buffer to finished
 *     - Calls the callback-routine, if wished
 *     - Resets the status flag of the finished buffer to empty.
 *
 * Parameters:
 *     - None
 *
 * Return value:
 *     - None
 *
 * Globals modified:
 *     - iXferInProgress in the dc object
 *     - uiStatus inside the buffer object
 *
 * Resources used:
 *     - None
 */
/****************************************************************/
interrupt void ADS1258_rblock_finished(void)
{
    int iIndex;


    if (pgADS->iXferInProgress == 1)
    {
        /* avoid additional synchronization events to the DMA   */
        /* by clearing the DMACCR register                      */
        DMA_RSETH(pgADS->hDmaRcv, DMACCR, 0);
        DMA_RSETH(pgADS->hDmaXmt, DMACCR, 0);
        (void)IRQ_disable(DMA_getEventId(pgADS->hDmaRcv));
        (void)ADS1258_setStartPin(pgADS, ADS1258_STARTPIN_LOW);
    }


    else /* there was a second transfer submitted               */
    {
        DMA_start(pgADS->hDmaXmt);
        DMA_start(pgADS->hDmaRcv);
    }


    /* if there is a callback function requested, call it       */
    iIndex = pgADS->iObjectIndex;
    if (pgADS->iXferInProgress == 2)
        iIndex = (pgADS->iObjectIndex + 1) & 0x0001;


    if (pgADS->xferBuffer[iIndex].ptrCallBack)
    {
        pgADS->xferBuffer[iIndex].uiStatus = 2;
        pgADS->xferBuffer[iIndex].ptrCallBack(pgADS);
    }
    pgADS->xferBuffer[iIndex].uiStatus = 0;


    /* signal that the transfer was successful                  */
    pgADS->iXferInProgress -= 1;    /* clear flag               */
}

/****************************************************************/
/* END OF t1258_ob.c                                             */
/****************************************************************/
/*TIDC_Wizard Auto Code End}}*/
