//UART1.C
#include "uart1.h"
volatile uint8_t UART1_TX_Buf[UART1_TX_LEN] = {0};
volatile uint8_t UART1_RX_Buf[UART1_RX_LEN] = {0};
volatile uint16_t UART1_TX_Index = 0;
volatile uint16_t UART1_RX_Index = 0;
volatile uint16_t UART1_RX_Len = 0;
void UART1_DMA_ON(uint16_t len)
{
	DMA1_Channel4->CCR &= ~(1<<0);       //رDMA 
	DMA1_Channel4->CNDTR = len;          //DMA1, 
	DMA1_Channel4->CCR |= 1<<0;          //DMA
}
void UART1_DMA_OFF(void)
{
}

void UART1_GPIO_Config(void)
{
	GPIO_InitTypeDef GPIO_InitStruct;
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);
	
	GPIO_InitStruct.GPIO_Mode = GPIO_Mode_AF_PP;
	GPIO_InitStruct.GPIO_Pin = GPIO_Pin_9;
	GPIO_InitStruct.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(GPIOA, &GPIO_InitStruct);
	
	GPIO_InitStruct.GPIO_Mode = GPIO_Mode_IN_FLOATING;
	GPIO_InitStruct.GPIO_Pin = GPIO_Pin_10;
	GPIO_Init(GPIOA, &GPIO_InitStruct);
}
void UART1_NVIC_Config(void)
{
	NVIC_InitTypeDef NVIC_InitStruct;
	NVIC_InitStruct.NVIC_IRQChannel = USART1_IRQn;
	NVIC_InitStruct.NVIC_IRQChannelCmd = ENABLE;
	NVIC_InitStruct.NVIC_IRQChannelSubPriority = 0;
	NVIC_InitStruct.NVIC_IRQChannelPreemptionPriority = 3;
	NVIC_Init(&NVIC_InitStruct);
}
void UART1_DMA_Config(void)
{
	DMA_InitTypeDef DMA_InitStruct;
	RCC_AHBPeriphClockCmd(RCC_AHBPeriph_DMA1, ENABLE);
	
	DMA_InitStruct.DMA_BufferSize = UART1_TX_LEN;
	DMA_InitStruct.DMA_DIR = DMA_DIR_PeripheralDST;
	DMA_InitStruct.DMA_M2M = DMA_M2M_Disable;
	DMA_InitStruct.DMA_MemoryBaseAddr = (uint32_t)UART1_TX_Buf;
	
	DMA_InitStruct.DMA_MemoryDataSize = DMA_MemoryDataSize_Byte;//8bits
	DMA_InitStruct.DMA_MemoryInc = DMA_MemoryInc_Enable;
//ѭȡ;ֹͣǷǴֹͣĵطʼͿʼ	
//ֻܴʵ飬οֲаûȷ˵
//2014.9.10 취ֻϺԽֹͣ
	DMA_InitStruct.DMA_Mode = DMA_Mode_Normal;		//2014916ݷ͸Ϊһֶ
	DMA_InitStruct.DMA_PeripheralBaseAddr = 0x40013804;
	DMA_InitStruct.DMA_PeripheralDataSize = DMA_PeripheralDataSize_Byte;
	DMA_InitStruct.DMA_PeripheralInc = DMA_PeripheralInc_Disable;
	DMA_InitStruct.DMA_Priority = DMA_Priority_Medium;
	
	DMA_Init(DMA1_Channel4, &DMA_InitStruct);
}
void UART1_MODE_Config(void)
{
	USART_InitTypeDef USART_InitStruct;
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1, ENABLE);
	
	USART_InitStruct.USART_BaudRate = 115200;//38400;//115200ݳ
	USART_InitStruct.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
	USART_InitStruct.USART_Mode = USART_Mode_Rx|USART_Mode_Tx;
	USART_InitStruct.USART_Parity = USART_Parity_No;
	USART_InitStruct.USART_StopBits = USART_StopBits_1;
	USART_InitStruct.USART_WordLength = 8;
	USART_Init(USART1, &USART_InitStruct);
	USART_ITConfig(USART1, USART_IT_RXNE, ENABLE);//ж
}
void UART1_Init(void)
{
	UART1_GPIO_Config();
	UART1_NVIC_Config();
	UART1_DMA_Config();
	UART1_MODE_Config();
	USART_Cmd(USART1, ENABLE);
	
//ʵ£һοUSART_DMACmd()ֻˢ	UART1_DMA_ON()
	USART_DMACmd(USART1, USART_DMAReq_Tx, ENABLE);//DMAͣDMAûͣǾDMAʹ
	//֪ǷԶʧܣ´ηʱҪһ
	UART1_DMA_ON(1);										//DMAʹ
}
/*
ҪPC,
PC_CMD_prefix:0x53
PC_CMD       :0x30 0x31 ...
*/
void USART1_IRQHandler (void)
{
	if( (USART_GetFlagStatus(USART1, USART_FLAG_RXNE)) == SET)
	{
//		UART1_RX_Flag = 1;
		if(UART1_RX_Index >= UART1_RX_LEN)
		{
			UART1_RX_Index = 0;
		}
		UART1_RX_Buf[UART1_RX_Index++] = USART_ReceiveData(USART1);
		UART1_RX_Len++;
	}
	USART_ClearFlag(USART1, USART_FLAG_RXNE);//ʵҲ֪־λǷԶ
}
///ضc⺯printfUSART1
int fputc(int ch, FILE *f)
{
		/* һֽݵUSART1 */
		USART_SendData(USART1, (uint8_t) ch);
		
		/* ȴ */
		while (USART_GetFlagStatus(USART1, USART_FLAG_TC) == RESET);//δλһֱѭ,һλ		
//ûзͳɹһֱѭ.	
		return (ch);
}

///ضc⺯scanfUSART1
int fgetc(FILE *f)
{
		/* ȴ1 */
		while (USART_GetFlagStatus(USART1, USART_FLAG_RXNE) == RESET);//ܷǿձ־λ
//Ƿǿյľһֱѭյľһֱѭ
		return (int)USART_ReceiveData(USART1);
}
/*****************end of the file*************************/
