/*

This is AIP device register map library.

Target Device: TAS5711 Compatible

File Date : 2010-05-24

By Ryan Wang
ryan-wang@ti.com

*/

#ifndef _TAS57XX_LIB_H_
#define _TAS57XX_LIB_H_

//Register Map
#define TI_TAS5711_I2C_ADDR			0x1B		//TAS57xx I2C address without R/W bit
#define TI_TAS5711_CLOCK_CONTROL		0x00
#define TI_TAS5711_DEVICE_ID			0x01
#define TI_TAS5711_ERROR_STATUS			0x02
#define TI_TAS5711_SYSTEM_CONTROL_1		0x03
#define TI_TAS5711_I2S_MODES			0x04
#define TI_TAS5711_POWER_CONTROL		0x05
#define TI_TAS5711_SOFTWARE_MUTE		0x06
#define TI_TAS5711_MASTER_VOL			0x07
#define TI_TAS5711_Sub_VOL 			0x0A
#define TI_TAS5711_VOLUME_CONFIG 	      	0x0E
#define TI_TAS5711_MODULATION_LIMIT            	0x10


#define TI_TAS5711_IC_DELAY_PWM1               	0x11
#define TI_TAS5711_IC_DELAY_PWM2               	0x12
#define TI_TAS5711_IC_DELAY_PWM3               	0x13
#define TI_TAS5711_IC_DELAY_PWM4               	0x14
#define TI_TAS5711_IC_DELAY_PWM5               	0x15
#define TI_TAS5711_IC_DELAY_PWM6               	0x16

#define TI_TAS5711_SHUTDOWN_GROUP_REGISTER     	0x19
#define TI_TAS5711_START_STOP_PERIOD           	0x1A
#define TI_TAS5711_OSCILLATOR_TRIM             	0x1B

#define TI_TAS5711_INPUT_MUX                   	0x20//INPUT MUX CONFIGURATION
#define TI_TAS5711_INPUT_DOWN_MIX              	0x21//INPUT DOWNMUX CONFIGURATION
#define TI_TAS5711_PWM_OUTPUT_MUX		0x25//PWM OUTPUT MUX CONFIGURATION

#define TI_TAS5711_CHANNEL1_3D_BQ0              0x29 //3D Delay
#define TI_TAS5711_CHANNEL1_3D_BQ1              0x2A //3D Delay
#define TI_TAS5711_CHANNEL1_BQ2               	0x2B 
#define TI_TAS5711_CHANNEL1_BQ3                	0x2C
#define TI_TAS5711_CHANNEL1_BQ4                	0x2D
#define TI_TAS5711_CHANNEL1_BQ5                	0x2E
#define TI_TAS5711_CHANNEL1_BQ6                	0x2F


#define TI_TAS5711_CHANNEL2_3D_BQ0              0x30 //3D Delay
#define TI_TAS5711_CHANNEL2_3D_BQ1              0x31 //3D Delay
#define TI_TAS5711_CHANNEL2_BQ2                	0x32
#define TI_TAS5711_CHANNEL2_BQ3                	0x33
#define TI_TAS5711_CHANNEL2_BQ4                	0x34
#define TI_TAS5711_CHANNEL2_BQ5                	0x35
#define TI_TAS5711_CHANNEL2_BQ6                	0x36


#define TI_TAS5711_DRC1_AE                     	0x3A
#define TI_TAS5711_DRC1_AA                     	0x3B
#define TI_TAS5711_DRC1_AD                     	0x3C
#define TI_TAS5711_DRC1_T                      	0x40
#define TI_TAS5711_DRC1_K                      	0x41
#define TI_TAS5711_DRC1_O                      	0x42


#define TI_TAS5711_DRC2_AE                     	0x3D
#define TI_TAS5711_DRC2_AA                     	0x3E
#define TI_TAS5711_DRC2_AD                     	0x3F
#define TI_TAS5711_DRC2_T                      	0x43
#define TI_TAS5711_DRC2_K                      	0x44
#define TI_TAS5711_DRC2_O                      	0x45
#define TI_TAS5711_DRC_CONTROL                 	0x46

#define TI_TAS5711_EQ_CONTROL		        0x50

#define TI_TAS5711_CH1_OUTPUT_Mixer	 	0x51
#define TI_TAS5711_CH2_OUTPUT_Mixer	  	0x52

#define TI_TAS5711_CH1_INPUT_Mixer	 	0x53
#define TI_TAS5711_CH2_INPUT_Mixer	 	0x54
#define TI_TAS5711_CH3_INPUT_Mixer	 	0x55

#define TI_TAS5711_Sub_BQ0			0x5A
#define TI_TAS5711_Sub_BQ1			0x5B

#define TI_TAS5711_PSEUDO_BQ1	     	 	0x5E//3D (L-R) Channel EQ
#define TI_TAS5711_PSEUDO_BQ2	    		0x5F//3D (L-R) Channel EQ


#endif

